/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.text;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IText;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.text.ITextProcessor;
import org.thymeleaf.processor.text.ITextStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractTextProcessor
extends AbstractProcessor
implements ITextProcessor {
    public AbstractTextProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IText text, ITextStructureHandler structureHandler) {
        try {
            this.doProcess(context, text, structureHandler);
        }
        catch (TemplateProcessingException e2) {
            if (text.hasLocation()) {
                if (!e2.hasTemplateName()) {
                    e2.setTemplateName(text.getTemplateName());
                }
                if (!e2.hasLineAndCol()) {
                    e2.setLineAndCol(text.getLine(), text.getCol());
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", text.getTemplateName(), text.getLine(), text.getCol(), e3);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IText var2, ITextStructureHandler var3);
}

