/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.xmldeclaration;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IXMLDeclaration;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.xmldeclaration.IXMLDeclarationProcessor;
import org.thymeleaf.processor.xmldeclaration.IXMLDeclarationStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractXMLDeclarationProcessor
extends AbstractProcessor
implements IXMLDeclarationProcessor {
    public AbstractXMLDeclarationProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IXMLDeclaration xmlDeclaration, IXMLDeclarationStructureHandler structureHandler) {
        try {
            this.doProcess(context, xmlDeclaration, structureHandler);
        }
        catch (TemplateProcessingException e2) {
            if (xmlDeclaration.hasLocation()) {
                if (!e2.hasTemplateName()) {
                    e2.setTemplateName(xmlDeclaration.getTemplateName());
                }
                if (!e2.hasLineAndCol()) {
                    e2.setLineAndCol(xmlDeclaration.getLine(), xmlDeclaration.getCol());
                }
            }
            throw e2;
        }
        catch (Exception e3) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", xmlDeclaration.getTemplateName(), xmlDeclaration.getLine(), xmlDeclaration.getCol(), e3);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IXMLDeclaration var2, IXMLDeclarationStructureHandler var3);
}

