/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.EqualsNotEqualsExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.util.EvaluationUtils;

public final class EqualsExpression
extends EqualsNotEqualsExpression {
    private static final long serialVersionUID = -3223406642461547141L;
    private static final Logger logger = LoggerFactory.getLogger(EqualsExpression.class);

    public EqualsExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation("==");
    }

    static Object executeEquals(IExpressionContext context, EqualsExpression expression, StandardExpressionExecutionContext expContext) {
        Object leftValue = expression.getLeft().execute(context, expContext);
        Object rightValue = expression.getRight().execute(context, expContext);
        leftValue = LiteralValue.unwrap(leftValue);
        rightValue = LiteralValue.unwrap(rightValue);
        if (leftValue == null) {
            return rightValue == null;
        }
        Boolean result2 = null;
        BigDecimal leftNumberValue = EvaluationUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = EvaluationUtils.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            result2 = leftNumberValue.compareTo(rightNumberValue) == 0;
        } else {
            if (leftValue instanceof Character) {
                leftValue = leftValue.toString();
            }
            if (rightValue != null && rightValue instanceof Character) {
                rightValue = rightValue.toString();
            }
            result2 = rightValue != null && leftValue.getClass().equals(rightValue.getClass()) && Comparable.class.isAssignableFrom(leftValue.getClass()) ? Boolean.valueOf(((Comparable)leftValue).compareTo(rightValue) == 0) : Boolean.valueOf(leftValue.equals(rightValue));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating EQUALS expression: \"{}\". Left is \"{}\", right is \"{}\". Result is \"{}\"", TemplateEngine.threadIndex(), expression.getStringRepresentation(), leftValue, rightValue, result2);
        }
        return result2;
    }
}

