/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.ExpressionParsingState;
import org.thymeleaf.standard.expression.ExpressionParsingUtil;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.Validate;

public abstract class Expression
implements IStandardExpression,
Serializable {
    private static final long serialVersionUID = 1608378943284014151L;
    public static final char PARSING_PLACEHOLDER_CHAR = '\u00a7';
    public static final char NESTING_START_CHAR = '(';
    public static final char NESTING_END_CHAR = ')';

    protected Expression() {
    }

    @Override
    public abstract String getStringRepresentation();

    public String toString() {
        return this.getStringRepresentation();
    }

    static Expression parse(String input) {
        Validate.notNull(input, "Input cannot be null");
        ExpressionParsingState decomposition = ExpressionParsingUtil.decompose(input);
        if (decomposition == null) {
            return null;
        }
        ExpressionParsingState result2 = ExpressionParsingUtil.compose(decomposition);
        if (result2 == null || !result2.hasExpressionAt(0)) {
            return null;
        }
        return ((ExpressionParsingNode)result2.get(0)).getExpression();
    }

    static Object execute(IExpressionContext context, Expression expression, IStandardVariableExpressionEvaluator expressionEvaluator, StandardExpressionExecutionContext expContext) {
        if (expression instanceof SimpleExpression) {
            return SimpleExpression.executeSimple(context, (SimpleExpression)expression, expressionEvaluator, expContext);
        }
        if (expression instanceof ComplexExpression) {
            return ComplexExpression.executeComplex(context, (ComplexExpression)expression, expContext);
        }
        throw new TemplateProcessingException("Unrecognized expression: " + expression.getClass().getName());
    }

    @Override
    public Object execute(IExpressionContext context) {
        return this.execute(context, StandardExpressionExecutionContext.NORMAL);
    }

    @Override
    public Object execute(IExpressionContext context, StandardExpressionExecutionContext expContext) {
        Validate.notNull(context, "Context cannot be null");
        IStandardVariableExpressionEvaluator variableExpressionEvaluator = StandardExpressions.getVariableExpressionEvaluator(context.getConfiguration());
        Object result2 = Expression.execute(context, this, variableExpressionEvaluator, expContext);
        return LiteralValue.unwrap(result2);
    }
}

