/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.ExpressionCacheKey;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Each;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.FragmentSignature;
import org.thymeleaf.standard.expression.IStandardExpression;

final class ExpressionCache {
    private static final String EXPRESSION_CACHE_TYPE_STANDARD_EXPRESSION = "expr";
    private static final String EXPRESSION_CACHE_TYPE_ASSIGNATION_SEQUENCE = "aseq";
    private static final String EXPRESSION_CACHE_TYPE_EXPRESSION_SEQUENCE = "eseq";
    private static final String EXPRESSION_CACHE_TYPE_EACH = "each";
    private static final String EXPRESSION_CACHE_TYPE_FRAGMENT_SIGNATURE = "fsig";

    private ExpressionCache() {
    }

    static Object getFromCache(IEngineConfiguration configuration, String input, String type2) {
        ICache<ExpressionCacheKey, Object> cache2;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache2 = cacheManager.getExpressionCache()) != null) {
            return cache2.get(new ExpressionCacheKey(type2, input));
        }
        return null;
    }

    static <V> void putIntoCache(IEngineConfiguration configuration, String input, V value2, String type2) {
        ICache<ExpressionCacheKey, Object> cache2;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache2 = cacheManager.getExpressionCache()) != null) {
            cache2.put(new ExpressionCacheKey(type2, input), value2);
        }
    }

    static <V> void removeFromCache(IEngineConfiguration configuration, String input, String type2) {
        ICache<ExpressionCacheKey, Object> cache2;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache2 = cacheManager.getExpressionCache()) != null) {
            cache2.clearKey(new ExpressionCacheKey(type2, input));
        }
    }

    static IStandardExpression getExpressionFromCache(IEngineConfiguration configuration, String input) {
        return (IStandardExpression)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_STANDARD_EXPRESSION);
    }

    static void putExpressionIntoCache(IEngineConfiguration configuration, String input, IStandardExpression value2) {
        ExpressionCache.putIntoCache(configuration, input, value2, EXPRESSION_CACHE_TYPE_STANDARD_EXPRESSION);
    }

    static AssignationSequence getAssignationSequenceFromCache(IEngineConfiguration configuration, String input) {
        return (AssignationSequence)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_ASSIGNATION_SEQUENCE);
    }

    static void putAssignationSequenceIntoCache(IEngineConfiguration configuration, String input, AssignationSequence value2) {
        ExpressionCache.putIntoCache(configuration, input, value2, EXPRESSION_CACHE_TYPE_ASSIGNATION_SEQUENCE);
    }

    static ExpressionSequence getExpressionSequenceFromCache(IEngineConfiguration configuration, String input) {
        return (ExpressionSequence)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_EXPRESSION_SEQUENCE);
    }

    static void putExpressionSequenceIntoCache(IEngineConfiguration configuration, String input, ExpressionSequence value2) {
        ExpressionCache.putIntoCache(configuration, input, value2, EXPRESSION_CACHE_TYPE_EXPRESSION_SEQUENCE);
    }

    static Each getEachFromCache(IEngineConfiguration configuration, String input) {
        return (Each)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_EACH);
    }

    static void putEachIntoCache(IEngineConfiguration configuration, String input, Each value2) {
        ExpressionCache.putIntoCache(configuration, input, value2, EXPRESSION_CACHE_TYPE_EACH);
    }

    static FragmentSignature getFragmentSignatureFromCache(IEngineConfiguration configuration, String input) {
        return (FragmentSignature)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_FRAGMENT_SIGNATURE);
    }

    static void putFragmentSignatureIntoCache(IEngineConfiguration configuration, String input, FragmentSignature value2) {
        ExpressionCache.putIntoCache(configuration, input, value2, EXPRESSION_CACHE_TYPE_FRAGMENT_SIGNATURE);
    }
}

