/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.util.Validate;

public final class ExpressionSequence
implements Iterable<IStandardExpression>,
Serializable {
    private static final long serialVersionUID = -6069208208568731809L;
    private final List<IStandardExpression> expressions;

    public ExpressionSequence(List<? extends IStandardExpression> expressions) {
        Validate.notNull(expressions, "Expression list cannot be null");
        Validate.containsNoNulls(expressions, "Expression list cannot contain any nulls");
        this.expressions = Collections.unmodifiableList(expressions);
    }

    public List<IStandardExpression> getExpressions() {
        return this.expressions;
    }

    public int size() {
        return this.expressions.size();
    }

    @Override
    public Iterator<IStandardExpression> iterator() {
        return this.expressions.iterator();
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.expressions.size() > 0) {
            sb.append(this.expressions.get(0));
            for (int i2 = 1; i2 < this.expressions.size(); ++i2) {
                sb.append(',');
                sb.append(this.expressions.get(i2));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getStringRepresentation();
    }
}

