/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.AssignationUtils;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class LinkExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(LinkExpression.class);
    private static final long serialVersionUID = -564516592085017252L;
    static final char SELECTOR = '@';
    private static final char PARAMS_START_CHAR = '(';
    private static final char PARAMS_END_CHAR = ')';
    private static final Pattern LINK_PATTERN = Pattern.compile("^\\s*\\@\\{(.+?)\\}\\s*$", 32);
    private final IStandardExpression base;
    private final AssignationSequence parameters;

    public LinkExpression(IStandardExpression base, AssignationSequence parameters2) {
        Validate.notNull(base, "Base cannot be null");
        this.base = base;
        this.parameters = parameters2;
    }

    public IStandardExpression getBase() {
        return this.base;
    }

    public AssignationSequence getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append('{');
        sb.append(this.base);
        if (this.hasParameters()) {
            sb.append('(');
            sb.append(this.parameters.getStringRepresentation());
            sb.append(')');
        }
        sb.append('}');
        return sb.toString();
    }

    static LinkExpression parseLinkExpression(String input) {
        Matcher matcher = LINK_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        String content2 = matcher.group(1);
        if (StringUtils.isEmptyOrWhitespace(content2)) {
            return null;
        }
        String trimmedInput = content2.trim();
        if (trimmedInput.endsWith(String.valueOf(')'))) {
            boolean inLiteral = false;
            int nestParLevel = 0;
            for (int i2 = trimmedInput.length() - 1; i2 >= 0; --i2) {
                char c2 = trimmedInput.charAt(i2);
                if (c2 == '\'') {
                    if (i2 != 0 && content2.charAt(i2 - 1) == '\\') continue;
                    inLiteral = !inLiteral;
                    continue;
                }
                if (!inLiteral && c2 == ')') {
                    ++nestParLevel;
                    continue;
                }
                if (inLiteral || c2 != '(') continue;
                if (--nestParLevel < 0) {
                    return null;
                }
                if (nestParLevel != 0) continue;
                if (i2 == 0) {
                    Expression baseExpr = LinkExpression.parseBaseDefaultAsLiteral(trimmedInput);
                    if (baseExpr == null) {
                        return null;
                    }
                    return new LinkExpression(baseExpr, null);
                }
                String base = trimmedInput.substring(0, i2).trim();
                String parameters2 = trimmedInput.substring(i2 + 1, trimmedInput.length() - 1).trim();
                Expression baseExpr = LinkExpression.parseBaseDefaultAsLiteral(base);
                if (baseExpr == null) {
                    return null;
                }
                AssignationSequence parametersAssigSeq = AssignationUtils.internalParseAssignationSequence(parameters2, true);
                if (parametersAssigSeq == null) {
                    return null;
                }
                return new LinkExpression(baseExpr, parametersAssigSeq);
            }
            return null;
        }
        Expression baseExpr = LinkExpression.parseBaseDefaultAsLiteral(trimmedInput);
        if (baseExpr == null) {
            return null;
        }
        return new LinkExpression(baseExpr, null);
    }

    private static Expression parseBaseDefaultAsLiteral(String base) {
        if (StringUtils.isEmptyOrWhitespace(base)) {
            return null;
        }
        Expression expr = Expression.parse(base);
        if (expr == null) {
            return Expression.parse(TextLiteralExpression.wrapStringIntoLiteral(base));
        }
        return expr;
    }

    static Object executeLinkExpression(IExpressionContext context, LinkExpression expression) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating link: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if (!(context instanceof ITemplateContext)) {
            throw new TemplateProcessingException("Cannot evaluate expression \"" + expression + "\". Link expressions can only be evaluated in a template-processing environment (as a part of an in-template expression) where processing context is an implementation of " + ITemplateContext.class.getClass() + ", which it isn't (" + context.getClass().getName() + ")");
        }
        ITemplateContext templateContext = (ITemplateContext)context;
        IStandardExpression baseExpression = expression.getBase();
        Object base = baseExpression.execute(templateContext, StandardExpressionExecutionContext.RESTRICTED);
        if ((base = LiteralValue.unwrap(base)) != null && !(base instanceof String)) {
            base = base.toString();
        }
        base = base == null || StringUtils.isEmptyOrWhitespace((String)base) ? "" : ((String)base).trim();
        Map<String, Object> parameters2 = LinkExpression.resolveParameters(templateContext, expression, StandardExpressionExecutionContext.NORMAL);
        return templateContext.buildLink((String)base, parameters2);
    }

    private static Map<String, Object> resolveParameters(IExpressionContext context, LinkExpression expression, StandardExpressionExecutionContext expContext) {
        if (!expression.hasParameters()) {
            return null;
        }
        List<Assignation> assignationValues = expression.getParameters().getAssignations();
        int assignationValuesLen = assignationValues.size();
        LinkedHashMap<String, Object> parameters2 = new LinkedHashMap<String, Object>(assignationValuesLen);
        LinkedHashMap<String, String> normalizedParameterNames = new LinkedHashMap<String, String>(assignationValuesLen + 1, 1.0f);
        for (int i2 = 0; i2 < assignationValuesLen; ++i2) {
            Object value2;
            String parameterName;
            Assignation assignationValue = assignationValues.get(i2);
            IStandardExpression parameterNameExpr = assignationValue.getLeft();
            IStandardExpression parameterValueExpr = assignationValue.getRight();
            Object parameterNameValue = parameterNameExpr.execute(context, expContext);
            String string = parameterName = parameterNameValue == null ? null : parameterNameValue.toString();
            if (StringUtils.isEmptyOrWhitespace(parameterName)) {
                throw new TemplateProcessingException("Parameters in link expression \"" + expression.getStringRepresentation() + "\" are incorrect: parameter name expression \"" + parameterNameExpr.getStringRepresentation() + "\" evaluated as null or empty string.");
            }
            Object parameterValue = parameterValueExpr == null ? null : ((value2 = parameterValueExpr.execute(context, expContext)) == null ? "" : LiteralValue.unwrap(value2));
            String lowerParameterName = parameterName.toLowerCase();
            if (normalizedParameterNames.containsKey(lowerParameterName)) {
                parameterName = (String)((HashMap)normalizedParameterNames).get(lowerParameterName);
            } else {
                normalizedParameterNames.put(lowerParameterName, parameterName);
            }
            LinkExpression.addParameter(parameters2, parameterName, parameterValue);
        }
        return parameters2;
    }

    private static void addParameter(Map<String, Object> parameters2, String parameterName, Object parameterValue) {
        Validate.notEmpty(parameterName, "Parameter name cannot be null");
        Object normalizedParameterValue = LinkExpression.normalizeParameterValue(parameterValue);
        if (parameters2.containsKey(parameterName)) {
            ArrayList currentValue = parameters2.get(parameterName);
            if (currentValue == null || !(currentValue instanceof List)) {
                ArrayList newValue = new ArrayList(3);
                newValue.add(currentValue);
                currentValue = newValue;
                parameters2.put(parameterName, currentValue);
            }
            if (normalizedParameterValue != null && normalizedParameterValue instanceof List) {
                ((List)currentValue).addAll((List)normalizedParameterValue);
            } else {
                ((List)currentValue).add(normalizedParameterValue);
            }
            return;
        }
        parameters2.put(parameterName, normalizedParameterValue);
    }

    private static Object normalizeParameterValue(Object parameterValue) {
        if (parameterValue == null) {
            return null;
        }
        if (parameterValue instanceof Iterable) {
            if (parameterValue instanceof List) {
                return new ArrayList((List)parameterValue);
            }
            if (parameterValue instanceof Set) {
                return new ArrayList((Set)parameterValue);
            }
            ArrayList result2 = new ArrayList(4);
            for (Object obj : (Iterable)parameterValue) {
                result2.add(obj);
            }
            return result2;
        }
        if (parameterValue.getClass().isArray()) {
            ArrayList<Serializable> result3 = new ArrayList<Serializable>(4);
            if (parameterValue instanceof byte[]) {
                for (byte obj : (byte[])parameterValue) {
                    result3.add(Byte.valueOf(obj));
                }
            } else if (parameterValue instanceof short[]) {
                for (short obj : (short[])parameterValue) {
                    result3.add(Short.valueOf(obj));
                }
            } else if (parameterValue instanceof int[]) {
                for (int obj : (int[])parameterValue) {
                    result3.add(Integer.valueOf(obj));
                }
            } else if (parameterValue instanceof long[]) {
                for (long obj : (long[])parameterValue) {
                    result3.add(Long.valueOf(obj));
                }
            } else if (parameterValue instanceof float[]) {
                for (float obj : (float[])parameterValue) {
                    result3.add(Float.valueOf(obj));
                }
            } else if (parameterValue instanceof double[]) {
                for (double obj : (double[])parameterValue) {
                    result3.add(Double.valueOf(obj));
                }
            } else if (parameterValue instanceof boolean[]) {
                for (boolean obj : (boolean[])parameterValue) {
                    result3.add(Boolean.valueOf(obj));
                }
            } else if (parameterValue instanceof char[]) {
                for (char obj : (char[])parameterValue) {
                    result3.add(Character.valueOf(obj));
                }
            } else {
                Object[] objParameterValue = (Object[])parameterValue;
                Collections.addAll(result3, objParameterValue);
            }
            return result3;
        }
        return parameterValue;
    }
}

