/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.Token;
import org.thymeleaf.util.StringUtils;

public final class NumberTokenExpression
extends Token {
    private static final Logger logger = LoggerFactory.getLogger(NumberTokenExpression.class);
    private static final long serialVersionUID = -3729844055243242571L;
    public static final char DECIMAL_POINT = '.';

    static Number computeValue(String value2) {
        BigDecimal bigDecimalValue = new BigDecimal(value2);
        if (bigDecimalValue.scale() > 0) {
            return bigDecimalValue;
        }
        return bigDecimalValue.toBigInteger();
    }

    public NumberTokenExpression(String value2) {
        super(NumberTokenExpression.computeValue(value2));
    }

    @Override
    public String getStringRepresentation() {
        Object value2 = this.getValue();
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)this.getValue()).toPlainString();
        }
        return value2.toString();
    }

    static NumberTokenExpression parseNumberTokenExpression(String input) {
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        boolean decimalFound = false;
        int inputLen = input.length();
        for (int i2 = 0; i2 < inputLen; ++i2) {
            char c2 = input.charAt(i2);
            if (Character.isDigit(c2)) continue;
            if (c2 == '.') {
                if (decimalFound) {
                    return null;
                }
                decimalFound = true;
                continue;
            }
            return null;
        }
        try {
            return new NumberTokenExpression(input);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    static Object executeNumberTokenExpression(IExpressionContext context, NumberTokenExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating number token: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

