/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.AbstractMemberAccess;
import ognl.ClassResolver;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.IStandardVariableExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.OGNLContextPropertyAccessor;
import org.thymeleaf.standard.expression.OGNLExpressionObjectsWrapper;
import org.thymeleaf.standard.expression.OGNLShortcutExpression;
import org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.standard.util.StandardExpressionUtils;
import org.thymeleaf.util.ExpressionUtils;

public final class OGNLVariableExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(OGNLVariableExpressionEvaluator.class);
    private static final String EXPRESSION_CACHE_TYPE_OGNL = "ognl";
    private static Map<String, Object> CONTEXT_VARIABLES_MAP_NOEXPOBJECTS_RESTRICTIONS = Collections.singletonMap("%RESTRICT_REQUEST_PARAMETERS%", "%RESTRICT_REQUEST_PARAMETERS%");
    private static MemberAccess MEMBER_ACCESS = new ThymeleafACLMemberAccess();
    private static ThymeleafACLClassResolver CLASS_RESOLVER = new ThymeleafACLClassResolver();
    private final boolean applyOGNLShortcuts;

    public OGNLVariableExpressionEvaluator(boolean applyOGNLShortcuts) {
        this.applyOGNLShortcuts = applyOGNLShortcuts;
        OGNLContextPropertyAccessor accessor = new OGNLContextPropertyAccessor();
        OgnlRuntime.setPropertyAccessor(IContext.class, accessor);
    }

    @Override
    public final Object evaluate(IExpressionContext context, IStandardVariableExpression expression, StandardExpressionExecutionContext expContext) {
        return OGNLVariableExpressionEvaluator.evaluate(context, expression, expContext, this.applyOGNLShortcuts);
    }

    private static Object evaluate(IExpressionContext context, IStandardVariableExpression expression, StandardExpressionExecutionContext expContext, boolean applyOGNLShortcuts) {
        try {
            Object result2;
            Map contextVariablesMap;
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] OGNL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)expression.getExpression());
            }
            IEngineConfiguration configuration = context.getConfiguration();
            String exp2 = expression.getExpression();
            boolean useSelectionAsRoot = expression.getUseSelectionAsRoot();
            if (exp2 == null) {
                throw new TemplateProcessingException("Expression content is null, which is not allowed");
            }
            ComputedOGNLExpression parsedExpression = OGNLVariableExpressionEvaluator.obtainComputedOGNLExpression(configuration, expression, exp2, expContext, applyOGNLShortcuts);
            if (parsedExpression.mightNeedExpressionObjects) {
                contextVariablesMap = new OGNLExpressionObjectsWrapper(context.getExpressionObjects());
                if (expContext.getRestrictVariableAccess()) {
                    contextVariablesMap.put("%RESTRICT_REQUEST_PARAMETERS%", "%RESTRICT_REQUEST_PARAMETERS%");
                } else {
                    contextVariablesMap.remove("%RESTRICT_REQUEST_PARAMETERS%");
                }
            } else {
                contextVariablesMap = expContext.getRestrictVariableAccess() ? CONTEXT_VARIABLES_MAP_NOEXPOBJECTS_RESTRICTIONS : Collections.EMPTY_MAP;
            }
            ITemplateContext templateContext = context instanceof ITemplateContext ? (ITemplateContext)context : null;
            ITemplateContext evaluationRoot = useSelectionAsRoot && templateContext != null && templateContext.hasSelectionTarget() ? templateContext.getSelectionTarget() : templateContext;
            try {
                result2 = OGNLVariableExpressionEvaluator.executeExpression(configuration, parsedExpression.expression, contextVariablesMap, evaluationRoot);
            }
            catch (OGNLShortcutExpression.OGNLShortcutExpressionNotApplicableException notApplicable) {
                OGNLVariableExpressionEvaluator.invalidateComputedOGNLExpression(configuration, expression, exp2);
                return OGNLVariableExpressionEvaluator.evaluate(context, expression, expContext, false);
            }
            if (!expContext.getPerformTypeConversion()) {
                return result2;
            }
            IStandardConversionService conversionService = StandardExpressions.getConversionService(configuration);
            return conversionService.convert(context, result2, String.class);
        }
        catch (Exception e2) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + expression.getExpression() + "\"", e2);
        }
    }

    private static ComputedOGNLExpression obtainComputedOGNLExpression(IEngineConfiguration configuration, IStandardVariableExpression expression, String exp2, StandardExpressionExecutionContext expContext, boolean applyOGNLShortcuts) throws OgnlException {
        boolean doApplyOGNLShortcuts;
        boolean bl = doApplyOGNLShortcuts = applyOGNLShortcuts && !expContext.getRestrictVariableAccess() && !expContext.getRestrictInstantiationAndStatic();
        if (expContext.getRestrictInstantiationAndStatic() && StandardExpressionUtils.containsOGNLInstantiationOrStaticOrParam(exp2)) {
            throw new TemplateProcessingException("Instantiation of new objects and access to static classes or parameters is forbidden in this context");
        }
        if (expression instanceof VariableExpression) {
            VariableExpression vexpression = (VariableExpression)expression;
            Object cachedExpression = vexpression.getCachedExpression();
            if (cachedExpression != null && cachedExpression instanceof ComputedOGNLExpression) {
                return (ComputedOGNLExpression)cachedExpression;
            }
            cachedExpression = OGNLVariableExpressionEvaluator.parseComputedOGNLExpression(configuration, exp2, doApplyOGNLShortcuts);
            if (cachedExpression != null) {
                vexpression.setCachedExpression(cachedExpression);
            }
            return (ComputedOGNLExpression)cachedExpression;
        }
        if (expression instanceof SelectionVariableExpression) {
            SelectionVariableExpression vexpression = (SelectionVariableExpression)expression;
            Object cachedExpression = vexpression.getCachedExpression();
            if (cachedExpression != null && cachedExpression instanceof ComputedOGNLExpression) {
                return (ComputedOGNLExpression)cachedExpression;
            }
            cachedExpression = OGNLVariableExpressionEvaluator.parseComputedOGNLExpression(configuration, exp2, doApplyOGNLShortcuts);
            if (cachedExpression != null) {
                vexpression.setCachedExpression(cachedExpression);
            }
            return (ComputedOGNLExpression)cachedExpression;
        }
        return OGNLVariableExpressionEvaluator.parseComputedOGNLExpression(configuration, exp2, doApplyOGNLShortcuts);
    }

    private static ComputedOGNLExpression parseComputedOGNLExpression(IEngineConfiguration configuration, String exp2, boolean applyOGNLShortcuts) throws OgnlException {
        ComputedOGNLExpression parsedExpression = (ComputedOGNLExpression)ExpressionCache.getFromCache(configuration, exp2, EXPRESSION_CACHE_TYPE_OGNL);
        if (parsedExpression != null) {
            return parsedExpression;
        }
        parsedExpression = OGNLVariableExpressionEvaluator.parseExpression(exp2, applyOGNLShortcuts);
        ExpressionCache.putIntoCache(configuration, exp2, parsedExpression, EXPRESSION_CACHE_TYPE_OGNL);
        return parsedExpression;
    }

    private static void invalidateComputedOGNLExpression(IEngineConfiguration configuration, IStandardVariableExpression expression, String exp2) {
        if (expression instanceof VariableExpression) {
            VariableExpression vexpression = (VariableExpression)expression;
            vexpression.setCachedExpression(null);
        } else if (expression instanceof SelectionVariableExpression) {
            SelectionVariableExpression vexpression = (SelectionVariableExpression)expression;
            vexpression.setCachedExpression(null);
        }
        ExpressionCache.removeFromCache(configuration, exp2, EXPRESSION_CACHE_TYPE_OGNL);
    }

    public String toString() {
        return "OGNL";
    }

    private static ComputedOGNLExpression parseExpression(String expression, boolean applyOGNLShortcuts) throws OgnlException {
        String[] parsedExpression;
        boolean mightNeedExpressionObjects = StandardExpressionUtils.mightNeedExpressionObjects(expression);
        if (applyOGNLShortcuts && (parsedExpression = OGNLShortcutExpression.parse(expression)) != null) {
            return new ComputedOGNLExpression(new OGNLShortcutExpression(parsedExpression), mightNeedExpressionObjects);
        }
        return new ComputedOGNLExpression(Ognl.parseExpression(expression), mightNeedExpressionObjects);
    }

    private static Object executeExpression(IEngineConfiguration configuration, Object parsedExpression, Map<String, Object> context, Object root) throws Exception {
        if (parsedExpression instanceof OGNLShortcutExpression) {
            return ((OGNLShortcutExpression)parsedExpression).evaluate(configuration, context, root);
        }
        OgnlContext ognlContext = new OgnlContext(MEMBER_ACCESS, CLASS_RESOLVER, null, context);
        return Ognl.getValue(parsedExpression, (Map)ognlContext, root);
    }

    private static final class ComputedOGNLExpression {
        final Object expression;
        final boolean mightNeedExpressionObjects;

        ComputedOGNLExpression(Object expression, boolean mightNeedExpressionObjects) {
            this.expression = expression;
            this.mightNeedExpressionObjects = mightNeedExpressionObjects;
        }
    }

    static final class ThymeleafACLClassResolver
    implements ClassResolver {
        private final ClassResolver classResolver = new ThymeleafDefaultClassResolver();

        @Override
        public Class<?> classForName(String className, Map context) throws ClassNotFoundException {
            if (!ExpressionUtils.isTypeAllowed(className)) {
                throw new TemplateProcessingException(String.format("Access is forbidden for type '%s' in this expression context.", className));
            }
            return this.classResolver.classForName(className, context);
        }
    }

    static final class ThymeleafACLMemberAccess
    extends AbstractMemberAccess {
        ThymeleafACLMemberAccess() {
        }

        @Override
        public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
            int modifiers = member.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                return false;
            }
            if (member instanceof Method && !ExpressionUtils.isMemberAllowed(target, member.getName())) {
                throw new TemplateProcessingException(String.format("Accessing member '%s' is forbidden for type '%s' in this expression context.", member.getName(), target.getClass()));
            }
            return true;
        }
    }

    static final class ThymeleafDefaultClassResolver
    implements ClassResolver {
        private final ConcurrentHashMap<String, Class> classes = new ConcurrentHashMap(101);

        ThymeleafDefaultClassResolver() {
        }

        @Override
        public Class classForName(String className, Map context) throws ClassNotFoundException {
            Class result2 = this.classes.get(className);
            if (result2 != null) {
                return result2;
            }
            result2 = this.toClassForName(className);
            this.classes.putIfAbsent(className, result2);
            return result2;
        }

        private Class toClassForName(String className) throws ClassNotFoundException {
            return Class.forName(className);
        }
    }
}

