/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.util.Validate;

public final class TextLiteralExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(TextLiteralExpression.class);
    private static final long serialVersionUID = 6511847028638506552L;
    static final char ESCAPE_PREFIX = '\\';
    static final char DELIMITER = '\'';
    private final LiteralValue value;

    public TextLiteralExpression(String value2) {
        Validate.notNull(value2, "Value cannot be null");
        this.value = new LiteralValue(TextLiteralExpression.unwrapLiteral(value2));
    }

    public LiteralValue getValue() {
        return this.value;
    }

    private static String unwrapLiteral(String input) {
        int inputLen = input.length();
        if (inputLen > 1 && input.charAt(0) == '\'' && input.charAt(inputLen - 1) == '\'') {
            return TextLiteralExpression.unescapeLiteral(input.substring(1, inputLen - 1));
        }
        return input;
    }

    @Override
    public String getStringRepresentation() {
        return String.valueOf('\'') + this.value.getValue().replace(String.valueOf('\''), "\\'") + String.valueOf('\'');
    }

    static TextLiteralExpression parseTextLiteralExpression(String input) {
        return new TextLiteralExpression(input);
    }

    static Object executeTextLiteralExpression(IExpressionContext context, TextLiteralExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating text literal: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }

    public static String wrapStringIntoLiteral(String str) {
        if (str == null) {
            return null;
        }
        int n = str.length();
        while (n-- != 0) {
            if (str.charAt(n) != '\'') continue;
            StringBuilder strBuilder = new StringBuilder(str.length() + 5);
            strBuilder.append('\'');
            int strLen = str.length();
            for (int i2 = 0; i2 < strLen; ++i2) {
                char c2 = str.charAt(i2);
                if (c2 == '\'') {
                    strBuilder.append('\\');
                }
                strBuilder.append(c2);
            }
            strBuilder.append('\'');
            return strBuilder.toString();
        }
        return '\'' + str + '\'';
    }

    static boolean isDelimiterEscaped(String input, int pos) {
        if (pos == 0 || input.charAt(pos - 1) != '\\') {
            return false;
        }
        boolean odd = false;
        for (int i2 = pos - 1; i2 >= 0; --i2) {
            if (input.charAt(i2) != '\\') {
                return odd;
            }
            odd = !odd;
        }
        return odd;
    }

    private static String unescapeLiteral(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        int max2 = text.length();
        int readOffset = 0;
        int referenceOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            if (c2 == '\\') {
                switch (text.charAt(i2 + 1)) {
                    case '\'': {
                        c2 = '\'';
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case '\\': {
                        c2 = '\\';
                        referenceOffset = i2 + 1;
                        break;
                    }
                    default: {
                        referenceOffset = i2;
                    }
                }
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 5);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            strBuilder.append(c2);
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        return strBuilder.toString();
    }
}

