/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.standard.expression.SimpleExpression;

public abstract class Token
extends SimpleExpression {
    private static final long serialVersionUID = 4357087922344497120L;
    private final Object value;

    protected Token(Object value2) {
        this.value = value2;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String getStringRepresentation() {
        return this.value.toString();
    }

    @Override
    public String toString() {
        return this.getStringRepresentation();
    }

    public static boolean isTokenChar(String context, int pos) {
        char c2 = context.charAt(pos);
        if (c2 >= 'a' && c2 <= 'z') {
            return true;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            return true;
        }
        if (c2 >= '0' && c2 <= '9') {
            return true;
        }
        if (c2 == ' ' || c2 == '\n' || c2 == '(' || c2 == ')' || c2 == '\'' || c2 == '\"' || c2 == '<' || c2 == '>' || c2 == '{' || c2 == '}' || c2 == '=' || c2 == ',' || c2 == ';' || c2 == ':' || c2 == '+' || c2 == '*' || c2 == '$' || c2 == '%' || c2 == '&' || c2 == '#') {
            return false;
        }
        if (c2 == '[' || c2 == ']' || c2 == '.' || c2 == '_') {
            return true;
        }
        if (c2 == '-') {
            int contextLen;
            if (pos > 0) {
                for (int i2 = pos - 1; i2 >= 0 && Token.isTokenChar(context, i2); --i2) {
                    char cc = context.charAt(i2);
                    if (cc >= '0' && cc <= '9' || cc == '.') continue;
                    return true;
                }
            }
            if (pos + 1 < (contextLen = context.length())) {
                for (int i3 = pos + 1; i3 < contextLen; ++i3) {
                    char cc = context.charAt(i3);
                    if (cc == '-') {
                        return true;
                    }
                    if (!Token.isTokenChar(context, i3)) break;
                    if (cc >= '0' && cc <= '9' || cc == '.') continue;
                    return true;
                }
            }
            return false;
        }
        if (c2 == '\u00b7') {
            return true;
        }
        if (c2 >= '\u00c0' && c2 <= '\u00d6') {
            return true;
        }
        if (c2 >= '\u00d8' && c2 <= '\u00f6') {
            return true;
        }
        if (c2 >= '\u00f8' && c2 <= '\u02ff') {
            return true;
        }
        if (c2 >= '\u0300' && c2 <= '\u036f') {
            return true;
        }
        if (c2 >= '\u0370' && c2 <= '\u037d') {
            return true;
        }
        if (c2 >= '\u037f' && c2 <= '\u1fff') {
            return true;
        }
        if (c2 >= '\u200c' && c2 <= '\u200d') {
            return true;
        }
        if (c2 >= '\u203f' && c2 <= '\u2040') {
            return true;
        }
        if (c2 >= '\u2070' && c2 <= '\u218f') {
            return true;
        }
        if (c2 >= '\u2c00' && c2 <= '\u2fef') {
            return true;
        }
        if (c2 >= '\u3001' && c2 <= '\ud7ff') {
            return true;
        }
        if (c2 >= '\uf900' && c2 <= '\ufdcf') {
            return true;
        }
        if (c2 >= '\ufdf0' && c2 <= '\ufffd') {
            return true;
        }
        return c2 >= '\ufdf0' && c2 <= '\ufffd';
    }

    public static final class TokenParsingTracer {
        public static final char TOKEN_SUBSTITUTE = '#';

        private TokenParsingTracer() {
        }

        public static String trace(String input) {
            int inputLen = input.length();
            StringBuilder strBuilder = new StringBuilder(inputLen + 1);
            for (int i2 = 0; i2 < inputLen; ++i2) {
                if (Token.isTokenChar(input, i2)) {
                    strBuilder.append('#');
                    continue;
                }
                strBuilder.append(input.charAt(i2));
            }
            return strBuilder.toString();
        }
    }
}

