/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.serializer.IStandardJavaScriptSerializer;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.DateUtils;
import org.unbescape.json.JsonEscape;
import org.unbescape.json.JsonEscapeLevel;
import org.unbescape.json.JsonEscapeType;

public final class StandardJavaScriptSerializer
implements IStandardJavaScriptSerializer {
    private static final Logger logger = LoggerFactory.getLogger(StandardJavaScriptSerializer.class);
    private final IStandardJavaScriptSerializer delegate;

    private String computeJacksonPackageNameIfPresent() {
        try {
            Class<ObjectMapper> objectMapperClass = ObjectMapper.class;
            String objectMapperPackageName = objectMapperClass.getPackage().getName();
            return objectMapperPackageName.substring(0, objectMapperPackageName.length() - ".databind".length());
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public StandardJavaScriptSerializer(boolean useJacksonIfAvailable) {
        String jacksonPrefix;
        IStandardJavaScriptSerializer newDelegate = null;
        String string = jacksonPrefix = useJacksonIfAvailable ? this.computeJacksonPackageNameIfPresent() : null;
        if (jacksonPrefix != null) {
            try {
                newDelegate = new JacksonStandardJavaScriptSerializer(jacksonPrefix);
            }
            catch (Exception e2) {
                this.handleErrorLoggingOnJacksonInitialization(e2);
            }
            catch (NoSuchMethodError e3) {
                this.handleErrorLoggingOnJacksonInitialization(e3);
            }
        }
        if (newDelegate == null) {
            newDelegate = new DefaultStandardJavaScriptSerializer();
        }
        this.delegate = newDelegate;
    }

    @Override
    public void serializeValue(Object object, Writer writer) {
        this.delegate.serializeValue(object, writer);
    }

    private void handleErrorLoggingOnJacksonInitialization(Throwable e2) {
        String warningMessage = "[THYMELEAF] Could not initialize Jackson-based serializer even if the Jackson library was detected to be present at the classpath. Please make sure you are adding the jackson-databind module to your classpath, and that version is >= 2.5.0. THYMELEAF INITIALIZATION WILL CONTINUE, but Jackson will not be used for JavaScript serialization.";
        if (logger.isDebugEnabled()) {
            logger.warn("[THYMELEAF] Could not initialize Jackson-based serializer even if the Jackson library was detected to be present at the classpath. Please make sure you are adding the jackson-databind module to your classpath, and that version is >= 2.5.0. THYMELEAF INITIALIZATION WILL CONTINUE, but Jackson will not be used for JavaScript serialization.", e2);
        } else {
            logger.warn("[THYMELEAF] Could not initialize Jackson-based serializer even if the Jackson library was detected to be present at the classpath. Please make sure you are adding the jackson-databind module to your classpath, and that version is >= 2.5.0. THYMELEAF INITIALIZATION WILL CONTINUE, but Jackson will not be used for JavaScript serialization. Set the log to DEBUG to see a complete exception trace. Exception message is: " + e2.getMessage());
        }
    }

    private static final class JacksonStandardJavaScriptSerializer
    implements IStandardJavaScriptSerializer {
        private final ObjectMapper mapper = new ObjectMapper();

        JacksonStandardJavaScriptSerializer(String jacksonPrefix) {
            this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.mapper.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            this.mapper.getFactory().configure(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature(), true);
            this.mapper.getFactory().setCharacterEscapes(new JacksonThymeleafCharacterEscapes());
            this.mapper.setDateFormat(new JacksonThymeleafISO8601DateFormat());
            Class<?> javaTimeModuleClass = ClassLoaderUtils.findClass(jacksonPrefix + ".datatype.jsr310.JavaTimeModule");
            if (javaTimeModuleClass != null) {
                try {
                    this.mapper.registerModule((Module)javaTimeModuleClass.newInstance());
                    this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
                }
                catch (InstantiationException e2) {
                    throw new ConfigurationException("Exception while trying to initialize JSR310 support for Jackson", e2);
                }
                catch (IllegalAccessException e3) {
                    throw new ConfigurationException("Exception while trying to initialize JSR310 support for Jackson", e3);
                }
            }
        }

        @Override
        public void serializeValue(Object object, Writer writer) {
            try {
                this.mapper.writeValue(writer, object);
            }
            catch (IOException e2) {
                throw new TemplateProcessingException("An exception was raised while trying to serialize object to JavaScript using Jackson", e2);
            }
        }
    }

    private static final class DefaultStandardJavaScriptSerializer
    implements IStandardJavaScriptSerializer {
        private DefaultStandardJavaScriptSerializer() {
        }

        @Override
        public void serializeValue(Object object, Writer writer) {
            try {
                DefaultStandardJavaScriptSerializer.writeValue(writer, object);
            }
            catch (IOException e2) {
                throw new TemplateProcessingException("An exception was raised while trying to serialize object to JavaScript using the default serializer", e2);
            }
        }

        private static void writeValue(Writer writer, Object object) throws IOException {
            if (object == null) {
                DefaultStandardJavaScriptSerializer.writeNull(writer);
                return;
            }
            if (object instanceof CharSequence) {
                DefaultStandardJavaScriptSerializer.writeString(writer, object.toString());
                return;
            }
            if (object instanceof Character) {
                DefaultStandardJavaScriptSerializer.writeString(writer, object.toString());
                return;
            }
            if (object instanceof Number) {
                DefaultStandardJavaScriptSerializer.writeNumber(writer, (Number)object);
                return;
            }
            if (object instanceof Boolean) {
                DefaultStandardJavaScriptSerializer.writeBoolean(writer, (Boolean)object);
                return;
            }
            if (object instanceof Date) {
                DefaultStandardJavaScriptSerializer.writeDate(writer, (Date)object);
                return;
            }
            if (object instanceof Calendar) {
                DefaultStandardJavaScriptSerializer.writeDate(writer, ((Calendar)object).getTime());
                return;
            }
            if (object.getClass().isArray()) {
                DefaultStandardJavaScriptSerializer.writeArray(writer, object);
                return;
            }
            if (object instanceof Collection) {
                DefaultStandardJavaScriptSerializer.writeCollection(writer, (Collection)object);
                return;
            }
            if (object instanceof Map) {
                DefaultStandardJavaScriptSerializer.writeMap(writer, (Map)object);
                return;
            }
            if (object instanceof Enum) {
                DefaultStandardJavaScriptSerializer.writeEnum(writer, object);
                return;
            }
            DefaultStandardJavaScriptSerializer.writeObject(writer, object);
        }

        private static void writeNull(Writer writer) throws IOException {
            writer.write("null");
        }

        private static void writeString(Writer writer, String str) throws IOException {
            writer.write(34);
            writer.write(JsonEscape.escapeJson(str, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_2_ALL_NON_ASCII_PLUS_BASIC_ESCAPE_SET));
            writer.write(34);
        }

        private static void writeNumber(Writer writer, Number number) throws IOException {
            writer.write(number.toString());
        }

        private static void writeBoolean(Writer writer, Boolean bool) throws IOException {
            writer.write(bool.toString());
        }

        private static void writeDate(Writer writer, Date date) throws IOException {
            writer.write(34);
            writer.write(DateUtils.formatISO(date));
            writer.write(34);
        }

        private static void writeArray(Writer writer, Object arrayObj) throws IOException {
            writer.write(91);
            if (arrayObj instanceof Object[]) {
                Object[] array = (Object[])arrayObj;
                boolean first2 = true;
                for (Object element : array) {
                    if (first2) {
                        first2 = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof boolean[]) {
                boolean[] array = (boolean[])arrayObj;
                boolean first3 = true;
                for (boolean element : array) {
                    if (first3) {
                        first3 = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof byte[]) {
                byte[] array = (byte[])arrayObj;
                boolean first4 = true;
                for (byte element : array) {
                    if (first4) {
                        first4 = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof short[]) {
                short[] array = (short[])arrayObj;
                boolean first5 = true;
                for (short element : array) {
                    if (first5) {
                        first5 = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof int[]) {
                int[] array = (int[])arrayObj;
                boolean first6 = true;
                for (int element : array) {
                    if (first6) {
                        first6 = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof long[]) {
                long[] array = (long[])arrayObj;
                boolean first7 = true;
                for (long element : array) {
                    if (first7) {
                        first7 = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof float[]) {
                float[] array = (float[])arrayObj;
                boolean first8 = true;
                for (float element : array) {
                    if (first8) {
                        first8 = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, Float.valueOf(element));
                }
            } else if (arrayObj instanceof double[]) {
                double[] array = (double[])arrayObj;
                boolean first9 = true;
                for (double element : array) {
                    if (first9) {
                        first9 = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else {
                throw new IllegalArgumentException("Cannot write value \"" + arrayObj + "\" of class " + arrayObj.getClass().getName() + " as an array");
            }
            writer.write(93);
        }

        private static void writeCollection(Writer writer, Collection<?> collection) throws IOException {
            writer.write(91);
            boolean first2 = true;
            for (Object element : collection) {
                if (first2) {
                    first2 = false;
                } else {
                    writer.write(44);
                }
                DefaultStandardJavaScriptSerializer.writeValue(writer, element);
            }
            writer.write(93);
        }

        private static void writeMap(Writer writer, Map<?, ?> map2) throws IOException {
            writer.write(123);
            boolean first2 = true;
            for (Map.Entry<?, ?> entry : map2.entrySet()) {
                if (first2) {
                    first2 = false;
                } else {
                    writer.write(44);
                }
                DefaultStandardJavaScriptSerializer.writeKeyValue(writer, entry.getKey(), entry.getValue());
            }
            writer.write(125);
        }

        private static void writeKeyValue(Writer writer, Object key2, Object value2) throws IOException {
            DefaultStandardJavaScriptSerializer.writeValue(writer, key2);
            writer.write(58);
            DefaultStandardJavaScriptSerializer.writeValue(writer, value2);
        }

        private static void writeObject(Writer writer, Object object) throws IOException {
            try {
                PropertyDescriptor[] descriptors = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(descriptors.length + 1, 1.0f);
                for (PropertyDescriptor descriptor2 : descriptors) {
                    String name;
                    Method readMethod = descriptor2.getReadMethod();
                    if (readMethod == null || "class".equals((name = descriptor2.getName()).toLowerCase())) continue;
                    Object value2 = readMethod.invoke(object, new Object[0]);
                    properties.put(name, value2);
                }
                DefaultStandardJavaScriptSerializer.writeMap(writer, properties);
            }
            catch (IllegalAccessException e2) {
                throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e2);
            }
            catch (InvocationTargetException e3) {
                throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e3);
            }
            catch (IntrospectionException e4) {
                throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e4);
            }
        }

        private static void writeEnum(Writer writer, Object object) throws IOException {
            Enum enumObject = (Enum)object;
            DefaultStandardJavaScriptSerializer.writeString(writer, enumObject.toString());
        }
    }

    private static final class JacksonThymeleafCharacterEscapes
    extends CharacterEscapes {
        private static final int[] CHARACTER_ESCAPES = CharacterEscapes.standardAsciiEscapesForJSON();
        private static final SerializableString SLASH_ESCAPE;
        private static final SerializableString AMPERSAND_ESCAPE;

        JacksonThymeleafCharacterEscapes() {
        }

        @Override
        public int[] getEscapeCodesForAscii() {
            return CHARACTER_ESCAPES;
        }

        @Override
        public SerializableString getEscapeSequence(int ch) {
            if (ch == 47) {
                return SLASH_ESCAPE;
            }
            if (ch == 38) {
                return AMPERSAND_ESCAPE;
            }
            return null;
        }

        static {
            JacksonThymeleafCharacterEscapes.CHARACTER_ESCAPES[47] = -2;
            JacksonThymeleafCharacterEscapes.CHARACTER_ESCAPES[38] = -2;
            SLASH_ESCAPE = new SerializedString("\\/");
            AMPERSAND_ESCAPE = new SerializedString("\\u0026");
        }
    }

    private static final class JacksonThymeleafISO8601DateFormat
    extends DateFormat {
        private static final long serialVersionUID = 1354081220093875129L;
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZ");

        JacksonThymeleafISO8601DateFormat() {
            this.setCalendar(this.dateFormat.getCalendar());
            this.setNumberFormat(this.dateFormat.getNumberFormat());
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            StringBuffer formatted = this.dateFormat.format(date, toAppendTo, fieldPosition);
            formatted.insert(26, ':');
            return formatted;
        }

        @Override
        public Date parse(String source2, ParsePosition pos) {
            throw new UnsupportedOperationException("JacksonThymeleafISO8601DateFormat should never be asked for a 'parse' operation");
        }

        @Override
        public Object clone() {
            JacksonThymeleafISO8601DateFormat other = (JacksonThymeleafISO8601DateFormat)super.clone();
            other.dateFormat = (SimpleDateFormat)this.dateFormat.clone();
            return other;
        }
    }
}

