/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.util;

public final class StandardConditionalCommentUtils {
    public static ConditionalCommentParsingResult parseConditionalComment(CharSequence text) {
        int i2;
        int len2 = text.length();
        for (i2 = 4; i2 < len2 && Character.isWhitespace(text.charAt(i2)); ++i2) {
        }
        if (i2 >= len2 || text.charAt(i2++) != '[') {
            return null;
        }
        int startExpressionOffset = i2;
        while (i2 < len2 && text.charAt(i2) != ']') {
            ++i2;
        }
        if (i2 >= len2) {
            return null;
        }
        int startExpressionLen = i2 - startExpressionOffset;
        ++i2;
        while (i2 < len2 && Character.isWhitespace(text.charAt(i2))) {
            ++i2;
        }
        if (i2 >= len2 || text.charAt(i2++) != '>') {
            return null;
        }
        int contentOffset = i2;
        for (i2 = len2 - 3 - 1; i2 > contentOffset && Character.isWhitespace(text.charAt(i2)); --i2) {
        }
        if (i2 <= contentOffset || text.charAt(i2--) != ']') {
            return null;
        }
        int endExpressionLastPos = i2 + 1;
        while (i2 > contentOffset && text.charAt(i2) != '[') {
            --i2;
        }
        if (i2 <= contentOffset) {
            return null;
        }
        int endExpressionOffset = i2 + 1;
        int endExpressionLen = endExpressionLastPos - endExpressionOffset;
        --i2;
        while (i2 >= contentOffset && Character.isWhitespace(text.charAt(i2))) {
            --i2;
        }
        if (i2 <= contentOffset || text.charAt(i2--) != '!') {
            return null;
        }
        if (i2 <= contentOffset || text.charAt(i2--) != '<') {
            return null;
        }
        int contentLen = i2 + 1 - contentOffset;
        if (contentLen <= 0 || startExpressionLen <= 0 || endExpressionLen <= 0) {
            return null;
        }
        return new ConditionalCommentParsingResult(startExpressionOffset, startExpressionLen, contentOffset, contentLen, endExpressionOffset, endExpressionLen);
    }

    private StandardConditionalCommentUtils() {
    }

    public static final class ConditionalCommentParsingResult {
        private final int startExpressionOffset;
        private final int startExpressionLen;
        private final int contentOffset;
        private final int contentLen;
        private final int endExpressionOffset;
        private final int endExpressionLen;

        public ConditionalCommentParsingResult(int startExpressionOffset, int startExpressionLen, int contentOffset, int contentLen, int endExpressionOffset, int endExpressionLen) {
            this.startExpressionOffset = startExpressionOffset;
            this.startExpressionLen = startExpressionLen;
            this.contentOffset = contentOffset;
            this.contentLen = contentLen;
            this.endExpressionOffset = endExpressionOffset;
            this.endExpressionLen = endExpressionLen;
        }

        public int getStartExpressionOffset() {
            return this.startExpressionOffset;
        }

        public int getStartExpressionLen() {
            return this.startExpressionLen;
        }

        public int getContentOffset() {
            return this.contentOffset;
        }

        public int getContentLen() {
            return this.contentLen;
        }

        public int getEndExpressionOffset() {
            return this.endExpressionOffset;
        }

        public int getEndExpressionLen() {
            return this.endExpressionLen;
        }
    }
}

