/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.markup;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.attoparser.AbstractMarkupHandler;
import org.attoparser.IMarkupHandler;
import org.attoparser.IMarkupParser;
import org.attoparser.MarkupParser;
import org.attoparser.ParseException;
import org.attoparser.config.ParseConfiguration;
import org.attoparser.select.BlockSelectorMarkupHandler;
import org.attoparser.select.IMarkupSelectorReferenceResolver;
import org.attoparser.select.NodeSelectorMarkupHandler;
import org.thymeleaf.EngineConfiguration;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.TemplateHandlerAdapterMarkupHandler;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.templateparser.markup.InlinedOutputExpressionMarkupHandler;
import org.thymeleaf.templateparser.markup.TemplateFragmentMarkupReferenceResolver;
import org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogic;
import org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogicMarkupHandler;
import org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogicUtils;
import org.thymeleaf.templateparser.reader.ParserLevelCommentMarkupReader;
import org.thymeleaf.templateparser.reader.PrototypeOnlyCommentMarkupReader;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.Validate;

public abstract class AbstractMarkupTemplateParser
implements ITemplateParser {
    private final IMarkupParser parser;
    private final boolean html;

    protected AbstractMarkupTemplateParser(ParseConfiguration parseConfiguration, int bufferPoolSize, int bufferSize) {
        Validate.notNull(parseConfiguration, "Parse configuration cannot be null");
        this.parser = new MarkupParser(parseConfiguration, bufferPoolSize, bufferSize);
        this.html = parseConfiguration.getMode().equals((Object)ParseConfiguration.ParsingMode.HTML);
    }

    @Override
    public void parseStandalone(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource2, TemplateMode templateMode, boolean useDecoupledLogic, ITemplateHandler handler2) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull(resource2, "Template Resource cannot be null");
        Validate.notNull((Object)templateMode, "Template Mode cannot be null");
        Validate.isTrue(templateMode.isMarkup(), "Template Mode has to be a markup template mode");
        Validate.notNull(handler2, "Template Handler cannot be null");
        this.parse(configuration, ownerTemplate, template, templateSelectors, resource2, 0, 0, templateMode, useDecoupledLogic, handler2);
    }

    @Override
    public void parseString(IEngineConfiguration configuration, String ownerTemplate, String template, int lineOffset, int colOffset, TemplateMode templateMode, ITemplateHandler handler2) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(ownerTemplate, "Owner template cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Validate.isTrue(templateMode.isMarkup(), "Template Mode has to be a markup template mode");
        Validate.notNull(handler2, "Template Handler cannot be null");
        this.parse(configuration, ownerTemplate, template, null, null, lineOffset, colOffset, templateMode, false, handler2);
    }

    private void parse(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource2, int lineOffset, int colOffset, TemplateMode templateMode, boolean useDecoupledLogic, ITemplateHandler templateHandler) {
        if (templateMode == TemplateMode.HTML) {
            Validate.isTrue(this.html, "Parser is configured as XML, but HTML-mode template parsing is being requested");
        } else if (templateMode == TemplateMode.XML) {
            Validate.isTrue(!this.html, "Parser is configured as HTML, but XML-mode template parsing is being requested");
        } else {
            throw new IllegalArgumentException("Parser is configured as " + (this.html ? "HTML" : "XML") + " but an unsupported template mode has been specified: " + (Object)((Object)templateMode));
        }
        String templateName = resource2 != null ? template : ownerTemplate;
        try {
            String standardDialectPrefix;
            boolean selectBlock;
            DecoupledTemplateLogic decoupledTemplateLogic = useDecoupledLogic && resource2 != null ? DecoupledTemplateLogicUtils.computeDecoupledTemplateLogic(configuration, ownerTemplate, template, templateSelectors, resource2, templateMode, this.parser) : null;
            AbstractMarkupHandler handler2 = new TemplateHandlerAdapterMarkupHandler(templateName, templateHandler, configuration.getElementDefinitions(), configuration.getAttributeDefinitions(), templateMode, lineOffset, colOffset);
            if (configuration instanceof EngineConfiguration && ((EngineConfiguration)configuration).isModelReshapeable(templateMode)) {
                handler2 = new InlinedOutputExpressionMarkupHandler(configuration, templateMode, configuration.getStandardDialectPrefix(), handler2);
            }
            boolean injectAttributes = decoupledTemplateLogic != null && decoupledTemplateLogic.hasInjectedAttributes();
            boolean bl = selectBlock = templateSelectors != null && !templateSelectors.isEmpty();
            TemplateFragmentMarkupReferenceResolver referenceResolver = injectAttributes || selectBlock ? ((standardDialectPrefix = configuration.getStandardDialectPrefix()) != null ? TemplateFragmentMarkupReferenceResolver.forPrefix(this.html, standardDialectPrefix) : null) : null;
            if (selectBlock) {
                handler2 = new BlockSelectorMarkupHandler((IMarkupHandler)handler2, templateSelectors.toArray(new String[templateSelectors.size()]), (IMarkupSelectorReferenceResolver)referenceResolver);
            }
            if (injectAttributes) {
                handler2 = new DecoupledTemplateLogicMarkupHandler(decoupledTemplateLogic, handler2);
                Set<String> nodeSelectors = decoupledTemplateLogic.getAllInjectedAttributeSelectors();
                handler2 = new NodeSelectorMarkupHandler((IMarkupHandler)handler2, (IMarkupHandler)handler2, nodeSelectors.toArray(new String[nodeSelectors.size()]), (IMarkupSelectorReferenceResolver)referenceResolver);
            }
            Reader templateReader = resource2 != null ? resource2.reader() : new StringReader(template);
            templateReader = new ParserLevelCommentMarkupReader(new PrototypeOnlyCommentMarkupReader(templateReader));
            this.parser.parse(templateReader, (IMarkupHandler)handler2);
        }
        catch (IOException e2) {
            String message = "An error happened during template parsing";
            throw new TemplateInputException("An error happened during template parsing", resource2 != null ? resource2.getDescription() : template, e2);
        }
        catch (ParseException e3) {
            String message = "An error happened during template parsing";
            if (e3.getLine() != null && e3.getCol() != null) {
                throw new TemplateInputException("An error happened during template parsing", resource2 != null ? resource2.getDescription() : template, e3.getLine(), e3.getCol(), e3);
            }
            throw new TemplateInputException("An error happened during template parsing", resource2 != null ? resource2.getDescription() : template, e3);
        }
    }
}

