/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.raw;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.TemplateHandlerAdapterRawHandler;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.templateparser.raw.IRawHandler;
import org.thymeleaf.templateparser.raw.RawParseException;
import org.thymeleaf.templateparser.raw.RawParser;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.Validate;

public final class RawTemplateParser
implements ITemplateParser {
    private final RawParser parser;

    public RawTemplateParser(int bufferPoolSize, int bufferSize) {
        this.parser = new RawParser(bufferPoolSize, bufferSize);
    }

    @Override
    public void parseStandalone(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource2, TemplateMode templateMode, boolean useDecoupledLogic, ITemplateHandler handler2) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull(resource2, "Template Resource cannot be null");
        Validate.isTrue(templateSelectors == null || templateSelectors.isEmpty(), "Template selectors cannot be specified for a template using RAW template mode: template insertion operations must be always performed on whole template files, not fragments");
        Validate.notNull((Object)templateMode, "Template Mode cannot be null");
        Validate.isTrue(templateMode == TemplateMode.RAW, "Template Mode has to be RAW");
        Validate.isTrue(!useDecoupledLogic, "Cannot use decoupled logic in template mode " + (Object)((Object)templateMode));
        Validate.notNull(handler2, "Template Handler cannot be null");
        this.parse(configuration, ownerTemplate, template, templateSelectors, resource2, 0, 0, templateMode, handler2);
    }

    @Override
    public void parseString(IEngineConfiguration configuration, String ownerTemplate, String template, int lineOffset, int colOffset, TemplateMode templateMode, ITemplateHandler handler2) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(ownerTemplate, "Owner template cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Validate.isTrue(templateMode == TemplateMode.RAW, "Template Mode has to be RAW");
        Validate.notNull(handler2, "Template Handler cannot be null");
        this.parse(configuration, ownerTemplate, template, null, null, lineOffset, colOffset, templateMode, handler2);
    }

    private void parse(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource2, int lineOffset, int colOffset, TemplateMode templateMode, ITemplateHandler templateHandler) {
        String templateName = resource2 != null ? template : ownerTemplate;
        try {
            TemplateHandlerAdapterRawHandler handler2 = new TemplateHandlerAdapterRawHandler(templateName, templateHandler, lineOffset, colOffset);
            Reader templateReader = resource2 != null ? resource2.reader() : new StringReader(template);
            this.parser.parse(templateReader, (IRawHandler)handler2);
        }
        catch (IOException e2) {
            String message = "An error happened during template parsing";
            throw new TemplateInputException("An error happened during template parsing", resource2 != null ? resource2.getDescription() : template, e2);
        }
        catch (RawParseException e3) {
            String message = "An error happened during template parsing";
            if (e3.getLine() != null && e3.getCol() != null) {
                throw new TemplateInputException("An error happened during template parsing", resource2 != null ? resource2.getDescription() : template, e3.getLine(), e3.getCol(), e3);
            }
            throw new TemplateInputException("An error happened during template parsing", resource2 != null ? resource2.getDescription() : template, e3);
        }
    }
}

