/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.inline.IInlinePreProcessorHandler;
import org.thymeleaf.standard.inline.OutputExpressionInlinePreProcessorHandler;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateparser.text.AbstractChainedTextHandler;
import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.TextParseException;

final class InlinedOutputExpressionTextHandler
extends AbstractChainedTextHandler {
    private final OutputExpressionInlinePreProcessorHandler inlineHandler;

    InlinedOutputExpressionTextHandler(IEngineConfiguration configuration, TemplateMode templateMode, String standardDialectPrefix, ITextHandler handler2) {
        super(handler2);
        this.inlineHandler = new OutputExpressionInlinePreProcessorHandler(configuration, templateMode, standardDialectPrefix, new InlineTextAdapterPreProcessorHandler(handler2));
    }

    @Override
    public void handleText(char[] buffer, int offset, int len2, int line, int col) throws TextParseException {
        this.inlineHandler.handleText(buffer, offset, len2, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws TextParseException {
        this.inlineHandler.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }

    @Override
    public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws TextParseException {
        this.inlineHandler.handleStandaloneElementEnd(buffer, nameOffset, nameLen, minimized, line, col);
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.inlineHandler.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.inlineHandler.handleOpenElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.inlineHandler.handleCloseElementStart(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.inlineHandler.handleCloseElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws TextParseException {
        this.inlineHandler.handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
    }

    private static final class InlineTextAdapterPreProcessorHandler
    implements IInlinePreProcessorHandler {
        private ITextHandler handler;

        InlineTextAdapterPreProcessorHandler(ITextHandler handler2) {
            this.handler = handler2;
        }

        @Override
        public void handleText(char[] buffer, int offset, int len2, int line, int col) {
            try {
                this.handler.handleText(buffer, offset, len2, line, col);
            }
            catch (TextParseException e2) {
                throw new TemplateProcessingException("Parse exception during processing of inlining", e2);
            }
        }

        @Override
        public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) {
            try {
                this.handler.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
            }
            catch (TextParseException e2) {
                throw new TemplateProcessingException("Parse exception during processing of inlining", e2);
            }
        }

        @Override
        public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) {
            try {
                this.handler.handleStandaloneElementEnd(buffer, nameOffset, nameLen, minimized, line, col);
            }
            catch (TextParseException e2) {
                throw new TemplateProcessingException("Parse exception during processing of inlining", e2);
            }
        }

        @Override
        public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) {
            try {
                this.handler.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
            }
            catch (TextParseException e2) {
                throw new TemplateProcessingException("Parse exception during processing of inlining", e2);
            }
        }

        @Override
        public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) {
            try {
                this.handler.handleOpenElementEnd(buffer, nameOffset, nameLen, line, col);
            }
            catch (TextParseException e2) {
                throw new TemplateProcessingException("Parse exception during processing of inlining", e2);
            }
        }

        @Override
        public void handleAutoOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) {
            throw new TemplateProcessingException("Parse exception during processing of inlining: auto-open not allowed in text mode");
        }

        @Override
        public void handleAutoOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) {
            throw new TemplateProcessingException("Parse exception during processing of inlining: auto-open not allowed in text mode");
        }

        @Override
        public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) {
            try {
                this.handler.handleCloseElementStart(buffer, nameOffset, nameLen, line, col);
            }
            catch (TextParseException e2) {
                throw new TemplateProcessingException("Parse exception during processing of inlining", e2);
            }
        }

        @Override
        public void handleCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) {
            try {
                this.handler.handleCloseElementEnd(buffer, nameOffset, nameLen, line, col);
            }
            catch (TextParseException e2) {
                throw new TemplateProcessingException("Parse exception during processing of inlining", e2);
            }
        }

        @Override
        public void handleAutoCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) {
            throw new TemplateProcessingException("Parse exception during processing of inlining: auto-close not allowed in text mode");
        }

        @Override
        public void handleAutoCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) {
            throw new TemplateProcessingException("Parse exception during processing of inlining: auto-close not allowed in text mode");
        }

        @Override
        public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) {
            try {
                this.handler.handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
            }
            catch (TextParseException e2) {
                throw new TemplateProcessingException("Parse exception during processing of inlining", e2);
            }
        }
    }
}

