/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.thymeleaf.templateparser.text.CommentProcessorTextHandler;
import org.thymeleaf.templateparser.text.EventProcessorTextHandler;
import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.ParsingLocatorUtil;
import org.thymeleaf.templateparser.text.TextParseException;
import org.thymeleaf.templateparser.text.TextParseStatus;
import org.thymeleaf.templateparser.text.TextParsingCommentUtil;
import org.thymeleaf.templateparser.text.TextParsingElementUtil;
import org.thymeleaf.templateparser.text.TextParsingLiteralUtil;
import org.thymeleaf.templateparser.text.TextParsingUtil;

final class TextParser {
    private final BufferPool pool;
    private final boolean processCommentsAndLiterals;
    private final boolean standardDialectPresent;

    TextParser(int poolSize, int bufferSize, boolean processCommentsAndLiterals, boolean standardDialectPresent) {
        this.pool = new BufferPool(poolSize, bufferSize);
        this.processCommentsAndLiterals = processCommentsAndLiterals;
        this.standardDialectPresent = standardDialectPresent;
    }

    public void parse(String document, ITextHandler handler2) throws TextParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.parse(new StringReader(document), handler2);
    }

    public void parse(Reader reader2, ITextHandler handler2) throws TextParseException {
        if (reader2 == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        if (handler2 == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        ITextHandler handlerChain = handler2;
        handlerChain = new EventProcessorTextHandler(handlerChain);
        if (this.processCommentsAndLiterals) {
            handlerChain = new CommentProcessorTextHandler(this.standardDialectPresent, handlerChain);
        }
        this.parseDocument(reader2, this.pool.poolBufferSize, handlerChain);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseDocument(Reader reader2, int suggestedBufferSize, ITextHandler handler2) throws TextParseException {
        long parsingStartTimeNanos = System.nanoTime();
        char[] buffer = null;
        try {
            TextParseStatus status3333332 = new TextParseStatus();
            handler2.handleDocumentStart(parsingStartTimeNanos, 1, 1);
            int bufferSize = suggestedBufferSize;
            buffer = this.pool.allocateBuffer(bufferSize);
            int bufferContentSize = reader2.read(buffer);
            boolean cont = bufferContentSize != -1;
            status3333332.offset = -1;
            status3333332.line = 1;
            status3333332.col = 1;
            status3333332.inStructure = false;
            status3333332.inCommentLine = false;
            status3333332.literalMarker = '\u0000';
            while (cont) {
                this.parseBuffer(buffer, 0, bufferContentSize, handler2, status3333332);
                int readOffset = 0;
                int readLen = bufferSize;
                if (status3333332.offset == 0) {
                    if (bufferContentSize == bufferSize) {
                        char[] newBuffer = null;
                        try {
                            newBuffer = this.pool.allocateBuffer(bufferSize *= 2);
                            System.arraycopy(buffer, 0, newBuffer, 0, bufferContentSize);
                            this.pool.releaseBuffer(buffer);
                            buffer = newBuffer;
                        }
                        catch (Exception ignored) {
                            this.pool.releaseBuffer(newBuffer);
                        }
                    }
                    readOffset = bufferContentSize;
                    readLen = bufferSize - readOffset;
                } else if (status3333332.offset < bufferContentSize) {
                    System.arraycopy(buffer, status3333332.offset, buffer, 0, bufferContentSize - status3333332.offset);
                    readOffset = bufferContentSize - status3333332.offset;
                    readLen = bufferSize - readOffset;
                    status3333332.offset = 0;
                    bufferContentSize = readOffset;
                }
                int read2 = reader2.read(buffer, readOffset, readLen);
                if (read2 != -1) {
                    bufferContentSize = readOffset + read2;
                    continue;
                }
                cont = false;
            }
            int lastLine = status3333332.line;
            int lastCol = status3333332.col;
            int lastStart = status3333332.offset;
            int lastLen = bufferContentSize - lastStart;
            if (lastLen > 0) {
                if (status3333332.inStructure && !status3333332.inCommentLine) {
                    throw new TextParseException("Incomplete structure: \"" + new String(buffer, lastStart, lastLen) + "\"", status3333332.line, status3333332.col);
                }
                handler2.handleText(buffer, lastStart, lastLen, status3333332.line, status3333332.col);
                for (int i2 = lastStart; i2 < lastStart + lastLen; ++i2) {
                    char c2 = buffer[i2];
                    if (c2 == '\n') {
                        ++lastLine;
                        lastCol = 1;
                        continue;
                    }
                    ++lastCol;
                }
            }
            long parsingEndTimeNanos = System.nanoTime();
            handler2.handleDocumentEnd(parsingEndTimeNanos, parsingEndTimeNanos - parsingStartTimeNanos, lastLine, lastCol);
        }
        catch (TextParseException e2) {
            try {
                throw e2;
                catch (Exception e3) {
                    throw new TextParseException(e3);
                }
            }
            catch (Throwable throwable) {
                this.pool.releaseBuffer(buffer);
                try {
                    reader2.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.pool.releaseBuffer(buffer);
        try {
            reader2.close();
            return;
        }
        catch (Throwable status3333332) {
            return;
        }
    }

    private void parseBuffer(char[] buffer, int offset, int len2, ITextHandler handler2, TextParseStatus status2) throws TextParseException {
        int i2;
        int[] locator = new int[]{status2.line, status2.col};
        int currentLine = locator[0];
        int currentCol = locator[1];
        int maxi = offset + len2;
        int current = i2 = offset;
        boolean inOpenElement = false;
        boolean inCloseElement = false;
        boolean inCommentBlock = false;
        boolean inCommentLine = false;
        boolean inLiteral = false;
        int pos = i2;
        int tagStart = i2;
        int tagEnd = i2;
        while (i2 < maxi) {
            boolean inStructure;
            boolean bl = inStructure = inOpenElement || inCloseElement || inCommentBlock || inCommentLine || inLiteral;
            if (!inStructure) {
                pos = TextParsingUtil.findNextStructureStartOrLiteralMarker(buffer, i2, maxi, locator, this.processCommentsAndLiterals);
                if (pos == -1) {
                    status2.offset = current;
                    status2.line = currentLine;
                    status2.col = currentCol;
                    status2.inStructure = false;
                    status2.inCommentLine = false;
                    status2.literalMarker = '\u0000';
                    return;
                }
                char c2 = buffer[pos];
                inOpenElement = TextParsingElementUtil.isOpenElementStart(buffer, pos, maxi);
                if (!(inOpenElement || (inCloseElement = TextParsingElementUtil.isCloseElementStart(buffer, pos, maxi)) || !this.processCommentsAndLiterals || (inCommentBlock = TextParsingCommentUtil.isCommentBlockStart(buffer, pos, maxi)) || (inCommentLine = TextParsingCommentUtil.isCommentLineStart(buffer, pos, maxi)))) {
                    inLiteral = c2 == '\'' || c2 == '\"' || c2 == '`' || TextParsingLiteralUtil.isRegexLiteralStart(buffer, pos, maxi);
                    status2.literalMarker = inLiteral ? c2 : (char)'\u0000';
                }
                boolean bl2 = inStructure = inOpenElement || inCloseElement || inCommentBlock || inCommentLine || inLiteral;
                if (inStructure && !inLiteral) {
                    tagStart = pos;
                }
                while (!inStructure) {
                    ParsingLocatorUtil.countChar(locator, c2);
                    pos = TextParsingUtil.findNextStructureStartOrLiteralMarker(buffer, pos + 1, maxi, locator, this.processCommentsAndLiterals);
                    if (pos == -1) {
                        status2.offset = current;
                        status2.line = currentLine;
                        status2.col = currentCol;
                        status2.inStructure = false;
                        status2.inCommentLine = false;
                        status2.literalMarker = '\u0000';
                        return;
                    }
                    c2 = buffer[pos];
                    inOpenElement = TextParsingElementUtil.isOpenElementStart(buffer, pos, maxi);
                    if (!(inOpenElement || (inCloseElement = TextParsingElementUtil.isCloseElementStart(buffer, pos, maxi)) || !this.processCommentsAndLiterals || (inCommentBlock = TextParsingCommentUtil.isCommentBlockStart(buffer, pos, maxi)) || (inCommentLine = TextParsingCommentUtil.isCommentLineStart(buffer, pos, maxi)))) {
                        inLiteral = c2 == '\'' || c2 == '\"' || c2 == '`' || TextParsingLiteralUtil.isRegexLiteralStart(buffer, pos, maxi);
                        status2.literalMarker = inLiteral ? c2 : (char)'\u0000';
                    }
                    if (!(inStructure = inOpenElement || inCloseElement || inCommentBlock || inCommentLine || inLiteral) || inLiteral) continue;
                    tagStart = pos;
                }
                if (tagStart > current) {
                    handler2.handleText(buffer, current, tagStart - current, currentLine, currentCol);
                }
                if (tagStart == pos) {
                    current = tagStart;
                    currentLine = locator[0];
                    currentCol = locator[1];
                }
                i2 = pos;
                continue;
            }
            int n = inLiteral ? TextParsingUtil.findNextLiteralEnd(buffer, i2, maxi, locator, status2.literalMarker) : (inCommentBlock ? TextParsingUtil.findNextCommentBlockEnd(buffer, i2, maxi, locator) : (pos = inCommentLine ? TextParsingUtil.findNextCommentLineEnd(buffer, i2, maxi, locator) : TextParsingUtil.findNextStructureEndAvoidQuotes(buffer, i2, maxi, locator)));
            if (pos < 0) {
                status2.offset = current;
                status2.line = currentLine;
                status2.col = currentCol;
                status2.inStructure = true;
                status2.inCommentLine = inCommentLine;
                status2.literalMarker = '\u0000';
                return;
            }
            if (inOpenElement) {
                tagEnd = pos;
                if (buffer[tagEnd - 1] == '/') {
                    TextParsingElementUtil.parseStandaloneElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                } else {
                    TextParsingElementUtil.parseOpenElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                }
                inOpenElement = false;
            } else if (inCloseElement) {
                tagEnd = pos;
                TextParsingElementUtil.parseCloseElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                inCloseElement = false;
            } else if (inCommentBlock) {
                tagEnd = pos;
                TextParsingCommentUtil.parseComment(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                inCommentBlock = false;
            } else if (inCommentLine) {
                tagEnd = pos;
                handler2.handleText(buffer, current, tagEnd - current + 1, currentLine, currentCol);
                inCommentLine = false;
            } else if (inLiteral) {
                inLiteral = false;
                status2.literalMarker = '\u0000';
            } else {
                throw new IllegalStateException("Illegal parsing state: structure is not of a recognized type");
            }
            ParsingLocatorUtil.countChar(locator, buffer[pos]);
            if (tagEnd == pos) {
                current = tagEnd + 1;
                currentLine = locator[0];
                currentCol = locator[1];
            }
            i2 = pos + 1;
        }
        status2.offset = current;
        status2.line = currentLine;
        status2.col = currentCol;
        status2.inStructure = false;
        status2.inCommentLine = false;
        status2.literalMarker = '\u0000';
    }

    private static final class BufferPool {
        private final char[][] pool;
        private final boolean[] allocated;
        private final int poolBufferSize;

        private BufferPool(int poolSize, int poolBufferSize) {
            this.pool = new char[poolSize][];
            this.allocated = new boolean[poolSize];
            this.poolBufferSize = poolBufferSize;
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                this.pool[i2] = new char[this.poolBufferSize];
            }
            Arrays.fill(this.allocated, false);
        }

        private synchronized char[] allocateBuffer(int bufferSize) {
            if (bufferSize != this.poolBufferSize) {
                return new char[bufferSize];
            }
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                if (this.allocated[i2]) continue;
                this.allocated[i2] = true;
                return this.pool[i2];
            }
            return new char[bufferSize];
        }

        private synchronized void releaseBuffer(char[] buffer) {
            if (buffer == null) {
                return;
            }
            if (buffer.length != this.poolBufferSize) {
                return;
            }
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                if (this.pool[i2] != buffer) continue;
                this.allocated[i2] = false;
                return;
            }
        }
    }
}

