/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.TextParseException;
import org.thymeleaf.templateparser.text.TextParsingUtil;

final class TextParsingAttributeSequenceUtil {
    private TextParsingAttributeSequenceUtil() {
    }

    public static void parseAttributeSequence(char[] buffer, int offset, int len2, int line, int col, ITextHandler handler2) throws TextParseException {
        int i2;
        int maxi = offset + len2;
        int[] locator = new int[]{line, col};
        int current = i2 = offset;
        while (i2 < maxi) {
            int valueEnd;
            int j2;
            boolean equalsPresent;
            int wsEnd = TextParsingUtil.findNextNonWhitespaceCharWildcard(buffer, i2, maxi, locator);
            if (wsEnd == -1) {
                i2 = maxi;
                continue;
            }
            if (wsEnd > current) {
                current = i2 = wsEnd;
            }
            int currentArtifactLine = locator[0];
            int currentArtifactCol = locator[1];
            int attributeNameEnd = TextParsingUtil.findNextOperatorCharWildcard(buffer, i2, maxi, locator);
            if (attributeNameEnd == -1) {
                handler2.handleAttribute(buffer, current, maxi - current, currentArtifactLine, currentArtifactCol, 0, 0, locator[0], locator[1], 0, 0, 0, 0, locator[0], locator[1]);
                i2 = maxi;
                continue;
            }
            if (attributeNameEnd <= current) {
                throw new TextParseException("Bad attribute name in sequence \"" + new String(buffer, offset, len2) + "\": attribute names cannot start with an equals sign", currentArtifactLine, currentArtifactCol);
            }
            int attributeNameOffset = current;
            int attributeNameLen = attributeNameEnd - current;
            int attributeNameLine = currentArtifactLine;
            int attributeNameCol = currentArtifactCol;
            current = i2 = attributeNameEnd;
            currentArtifactLine = locator[0];
            currentArtifactCol = locator[1];
            int operatorEnd = TextParsingUtil.findNextNonOperatorCharWildcard(buffer, i2, maxi, locator);
            if (operatorEnd == -1) {
                equalsPresent = false;
                for (j2 = i2; j2 < maxi; ++j2) {
                    if (buffer[j2] != '=') continue;
                    equalsPresent = true;
                    break;
                }
                if (equalsPresent) {
                    handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, current, maxi - current, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, locator[0], locator[1]);
                } else {
                    handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, 0, 0, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, currentArtifactLine, currentArtifactCol);
                }
                i2 = maxi;
                continue;
            }
            equalsPresent = false;
            for (j2 = current; j2 < operatorEnd; ++j2) {
                if (buffer[j2] != '=') continue;
                equalsPresent = true;
                break;
            }
            if (!equalsPresent) {
                handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, 0, 0, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, currentArtifactLine, currentArtifactCol);
                current = i2 = operatorEnd;
                continue;
            }
            int operatorOffset = current;
            int operatorLen = operatorEnd - current;
            int operatorLine = currentArtifactLine;
            int operatorCol = currentArtifactCol;
            current = i2 = operatorEnd;
            currentArtifactLine = locator[0];
            currentArtifactCol = locator[1];
            boolean attributeEndsWithQuotes = i2 < maxi && (buffer[current] == '\"' || buffer[current] == '\'');
            int n = valueEnd = attributeEndsWithQuotes ? TextParsingUtil.findNextAnyCharAvoidQuotesWildcard(buffer, i2, maxi, locator) : TextParsingUtil.findNextWhitespaceCharWildcard(buffer, i2, maxi, false, locator);
            if (valueEnd == -1) {
                int valueContentOffset = current;
                int valueContentLen = maxi - current;
                if (TextParsingAttributeSequenceUtil.isValueSurroundedByCommas(buffer, current, maxi - current)) {
                    ++valueContentOffset;
                    valueContentLen -= 2;
                }
                handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, current, maxi - current, currentArtifactLine, currentArtifactCol);
                i2 = maxi;
                continue;
            }
            int valueOuterOffset = current;
            int valueOuterLen = valueEnd - current;
            int valueContentOffset = valueOuterOffset;
            int valueContentLen = valueOuterLen;
            if (TextParsingAttributeSequenceUtil.isValueSurroundedByCommas(buffer, valueOuterOffset, valueOuterLen)) {
                valueContentOffset = valueOuterOffset + 1;
                valueContentLen = valueOuterLen - 2;
            }
            handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, currentArtifactLine, currentArtifactCol);
            current = i2 = valueEnd;
        }
    }

    private static boolean isValueSurroundedByCommas(char[] buffer, int offset, int len2) {
        return len2 >= 2 && (buffer[offset] == '\"' && buffer[offset + len2 - 1] == '\"' || buffer[offset] == '\'' && buffer[offset + len2 - 1] == '\'');
    }
}

