/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.TextParseException;

final class TextParsingCommentUtil {
    private TextParsingCommentUtil() {
    }

    public static void parseComment(char[] buffer, int offset, int len2, int line, int col, ITextHandler handler2) throws TextParseException {
        if (len2 < 4 || !TextParsingCommentUtil.isCommentBlockStart(buffer, offset, offset + len2) || !TextParsingCommentUtil.isCommentBlockEnd(buffer, offset + len2 - 2, offset + len2)) {
            throw new TextParseException("Could not parse as a well-formed Comment: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len2 - 4;
        handler2.handleComment(buffer, contentOffset, contentLen, offset, len2, line, col);
    }

    static boolean isCommentBlockStart(char[] buffer, int offset, int maxi) {
        return maxi - offset > 1 && buffer[offset] == '/' && buffer[offset + 1] == '*';
    }

    static boolean isCommentBlockEnd(char[] buffer, int offset, int maxi) {
        return maxi - offset > 1 && buffer[offset] == '*' && buffer[offset + 1] == '/';
    }

    static boolean isCommentLineStart(char[] buffer, int offset, int maxi) {
        return maxi - offset > 1 && buffer[offset] == '/' && buffer[offset + 1] == '/';
    }
}

