/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.TextParseException;
import org.thymeleaf.templateparser.text.TextParsingAttributeSequenceUtil;
import org.thymeleaf.templateparser.text.TextParsingUtil;

final class TextParsingElementUtil {
    private TextParsingElementUtil() {
    }

    public static void parseStandaloneElement(char[] buffer, int offset, int len2, int line, int col, ITextHandler handler2) throws TextParseException {
        if (len2 < 4 || !TextParsingElementUtil.isOpenElementStart(buffer, offset, offset + len2) || !TextParsingElementUtil.isElementEnd(buffer, offset + len2 - 2, offset + len2, true)) {
            throw new TextParseException("Could not parse as a well-formed standalone element: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len2 - 4;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int elementNameEnd = TextParsingUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            handler2.handleStandaloneElementStart(buffer, contentOffset, contentLen, true, line, col);
            handler2.handleStandaloneElementEnd(buffer, contentOffset, contentLen, true, locator[0], locator[1]);
            return;
        }
        handler2.handleStandaloneElementStart(buffer, contentOffset, elementNameEnd - contentOffset, true, line, col);
        TextParsingAttributeSequenceUtil.parseAttributeSequence(buffer, elementNameEnd, maxi - elementNameEnd, locator[0], locator[1], handler2);
        TextParsingUtil.findNextStructureEndAvoidQuotes(buffer, elementNameEnd, maxi, locator);
        handler2.handleStandaloneElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, true, locator[0], locator[1]);
    }

    public static void parseOpenElement(char[] buffer, int offset, int len2, int line, int col, ITextHandler handler2) throws TextParseException {
        if (len2 < 3 || !TextParsingElementUtil.isOpenElementStart(buffer, offset, offset + len2) || !TextParsingElementUtil.isElementEnd(buffer, offset + len2 - 1, offset + len2, false)) {
            throw new TextParseException("Could not parse as a well-formed open element: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len2 - 3;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int elementNameEnd = TextParsingUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            handler2.handleOpenElementStart(buffer, contentOffset, contentLen, line, col);
            handler2.handleOpenElementEnd(buffer, contentOffset, contentLen, locator[0], locator[1]);
            return;
        }
        handler2.handleOpenElementStart(buffer, contentOffset, elementNameEnd - contentOffset, line, col);
        TextParsingAttributeSequenceUtil.parseAttributeSequence(buffer, elementNameEnd, maxi - elementNameEnd, locator[0], locator[1], handler2);
        TextParsingUtil.findNextStructureEndAvoidQuotes(buffer, elementNameEnd, maxi, locator);
        handler2.handleOpenElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, locator[0], locator[1]);
    }

    public static void parseCloseElement(char[] buffer, int offset, int len2, int line, int col, ITextHandler handler2) throws TextParseException {
        if (len2 < 3 || !TextParsingElementUtil.isCloseElementStart(buffer, offset, offset + len2) || !TextParsingElementUtil.isElementEnd(buffer, offset + len2 - 1, offset + len2, false)) {
            throw new TextParseException("Could not parse as a well-formed close element: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len2 - 3;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int elementNameEnd = TextParsingUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            handler2.handleCloseElementStart(buffer, contentOffset, contentLen, line, col);
            handler2.handleCloseElementEnd(buffer, contentOffset, contentLen, locator[0], locator[1]);
            return;
        }
        handler2.handleCloseElementStart(buffer, contentOffset, elementNameEnd - contentOffset, line, col);
        int wsEnd = TextParsingUtil.findNextNonWhitespaceCharWildcard(buffer, elementNameEnd, maxi, locator);
        if (wsEnd != -1) {
            throw new TextParseException("Could not parse as a well-formed closing element \"" + new String(buffer, offset, len2) + "\": No attributes are allowed here", line, col);
        }
        handler2.handleCloseElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, locator[0], locator[1]);
    }

    static boolean isOpenElementStart(char[] buffer, int offset, int maxi) {
        int len2 = maxi - offset;
        return len2 > 2 && buffer[offset] == '[' && buffer[offset + 1] == '#' && TextParsingElementUtil.isElementNameOrEnd(buffer, offset + 2, maxi);
    }

    static boolean isCloseElementStart(char[] buffer, int offset, int maxi) {
        int len2 = maxi - offset;
        return len2 > 2 && buffer[offset] == '[' && buffer[offset + 1] == '/' && TextParsingElementUtil.isElementNameOrEnd(buffer, offset + 2, maxi);
    }

    static boolean isElementEnd(char[] buffer, int offset, int maxi, boolean minimized) {
        int len2 = maxi - offset;
        if (len2 < 1) {
            return false;
        }
        if (minimized) {
            if (len2 < 2 || buffer[offset] != '/') {
                return false;
            }
            return buffer[offset + 1] == ']';
        }
        return buffer[offset] == ']';
    }

    private static boolean isElementNameOrEnd(char[] buffer, int offset, int maxi) {
        if (Character.isWhitespace(buffer[offset])) {
            return true;
        }
        int len2 = maxi - offset;
        if (len2 > 1 && buffer[offset] == '/') {
            return TextParsingElementUtil.isElementEnd(buffer, offset, maxi, true);
        }
        if (len2 > 0 && buffer[offset] == ']') {
            return TextParsingElementUtil.isElementEnd(buffer, offset, maxi, false);
        }
        return len2 > 0 && buffer[offset] != '-' && buffer[offset] != '!' && buffer[offset] != '/' && buffer[offset] != '?' && buffer[offset] != '[' && buffer[offset] != '{' && !Character.isWhitespace(buffer[offset]);
    }
}

