/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import org.thymeleaf.templateparser.text.ParsingLocatorUtil;

final class TextParsingUtil {
    private TextParsingUtil() {
    }

    static int findNextStructureEndAvoidQuotes(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int colIndex = offset;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (c2 == '\n') {
                colIndex = i2;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (c2 == '\"' && !inApos) {
                inQuotes = !inQuotes;
            } else if (c2 == '\'' && !inQuotes) {
                inApos = !inApos;
            } else if (c2 == ']' && !inQuotes && !inApos) {
                locator[1] = locator[1] + (i2 - colIndex);
                return i2;
            }
            ++i2;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextCommentBlockEnd(char[] text, int offset, int maxi, int[] locator) {
        int colIndex = offset;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (c2 == '\n') {
                colIndex = i2;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (i2 > offset && c2 == '/' && text[i2 - 1] == '*') {
                locator[1] = locator[1] + (i2 - colIndex);
                return i2;
            }
            ++i2;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextCommentLineEnd(char[] text, int offset, int maxi, int[] locator) {
        int colIndex = offset;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (c2 == '\n') {
                locator[1] = locator[1] + (i2 - colIndex);
                return i2;
            }
            ++i2;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextLiteralEnd(char[] text, int offset, int maxi, int[] locator, char literalMarker) {
        int colIndex = offset;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (c2 == '\n') {
                colIndex = i2;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (i2 > offset && c2 == literalMarker && TextParsingUtil.isLiteralDelimiter(text, offset, i2)) {
                locator[1] = locator[1] + (i2 - colIndex);
                return i2;
            }
            ++i2;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextStructureStartOrLiteralMarker(char[] text, int offset, int maxi, int[] locator, boolean processCommentsAndLiterals) {
        int colIndex = offset;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (c2 == '\n') {
                colIndex = i2;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else {
                if (c2 == '[') {
                    locator[1] = locator[1] + (i2 - colIndex);
                    return i2;
                }
                if (processCommentsAndLiterals) {
                    if (c2 == '/') {
                        locator[1] = locator[1] + (i2 - colIndex);
                        return i2;
                    }
                    if ((c2 == '\'' || c2 == '\"' || c2 == '`') && TextParsingUtil.isLiteralDelimiter(text, offset, i2)) {
                        locator[1] = locator[1] + (i2 - colIndex);
                        return i2;
                    }
                }
            }
            ++i2;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    private static boolean isLiteralDelimiter(char[] text, int offset, int i2) {
        int escapes = 0;
        int j2 = i2 - 1;
        while (j2 >= offset && text[j2--] == '\\') {
            ++escapes;
        }
        return escapes % 2 == 0;
    }

    static int findNextWhitespaceCharWildcard(char[] text, int offset, int maxi, boolean avoidQuotes, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (avoidQuotes && !inApos && c2 == '\"') {
                inQuotes = !inQuotes;
            } else if (avoidQuotes && !inQuotes && c2 == '\'') {
                inApos = !inApos;
            } else if (!inQuotes && !inApos && (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r' || c2 == '\f' || c2 == '\u000b' || c2 == '\u001c' || c2 == '\u001d' || c2 == '\u001e' || c2 == '\u001f' || c2 > '\u007f' && Character.isWhitespace(c2))) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c2);
            ++i2;
        }
        return -1;
    }

    static int findNextNonWhitespaceCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            boolean isWhitespace;
            char c2 = text[i2];
            boolean bl = isWhitespace = c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r' || c2 == '\f' || c2 == '\u000b' || c2 == '\u001c' || c2 == '\u001d' || c2 == '\u001e' || c2 == '\u001f' || c2 > '\u007f' && Character.isWhitespace(c2);
            if (!isWhitespace) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c2);
            ++i2;
        }
        return -1;
    }

    static int findNextOperatorCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (c2 == '=' || c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r' || c2 == '\f' || c2 == '\u000b' || c2 == '\u001c' || c2 == '\u001d' || c2 == '\u001e' || c2 == '\u001f' || c2 > '\u007f' && Character.isWhitespace(c2)) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c2);
            ++i2;
        }
        return -1;
    }

    static int findNextNonOperatorCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (!(c2 == '=' || c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r' || c2 == '\f' || c2 == '\u000b' || c2 == '\u001c' || c2 == '\u001d' || c2 == '\u001e' || c2 == '\u001f' || c2 > '\u007f' && Character.isWhitespace(c2))) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c2);
            ++i2;
        }
        return -1;
    }

    static int findNextAnyCharAvoidQuotesWildcard(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c2 = text[i2];
            if (!inApos && c2 == '\"') {
                if (inQuotes) {
                    ParsingLocatorUtil.countChar(locator, c2);
                    return ++i2 < maxi ? i2 : -1;
                }
                inQuotes = true;
            } else if (!inQuotes && c2 == '\'') {
                if (inApos) {
                    ParsingLocatorUtil.countChar(locator, c2);
                    return ++i2 < maxi ? i2 : -1;
                }
                inApos = true;
            } else if (!inQuotes && !inApos) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c2);
            ++i2;
        }
        return -1;
    }
}

