/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.TemplateResourceUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class FileTemplateResource
implements ITemplateResource,
Serializable {
    private final String path;
    private final File file;
    private final String characterEncoding;

    public FileTemplateResource(String path2, String characterEncoding) {
        Validate.notEmpty(path2, "Resource Path cannot be null or empty");
        this.path = TemplateResourceUtils.cleanPath(path2);
        this.file = new File(path2);
        this.characterEncoding = characterEncoding;
    }

    public FileTemplateResource(File file2, String characterEncoding) {
        Validate.notNull(file2, "Resource File cannot be null");
        this.path = TemplateResourceUtils.cleanPath(file2.getPath());
        this.file = file2;
        this.characterEncoding = characterEncoding;
    }

    @Override
    public String getDescription() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getBaseName() {
        return TemplateResourceUtils.computeBaseName(this.path);
    }

    @Override
    public Reader reader() throws IOException {
        FileInputStream inputStream2 = new FileInputStream(this.file);
        if (!StringUtils.isEmptyOrWhitespace(this.characterEncoding)) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream2), this.characterEncoding));
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream2)));
    }

    @Override
    public ITemplateResource relative(String relativeLocation) {
        Validate.notEmpty(relativeLocation, "Relative Path cannot be null or empty");
        String fullRelativeLocation = TemplateResourceUtils.computeRelativeLocation(this.path, relativeLocation);
        return new FileTemplateResource(fullRelativeLocation, this.characterEncoding);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }
}

