/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.thymeleaf.util.EvaluationUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class DateUtils {
    private static final Map<DateFormatKey, DateFormat> dateFormats = new ConcurrentHashMap<DateFormatKey, DateFormat>(4, 0.9f, 2);
    private static final SimpleDateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZ");

    public static Calendar create(Object year2, Object month, Object day2) {
        return DateUtils.create(year2, month, day2, null, null, null, null, null, null);
    }

    public static Calendar create(Object year2, Object month, Object day2, Object hour2, Object minute2) {
        return DateUtils.create(year2, month, day2, hour2, minute2, null, null, null, null);
    }

    public static Calendar create(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, null, null, null);
    }

    public static Calendar create(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2, Object millisecond) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, millisecond, null, null);
    }

    public static Calendar create(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2, Object millisecond, Object timeZone) {
        return DateUtils.create(year2, month, day2, hour2, minute2, second2, millisecond, timeZone, null);
    }

    public static Calendar create(Object year2, Object month, Object day2, Object hour2, Object minute2, Object second2, Object millisecond, Object timeZone, Locale locale) {
        TimeZone tzTimeZone;
        BigDecimal nMillisecond;
        BigDecimal nYear = year2 == null ? null : EvaluationUtils.evaluateAsNumber(year2);
        BigDecimal nMonth = month == null ? null : EvaluationUtils.evaluateAsNumber(month);
        BigDecimal nDay = day2 == null ? null : EvaluationUtils.evaluateAsNumber(day2);
        BigDecimal nHour = hour2 == null ? null : EvaluationUtils.evaluateAsNumber(hour2);
        BigDecimal nMinute = minute2 == null ? null : EvaluationUtils.evaluateAsNumber(minute2);
        BigDecimal nSecond = second2 == null ? null : EvaluationUtils.evaluateAsNumber(second2);
        BigDecimal bigDecimal = nMillisecond = millisecond == null ? null : EvaluationUtils.evaluateAsNumber(millisecond);
        TimeZone timeZone2 = timeZone != null ? (timeZone instanceof TimeZone ? (TimeZone)timeZone : TimeZone.getTimeZone(timeZone.toString())) : (tzTimeZone = null);
        Calendar cal = tzTimeZone != null && locale != null ? Calendar.getInstance(tzTimeZone, locale) : (tzTimeZone != null ? Calendar.getInstance(tzTimeZone) : (locale != null ? Calendar.getInstance(locale) : Calendar.getInstance()));
        if (nYear == null || nMonth == null || nDay == null) {
            throw new IllegalArgumentException("Cannot create Calendar/Date object with null year (" + nYear + "), month (" + nMonth + ") or day (" + nDay + ")");
        }
        cal.set(1, nYear.intValue());
        cal.set(2, nMonth.intValue() - 1);
        cal.set(5, nDay.intValue());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (nHour != null && nMinute != null) {
            cal.set(11, nHour.intValue());
            cal.set(12, nMinute.intValue());
            if (nSecond != null) {
                cal.set(13, nSecond.intValue());
                if (nMillisecond != null) {
                    cal.set(14, nMillisecond.intValue());
                }
            } else if (nMillisecond != null) {
                throw new IllegalArgumentException("Calendar/Date object cannot be correctly created from a null second but non-null millisecond.");
            }
        } else {
            if (nHour != null || nMinute != null) {
                throw new IllegalArgumentException("Calendar/Date object can only be correctly created if hour (" + nHour + ") and minute (" + nMinute + ") are either both null or non-null.");
            }
            if (nSecond != null || nMillisecond != null) {
                throw new IllegalArgumentException("Calendar/Date object cannot be correctly created from a null hour and minute but non-null second and/or millisecond.");
            }
        }
        return cal;
    }

    public static Calendar createNow() {
        return DateUtils.createNow(null, null);
    }

    public static Calendar createNow(Object timeZone) {
        return DateUtils.createNow(timeZone, null);
    }

    public static Calendar createNow(Object timeZone, Locale locale) {
        TimeZone tzTimeZone;
        TimeZone timeZone2 = timeZone != null ? (timeZone instanceof TimeZone ? (TimeZone)timeZone : TimeZone.getTimeZone(timeZone.toString())) : (tzTimeZone = null);
        if (tzTimeZone != null && locale != null) {
            return Calendar.getInstance(tzTimeZone, locale);
        }
        if (tzTimeZone != null) {
            return Calendar.getInstance(tzTimeZone);
        }
        if (locale != null) {
            return Calendar.getInstance(locale);
        }
        return Calendar.getInstance();
    }

    public static Calendar createToday() {
        return DateUtils.createToday(null, null);
    }

    public static Calendar createToday(Object timeZone) {
        return DateUtils.createToday(timeZone, null);
    }

    public static Calendar createToday(Object timeZone, Locale locale) {
        Calendar cal = DateUtils.createNow(timeZone, locale);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal;
    }

    public static String format(Object target, Locale locale) {
        if (target == null) {
            return null;
        }
        return DateUtils.formatDate(target, locale);
    }

    public static String format(Object target, String pattern2, Locale locale) {
        Validate.notEmpty(pattern2, "Pattern cannot be null or empty");
        if (target == null) {
            return null;
        }
        return DateUtils.formatDate(target, pattern2, locale);
    }

    public static Integer day(Object target) {
        if (target == null) {
            return null;
        }
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(5);
    }

    public static Integer month(Object target) {
        if (target == null) {
            return null;
        }
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(2) + 1;
    }

    public static String monthName(Object target, Locale locale) {
        if (target == null) {
            return null;
        }
        return DateUtils.format(target, "MMMM", locale);
    }

    public static String monthNameShort(Object target, Locale locale) {
        if (target == null) {
            return null;
        }
        return DateUtils.format(target, "MMM", locale);
    }

    public static Integer year(Object target) {
        if (target == null) {
            return null;
        }
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(1);
    }

    public static Integer dayOfWeek(Object target) {
        if (target == null) {
            return null;
        }
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(7);
    }

    public static String dayOfWeekName(Object target, Locale locale) {
        if (target == null) {
            return null;
        }
        return DateUtils.format(target, "EEEE", locale);
    }

    public static String dayOfWeekNameShort(Object target, Locale locale) {
        if (target == null) {
            return null;
        }
        return DateUtils.format(target, "EEE", locale);
    }

    public static Integer hour(Object target) {
        if (target == null) {
            return null;
        }
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(11);
    }

    public static Integer minute(Object target) {
        if (target == null) {
            return null;
        }
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(12);
    }

    public static Integer second(Object target) {
        if (target == null) {
            return null;
        }
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(13);
    }

    public static Integer millisecond(Object target) {
        if (target == null) {
            return null;
        }
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(14);
    }

    private static Calendar normalizeDate(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Calendar) {
            return (Calendar)target;
        }
        if (target instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Date)target).getTime());
            return cal;
        }
        throw new IllegalArgumentException("Cannot normalize class \"" + target.getClass().getName() + "\" as a date");
    }

    private static String formatDate(Object target, Locale locale) {
        if (target == null) {
            return null;
        }
        return DateUtils.formatDate(target, null, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatDate(Object target, String pattern2, Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        DateFormatKey key2 = new DateFormatKey(target, pattern2, locale);
        DateFormat dateFormat = dateFormats.get(key2);
        if (dateFormat == null) {
            dateFormat = StringUtils.isEmptyOrWhitespace(pattern2) ? DateFormat.getDateTimeInstance(1, 1, locale) : new SimpleDateFormat(pattern2, locale);
            if (key2.timeZone != null) {
                dateFormat.setTimeZone(key2.timeZone);
            }
            dateFormats.put(key2, dateFormat);
        }
        if (target instanceof Calendar) {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                return dateFormat.format(((Calendar)target).getTime());
            }
        }
        if (target instanceof Date) {
            DateFormat dateFormat3 = dateFormat;
            synchronized (dateFormat3) {
                return dateFormat.format((Date)target);
            }
        }
        throw new IllegalArgumentException("Cannot format object of class \"" + target.getClass().getName() + "\" as a date");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatISO(Object target) {
        String formatted;
        Date targetDate;
        if (target == null) {
            return null;
        }
        if (target instanceof Calendar) {
            targetDate = ((Calendar)target).getTime();
        } else if (target instanceof Date) {
            targetDate = (Date)target;
        } else {
            throw new IllegalArgumentException("Cannot format object of class \"" + target.getClass().getName() + "\" as a date");
        }
        SimpleDateFormat simpleDateFormat = ISO8601_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            formatted = ISO8601_DATE_FORMAT.format(targetDate);
        }
        StringBuilder strBuilder = new StringBuilder(formatted.length() + 1);
        strBuilder.append(formatted);
        strBuilder.insert(26, ':');
        return strBuilder.toString();
    }

    private DateUtils() {
    }

    private static final class DateFormatKey {
        final String format;
        final TimeZone timeZone;
        final Locale locale;

        DateFormatKey(Object target, String format2, Locale locale) {
            Validate.notNull(locale, "Locale cannot be null");
            this.format = format2;
            this.locale = locale;
            this.timeZone = target != null && target instanceof Calendar ? ((Calendar)target).getTimeZone() : null;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.format == null ? 0 : this.format.hashCode());
            result2 = 31 * result2 + this.locale.hashCode();
            result2 = 31 * result2 + (this.timeZone == null ? 0 : this.timeZone.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DateFormatKey other = (DateFormatKey)obj;
            if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
                return false;
            }
            if (this.timeZone == null ? other.timeZone != null : !this.timeZone.equals(other.timeZone)) {
                return false;
            }
            return this.locale.equals(other.locale);
        }
    }
}

