/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.thymeleaf.util.Validate;

public final class ExpressionUtils {
    private static final Set<String> BLOCKED_ALL_PURPOSES_PACKAGE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("java.", "javax.", "jakarta.", "jdk.", "org.ietf.jgss.", "org.omg.", "org.w3c.dom.", "org.xml.sax.", "com.sun.", "sun."));
    private static final Set<String> ALLOWED_ALL_PURPOSES_PACKAGE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("java.time."));
    private static final Set<String> BLOCKED_TYPE_REFERENCE_PACKAGE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("com.squareup.javapoet.", "net.bytebuddy.", "net.sf.cglib.", "javassist.", "javax0.geci.", "org.apache.bcel.", "org.aspectj.", "org.javassist.", "org.mockito.", "org.objectweb.asm.", "org.objenesis.", "org.springframework.aot.", "org.springframework.asm.", "org.springframework.cglib.", "org.springframework.javapoet.", "org.springframework.objenesis.", "org.springframework.web.", "org.springframework.webflow.", "org.springframework.context.", "org.springframework.beans.", "org.springframework.aspects.", "org.springframework.aop.", "org.springframework.expression.", "org.springframework.util."));
    private static final Set<String> ALLOWED_JAVA_CLASS_NAMES;
    private static final Set<Class<?>> ALLOWED_JAVA_CLASSES;
    private static final Set<String> ALLOWED_JAVA_SUPERS_NAMES;
    private static final Set<Class<?>> ALLOWED_JAVA_SUPERS;
    private static final Set<String> BLOCKED_MEMBER_CALL_JAVA_SUPERS_NAMES;
    private static final Set<Class<?>> BLOCKED_MEMBER_CALL_JAVA_SUPERS;
    private static final Set<String> ALLOWED_CLASS_METHODS;
    private static final Set<String> BLOCKED_CLASS_METHODS;

    public static String normalize(String expression) {
        if (expression == null) {
            return expression;
        }
        StringBuilder strBuilder = null;
        int expLen = expression.length();
        for (int i2 = 0; i2 < expLen; ++i2) {
            char c2 = expression.charAt(i2);
            if (c2 != '\n' && (c2 < ' ' || c2 >= '\u007f' && c2 <= '\u009f')) {
                if (strBuilder != null) continue;
                strBuilder = new StringBuilder(expLen);
                strBuilder.append(expression, 0, i2);
                continue;
            }
            if (strBuilder == null) continue;
            strBuilder.append(c2);
        }
        return strBuilder == null ? expression : strBuilder.toString();
    }

    static boolean isJavaPackage(String typeName2) {
        return typeName2.charAt(0) == 'j' && typeName2.charAt(4) == '.' && typeName2.charAt(1) == 'a' && typeName2.charAt(2) == 'v' && typeName2.charAt(3) == 'a';
    }

    static boolean isTypeBlockedForAllPurposes(String typeName2) {
        char c0 = typeName2.charAt(0);
        if (c0 != 'c' && c0 != 'j' && c0 != 'o' && c0 != 's') {
            return false;
        }
        if (c0 == 'c') {
            return typeName2.startsWith("com.sun.");
        }
        if (ExpressionUtils.isJavaPackage(typeName2)) {
            return !typeName2.startsWith("java.time.");
        }
        return BLOCKED_ALL_PURPOSES_PACKAGE_NAME_PREFIXES.stream().anyMatch(prefix2 -> typeName2.startsWith((String)prefix2));
    }

    static boolean isTypeBlockedForTypeReference(String typeName2) {
        if (ExpressionUtils.isTypeBlockedForAllPurposes(typeName2)) {
            return true;
        }
        char c0 = typeName2.charAt(0);
        if (c0 != 'c' && c0 != 'n' && c0 != 'j' && c0 != 'o') {
            return false;
        }
        if (c0 == 'c') {
            return typeName2.startsWith("com.squareup.javapoet.");
        }
        return BLOCKED_TYPE_REFERENCE_PACKAGE_NAME_PREFIXES.stream().anyMatch(prefix2 -> typeName2.startsWith((String)prefix2));
    }

    public static boolean isTypeAllowed(String typeName2) {
        Validate.notNull(typeName2, "Type name cannot be null");
        String normalizedTypeName = ExpressionUtils.normalize(typeName2);
        if (!ExpressionUtils.isTypeBlockedForTypeReference(normalizedTypeName)) {
            return true;
        }
        return ALLOWED_JAVA_CLASS_NAMES.contains(normalizedTypeName) || ALLOWED_JAVA_SUPERS_NAMES.contains(normalizedTypeName);
    }

    static boolean isTypeBlockedForMemberCalls(Class<?> type2) {
        return BLOCKED_MEMBER_CALL_JAVA_SUPERS.stream().anyMatch(i2 -> i2.isAssignableFrom(type2));
    }

    static boolean isMemberAllowedForInstanceOfType(Class<?> type2, String memberName) {
        Validate.notNull(type2, "Type cannot be null");
        String typeName2 = type2.getName();
        if (!ExpressionUtils.isTypeBlockedForAllPurposes(typeName2) && !ExpressionUtils.isTypeBlockedForMemberCalls(type2)) {
            return true;
        }
        if (type2.isEnum() || type2.isAnnotation()) {
            return true;
        }
        if (Proxy.isProxyClass(type2)) {
            return true;
        }
        if (ALLOWED_JAVA_CLASSES.contains(type2)) {
            return true;
        }
        return ALLOWED_JAVA_SUPERS.stream().filter(i2 -> i2.isAssignableFrom(type2)).anyMatch(i2 -> Arrays.stream(i2.getDeclaredMethods()).anyMatch(m4 -> memberName.equals(m4.getName())));
    }

    public static boolean isMemberAllowed(Object target, String memberName) {
        Validate.notNull(memberName, "Member name cannot be null");
        if (target == null) {
            return true;
        }
        String normalizedMemberName = ExpressionUtils.normalize(memberName);
        if ("getClass".equals(normalizedMemberName) || "toString".equals(normalizedMemberName)) {
            return true;
        }
        if (target instanceof Class) {
            String targetTypeName = ((Class)target).getName();
            return ALLOWED_CLASS_METHODS.contains(normalizedMemberName) || !BLOCKED_CLASS_METHODS.contains(normalizedMemberName) && ExpressionUtils.isTypeAllowed(targetTypeName);
        }
        return ExpressionUtils.isMemberAllowedForInstanceOfType(target.getClass(), normalizedMemberName);
    }

    private ExpressionUtils() {
    }

    static {
        ALLOWED_JAVA_CLASSES = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Enum.class, Float.class, Integer.class, Long.class, Math.class, Number.class, Short.class, String.class, BigDecimal.class, BigInteger.class, RoundingMode.class, ArrayList.class, LinkedList.class, HashMap.class, LinkedHashMap.class, HashSet.class, LinkedHashSet.class, Iterator.class, Enumeration.class, Deque.class, Locale.class, Properties.class, java.util.Date.class, Calendar.class, Optional.class, OptionalDouble.class, OptionalInt.class, OptionalLong.class, UUID.class, Currency.class, AtomicBoolean.class, AtomicInteger.class, AtomicIntegerArray.class, AtomicIntegerFieldUpdater.class, AtomicLong.class, AtomicLongArray.class, AtomicLongFieldUpdater.class, AtomicMarkableReference.class, AtomicReference.class, AtomicReferenceArray.class, AtomicReferenceFieldUpdater.class, AtomicStampedReference.class, DoubleAccumulator.class, DoubleAdder.class, LongAccumulator.class, LongAdder.class, Date.class, Time.class, Timestamp.class));
        ALLOWED_JAVA_SUPERS = new HashSet<Class>(Arrays.asList(Collection.class, Iterable.class, Iterator.class, List.class, Map.class, Map.Entry.class, Set.class, Calendar.class, Stream.class));
        BLOCKED_MEMBER_CALL_JAVA_SUPERS_NAMES = new HashSet<String>(Arrays.asList("java.lang.ClassLoader", "org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator", "org.thymeleaf.standard.expression.IStandardExpressionParser", "org.thymeleaf.standard.expression.IStandardConversionService", "org.thymeleaf.spring5.context.IThymeleafRequestContext", "org.thymeleaf.spring5.expression.IThymeleafEvaluationContext", "org.thymeleaf.spring6.context.IThymeleafRequestContext", "org.thymeleaf.spring6.expression.IThymeleafEvaluationContext", "org.springframework.web.servlet.support.RequestContext", "org.springframework.web.reactive.result.view.RequestContext", "org.springframework.core.io.ResourceLoader"));
        ALLOWED_CLASS_METHODS = new HashSet<String>(Arrays.asList("getName", "isAssignableFrom", "isInstance", "isInterface", "isPrimitive", "isRecord", "isAnnotation", "isArray", "isEnum"));
        BLOCKED_CLASS_METHODS = Arrays.stream(Class.class.getDeclaredMethods()).map(Method::getName).collect(Collectors.toSet());
        ALLOWED_JAVA_CLASS_NAMES = ALLOWED_JAVA_CLASSES.stream().map(c2 -> c2.getName()).collect(Collectors.toSet());
        ALLOWED_JAVA_SUPERS_NAMES = ALLOWED_JAVA_SUPERS.stream().map(c2 -> c2.getName()).collect(Collectors.toSet());
        BLOCKED_MEMBER_CALL_JAVA_SUPERS = BLOCKED_MEMBER_CALL_JAVA_SUPERS_NAMES.stream().map(className -> {
            try {
                return Optional.of(Class.forName(className));
            }
            catch (ClassNotFoundException e2) {
                return Optional.ofNullable(null);
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }
}

