/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.IOException;
import java.io.Writer;

public final class FastStringWriter
extends Writer {
    private final StringBuilder builder;

    public FastStringWriter() {
        this.builder = new StringBuilder();
    }

    public FastStringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.builder = new StringBuilder(initialSize);
    }

    @Override
    public void write(int c2) {
        this.builder.append((char)c2);
    }

    @Override
    public void write(String str) {
        this.builder.append(str);
    }

    @Override
    public void write(String str, int off, int len2) {
        this.builder.append(str, off, off + len2);
    }

    @Override
    public void write(char[] cbuf) {
        this.builder.append(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len2) {
        if (off < 0 || off > cbuf.length || len2 < 0 || off + len2 > cbuf.length || off + len2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len2 == 0) {
            return;
        }
        this.builder.append(cbuf, off, len2);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.builder.toString();
    }
}

