/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.thymeleaf.util.Validate;

public final class ListUtils {
    public static List<?> toList(Object target) {
        Validate.notNull(target, "Cannot convert null to list");
        if (target instanceof List) {
            return (List)target;
        }
        if (target.getClass().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])target));
        }
        if (target instanceof Iterable) {
            ArrayList elements = new ArrayList(10);
            for (Object element : (Iterable)target) {
                elements.add(element);
            }
            return elements;
        }
        throw new IllegalArgumentException("Cannot convert object of class \"" + target.getClass().getName() + "\" to a list");
    }

    public static int size(List<?> target) {
        Validate.notNull(target, "Cannot get list size of null");
        return target.size();
    }

    public static boolean isEmpty(List<?> target) {
        return target == null || target.isEmpty();
    }

    public static boolean contains(List<?> target, Object element) {
        Validate.notNull(target, "Cannot execute list contains: target is null");
        return target.contains(element);
    }

    public static boolean containsAll(List<?> target, Object[] elements) {
        Validate.notNull(target, "Cannot execute list containsAll: target is null");
        Validate.notNull(elements, "Cannot execute list containsAll: elements is null");
        return ListUtils.containsAll(target, Arrays.asList(elements));
    }

    public static boolean containsAll(List<?> target, Collection<?> elements) {
        Validate.notNull(target, "Cannot execute list contains: target is null");
        Validate.notNull(elements, "Cannot execute list containsAll: elements is null");
        return target.containsAll(elements);
    }

    public static <T extends Comparable<? super T>> List<T> sort(List<T> list) {
        Validate.notNull(list, "Cannot execute list sort: list is null");
        Object[] a2 = list.toArray();
        Arrays.sort(a2);
        return ListUtils.fillNewList(a2, list.getClass());
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c2) {
        Validate.notNull(list, "Cannot execute list sort: list is null");
        Object[] a2 = list.toArray();
        Arrays.sort(a2, c2);
        return ListUtils.fillNewList(a2, list.getClass());
    }

    private static <T> List<T> fillNewList(Object[] a2, Class<? extends List> listType) {
        ArrayList<Object> newList;
        try {
            newList = listType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            newList = new ArrayList<Object>(a2.length + 2);
        }
        for (Object object : a2) {
            newList.add(object);
        }
        return newList;
    }

    private ListUtils() {
    }
}

