/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.thymeleaf.util.Validate;

public final class MapUtils {
    public static int size(Map<?, ?> target) {
        Validate.notNull(target, "Cannot get map size of null");
        return target.size();
    }

    public static boolean isEmpty(Map<?, ?> target) {
        return target == null || target.isEmpty();
    }

    public static <X> boolean containsKey(Map<? super X, ?> target, X key2) {
        Validate.notNull(target, "Cannot execute map containsKey: target is null");
        return target.containsKey(key2);
    }

    public static <X> boolean containsAllKeys(Map<? super X, ?> target, X[] keys2) {
        Validate.notNull(target, "Cannot execute map containsAllKeys: target is null");
        Validate.notNull(keys2, "Cannot execute map containsAllKeys: keys is null");
        return MapUtils.containsAllKeys(target, Arrays.asList(keys2));
    }

    public static <X> boolean containsAllKeys(Map<? super X, ?> target, Collection<X> keys2) {
        Validate.notNull(target, "Cannot execute map containsAllKeys: target is null");
        Validate.notNull(keys2, "Cannot execute map containsAllKeys: keys is null");
        return target.keySet().containsAll(keys2);
    }

    public static <X> boolean containsValue(Map<?, ? super X> target, X value2) {
        Validate.notNull(target, "Cannot execute map containsValue: target is null");
        return target.containsValue(value2);
    }

    public static <X> boolean containsAllValues(Map<?, ? super X> target, X[] values2) {
        Validate.notNull(target, "Cannot execute map containsAllValues: target is null");
        Validate.notNull(values2, "Cannot execute map containsAllValues: values is null");
        return MapUtils.containsAllValues(target, Arrays.asList(values2));
    }

    public static <X> boolean containsAllValues(Map<?, ? super X> target, Collection<X> values2) {
        Validate.notNull(target, "Cannot execute map containsAllValues: target is null");
        Validate.notNull(values2, "Cannot execute map containsAllValues: values is null");
        return target.values().containsAll(values2);
    }

    private MapUtils() {
    }
}

