/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.thymeleaf.util.NumberPointType;
import org.thymeleaf.util.Validate;

public final class NumberUtils {
    public static String format(Number target, Integer minIntegerDigits, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, 0, NumberPointType.NONE, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, 0, NumberPointType.NONE, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, Integer decimalDigits, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, decimalDigits, NumberPointType.DEFAULT, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, Integer decimalDigits, NumberPointType decimalPointType, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, NumberPointType.NONE, decimalDigits, decimalPointType, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer decimalDigits, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, decimalDigits, NumberPointType.DEFAULT, locale);
    }

    public static String format(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer decimalDigits, NumberPointType decimalPointType, Locale locale) {
        if (target == null) {
            return null;
        }
        Validate.notNull(minIntegerDigits, "Minimum integer digits cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(decimalDigits, "Decimal digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        return NumberUtils.formatNumber(target, minIntegerDigits, thousandsPointType, decimalDigits, decimalPointType, locale);
    }

    public static Integer[] sequence(Integer from2, Integer to) {
        return NumberUtils.sequence(from2, to, from2 <= to ? 1 : -1);
    }

    public static Integer[] sequence(Integer from2, Integer to, Integer step) {
        ArrayList<Integer> values2;
        block5: {
            int iStep;
            int iTo;
            int iFrom;
            block4: {
                Validate.notNull(from2, "Value to start the sequence from cannot be null");
                Validate.notNull(to, "Value to generate the sequence up to cannot be null");
                Validate.notNull(step, "Step to generate the sequence cannot be null");
                iFrom = from2;
                iTo = to;
                iStep = step;
                if (iFrom == iTo) {
                    return new Integer[]{iFrom};
                }
                if (iStep == 0) {
                    throw new IllegalArgumentException("Cannot create sequence from " + iFrom + " to " + iTo + " with step " + iStep);
                }
                values2 = new ArrayList<Integer>(10);
                if (iFrom >= iTo || iStep <= 0) break block4;
                for (int i2 = iFrom; i2 <= iTo; i2 += iStep) {
                    values2.add(i2);
                }
                break block5;
            }
            if (iFrom <= iTo || iStep >= 0) break block5;
            for (int i3 = iFrom; i3 >= iTo; i3 += iStep) {
                values2.add(i3);
            }
        }
        return values2.toArray(new Integer[values2.size()]);
    }

    private static String formatNumber(Number target, Integer minIntegerDigits, NumberPointType thousandsPointType, Integer fractionDigits, NumberPointType decimalPointType, Locale locale) {
        Validate.notNull(fractionDigits, "Fraction digits cannot be null");
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        DecimalFormat format2 = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        format2.setMinimumFractionDigits(fractionDigits);
        format2.setMaximumFractionDigits(fractionDigits);
        if (minIntegerDigits != null) {
            format2.setMinimumIntegerDigits(minIntegerDigits);
        }
        format2.setDecimalSeparatorAlwaysShown(decimalPointType != NumberPointType.NONE && fractionDigits > 0);
        format2.setGroupingUsed(thousandsPointType != NumberPointType.NONE);
        format2.setDecimalFormatSymbols(NumberUtils.computeDecimalFormatSymbols(decimalPointType, thousandsPointType, locale));
        return format2.format(target);
    }

    private static DecimalFormatSymbols computeDecimalFormatSymbols(NumberPointType decimalPointType, NumberPointType thousandsPointType, Locale locale) {
        Validate.notNull((Object)decimalPointType, "Decimal point type cannot be null");
        Validate.notNull((Object)thousandsPointType, "Thousands point type cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        switch (decimalPointType) {
            case POINT: {
                symbols.setDecimalSeparator('.');
                break;
            }
            case COMMA: {
                symbols.setDecimalSeparator(',');
                break;
            }
            case WHITESPACE: {
                symbols.setDecimalSeparator(' ');
                break;
            }
            case DEFAULT: {
                break;
            }
            case NONE: {
                symbols.setDecimalSeparator('?');
            }
        }
        switch (thousandsPointType) {
            case POINT: {
                symbols.setGroupingSeparator('.');
                break;
            }
            case COMMA: {
                symbols.setGroupingSeparator(',');
                break;
            }
            case WHITESPACE: {
                symbols.setGroupingSeparator(' ');
                break;
            }
            case DEFAULT: {
                break;
            }
            case NONE: {
                symbols.setGroupingSeparator('?');
            }
        }
        return symbols;
    }

    public static String formatCurrency(Number target, Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        NumberFormat format2 = NumberFormat.getCurrencyInstance(locale);
        return format2.format(target);
    }

    public static String formatPercent(Number target, Integer minIntegerDigits, Integer fractionDigits, Locale locale) {
        Validate.notNull(fractionDigits, "Fraction digits cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        if (target == null) {
            return null;
        }
        NumberFormat format2 = NumberFormat.getPercentInstance(locale);
        format2.setMinimumFractionDigits(fractionDigits);
        format2.setMaximumFractionDigits(fractionDigits);
        if (minIntegerDigits != null) {
            format2.setMinimumIntegerDigits(minIntegerDigits);
        }
        return format2.format(target);
    }

    private NumberUtils() {
    }
}

