/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.thymeleaf.util.PatternUtils;
import org.thymeleaf.util.Validate;

public final class PatternSpec {
    private static final int DEFAULT_PATTERN_SET_SIZE = 3;
    private LinkedHashSet<String> patternStrs;
    private LinkedHashSet<Pattern> patterns;

    public boolean isEmpty() {
        return this.patterns == null || this.patterns.size() == 0;
    }

    public Set<String> getPatterns() {
        if (this.patternStrs == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.patternStrs);
    }

    public void setPatterns(Set<String> newPatterns2) {
        if (newPatterns2 != null) {
            if (this.patterns == null) {
                this.patternStrs = new LinkedHashSet(3);
                this.patterns = new LinkedHashSet(3);
            } else {
                this.patternStrs.clear();
                this.patterns.clear();
            }
            this.patternStrs.addAll(newPatterns2);
            for (String pattern2 : newPatterns2) {
                this.patterns.add(PatternUtils.strPatternToPattern(pattern2));
            }
        } else if (this.patterns != null) {
            this.patternStrs.clear();
            this.patterns.clear();
        }
    }

    public void addPattern(String pattern2) {
        Validate.notEmpty(pattern2, "Pattern cannot be null or empty");
        if (this.patterns == null) {
            this.patternStrs = new LinkedHashSet(3);
            this.patterns = new LinkedHashSet(3);
        }
        this.patternStrs.add(pattern2);
        this.patterns.add(PatternUtils.strPatternToPattern(pattern2));
    }

    public void clearPatterns() {
        if (this.patterns != null) {
            this.patternStrs.clear();
            this.patterns.clear();
        }
    }

    public boolean matches(String templateName) {
        if (this.patterns == null) {
            return false;
        }
        for (Pattern p : this.patterns) {
            if (!p.matcher(templateName).matches()) continue;
            return true;
        }
        return false;
    }
}

