/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import org.thymeleaf.util.Validate;

public final class VersionUtils {
    public static VersionSpec parseVersion(String version2) {
        return VersionUtils.parseVersion(version2, null);
    }

    public static VersionSpec parseVersion(String version2, String buildTimestamp) {
        if (version2 == null || version2.trim().length() == 0) {
            return new VersionSpec(buildTimestamp);
        }
        try {
            Integer patch2;
            Integer minor;
            int major;
            String qualifier;
            Character qualifierSeparator;
            String numVer;
            String ver = version2.trim();
            int endOfNumericVersionIdx = VersionUtils.findEndOfNumericVersion(ver);
            if (endOfNumericVersionIdx < 0) {
                numVer = ver;
                qualifierSeparator = null;
                qualifier = null;
            } else {
                numVer = ver.substring(0, endOfNumericVersionIdx);
                char c2 = ver.charAt(endOfNumericVersionIdx);
                if (Character.isLetter(c2)) {
                    qualifierSeparator = null;
                    qualifier = ver.substring(endOfNumericVersionIdx);
                } else {
                    qualifierSeparator = Character.valueOf(ver.charAt(endOfNumericVersionIdx));
                    qualifier = ver.substring(endOfNumericVersionIdx + 1);
                    if (qualifier == null || qualifier.trim().length() == 0) {
                        return new VersionSpec(buildTimestamp);
                    }
                }
            }
            int separator1Idx = numVer.indexOf(46);
            if (separator1Idx < 0) {
                major = Integer.parseInt(numVer);
                minor = null;
                patch2 = null;
            } else {
                major = Integer.parseInt(numVer.substring(0, separator1Idx));
                int separator2Idx = numVer.indexOf(46, separator1Idx + 1);
                if (separator2Idx < 0) {
                    minor = Integer.valueOf(numVer.substring(separator1Idx + 1));
                    patch2 = null;
                } else {
                    minor = Integer.valueOf(numVer.substring(separator1Idx + 1, separator2Idx));
                    patch2 = Integer.valueOf(numVer.substring(separator2Idx + 1));
                }
            }
            return new VersionSpec(major, minor, patch2, qualifierSeparator, qualifier, buildTimestamp);
        }
        catch (Exception e2) {
            return new VersionSpec(buildTimestamp);
        }
    }

    private static int findEndOfNumericVersion(CharSequence sequence2) {
        int seqLen = sequence2.length();
        for (int i2 = 0; i2 < seqLen; ++i2) {
            char c2 = sequence2.charAt(i2);
            if (c2 == '.' || Character.isDigit(c2)) continue;
            if (i2 > 1 && sequence2.charAt(i2 - 1) == '.') {
                return i2 - 1;
            }
            return i2;
        }
        return -1;
    }

    private VersionUtils() {
    }

    public static final class VersionSpec {
        private static final String STABLE_RELEASE_QUALIFIER = "RELEASE";
        private static final String UNKNOWN_VERSION = "UNKNOWN";
        private boolean unknown;
        private int major;
        private int minor;
        private int patch;
        private String qualifier;
        private String buildTimestamp;
        private String versionCore;
        private String version;
        private String fullVersion;

        private VersionSpec(String buildTimestamp) {
            this.unknown = true;
            this.major = 0;
            this.minor = 0;
            this.patch = 0;
            this.qualifier = null;
            this.buildTimestamp = buildTimestamp;
            this.version = this.versionCore = UNKNOWN_VERSION;
            this.fullVersion = this.buildTimestamp != null ? String.format("%s (%s)", this.version, this.buildTimestamp) : this.version;
        }

        private VersionSpec(int major, Integer minor, Integer patch2, Character qualifierSeparator, String qualifier, String buildTimestamp) {
            Validate.isTrue(major >= 0, "Major version must be >= 0");
            Validate.isTrue(minor == null || minor >= 0, "Minor version must be >= 0");
            Validate.isTrue(patch2 == null || patch2 >= 0, "Patch version must be >= 0");
            Validate.isTrue(patch2 == null || minor != null, "Patch version present without minor");
            this.unknown = false;
            this.major = major;
            this.minor = minor != null ? minor : 0;
            this.patch = patch2 != null ? patch2 : 0;
            this.qualifier = qualifier;
            this.buildTimestamp = buildTimestamp;
            String string = patch2 != null ? String.format("%d.%d.%d", major, minor, patch2) : (this.versionCore = minor != null ? String.format("%d.%d", major, minor) : String.valueOf(major));
            this.version = qualifier == null ? this.versionCore : (qualifierSeparator != null ? String.format("%s%c%s", this.versionCore, qualifierSeparator, qualifier) : String.format("%s%s", this.versionCore, qualifier));
            this.fullVersion = buildTimestamp != null ? String.format("%s (%s)", this.version, this.buildTimestamp) : this.version;
        }

        public boolean isUnknown() {
            return this.unknown;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public boolean hasQualifier() {
            return this.qualifier != null;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public String getVersionCore() {
            return this.versionCore;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean hasBuildTimestamp() {
            return this.buildTimestamp != null;
        }

        public String getBuildTimestamp() {
            return this.buildTimestamp;
        }

        public String getFullVersion() {
            return this.fullVersion;
        }

        public boolean isAtLeast(int major) {
            return this.isAtLeast(major, 0);
        }

        public boolean isAtLeast(int major, int minor) {
            return this.isAtLeast(major, minor, 0);
        }

        public boolean isAtLeast(int major, int minor, int patch2) {
            return this.major > major || this.major == major && this.minor > minor || this.major == major && this.minor == minor && this.patch >= patch2;
        }

        public boolean isStableRelease() {
            return !this.unknown && (this.qualifier == null || this.qualifier.length() == 0) || STABLE_RELEASE_QUALIFIER.equals(this.qualifier);
        }
    }
}

