/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util.temporal;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;
import org.thymeleaf.util.temporal.TemporalObjects;

public final class TemporalFormattingUtils {
    private static final DateTimeFormatter ISO8601_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZZ");
    private final Locale locale;
    private final ZoneId defaultZoneId;

    public TemporalFormattingUtils(Locale locale, ZoneId defaultZoneId) {
        Validate.notNull(locale, "Locale cannot be null");
        Validate.notNull(defaultZoneId, "ZoneId cannot be null");
        this.locale = locale;
        this.defaultZoneId = defaultZoneId;
    }

    public String format(Object target) {
        return this.formatDate(target);
    }

    public String format(Object target, Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        return this.formatDate(target, null, locale, null);
    }

    public String format(Object target, String pattern2, ZoneId zoneId) {
        return this.format(target, pattern2, null, zoneId);
    }

    public String format(Object target, String pattern2, Locale locale, ZoneId zoneId) {
        Validate.notEmpty(pattern2, "Pattern cannot be null or empty");
        return this.formatDate(target, pattern2, locale, zoneId);
    }

    public Integer day(Object target) {
        if (target == null) {
            return null;
        }
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.DAY_OF_MONTH);
    }

    public Integer month(Object target) {
        if (target == null) {
            return null;
        }
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.MONTH_OF_YEAR);
    }

    public String monthName(Object target) {
        return this.format(target, "MMMM", null);
    }

    public String monthNameShort(Object target) {
        return this.format(target, "MMM", null);
    }

    public Integer year(Object target) {
        if (target == null) {
            return null;
        }
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.YEAR);
    }

    public Integer dayOfWeek(Object target) {
        if (target == null) {
            return null;
        }
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.DAY_OF_WEEK);
    }

    public String dayOfWeekName(Object target) {
        return this.format(target, "EEEE", null);
    }

    public String dayOfWeekNameShort(Object target) {
        return this.format(target, "EEE", null);
    }

    public Integer hour(Object target) {
        if (target == null) {
            return null;
        }
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.HOUR_OF_DAY);
    }

    public Integer minute(Object target) {
        if (target == null) {
            return null;
        }
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.MINUTE_OF_HOUR);
    }

    public Integer second(Object target) {
        if (target == null) {
            return null;
        }
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.SECOND_OF_MINUTE);
    }

    public Integer nanosecond(Object target) {
        if (target == null) {
            return null;
        }
        TemporalAccessor time = TemporalObjects.temporal(target);
        return time.get(ChronoField.NANO_OF_SECOND);
    }

    public String formatISO(Object target) {
        if (target == null) {
            return null;
        }
        if (target instanceof TemporalAccessor) {
            ChronoZonedDateTime time = TemporalObjects.zonedTime(target, this.defaultZoneId);
            return ISO8601_DATE_TIME_FORMATTER.withLocale(this.locale).format(time);
        }
        throw new IllegalArgumentException("Cannot format object of class \"" + target.getClass().getName() + "\" as a date");
    }

    private String formatDate(Object target) {
        return this.formatDate(target, null, null, null);
    }

    private String formatDate(Object target, String pattern2, Locale localeOverride, ZoneId zoneId) {
        if (target == null) {
            return null;
        }
        Locale formattingLocale = localeOverride != null ? localeOverride : this.locale;
        try {
            if (StringUtils.isEmptyOrWhitespace(pattern2)) {
                DateTimeFormatter formatter = TemporalObjects.formatterFor(target, formattingLocale);
                return formatter.format(TemporalObjects.temporal(target));
            }
            DateTimeFormatter formatter = TemporalFormattingUtils.computeFormatter(pattern2, target.getClass(), formattingLocale, zoneId);
            return formatter.format(TemporalObjects.zonedTime(target, this.defaultZoneId));
        }
        catch (Exception e2) {
            throw new TemplateProcessingException("Error formatting date for locale " + formattingLocale, e2);
        }
    }

    private static DateTimeFormatter computeFormatter(String pattern2, Class<?> targetClass, Locale locale, ZoneId zoneId) {
        FormatStyle formatStyle;
        switch (pattern2) {
            case "SHORT": {
                formatStyle = FormatStyle.SHORT;
                break;
            }
            case "MEDIUM": {
                formatStyle = FormatStyle.MEDIUM;
                break;
            }
            case "LONG": {
                formatStyle = FormatStyle.LONG;
                break;
            }
            case "FULL": {
                formatStyle = FormatStyle.FULL;
                break;
            }
            default: {
                formatStyle = null;
            }
        }
        if (formatStyle != null) {
            if (LocalDate.class.isAssignableFrom(targetClass)) {
                return DateTimeFormatter.ofLocalizedDate(formatStyle).withLocale(locale);
            }
            if (LocalTime.class.isAssignableFrom(targetClass)) {
                return DateTimeFormatter.ofLocalizedTime(formatStyle).withLocale(locale);
            }
            return DateTimeFormatter.ofLocalizedDateTime(formatStyle).withLocale(locale);
        }
        return DateTimeFormatter.ofPattern(pattern2, locale).withZone(zoneId);
    }
}

