/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.web;

import java.util.Map;
import java.util.Set;

public interface IWebRequest {
    public String getMethod();

    default public boolean isSecure() {
        String scheme2 = this.getScheme();
        return scheme2 != null && scheme2.equalsIgnoreCase("https");
    }

    public String getScheme();

    public String getServerName();

    public Integer getServerPort();

    public String getApplicationPath();

    public String getPathWithinApplication();

    public String getQueryString();

    default public String getRequestPath() {
        String applicationPath = this.getApplicationPath();
        String pathWithinApplication = this.getPathWithinApplication();
        return (applicationPath == null ? "" : applicationPath) + (pathWithinApplication == null ? "" : pathWithinApplication);
    }

    default public String getRequestURL() {
        String scheme2 = this.getScheme();
        String serverName = this.getServerName();
        Integer serverPort2 = this.getServerPort();
        String requestPath2 = this.getRequestPath();
        String queryString = this.getQueryString();
        if (scheme2 == null || serverName == null || serverPort2 == null) {
            throw new UnsupportedOperationException("Request scheme, server name or port are null in this environment. Cannot compute request URL");
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(scheme2).append("://").append(serverName);
        if (!(scheme2.equals("http") && serverPort2 == 80 || scheme2.equals("https") && serverPort2 == 443)) {
            urlBuilder.append(':').append(serverPort2);
        }
        urlBuilder.append(requestPath2);
        if (queryString != null) {
            urlBuilder.append('?').append(queryString);
        }
        return urlBuilder.toString();
    }

    public boolean containsHeader(String var1);

    public int getHeaderCount();

    public Set<String> getAllHeaderNames();

    public Map<String, String[]> getHeaderMap();

    default public String getHeaderValue(String name) {
        String[] headerValues = this.getHeaderValues(name);
        return headerValues == null || headerValues.length == 0 ? null : headerValues[0];
    }

    public String[] getHeaderValues(String var1);

    public boolean containsParameter(String var1);

    public int getParameterCount();

    public Set<String> getAllParameterNames();

    public Map<String, String[]> getParameterMap();

    default public String getParameterValue(String name) {
        String[] parameterValues = this.getParameterValues(name);
        return parameterValues == null || parameterValues.length == 0 ? null : parameterValues[0];
    }

    public String[] getParameterValues(String var1);

    public boolean containsCookie(String var1);

    public int getCookieCount();

    public Set<String> getAllCookieNames();

    public Map<String, String[]> getCookieMap();

    default public String getCookieValue(String name) {
        String[] cookieValues = this.getCookieValues(name);
        return cookieValues == null || cookieValues.length == 0 ? null : cookieValues[0];
    }

    public String[] getCookieValues(String var1);
}

