/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.servlet.IServletWebSession;

final class JakartaServletWebSession
implements IServletWebSession {
    private final HttpServletRequest request;
    private HttpSession session;

    JakartaServletWebSession(HttpServletRequest request2) {
        Validate.notNull(request2, "Request cannot be null");
        this.request = request2;
        this.session = this.request.getSession(false);
    }

    @Override
    public boolean exists() {
        return this.session != null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.session == null) {
            return Collections.emptyEnumeration();
        }
        return this.session.getAttributeNames();
    }

    @Override
    public Object getAttributeValue(String name) {
        Validate.notNull(name, "Name cannot be null");
        if (this.session == null) {
            return null;
        }
        return this.session.getAttribute(name);
    }

    @Override
    public void setAttributeValue(String name, Object value2) {
        Validate.notNull(name, "Name cannot be null");
        if (this.session == null) {
            this.session = this.request.getSession(true);
        }
        this.session.setAttribute(name, value2);
    }

    @Override
    public Object getNativeSessionObject() {
        return this.session;
    }
}

