/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.web.servlet;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.servlet.IServletWebApplication;
import org.thymeleaf.web.servlet.IServletWebExchange;
import org.thymeleaf.web.servlet.IServletWebRequest;
import org.thymeleaf.web.servlet.IServletWebSession;
import org.thymeleaf.web.servlet.JavaxServletWebApplication;
import org.thymeleaf.web.servlet.JavaxServletWebRequest;
import org.thymeleaf.web.servlet.JavaxServletWebSession;

final class JavaxServletWebExchange
implements IServletWebExchange {
    private final JavaxServletWebRequest webRequest;
    private final JavaxServletWebSession webSession;
    private final JavaxServletWebApplication webApplication;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;

    JavaxServletWebExchange(JavaxServletWebRequest webRequest, JavaxServletWebSession webSession, JavaxServletWebApplication webApplication, HttpServletResponse httpServletResponse) {
        Validate.notNull(webRequest, "Web Request cannot be null");
        Validate.notNull(webApplication, "Web Application cannot be null");
        Validate.notNull(httpServletResponse, "Response cannot be null");
        this.webRequest = webRequest;
        this.webSession = webSession;
        this.webApplication = webApplication;
        this.httpServletRequest = (HttpServletRequest)this.webRequest.getNativeRequestObject();
        this.httpServletResponse = httpServletResponse;
    }

    @Override
    public IServletWebRequest getRequest() {
        return this.webRequest;
    }

    @Override
    public IServletWebSession getSession() {
        return this.webSession;
    }

    @Override
    public IServletWebApplication getApplication() {
        return this.webApplication;
    }

    @Override
    public Principal getPrincipal() {
        return this.httpServletRequest.getUserPrincipal();
    }

    @Override
    public Locale getLocale() {
        return this.httpServletResponse.getLocale();
    }

    @Override
    public String getContentType() {
        return this.httpServletResponse.getContentType();
    }

    @Override
    public String getCharacterEncoding() {
        return this.httpServletResponse.getCharacterEncoding();
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.httpServletRequest.getAttributeNames();
    }

    @Override
    public Object getAttributeValue(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.httpServletRequest.getAttribute(name);
    }

    @Override
    public void setAttributeValue(String name, Object value2) {
        Validate.notNull(name, "Name cannot be null");
        this.httpServletRequest.setAttribute(name, value2);
    }

    @Override
    public String transformURL(String url2) {
        return this.httpServletResponse.encodeURL(url2);
    }

    @Override
    public Object getNativeRequestObject() {
        return this.httpServletRequest;
    }

    @Override
    public Object getNativeResponseObject() {
        return this.httpServletResponse;
    }
}

