/*
 * Decompiled with CFR 0.152.
 */
package org.unbescape.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

final class CssUnescapeUtil {
    private static final char ESCAPE_PREFIX = '\\';
    private static char[] HEXA_CHARS_UPPER = "0123456789ABCDEF".toCharArray();
    private static char[] HEXA_CHARS_LOWER = "0123456789abcdef".toCharArray();

    private CssUnescapeUtil() {
    }

    static int parseIntFromReference(String text, int start2, int end2, int radix) {
        int result2 = 0;
        for (int i2 = start2; i2 < end2; ++i2) {
            char c2 = text.charAt(i2);
            int n = -1;
            for (int j2 = 0; j2 < HEXA_CHARS_UPPER.length; ++j2) {
                if (c2 != HEXA_CHARS_UPPER[j2] && c2 != HEXA_CHARS_LOWER[j2]) continue;
                n = j2;
                break;
            }
            result2 = radix * result2 + n;
        }
        return result2;
    }

    static int parseIntFromReference(char[] text, int start2, int end2, int radix) {
        int result2 = 0;
        for (int i2 = start2; i2 < end2; ++i2) {
            char c2 = text[i2];
            int n = -1;
            for (int j2 = 0; j2 < HEXA_CHARS_UPPER.length; ++j2) {
                if (c2 != HEXA_CHARS_UPPER[j2] && c2 != HEXA_CHARS_LOWER[j2]) continue;
                n = j2;
                break;
            }
            result2 = radix * result2 + n;
        }
        return result2;
    }

    static String unescape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = text.length();
        int readOffset = 0;
        int referenceOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            int codepoint = -1;
            if (c2 == '\\') {
                char c1 = text.charAt(i2 + 1);
                switch (c1) {
                    case '\n': {
                        codepoint = -2;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case ' ': 
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '$': 
                    case '%': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case '@': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '_': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        codepoint = c1;
                        referenceOffset = i2 + 1;
                    }
                }
                if (codepoint == -1) {
                    if (c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f') {
                        char cf;
                        int f2;
                        for (f2 = i2 + 2; f2 < i2 + 7 && f2 < max2 && ((cf = text.charAt(f2)) >= '0' && cf <= '9' || cf >= 'A' && cf <= 'F' || cf >= 'a' && cf <= 'f'); ++f2) {
                        }
                        codepoint = CssUnescapeUtil.parseIntFromReference(text, i2 + 1, f2, 16);
                        referenceOffset = f2 - 1;
                        if (f2 < max2 && text.charAt(f2) == ' ') {
                            ++referenceOffset;
                        }
                    } else {
                        if (c1 == '\r' || c1 == '\f') {
                            ++i2;
                            continue;
                        }
                        codepoint = c1;
                        referenceOffset = i2 + 1;
                    }
                }
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 5);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (codepoint > 65535) {
                strBuilder.append(Character.toChars(codepoint));
                continue;
            }
            if (codepoint == -2) continue;
            strBuilder.append((char)codepoint);
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        return strBuilder.toString();
    }

    static void unescape(Reader reader2, Writer writer) throws IOException {
        if (reader2 == null) {
            return;
        }
        int escapei = 0;
        char[] escapes = new char[6];
        int c2 = reader2.read();
        while (c2 >= 0) {
            int c1 = c2;
            c2 = reader2.read();
            if (c1 != 92 || c2 < 0) {
                writer.write(c1);
                continue;
            }
            int codepoint = -1;
            if (c1 == 92) {
                switch (c2) {
                    case 10: {
                        codepoint = -2;
                        c1 = c2;
                        c2 = reader2.read();
                        break;
                    }
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: {
                        codepoint = c2;
                        c1 = c2;
                        c2 = reader2.read();
                    }
                }
                if (codepoint == -1) {
                    if (c2 >= 48 && c2 <= 57 || c2 >= 65 && c2 <= 70 || c2 >= 97 && c2 <= 102) {
                        int ce = c2;
                        for (escapei = 0; ce >= 0 && escapei < 6 && (ce >= 48 && ce <= 57 || ce >= 65 && ce <= 70 || ce >= 97 && ce <= 102); ++escapei) {
                            escapes[escapei] = (char)ce;
                            ce = reader2.read();
                        }
                        c1 = escapes[5];
                        c2 = ce;
                        codepoint = CssUnescapeUtil.parseIntFromReference(escapes, 0, escapei, 16);
                        if (c2 == 32) {
                            c1 = c2;
                            c2 = reader2.read();
                        }
                    } else {
                        if (c2 == 13 || c2 == 12) {
                            writer.write(c1);
                            continue;
                        }
                        codepoint = c2;
                        c1 = c2;
                        c2 = reader2.read();
                    }
                }
            }
            if (codepoint > 65535) {
                writer.write(Character.toChars(codepoint));
                continue;
            }
            if (codepoint == -2) continue;
            writer.write((char)codepoint);
        }
    }

    static void unescape(char[] text, int offset, int len2, Writer writer) throws IOException {
        if (text == null) {
            return;
        }
        int max2 = offset + len2;
        int readOffset = offset;
        int referenceOffset = offset;
        for (int i2 = offset; i2 < max2; ++i2) {
            char c2 = text[i2];
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            int codepoint = -1;
            if (c2 == '\\') {
                int c1 = text[i2 + 1];
                switch (c1) {
                    case 10: {
                        codepoint = -2;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: {
                        codepoint = c1;
                        referenceOffset = i2 + 1;
                    }
                }
                if (codepoint == -1) {
                    if (c1 >= 48 && c1 <= 57 || c1 >= 65 && c1 <= 70 || c1 >= 97 && c1 <= 102) {
                        char cf;
                        int f2;
                        for (f2 = i2 + 2; f2 < i2 + 7 && f2 < max2 && ((cf = text[f2]) >= '0' && cf <= '9' || cf >= 'A' && cf <= 'F' || cf >= 'a' && cf <= 'f'); ++f2) {
                        }
                        codepoint = CssUnescapeUtil.parseIntFromReference(text, i2 + 1, f2, 16);
                        referenceOffset = f2 - 1;
                        if (f2 < max2 && text[f2] == ' ') {
                            ++referenceOffset;
                        }
                    } else {
                        if (c1 == 13 || c1 == 12) {
                            ++i2;
                            continue;
                        }
                        codepoint = c1;
                        referenceOffset = i2 + 1;
                    }
                }
            }
            if (i2 - readOffset > 0) {
                writer.write(text, readOffset, i2 - readOffset);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (codepoint > 65535) {
                writer.write(Character.toChars(codepoint));
                continue;
            }
            if (codepoint == -2) continue;
            writer.write((char)codepoint);
        }
        if (max2 - readOffset > 0) {
            writer.write(text, readOffset, max2 - readOffset);
        }
    }
}

