/*
 * Decompiled with CFR 0.152.
 */
package org.unbescape.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

final class CsvEscapeUtil {
    private static final char DOUBLE_QUOTE = '\"';
    private static final char[] TWO_DOUBLE_QUOTES = "\"\"".toCharArray();

    private CsvEscapeUtil() {
    }

    static String escape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = text.length();
        int readOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') continue;
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 20);
                strBuilder.append('\"');
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            readOffset = i2 + 1;
            if (c2 == '\"') {
                strBuilder.append(TWO_DOUBLE_QUOTES);
                continue;
            }
            strBuilder.append(c2);
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        strBuilder.append('\"');
        return strBuilder.toString();
    }

    static void escape(Reader reader2, Writer writer) throws IOException {
        if (reader2 == null) {
            return;
        }
        int doQuote = -1;
        int bufferSize = 0;
        char[] buffer = new char[10];
        int read2 = reader2.read(buffer, 0, buffer.length);
        if (read2 < 0) {
            return;
        }
        while (doQuote < 0 && read2 >= 0) {
            int i2 = bufferSize;
            bufferSize += read2;
            while (doQuote < 0 && i2 < bufferSize) {
                char cq;
                if ((cq = buffer[i2++]) >= 'a' && cq <= 'z' || cq >= 'A' && cq <= 'Z' || cq >= '0' && cq <= '9') continue;
                doQuote = 1;
                break;
            }
            if (doQuote >= 0 || read2 < 0) continue;
            if (bufferSize == buffer.length) {
                char[] newBuffer = new char[buffer.length + buffer.length / 2];
                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                buffer = newBuffer;
            }
            read2 = reader2.read(buffer, bufferSize, buffer.length - bufferSize);
        }
        if ((doQuote = Math.max(doQuote, 0)) == 1) {
            writer.write(34);
        }
        if (bufferSize > 0) {
            for (int i3 = 0; i3 < bufferSize; ++i3) {
                char c2 = buffer[i3];
                if (c2 == '\"') {
                    writer.write(TWO_DOUBLE_QUOTES);
                    continue;
                }
                writer.write(c2);
            }
        }
        if (read2 >= 0) {
            int c1 = -1;
            int c2 = reader2.read();
            while (c2 >= 0) {
                c1 = c2;
                c2 = reader2.read();
                if (c1 == 34) {
                    writer.write(TWO_DOUBLE_QUOTES);
                    continue;
                }
                writer.write(c1);
            }
        }
        if (doQuote == 1) {
            writer.write(34);
        }
    }

    static void escape(char[] text, int offset, int len2, Writer writer) throws IOException {
        if (text == null || text.length == 0) {
            return;
        }
        int max2 = offset + len2;
        int readOffset = offset;
        for (int i2 = offset; i2 < max2; ++i2) {
            char c2 = text[i2];
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') continue;
            if (readOffset == offset) {
                writer.write(34);
            }
            if (i2 - readOffset > 0) {
                writer.write(text, readOffset, i2 - readOffset);
            }
            readOffset = i2 + 1;
            if (c2 == '\"') {
                writer.write(TWO_DOUBLE_QUOTES);
                continue;
            }
            writer.write(c2);
        }
        if (max2 - readOffset > 0) {
            writer.write(text, readOffset, max2 - readOffset);
        }
        if (readOffset > offset) {
            writer.write(34);
        }
    }

    static String unescape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = text.length();
        int readOffset = 0;
        int referenceOffset = 0;
        boolean isQuoted = false;
        for (int i2 = 0; i2 < max2; ++i2) {
            char c2 = text.charAt(i2);
            if (i2 > 0 && c2 != '\"' || c2 != '\"') continue;
            if (i2 == 0) {
                if (i2 + 1 >= max2 || text.charAt(max2 - 1) != '\"') continue;
                isQuoted = true;
                referenceOffset = i2 + 1;
                readOffset = i2 + 1;
                continue;
            }
            if (isQuoted && i2 + 2 < max2) {
                char c1 = text.charAt(i2 + 1);
                if (c1 == '\"') {
                    referenceOffset = i2 + 1;
                }
            } else {
                if (!isQuoted || i2 + 1 < max2) continue;
                referenceOffset = i2 + 1;
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 5);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (referenceOffset >= max2) continue;
            strBuilder.append(c2);
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        return strBuilder.toString();
    }

    static void unescape(Reader reader2, Writer writer) throws IOException {
        int c1;
        if (reader2 == null) {
            return;
        }
        boolean isQuoted = false;
        int c2 = reader2.read();
        if (c2 < 0) {
            return;
        }
        if (c2 == 34) {
            c1 = c2;
            c2 = reader2.read();
            if (c2 < 0) {
                writer.write(c1);
                return;
            }
            isQuoted = true;
        }
        while (c2 >= 0) {
            c1 = c2;
            c2 = reader2.read();
            if (c1 != 34) {
                writer.write(c1);
                continue;
            }
            if (c2 < 0) {
                if (isQuoted) continue;
                writer.write(c1);
                continue;
            }
            if (c2 == 34) {
                writer.write(34);
                c1 = c2;
                c2 = reader2.read();
                continue;
            }
            writer.write(34);
        }
    }

    static void unescape(char[] text, int offset, int len2, Writer writer) throws IOException {
        if (text == null) {
            return;
        }
        int max2 = offset + len2;
        int readOffset = offset;
        int referenceOffset = offset;
        boolean isQuoted = false;
        for (int i2 = offset; i2 < max2; ++i2) {
            char c2 = text[i2];
            if (i2 > offset && c2 != '\"' || c2 != '\"') continue;
            if (i2 == offset) {
                if (i2 + 1 >= max2 || text[max2 - 1] != '\"') continue;
                isQuoted = true;
                referenceOffset = i2 + 1;
                readOffset = i2 + 1;
                continue;
            }
            if (isQuoted && i2 + 2 < max2) {
                char c1 = text[i2 + 1];
                if (c1 == '\"') {
                    referenceOffset = i2 + 1;
                }
            } else {
                if (!isQuoted || i2 + 1 < max2) continue;
                referenceOffset = i2 + 1;
            }
            if (i2 - readOffset > 0) {
                writer.write(text, readOffset, i2 - readOffset);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (referenceOffset >= max2) continue;
            writer.write(c2);
        }
        if (max2 - readOffset > 0) {
            writer.write(text, readOffset, max2 - readOffset);
        }
    }
}

