/*
 * Decompiled with CFR 0.152.
 */
package org.unbescape.java;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.unbescape.java.JavaEscapeLevel;

final class JavaEscapeUtil {
    private static final char ESCAPE_PREFIX = '\\';
    private static final char ESCAPE_UHEXA_PREFIX2 = 'u';
    private static final char[] ESCAPE_UHEXA_PREFIX;
    private static char[] HEXA_CHARS_UPPER;
    private static char[] HEXA_CHARS_LOWER;
    private static int SEC_CHARS_LEN;
    private static char SEC_CHARS_NO_SEC;
    private static char[] SEC_CHARS;
    private static final char ESCAPE_LEVELS_LEN = '\u00a1';
    private static final byte[] ESCAPE_LEVELS;

    private JavaEscapeUtil() {
    }

    static char[] toUHexa(int codepoint) {
        char[] result2 = new char[4];
        result2[3] = HEXA_CHARS_UPPER[codepoint % 16];
        result2[2] = HEXA_CHARS_UPPER[(codepoint >>> 4) % 16];
        result2[1] = HEXA_CHARS_UPPER[(codepoint >>> 8) % 16];
        result2[0] = HEXA_CHARS_UPPER[(codepoint >>> 12) % 16];
        return result2;
    }

    static String escape(String text, JavaEscapeLevel escapeLevel) {
        if (text == null) {
            return null;
        }
        int level = escapeLevel.getEscapeLevel();
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = text.length();
        int readOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            char sec;
            int codepoint = Character.codePointAt(text, i2);
            if (codepoint <= 159 && level < ESCAPE_LEVELS[codepoint]) continue;
            if (codepoint > 159 && level < ESCAPE_LEVELS[160]) {
                if (Character.charCount(codepoint) <= 1) continue;
                ++i2;
                continue;
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 20);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i2;
            }
            readOffset = i2 + 1;
            if (codepoint < SEC_CHARS_LEN && (sec = SEC_CHARS[codepoint]) != SEC_CHARS_NO_SEC) {
                strBuilder.append('\\');
                strBuilder.append(sec);
                continue;
            }
            if (Character.charCount(codepoint) > 1) {
                char[] codepointChars = Character.toChars(codepoint);
                strBuilder.append(ESCAPE_UHEXA_PREFIX);
                strBuilder.append(JavaEscapeUtil.toUHexa(codepointChars[0]));
                strBuilder.append(ESCAPE_UHEXA_PREFIX);
                strBuilder.append(JavaEscapeUtil.toUHexa(codepointChars[1]));
                continue;
            }
            strBuilder.append(ESCAPE_UHEXA_PREFIX);
            strBuilder.append(JavaEscapeUtil.toUHexa(codepoint));
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        return strBuilder.toString();
    }

    static void escape(Reader reader2, Writer writer, JavaEscapeLevel escapeLevel) throws IOException {
        if (reader2 == null) {
            return;
        }
        int level = escapeLevel.getEscapeLevel();
        int c2 = reader2.read();
        while (c2 >= 0) {
            char sec;
            int c1 = c2;
            int codepoint = JavaEscapeUtil.codePointAt((char)c1, (char)(c2 = reader2.read()));
            if (codepoint <= 159 && level < ESCAPE_LEVELS[codepoint]) {
                writer.write(c1);
                continue;
            }
            if (codepoint > 159 && level < ESCAPE_LEVELS[160]) {
                writer.write(c1);
                if (Character.charCount(codepoint) <= 1) continue;
                writer.write(c2);
                c1 = c2;
                c2 = reader2.read();
                continue;
            }
            if (Character.charCount(codepoint) > 1) {
                c1 = c2;
                c2 = reader2.read();
            }
            if (codepoint < SEC_CHARS_LEN && (sec = SEC_CHARS[codepoint]) != SEC_CHARS_NO_SEC) {
                writer.write(92);
                writer.write(sec);
                continue;
            }
            if (Character.charCount(codepoint) > 1) {
                char[] codepointChars = Character.toChars(codepoint);
                writer.write(ESCAPE_UHEXA_PREFIX);
                writer.write(JavaEscapeUtil.toUHexa(codepointChars[0]));
                writer.write(ESCAPE_UHEXA_PREFIX);
                writer.write(JavaEscapeUtil.toUHexa(codepointChars[1]));
                continue;
            }
            writer.write(ESCAPE_UHEXA_PREFIX);
            writer.write(JavaEscapeUtil.toUHexa(codepoint));
        }
    }

    static void escape(char[] text, int offset, int len2, Writer writer, JavaEscapeLevel escapeLevel) throws IOException {
        if (text == null || text.length == 0) {
            return;
        }
        int level = escapeLevel.getEscapeLevel();
        int max2 = offset + len2;
        int readOffset = offset;
        for (int i2 = offset; i2 < max2; ++i2) {
            char sec;
            int codepoint = Character.codePointAt(text, i2);
            if (codepoint <= 159 && level < ESCAPE_LEVELS[codepoint]) continue;
            if (codepoint > 159 && level < ESCAPE_LEVELS[160]) {
                if (Character.charCount(codepoint) <= 1) continue;
                ++i2;
                continue;
            }
            if (i2 - readOffset > 0) {
                writer.write(text, readOffset, i2 - readOffset);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i2;
            }
            readOffset = i2 + 1;
            if (codepoint < SEC_CHARS_LEN && (sec = SEC_CHARS[codepoint]) != SEC_CHARS_NO_SEC) {
                writer.write(92);
                writer.write(sec);
                continue;
            }
            if (Character.charCount(codepoint) > 1) {
                char[] codepointChars = Character.toChars(codepoint);
                writer.write(ESCAPE_UHEXA_PREFIX);
                writer.write(JavaEscapeUtil.toUHexa(codepointChars[0]));
                writer.write(ESCAPE_UHEXA_PREFIX);
                writer.write(JavaEscapeUtil.toUHexa(codepointChars[1]));
                continue;
            }
            writer.write(ESCAPE_UHEXA_PREFIX);
            writer.write(JavaEscapeUtil.toUHexa(codepoint));
        }
        if (max2 - readOffset > 0) {
            writer.write(text, readOffset, max2 - readOffset);
        }
    }

    static int parseIntFromReference(String text, int start2, int end2, int radix) {
        int result2 = 0;
        for (int i2 = start2; i2 < end2; ++i2) {
            char c2 = text.charAt(i2);
            int n = -1;
            for (int j2 = 0; j2 < HEXA_CHARS_UPPER.length; ++j2) {
                if (c2 != HEXA_CHARS_UPPER[j2] && c2 != HEXA_CHARS_LOWER[j2]) continue;
                n = j2;
                break;
            }
            result2 = radix * result2 + n;
        }
        return result2;
    }

    static int parseIntFromReference(char[] text, int start2, int end2, int radix) {
        int result2 = 0;
        for (int i2 = start2; i2 < end2; ++i2) {
            char c2 = text[i2];
            int n = -1;
            for (int j2 = 0; j2 < HEXA_CHARS_UPPER.length; ++j2) {
                if (c2 != HEXA_CHARS_UPPER[j2] && c2 != HEXA_CHARS_LOWER[j2]) continue;
                n = j2;
                break;
            }
            result2 = radix * result2 + n;
        }
        return result2;
    }

    static boolean isOctalEscape(String text, int start2, int end2) {
        if (start2 >= end2) {
            return false;
        }
        char c1 = text.charAt(start2);
        if (c1 < '0' || c1 > '7') {
            return false;
        }
        if (start2 + 1 >= end2) {
            return c1 != '0';
        }
        char c2 = text.charAt(start2 + 1);
        if (c2 < '0' || c2 > '7') {
            return c1 != '0';
        }
        if (start2 + 2 >= end2) {
            return c1 != '0' || c2 != '0';
        }
        char c3 = text.charAt(start2 + 2);
        if (c3 < '0' || c3 > '7') {
            return c1 != '0' || c2 != '0';
        }
        return c1 != '0' || c2 != '0' || c3 != '0';
    }

    static boolean isOctalEscape(char[] text, int start2, int end2) {
        if (start2 >= end2) {
            return false;
        }
        char c1 = text[start2];
        if (c1 < '0' || c1 > '7') {
            return false;
        }
        if (start2 + 1 >= end2) {
            return c1 != '0';
        }
        char c2 = text[start2 + 1];
        if (c2 < '0' || c2 > '7') {
            return c1 != '0';
        }
        if (start2 + 2 >= end2) {
            return c1 != '0' || c2 != '0';
        }
        char c3 = text[start2 + 2];
        if (c3 < '0' || c3 > '7') {
            return c1 != '0' || c2 != '0';
        }
        return c1 != '0' || c2 != '0' || c3 != '0';
    }

    static String unicodeUnescape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = text.length();
        int readOffset = 0;
        int referenceOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            int codepoint = -1;
            if (c2 == '\\') {
                char c1 = text.charAt(i2 + 1);
                if (c1 == 'u') {
                    char cf;
                    char cf2;
                    int f2;
                    for (f2 = i2 + 2; f2 < max2 && (cf2 = text.charAt(f2)) == 'u'; ++f2) {
                    }
                    int s2 = f2;
                    while (f2 < s2 + 4 && f2 < max2 && ((cf = text.charAt(f2)) >= '0' && cf <= '9' || cf >= 'A' && cf <= 'F' || cf >= 'a' && cf <= 'f')) {
                        ++f2;
                    }
                    if (f2 - s2 < 4) {
                        ++i2;
                        continue;
                    }
                    codepoint = JavaEscapeUtil.parseIntFromReference(text, s2, f2, 16);
                    referenceOffset = f2 - 1;
                } else {
                    ++i2;
                    continue;
                }
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 5);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (codepoint > 65535) {
                strBuilder.append(Character.toChars(codepoint));
                continue;
            }
            strBuilder.append((char)codepoint);
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        return strBuilder.toString();
    }

    static boolean requiresUnicodeUnescape(char[] text, int offset, int len2) {
        if (text == null) {
            return false;
        }
        int max2 = offset + len2;
        for (int i2 = offset; i2 < max2; ++i2) {
            char c1;
            char c2 = text[i2];
            if (c2 != '\\' || i2 + 1 >= max2 || c2 != '\\' || (c1 = text[i2 + 1]) != 'u') continue;
            return true;
        }
        return false;
    }

    static void unicodeUnescape(char[] text, int offset, int len2, Writer writer) throws IOException {
        if (text == null) {
            return;
        }
        int max2 = offset + len2;
        int readOffset = offset;
        int referenceOffset = offset;
        for (int i2 = offset; i2 < max2; ++i2) {
            char c2 = text[i2];
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            int codepoint = -1;
            if (c2 == '\\') {
                char c1 = text[i2 + 1];
                if (c1 == 'u') {
                    char cf;
                    char cf2;
                    int f2;
                    for (f2 = i2 + 2; f2 < max2 && (cf2 = text[f2]) == 'u'; ++f2) {
                    }
                    int s2 = f2;
                    while (f2 < s2 + 4 && f2 < max2 && ((cf = text[f2]) >= '0' && cf <= '9' || cf >= 'A' && cf <= 'F' || cf >= 'a' && cf <= 'f')) {
                        ++f2;
                    }
                    if (f2 - s2 < 4) {
                        ++i2;
                        continue;
                    }
                    codepoint = JavaEscapeUtil.parseIntFromReference(text, s2, f2, 16);
                    referenceOffset = f2 - 1;
                } else {
                    ++i2;
                    continue;
                }
            }
            if (i2 - readOffset > 0) {
                writer.write(text, readOffset, i2 - readOffset);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (codepoint > 65535) {
                writer.write(Character.toChars(codepoint));
                continue;
            }
            writer.write((char)codepoint);
        }
        if (max2 - readOffset > 0) {
            writer.write(text, readOffset, max2 - readOffset);
        }
    }

    static String unescape(String text) {
        if (text == null) {
            return null;
        }
        String unicodeEscapedText = JavaEscapeUtil.unicodeUnescape(text);
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = unicodeEscapedText.length();
        int readOffset = 0;
        int referenceOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            char c2 = unicodeEscapedText.charAt(i2);
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            int codepoint = -1;
            if (c2 == '\\') {
                char c1 = unicodeEscapedText.charAt(i2 + 1);
                switch (c1) {
                    case '0': {
                        if (JavaEscapeUtil.isOctalEscape(unicodeEscapedText, i2 + 1, max2)) break;
                        codepoint = 0;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'b': {
                        codepoint = 8;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 't': {
                        codepoint = 9;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'n': {
                        codepoint = 10;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'f': {
                        codepoint = 12;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'r': {
                        codepoint = 13;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case '\"': {
                        codepoint = 34;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case '\'': {
                        codepoint = 39;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case '\\': {
                        codepoint = 92;
                        referenceOffset = i2 + 1;
                    }
                }
                if (codepoint == -1) {
                    if (c1 >= '0' && c1 <= '7') {
                        char cf;
                        int f2;
                        for (f2 = i2 + 2; f2 < i2 + 4 && f2 < max2 && (cf = unicodeEscapedText.charAt(f2)) >= '0' && cf <= '7'; ++f2) {
                        }
                        codepoint = JavaEscapeUtil.parseIntFromReference(unicodeEscapedText, i2 + 1, f2, 8);
                        if (codepoint > 255) {
                            codepoint = JavaEscapeUtil.parseIntFromReference(unicodeEscapedText, i2 + 1, f2 - 1, 8);
                            referenceOffset = f2 - 2;
                        } else {
                            referenceOffset = f2 - 1;
                        }
                    } else {
                        ++i2;
                        continue;
                    }
                }
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 5);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(unicodeEscapedText, readOffset, i2);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (codepoint > 65535) {
                strBuilder.append(Character.toChars(codepoint));
                continue;
            }
            strBuilder.append((char)codepoint);
        }
        if (strBuilder == null) {
            return unicodeEscapedText;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(unicodeEscapedText, readOffset, max2);
        }
        return strBuilder.toString();
    }

    static void unescape(Reader reader2, Writer writer) throws IOException {
        if (reader2 == null) {
            return;
        }
        char[] buffer = new char[20];
        int read2 = reader2.read(buffer, 0, buffer.length);
        if (read2 < 0) {
            return;
        }
        int bufferSize = read2;
        while (bufferSize > 0 || read2 >= 0) {
            int nonEscCounter = 0;
            int n = bufferSize;
            while (nonEscCounter < 8 && n-- != 0) {
                if (buffer[n] == '\\') {
                    nonEscCounter = 0;
                    continue;
                }
                ++nonEscCounter;
            }
            if (nonEscCounter < 8 && read2 >= 0) {
                if (bufferSize == buffer.length) {
                    char[] newBuffer = new char[buffer.length + buffer.length / 2];
                    System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                    buffer = newBuffer;
                }
                if ((read2 = reader2.read(buffer, bufferSize, buffer.length - bufferSize)) < 0) continue;
                bufferSize += read2;
                continue;
            }
            n = n < 0 ? bufferSize : n + nonEscCounter;
            JavaEscapeUtil.unescape(buffer, 0, n, writer);
            System.arraycopy(buffer, n, buffer, 0, bufferSize - n);
            if ((read2 = reader2.read(buffer, bufferSize -= n, buffer.length - bufferSize)) < 0) continue;
            bufferSize += read2;
        }
    }

    static void unescape(char[] text, int offset, int len2, Writer writer) throws IOException {
        if (text == null) {
            return;
        }
        char[] unicodeEscapedText = text;
        int unicodeEscapedOffset = offset;
        int unicodeEscapedLen = len2;
        if (JavaEscapeUtil.requiresUnicodeUnescape(text, offset, len2)) {
            CharArrayWriter charArrayWriter = new CharArrayWriter(len2 + 2);
            JavaEscapeUtil.unicodeUnescape(text, offset, len2, charArrayWriter);
            unicodeEscapedText = charArrayWriter.toCharArray();
            unicodeEscapedOffset = 0;
            unicodeEscapedLen = unicodeEscapedText.length;
        }
        int max2 = unicodeEscapedOffset + unicodeEscapedLen;
        int readOffset = unicodeEscapedOffset;
        int referenceOffset = unicodeEscapedOffset;
        for (int i2 = unicodeEscapedOffset; i2 < max2; ++i2) {
            char c2 = unicodeEscapedText[i2];
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            int codepoint = -1;
            if (c2 == '\\') {
                char c1 = unicodeEscapedText[i2 + 1];
                switch (c1) {
                    case '0': {
                        if (JavaEscapeUtil.isOctalEscape(unicodeEscapedText, i2 + 1, max2)) break;
                        codepoint = 0;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'b': {
                        codepoint = 8;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 't': {
                        codepoint = 9;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'n': {
                        codepoint = 10;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'f': {
                        codepoint = 12;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'r': {
                        codepoint = 13;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case '\"': {
                        codepoint = 34;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case '\'': {
                        codepoint = 39;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case '\\': {
                        codepoint = 92;
                        referenceOffset = i2 + 1;
                    }
                }
                if (codepoint == -1) {
                    if (c1 >= '0' && c1 <= '7') {
                        char cf;
                        int f2;
                        for (f2 = i2 + 2; f2 < i2 + 4 && f2 < max2 && (cf = unicodeEscapedText[f2]) >= '0' && cf <= '7'; ++f2) {
                        }
                        codepoint = JavaEscapeUtil.parseIntFromReference(unicodeEscapedText, i2 + 1, f2, 8);
                        if (codepoint > 255) {
                            codepoint = JavaEscapeUtil.parseIntFromReference(unicodeEscapedText, i2 + 1, f2 - 1, 8);
                            referenceOffset = f2 - 2;
                        } else {
                            referenceOffset = f2 - 1;
                        }
                    } else {
                        ++i2;
                        continue;
                    }
                }
            }
            if (i2 - readOffset > 0) {
                writer.write(unicodeEscapedText, readOffset, i2 - readOffset);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (codepoint > 65535) {
                writer.write(Character.toChars(codepoint));
                continue;
            }
            writer.write((char)codepoint);
        }
        if (max2 - readOffset > 0) {
            writer.write(unicodeEscapedText, readOffset, max2 - readOffset);
        }
    }

    private static int codePointAt(char c1, char c2) {
        if (Character.isHighSurrogate(c1) && c2 >= '\u0000' && Character.isLowSurrogate(c2)) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    static {
        int c2;
        ESCAPE_UHEXA_PREFIX = "\\u".toCharArray();
        HEXA_CHARS_UPPER = "0123456789ABCDEF".toCharArray();
        HEXA_CHARS_LOWER = "0123456789abcdef".toCharArray();
        SEC_CHARS_LEN = 93;
        SEC_CHARS_NO_SEC = (char)42;
        SEC_CHARS = new char[SEC_CHARS_LEN];
        Arrays.fill(SEC_CHARS, SEC_CHARS_NO_SEC);
        JavaEscapeUtil.SEC_CHARS[8] = 98;
        JavaEscapeUtil.SEC_CHARS[9] = 116;
        JavaEscapeUtil.SEC_CHARS[10] = 110;
        JavaEscapeUtil.SEC_CHARS[12] = 102;
        JavaEscapeUtil.SEC_CHARS[13] = 114;
        JavaEscapeUtil.SEC_CHARS[34] = 34;
        JavaEscapeUtil.SEC_CHARS[39] = 39;
        JavaEscapeUtil.SEC_CHARS[92] = 92;
        ESCAPE_LEVELS = new byte[161];
        Arrays.fill(ESCAPE_LEVELS, (byte)3);
        for (c2 = 128; c2 < 161; c2 = (int)((char)(c2 + 1))) {
            JavaEscapeUtil.ESCAPE_LEVELS[c2] = 2;
        }
        for (c2 = 65; c2 <= 90; c2 = (int)((char)(c2 + 1))) {
            JavaEscapeUtil.ESCAPE_LEVELS[c2] = 4;
        }
        for (c2 = 97; c2 <= 122; c2 = (int)((char)(c2 + 1))) {
            JavaEscapeUtil.ESCAPE_LEVELS[c2] = 4;
        }
        for (c2 = 48; c2 <= 57; c2 = (int)((char)(c2 + 1))) {
            JavaEscapeUtil.ESCAPE_LEVELS[c2] = 4;
        }
        JavaEscapeUtil.ESCAPE_LEVELS[8] = 1;
        JavaEscapeUtil.ESCAPE_LEVELS[9] = 1;
        JavaEscapeUtil.ESCAPE_LEVELS[10] = 1;
        JavaEscapeUtil.ESCAPE_LEVELS[12] = 1;
        JavaEscapeUtil.ESCAPE_LEVELS[13] = 1;
        JavaEscapeUtil.ESCAPE_LEVELS[34] = 1;
        JavaEscapeUtil.ESCAPE_LEVELS[39] = 3;
        JavaEscapeUtil.ESCAPE_LEVELS[92] = 1;
        for (c2 = 0; c2 <= 31; c2 = (int)((char)(c2 + 1))) {
            JavaEscapeUtil.ESCAPE_LEVELS[c2] = 1;
        }
        for (c2 = 127; c2 <= 159; c2 = (int)((char)(c2 + 1))) {
            JavaEscapeUtil.ESCAPE_LEVELS[c2] = 1;
        }
    }
}

