/*
 * Decompiled with CFR 0.152.
 */
package org.unbescape.json;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.unbescape.json.JsonEscapeLevel;
import org.unbescape.json.JsonEscapeType;
import org.unbescape.json.JsonEscapeUtil;

public final class JsonEscape {
    public static String escapeJsonMinimal(String text) {
        return JsonEscape.escapeJson(text, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_1_BASIC_ESCAPE_SET);
    }

    public static String escapeJson(String text) {
        return JsonEscape.escapeJson(text, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_2_ALL_NON_ASCII_PLUS_BASIC_ESCAPE_SET);
    }

    public static String escapeJson(String text, JsonEscapeType type2, JsonEscapeLevel level) {
        if (type2 == null) {
            throw new IllegalArgumentException("The 'type' argument cannot be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("The 'level' argument cannot be null");
        }
        return JsonEscapeUtil.escape(text, type2, level);
    }

    public static void escapeJsonMinimal(String text, Writer writer) throws IOException {
        JsonEscape.escapeJson(text, writer, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_1_BASIC_ESCAPE_SET);
    }

    public static void escapeJson(String text, Writer writer) throws IOException {
        JsonEscape.escapeJson(text, writer, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_2_ALL_NON_ASCII_PLUS_BASIC_ESCAPE_SET);
    }

    public static void escapeJson(String text, Writer writer, JsonEscapeType type2, JsonEscapeLevel level) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'writer' cannot be null");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("The 'type' argument cannot be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("The 'level' argument cannot be null");
        }
        JsonEscapeUtil.escape(new InternalStringReader(text), writer, type2, level);
    }

    public static void escapeJsonMinimal(Reader reader2, Writer writer) throws IOException {
        JsonEscape.escapeJson(reader2, writer, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_1_BASIC_ESCAPE_SET);
    }

    public static void escapeJson(Reader reader2, Writer writer) throws IOException {
        JsonEscape.escapeJson(reader2, writer, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_2_ALL_NON_ASCII_PLUS_BASIC_ESCAPE_SET);
    }

    public static void escapeJson(Reader reader2, Writer writer, JsonEscapeType type2, JsonEscapeLevel level) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'writer' cannot be null");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("The 'type' argument cannot be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("The 'level' argument cannot be null");
        }
        JsonEscapeUtil.escape(reader2, writer, type2, level);
    }

    public static void escapeJsonMinimal(char[] text, int offset, int len2, Writer writer) throws IOException {
        JsonEscape.escapeJson(text, offset, len2, writer, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_1_BASIC_ESCAPE_SET);
    }

    public static void escapeJson(char[] text, int offset, int len2, Writer writer) throws IOException {
        JsonEscape.escapeJson(text, offset, len2, writer, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_2_ALL_NON_ASCII_PLUS_BASIC_ESCAPE_SET);
    }

    public static void escapeJson(char[] text, int offset, int len2, Writer writer, JsonEscapeType type2, JsonEscapeLevel level) throws IOException {
        int textLen;
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'writer' cannot be null");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("The 'type' argument cannot be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("The 'level' argument cannot be null");
        }
        int n = textLen = text == null ? 0 : text.length;
        if (offset < 0 || offset > textLen) {
            throw new IllegalArgumentException("Invalid (offset, len). offset=" + offset + ", len=" + len2 + ", text.length=" + textLen);
        }
        if (len2 < 0 || offset + len2 > textLen) {
            throw new IllegalArgumentException("Invalid (offset, len). offset=" + offset + ", len=" + len2 + ", text.length=" + textLen);
        }
        JsonEscapeUtil.escape(text, offset, len2, writer, type2, level);
    }

    public static String unescapeJson(String text) {
        if (text == null) {
            return null;
        }
        if (text.indexOf(92) < 0) {
            return text;
        }
        return JsonEscapeUtil.unescape(text);
    }

    public static void unescapeJson(String text, Writer writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'writer' cannot be null");
        }
        if (text == null) {
            return;
        }
        if (text.indexOf(92) < 0) {
            writer.write(text);
            return;
        }
        JsonEscapeUtil.unescape(new InternalStringReader(text), writer);
    }

    public static void unescapeJson(Reader reader2, Writer writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'writer' cannot be null");
        }
        JsonEscapeUtil.unescape(reader2, writer);
    }

    public static void unescapeJson(char[] text, int offset, int len2, Writer writer) throws IOException {
        int textLen;
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'writer' cannot be null");
        }
        int n = textLen = text == null ? 0 : text.length;
        if (offset < 0 || offset > textLen) {
            throw new IllegalArgumentException("Invalid (offset, len). offset=" + offset + ", len=" + len2 + ", text.length=" + textLen);
        }
        if (len2 < 0 || offset + len2 > textLen) {
            throw new IllegalArgumentException("Invalid (offset, len). offset=" + offset + ", len=" + len2 + ", text.length=" + textLen);
        }
        JsonEscapeUtil.unescape(text, offset, len2, writer);
    }

    private JsonEscape() {
    }

    private static final class InternalStringReader
    extends Reader {
        private String str;
        private int length;
        private int next = 0;

        public InternalStringReader(String s2) {
            this.str = s2;
            this.length = s2.length();
        }

        @Override
        public int read() throws IOException {
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next++);
        }

        @Override
        public int read(char[] cbuf, int off, int len2) throws IOException {
            if (off < 0 || off > cbuf.length || len2 < 0 || off + len2 > cbuf.length || off + len2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len2 == 0) {
                return 0;
            }
            if (this.next >= this.length) {
                return -1;
            }
            int n = Math.min(this.length - this.next, len2);
            this.str.getChars(this.next, this.next + n, cbuf, off);
            this.next += n;
            return n;
        }

        @Override
        public void close() throws IOException {
            this.str = null;
        }
    }
}

