/*
 * Decompiled with CFR 0.152.
 */
package org.unbescape.properties;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

final class PropertiesUnescapeUtil {
    private static final char ESCAPE_PREFIX = '\\';
    private static final char ESCAPE_UHEXA_PREFIX2 = 'u';
    private static char[] HEXA_CHARS_UPPER = "0123456789ABCDEF".toCharArray();
    private static char[] HEXA_CHARS_LOWER = "0123456789abcdef".toCharArray();

    private PropertiesUnescapeUtil() {
    }

    static int parseIntFromReference(String text, int start2, int end2, int radix) {
        int result2 = 0;
        for (int i2 = start2; i2 < end2; ++i2) {
            char c2 = text.charAt(i2);
            int n = -1;
            for (int j2 = 0; j2 < HEXA_CHARS_UPPER.length; ++j2) {
                if (c2 != HEXA_CHARS_UPPER[j2] && c2 != HEXA_CHARS_LOWER[j2]) continue;
                n = j2;
                break;
            }
            result2 = radix * result2 + n;
        }
        return result2;
    }

    static int parseIntFromReference(char[] text, int start2, int end2, int radix) {
        int result2 = 0;
        for (int i2 = start2; i2 < end2; ++i2) {
            char c2 = text[i2];
            int n = -1;
            for (int j2 = 0; j2 < HEXA_CHARS_UPPER.length; ++j2) {
                if (c2 != HEXA_CHARS_UPPER[j2] && c2 != HEXA_CHARS_LOWER[j2]) continue;
                n = j2;
                break;
            }
            result2 = radix * result2 + n;
        }
        return result2;
    }

    static String unescape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = text.length();
        int readOffset = 0;
        int referenceOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            int codepoint = -1;
            if (c2 == '\\') {
                char c1 = text.charAt(i2 + 1);
                switch (c1) {
                    case 't': {
                        codepoint = 9;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'n': {
                        codepoint = 10;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'f': {
                        codepoint = 12;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 'r': {
                        codepoint = 13;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case '\\': {
                        codepoint = 92;
                        referenceOffset = i2 + 1;
                    }
                }
                if (codepoint == -1) {
                    if (c1 == 'u') {
                        char cf;
                        int f2;
                        for (f2 = i2 + 2; f2 < i2 + 6 && f2 < max2 && ((cf = text.charAt(f2)) >= '0' && cf <= '9' || cf >= 'A' && cf <= 'F' || cf >= 'a' && cf <= 'f'); ++f2) {
                        }
                        if (f2 - (i2 + 2) < 4) {
                            ++i2;
                            continue;
                        }
                        codepoint = PropertiesUnescapeUtil.parseIntFromReference(text, i2 + 2, f2, 16);
                        referenceOffset = f2 - 1;
                    } else {
                        codepoint = c1;
                        referenceOffset = i2 + 1;
                    }
                }
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 5);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (codepoint > 65535) {
                strBuilder.append(Character.toChars(codepoint));
                continue;
            }
            strBuilder.append((char)codepoint);
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        return strBuilder.toString();
    }

    static void unescape(Reader reader2, Writer writer) throws IOException {
        if (reader2 == null) {
            return;
        }
        char[] escapes = new char[4];
        int c2 = reader2.read();
        while (c2 >= 0) {
            int c1 = c2;
            c2 = reader2.read();
            if (c1 != 92 || c2 < 0) {
                writer.write(c1);
                continue;
            }
            int codepoint = -1;
            if (c1 == 92) {
                switch (c2) {
                    case 116: {
                        codepoint = 9;
                        c1 = c2;
                        c2 = reader2.read();
                        break;
                    }
                    case 110: {
                        codepoint = 10;
                        c1 = c2;
                        c2 = reader2.read();
                        break;
                    }
                    case 102: {
                        codepoint = 12;
                        c1 = c2;
                        c2 = reader2.read();
                        break;
                    }
                    case 114: {
                        codepoint = 13;
                        c1 = c2;
                        c2 = reader2.read();
                        break;
                    }
                    case 92: {
                        codepoint = 92;
                        c1 = c2;
                        c2 = reader2.read();
                    }
                }
                if (codepoint == -1) {
                    if (c2 == 117) {
                        int escapei;
                        int ce = reader2.read();
                        for (escapei = 0; ce >= 0 && escapei < 4 && (ce >= 48 && ce <= 57 || ce >= 65 && ce <= 70 || ce >= 97 && ce <= 102); ++escapei) {
                            escapes[escapei] = (char)ce;
                            ce = reader2.read();
                        }
                        if (escapei < 4) {
                            writer.write(c1);
                            writer.write(c2);
                            for (int i2 = 0; i2 < escapei; ++i2) {
                                c1 = c2;
                                c2 = escapes[i2];
                                writer.write(c2);
                            }
                            c1 = c2;
                            c2 = ce;
                            continue;
                        }
                        c1 = escapes[3];
                        c2 = ce;
                        codepoint = PropertiesUnescapeUtil.parseIntFromReference(escapes, 0, 4, 16);
                    } else {
                        codepoint = c2;
                        c1 = c2;
                        c2 = reader2.read();
                    }
                }
            }
            if (codepoint > 65535) {
                writer.write(Character.toChars(codepoint));
                continue;
            }
            writer.write((char)codepoint);
        }
    }

    static void unescape(char[] text, int offset, int len2, Writer writer) throws IOException {
        if (text == null) {
            return;
        }
        int max2 = offset + len2;
        int readOffset = offset;
        int referenceOffset = offset;
        for (int i2 = offset; i2 < max2; ++i2) {
            char c2 = text[i2];
            if (c2 != '\\' || i2 + 1 >= max2) continue;
            int codepoint = -1;
            if (c2 == '\\') {
                int c1 = text[i2 + 1];
                switch (c1) {
                    case 116: {
                        codepoint = 9;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 110: {
                        codepoint = 10;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 102: {
                        codepoint = 12;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 114: {
                        codepoint = 13;
                        referenceOffset = i2 + 1;
                        break;
                    }
                    case 92: {
                        codepoint = 92;
                        referenceOffset = i2 + 1;
                    }
                }
                if (codepoint == -1) {
                    if (c1 == 117) {
                        char cf;
                        int f2;
                        for (f2 = i2 + 2; f2 < i2 + 6 && f2 < max2 && ((cf = text[f2]) >= '0' && cf <= '9' || cf >= 'A' && cf <= 'F' || cf >= 'a' && cf <= 'f'); ++f2) {
                        }
                        if (f2 - (i2 + 2) < 4) {
                            ++i2;
                            continue;
                        }
                        codepoint = PropertiesUnescapeUtil.parseIntFromReference(text, i2 + 2, f2, 16);
                        referenceOffset = f2 - 1;
                    } else {
                        codepoint = c1;
                        referenceOffset = i2 + 1;
                    }
                }
            }
            if (i2 - readOffset > 0) {
                writer.write(text, readOffset, i2 - readOffset);
            }
            i2 = referenceOffset;
            readOffset = i2 + 1;
            if (codepoint > 65535) {
                writer.write(Character.toChars(codepoint));
                continue;
            }
            writer.write((char)codepoint);
        }
        if (max2 - readOffset > 0) {
            writer.write(text, readOffset, max2 - readOffset);
        }
    }
}

