/*
 * Decompiled with CFR 0.152.
 */
package org.unbescape.uri;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

final class UriEscapeUtil {
    private static final char ESCAPE_PREFIX = '%';
    private static char[] HEXA_CHARS_UPPER = "0123456789ABCDEF".toCharArray();
    private static char[] HEXA_CHARS_LOWER = "0123456789abcdef".toCharArray();

    private UriEscapeUtil() {
    }

    static char[] printHexa(byte b2) {
        char[] result2 = new char[]{HEXA_CHARS_UPPER[b2 >> 4 & 0xF], HEXA_CHARS_UPPER[b2 & 0xF]};
        return result2;
    }

    static byte parseHexa(char c1, char c2) {
        int j2;
        byte result2 = 0;
        for (j2 = 0; j2 < HEXA_CHARS_UPPER.length; ++j2) {
            if (c1 != HEXA_CHARS_UPPER[j2] && c1 != HEXA_CHARS_LOWER[j2]) continue;
            result2 = (byte)(result2 + (j2 << 4));
            break;
        }
        for (j2 = 0; j2 < HEXA_CHARS_UPPER.length; ++j2) {
            if (c2 != HEXA_CHARS_UPPER[j2] && c2 != HEXA_CHARS_LOWER[j2]) continue;
            result2 = (byte)(result2 + j2);
            break;
        }
        return result2;
    }

    static String escape(String text, UriEscapeType escapeType, String encoding) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = text.length();
        int readOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            byte[] charAsBytes;
            int codepoint = Character.codePointAt(text, i2);
            if (UriEscapeType.isAlpha(codepoint) || escapeType.isAllowed(codepoint)) continue;
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 20);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i2;
            }
            readOffset = i2 + 1;
            try {
                charAsBytes = new String(Character.toChars(codepoint)).getBytes(encoding);
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalArgumentException("Exception while escaping URI: Bad encoding '" + encoding + "'", e2);
            }
            for (byte b2 : charAsBytes) {
                strBuilder.append('%');
                strBuilder.append(UriEscapeUtil.printHexa(b2));
            }
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        return strBuilder.toString();
    }

    static void escape(Reader reader2, Writer writer, UriEscapeType escapeType, String encoding) throws IOException {
        if (reader2 == null) {
            return;
        }
        int c2 = reader2.read();
        while (c2 >= 0) {
            byte[] charAsBytes;
            int c1 = c2;
            int codepoint = UriEscapeUtil.codePointAt((char)c1, (char)(c2 = reader2.read()));
            if (UriEscapeType.isAlpha(codepoint)) {
                writer.write(c1);
                continue;
            }
            if (escapeType.isAllowed(codepoint)) {
                writer.write(c1);
                continue;
            }
            if (Character.charCount(codepoint) > 1) {
                c1 = c2;
                c2 = reader2.read();
            }
            try {
                charAsBytes = new String(Character.toChars(codepoint)).getBytes(encoding);
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalArgumentException("Exception while escaping URI: Bad encoding '" + encoding + "'", e2);
            }
            for (byte b2 : charAsBytes) {
                writer.write(37);
                writer.write(UriEscapeUtil.printHexa(b2));
            }
        }
    }

    static void escape(char[] text, int offset, int len2, Writer writer, UriEscapeType escapeType, String encoding) throws IOException {
        if (text == null || text.length == 0) {
            return;
        }
        int max2 = offset + len2;
        int readOffset = offset;
        for (int i2 = offset; i2 < max2; ++i2) {
            byte[] charAsBytes;
            int codepoint = Character.codePointAt(text, i2);
            if (UriEscapeType.isAlpha(codepoint) || escapeType.isAllowed(codepoint)) continue;
            if (i2 - readOffset > 0) {
                writer.write(text, readOffset, i2 - readOffset);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i2;
            }
            readOffset = i2 + 1;
            try {
                charAsBytes = new String(Character.toChars(codepoint)).getBytes(encoding);
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalArgumentException("Exception while escaping URI: Bad encoding '" + encoding + "'", e2);
            }
            for (byte b2 : charAsBytes) {
                writer.write(37);
                writer.write(UriEscapeUtil.printHexa(b2));
            }
        }
        if (max2 - readOffset > 0) {
            writer.write(text, readOffset, max2 - readOffset);
        }
    }

    static String unescape(String text, UriEscapeType escapeType, String encoding) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean offset = false;
        int max2 = text.length();
        int readOffset = 0;
        for (int i2 = 0; i2 < max2; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 != '%' && (c2 != '+' || !escapeType.canPlusEscapeWhitespace())) continue;
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max2 + 5);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            if (c2 == '+') {
                strBuilder.append(' ');
                readOffset = i2 + 1;
                continue;
            }
            byte[] bytes = new byte[(max2 - i2) / 3];
            char aheadC = c2;
            int pos = 0;
            while (i2 + 2 < max2 && aheadC == '%') {
                bytes[pos++] = UriEscapeUtil.parseHexa(text.charAt(i2 + 1), text.charAt(i2 + 2));
                if ((i2 += 3) >= max2) continue;
                aheadC = text.charAt(i2);
            }
            if (i2 < max2 && aheadC == '%') {
                throw new IllegalArgumentException("Incomplete escaping sequence in input");
            }
            try {
                strBuilder.append(new String(bytes, 0, pos, encoding));
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalArgumentException("Exception while escaping URI: Bad encoding '" + encoding + "'", e2);
            }
            readOffset = i2;
        }
        if (strBuilder == null) {
            return text;
        }
        if (max2 - readOffset > 0) {
            strBuilder.append(text, readOffset, max2);
        }
        return strBuilder.toString();
    }

    static void unescape(Reader reader2, Writer writer, UriEscapeType escapeType, String encoding) throws IOException {
        if (reader2 == null) {
            return;
        }
        byte[] escapes = new byte[4];
        int c2 = reader2.read();
        while (c2 >= 0) {
            int c1 = c2;
            c2 = reader2.read();
            if (!(c1 == 37 && c2 >= 0 || c1 == 43 && escapeType.canPlusEscapeWhitespace())) {
                writer.write(c1);
                continue;
            }
            if (c1 == 43) {
                writer.write(32);
                continue;
            }
            int pos = 0;
            int ce0 = c1;
            int ce1 = c2;
            int ce2 = reader2.read();
            while (ce0 == 37 && ce1 >= 0 && ce2 >= 0) {
                if (pos == escapes.length) {
                    byte[] newEscapes = new byte[escapes.length + 4];
                    System.arraycopy(escapes, 0, newEscapes, 0, escapes.length);
                    escapes = newEscapes;
                }
                escapes[pos++] = UriEscapeUtil.parseHexa((char)ce1, (char)ce2);
                ce0 = reader2.read();
                int n = ce0 < 0 ? ce0 : (ce1 = ce0 != 37 ? 0 : reader2.read());
                ce2 = ce1 < 0 ? ce1 : (ce0 != 37 ? 0 : reader2.read());
            }
            if (ce0 == 37) {
                throw new IllegalArgumentException("Incomplete escaping sequence in input");
            }
            c2 = ce0;
            try {
                writer.write(new String(escapes, 0, pos, encoding));
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalArgumentException("Exception while escaping URI: Bad encoding '" + encoding + "'", e2);
            }
        }
    }

    static void unescape(char[] text, int offset, int len2, Writer writer, UriEscapeType escapeType, String encoding) throws IOException {
        if (text == null) {
            return;
        }
        int max2 = offset + len2;
        int readOffset = offset;
        for (int i2 = offset; i2 < max2; ++i2) {
            char c2 = text[i2];
            if (c2 != '%' && (c2 != '+' || !escapeType.canPlusEscapeWhitespace())) continue;
            if (i2 - readOffset > 0) {
                writer.write(text, readOffset, i2 - readOffset);
            }
            if (c2 == '+') {
                writer.write(32);
                readOffset = i2 + 1;
                continue;
            }
            byte[] bytes = new byte[(max2 - i2) / 3];
            char aheadC = c2;
            int pos = 0;
            while (i2 + 2 < max2 && aheadC == '%') {
                bytes[pos++] = UriEscapeUtil.parseHexa(text[i2 + 1], text[i2 + 2]);
                if ((i2 += 3) >= max2) continue;
                aheadC = text[i2];
            }
            if (i2 < max2 && aheadC == '%') {
                throw new IllegalArgumentException("Incomplete escaping sequence in input");
            }
            try {
                writer.write(new String(bytes, 0, pos, encoding));
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalArgumentException("Exception while escaping URI: Bad encoding '" + encoding + "'", e2);
            }
            readOffset = i2;
        }
        if (max2 - readOffset > 0) {
            writer.write(text, readOffset, max2 - readOffset);
        }
    }

    private static int codePointAt(char c1, char c2) {
        if (Character.isHighSurrogate(c1) && c2 >= '\u0000' && Character.isLowSurrogate(c2)) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    static enum UriEscapeType {
        PATH{

            @Override
            public boolean isAllowed(int c2) {
                return UriEscapeType.isPchar(c2) || 47 == c2;
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isAllowed(int c2) {
                return UriEscapeType.isPchar(c2);
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isAllowed(int c2) {
                if (61 == c2 || 38 == c2 || 43 == c2 || 35 == c2) {
                    return false;
                }
                return UriEscapeType.isPchar(c2) || 47 == c2 || 63 == c2;
            }

            @Override
            public boolean canPlusEscapeWhitespace() {
                return true;
            }
        }
        ,
        FRAGMENT_ID{

            @Override
            public boolean isAllowed(int c2) {
                return UriEscapeType.isPchar(c2) || 47 == c2 || 63 == c2;
            }
        };


        public abstract boolean isAllowed(int var1);

        public boolean canPlusEscapeWhitespace() {
            return false;
        }

        private static boolean isPchar(int c2) {
            return UriEscapeType.isUnreserved(c2) || UriEscapeType.isSubDelim(c2) || 58 == c2 || 64 == c2;
        }

        private static boolean isUnreserved(int c2) {
            return UriEscapeType.isAlpha(c2) || UriEscapeType.isDigit(c2) || 45 == c2 || 46 == c2 || 95 == c2 || 126 == c2;
        }

        private static boolean isReserved(int c2) {
            return UriEscapeType.isGenDelim(c2) || UriEscapeType.isSubDelim(c2);
        }

        private static boolean isSubDelim(int c2) {
            return 33 == c2 || 36 == c2 || 38 == c2 || 39 == c2 || 40 == c2 || 41 == c2 || 42 == c2 || 43 == c2 || 44 == c2 || 59 == c2 || 61 == c2;
        }

        private static boolean isGenDelim(int c2) {
            return 58 == c2 || 47 == c2 || 63 == c2 || 35 == c2 || 91 == c2 || 93 == c2 || 64 == c2;
        }

        static boolean isAlpha(int c2) {
            return c2 >= 65 && c2 <= 90 || c2 >= 97 && c2 <= 122;
        }

        private static boolean isDigit(int c2) {
            return c2 >= 48 && c2 <= 57;
        }
    }
}

