/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.introspector;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.util.PlatformFeatureDetector;

public class PropertyUtils {
    private final Map<Class<?>, Map<String, Property>> propertiesCache = new HashMap();
    private final Map<Class<?>, Set<Property>> readableProperties = new HashMap();
    private BeanAccess beanAccess = BeanAccess.DEFAULT;
    private boolean allowReadOnlyProperties = false;
    private boolean skipMissingProperties = false;
    private final PlatformFeatureDetector platformFeatureDetector;

    public PropertyUtils() {
        this(new PlatformFeatureDetector());
    }

    PropertyUtils(PlatformFeatureDetector platformFeatureDetector) {
        this.platformFeatureDetector = platformFeatureDetector;
        if (!platformFeatureDetector.isIntrospectionAvailable()) {
            this.beanAccess = BeanAccess.FIELD;
        }
    }

    protected Map<String, Property> getPropertiesMap(Class<?> type2, BeanAccess bAccess) {
        if (this.propertiesCache.containsKey(type2)) {
            return this.propertiesCache.get(type2);
        }
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        boolean inaccessableFieldsExist = false;
        if (bAccess == BeanAccess.FIELD) {
            for (Class<?> c2 = type2; c2 != null; c2 = c2.getSuperclass()) {
                for (Field field : c2.getDeclaredFields()) {
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || properties.containsKey(field.getName())) continue;
                    properties.put(field.getName(), new FieldProperty(field));
                }
            }
        } else {
            inaccessableFieldsExist = MethodProperty.addPublicFields(type2, properties);
        }
        if (properties.isEmpty() && inaccessableFieldsExist) {
            throw new YAMLException("No JavaBean properties found in " + type2.getName());
        }
        this.propertiesCache.put(type2, properties);
        return properties;
    }

    public Set<Property> getProperties(Class<? extends Object> type2) {
        return this.getProperties(type2, this.beanAccess);
    }

    public Set<Property> getProperties(Class<? extends Object> type2, BeanAccess bAccess) {
        if (this.readableProperties.containsKey(type2)) {
            return this.readableProperties.get(type2);
        }
        Set<Property> properties = this.createPropertySet(type2, bAccess);
        this.readableProperties.put(type2, properties);
        return properties;
    }

    protected Set<Property> createPropertySet(Class<? extends Object> type2, BeanAccess bAccess) {
        TreeSet<Property> properties = new TreeSet<Property>();
        Collection<Property> props = this.getPropertiesMap(type2, bAccess).values();
        for (Property property2 : props) {
            if (!property2.isReadable() || !this.allowReadOnlyProperties && !property2.isWritable()) continue;
            properties.add(property2);
        }
        return properties;
    }

    public Property getProperty(Class<? extends Object> type2, String name) {
        return this.getProperty(type2, name, this.beanAccess);
    }

    public Property getProperty(Class<? extends Object> type2, String name, BeanAccess bAccess) {
        Map<String, Property> properties = this.getPropertiesMap(type2, bAccess);
        Property property2 = properties.get(name);
        if (property2 == null && this.skipMissingProperties) {
            property2 = new MissingProperty(name);
        }
        if (property2 == null) {
            throw new YAMLException("Unable to find property '" + name + "' on class: " + type2.getName());
        }
        return property2;
    }

    public void setBeanAccess(BeanAccess beanAccess) {
        if (this.platformFeatureDetector.isRunningOnAndroid() && beanAccess != BeanAccess.FIELD) {
            throw new IllegalArgumentException("JVM is Android - only BeanAccess.FIELD is available");
        }
        if (this.beanAccess != beanAccess) {
            this.beanAccess = beanAccess;
            this.propertiesCache.clear();
            this.readableProperties.clear();
        }
    }

    public void setAllowReadOnlyProperties(boolean allowReadOnlyProperties) {
        if (this.allowReadOnlyProperties != allowReadOnlyProperties) {
            this.allowReadOnlyProperties = allowReadOnlyProperties;
            this.readableProperties.clear();
        }
    }

    public boolean isAllowReadOnlyProperties() {
        return this.allowReadOnlyProperties;
    }

    public void setSkipMissingProperties(boolean skipMissingProperties) {
        if (this.skipMissingProperties != skipMissingProperties) {
            this.skipMissingProperties = skipMissingProperties;
            this.readableProperties.clear();
        }
    }

    public boolean isSkipMissingProperties() {
        return this.skipMissingProperties;
    }
}

