/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.reader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.scanner.Constant;

public class StreamReader {
    private String name;
    private final Reader stream;
    private int[] dataWindow;
    private int dataLength;
    private int pointer = 0;
    private boolean eof;
    private int index = 0;
    private int documentIndex = 0;
    private int line = 0;
    private int column = 0;
    private final char[] buffer;

    public StreamReader(String stream) {
        this(new StringReader(stream));
        this.name = "'string'";
    }

    public StreamReader(Reader reader2) {
        if (reader2 == null) {
            throw new NullPointerException("Reader must be provided.");
        }
        this.name = "'reader'";
        this.dataWindow = new int[0];
        this.dataLength = 0;
        this.stream = reader2;
        this.eof = false;
        this.buffer = new char[1024];
    }

    public static boolean isPrintable(String data2) {
        int codePoint;
        int length = data2.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = data2.codePointAt(offset);
            if (StreamReader.isPrintable(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(int c2) {
        return c2 >= 32 && c2 <= 126 || c2 == 9 || c2 == 10 || c2 == 13 || c2 == 133 || c2 >= 160 && c2 <= 55295 || c2 >= 57344 && c2 <= 65533 || c2 >= 65536 && c2 <= 0x10FFFF;
    }

    public Mark getMark() {
        return new Mark(this.name, this.index, this.line, this.column, this.dataWindow, this.pointer);
    }

    public void forward() {
        this.forward(1);
    }

    public void forward(int length) {
        for (int i2 = 0; i2 < length && this.ensureEnoughData(); ++i2) {
            int c2 = this.dataWindow[this.pointer++];
            this.moveIndices(1);
            if (Constant.LINEBR.has(c2) || c2 == 13 && this.ensureEnoughData() && this.dataWindow[this.pointer] != 10) {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (c2 == 65279) continue;
            ++this.column;
        }
    }

    public int peek() {
        return this.ensureEnoughData() ? this.dataWindow[this.pointer] : 0;
    }

    public int peek(int index) {
        return this.ensureEnoughData(index) ? this.dataWindow[this.pointer + index] : 0;
    }

    public String prefix(int length) {
        if (length == 0) {
            return "";
        }
        if (this.ensureEnoughData(length)) {
            return new String(this.dataWindow, this.pointer, length);
        }
        return new String(this.dataWindow, this.pointer, Math.min(length, this.dataLength - this.pointer));
    }

    public String prefixForward(int length) {
        String prefix2 = this.prefix(length);
        this.pointer += length;
        this.moveIndices(length);
        this.column += length;
        return prefix2;
    }

    private boolean ensureEnoughData() {
        return this.ensureEnoughData(0);
    }

    private boolean ensureEnoughData(int size2) {
        if (!this.eof && this.pointer + size2 >= this.dataLength) {
            this.update();
        }
        return this.pointer + size2 < this.dataLength;
    }

    private void update() {
        try {
            int read2 = this.stream.read(this.buffer, 0, this.buffer.length - 1);
            if (read2 > 0) {
                int cpIndex = this.dataLength - this.pointer;
                this.dataWindow = Arrays.copyOfRange(this.dataWindow, this.pointer, this.dataLength + read2);
                if (Character.isHighSurrogate(this.buffer[read2 - 1])) {
                    if (this.stream.read(this.buffer, read2, 1) == -1) {
                        throw new ReaderException(this.name, this.index + read2, this.buffer[read2 - 1], "The last char is HighSurrogate (no LowSurrogate detected).");
                    }
                    ++read2;
                }
                int nonPrintable = 32;
                int i2 = 0;
                while (i2 < read2) {
                    int codePoint;
                    this.dataWindow[cpIndex] = codePoint = Character.codePointAt(this.buffer, i2);
                    if (StreamReader.isPrintable(codePoint)) {
                        int charCount = Character.charCount(codePoint);
                        i2 += charCount;
                    } else {
                        nonPrintable = codePoint;
                        i2 = read2;
                    }
                    ++cpIndex;
                }
                this.dataLength = cpIndex;
                this.pointer = 0;
                if (nonPrintable != 32) {
                    throw new ReaderException(this.name, this.index + cpIndex - 1, nonPrintable, "special characters are not allowed");
                }
            } else {
                this.eof = true;
            }
        }
        catch (IOException ioe) {
            throw new YAMLException(ioe);
        }
    }

    public int getColumn() {
        return this.column;
    }

    private void moveIndices(int length) {
        this.index += length;
        this.documentIndex += length;
    }

    public int getDocumentIndex() {
        return this.documentIndex;
    }

    public void resetDocumentIndex() {
        this.documentIndex = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }
}

