/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.util.Tuple;

public abstract class MergeUtils {
    public abstract MappingNode asMappingNode(Node var1);

    public List<NodeTuple> flatten(MappingNode node) {
        List<NodeTuple> toProcess;
        List<NodeTuple> result2 = toProcess = node.getValue();
        boolean process2 = true;
        while (process2) {
            process2 = false;
            ArrayList<NodeTuple> updated = new ArrayList<NodeTuple>(toProcess.size());
            HashSet<String> keys2 = new HashSet<String>(toProcess.size());
            ArrayList<NodeTuple> merges = new ArrayList<NodeTuple>(2);
            for (NodeTuple tuple : toProcess) {
                Node keyNode = tuple.getKeyNode();
                if (keyNode.getTag().equals(Tag.MERGE)) {
                    merges.add(tuple);
                    continue;
                }
                updated.add(tuple);
                if (!(keyNode instanceof ScalarNode)) continue;
                ScalarNode sNode = (ScalarNode)keyNode;
                keys2.add(sNode.getValue());
            }
            for (NodeTuple tuple : merges) {
                Node valueNode = tuple.getValueNode();
                if (valueNode instanceof SequenceNode) {
                    SequenceNode seqNode = (SequenceNode)valueNode;
                    for (Node ref : seqNode.getValue()) {
                        MappingNode mergable = this.asMappingNode(ref);
                        process2 = process2 || mergable.isMerged();
                        Tuple<List<NodeTuple>, Set<String>> filtered2 = this.filter(mergable.getValue(), keys2);
                        updated.addAll((Collection<NodeTuple>)filtered2._1());
                        keys2.addAll((Collection<String>)filtered2._2());
                    }
                    continue;
                }
                MappingNode mergable = this.asMappingNode(valueNode);
                process2 = process2 || mergable.isMerged();
                Tuple<List<NodeTuple>, Set<String>> filtered3 = this.filter(mergable.getValue(), keys2);
                updated.addAll((Collection<NodeTuple>)filtered3._1());
                keys2.addAll((Collection<String>)filtered3._2());
            }
            result2 = updated;
            if (!process2) continue;
            toProcess = updated;
        }
        return result2;
    }

    private Tuple<List<NodeTuple>, Set<String>> filter(List<NodeTuple> mergables, Set<String> filter2) {
        int size2 = mergables.size();
        HashSet<String> keys2 = new HashSet<String>(size2);
        ArrayList<NodeTuple> result2 = new ArrayList<NodeTuple>(size2);
        for (NodeTuple tuple : mergables) {
            Node key2 = tuple.getKeyNode();
            if (key2 instanceof ScalarNode) {
                ScalarNode sNode = (ScalarNode)key2;
                String nodeValue = sNode.getValue();
                if (filter2.contains(nodeValue)) continue;
                result2.add(tuple);
                keys2.add(nodeValue);
                continue;
            }
            result2.add(tuple);
        }
        return new Tuple<List<NodeTuple>, Set<String>>(result2, keys2);
    }
}

