/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.HashSet;
import redis.clients.jedis.exceptions.JedisValidationException;

public final class ClientSetInfoConfig {
    private final boolean disabled;
    private final String libNameSuffix;
    private static final HashSet<Character> BRACES = new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}')));
    public static final ClientSetInfoConfig DEFAULT = new ClientSetInfoConfig();
    public static final ClientSetInfoConfig DISABLED = new ClientSetInfoConfig(true);

    public ClientSetInfoConfig() {
        this(false, null);
    }

    public ClientSetInfoConfig(boolean disabled) {
        this(disabled, null);
    }

    public ClientSetInfoConfig(String libNameSuffix) {
        this(false, libNameSuffix);
    }

    private ClientSetInfoConfig(boolean disabled, String libNameSuffix) {
        this.disabled = disabled;
        this.libNameSuffix = ClientSetInfoConfig.validateLibNameSuffix(libNameSuffix);
    }

    private static String validateLibNameSuffix(String suffix) {
        if (suffix == null || suffix.trim().isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < suffix.length(); ++i2) {
            char c2 = suffix.charAt(i2);
            if (c2 >= ' ' && c2 <= '~' && !BRACES.contains(Character.valueOf(c2))) continue;
            throw new JedisValidationException("lib-name suffix cannot contain braces, newlines or special characters.");
        }
        return suffix.replaceAll("\\s", "-");
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    public final String getLibNameSuffix() {
        return this.libNameSuffix;
    }

    public static ClientSetInfoConfig withLibNameSuffix(String suffix) {
        return new ClientSetInfoConfig(suffix);
    }
}

