/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisClusterOperationException;
import redis.clients.jedis.util.JedisClusterCRC16;

public class ClusterCommandArguments
extends CommandArguments {
    private int commandHashSlot = -1;

    public ClusterCommandArguments(ProtocolCommand command2) {
        super(command2);
    }

    public int getCommandHashSlot() {
        return this.commandHashSlot;
    }

    @Override
    protected CommandArguments processKey(byte[] key2) {
        int hashSlot = JedisClusterCRC16.getSlot(key2);
        if (this.commandHashSlot < 0) {
            this.commandHashSlot = hashSlot;
        } else if (this.commandHashSlot != hashSlot) {
            throw new JedisClusterOperationException("Keys must belong to same hashslot.");
        }
        return this;
    }

    @Override
    protected CommandArguments processKey(String key2) {
        int hashSlot = JedisClusterCRC16.getSlot(key2);
        if (this.commandHashSlot < 0) {
            this.commandHashSlot = hashSlot;
        } else if (this.commandHashSlot != hashSlot) {
            throw new JedisClusterOperationException("Keys must belong to same hashslot.");
        }
        return this;
    }
}

