/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.time.Duration;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.ClusterCommandArguments;
import redis.clients.jedis.ClusterCommandObjects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.MultiNodePipelineBase;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.providers.ClusterConnectionProvider;
import redis.clients.jedis.util.IOUtils;

public class ClusterPipeline
extends MultiNodePipelineBase {
    private final ClusterConnectionProvider provider;
    private AutoCloseable closeable = null;

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig, poolConfig), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig, Duration topologyRefreshPeriod) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig, poolConfig, topologyRefreshPeriod), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(ClusterConnectionProvider provider2) {
        this(provider2, new ClusterCommandObjects());
    }

    public ClusterPipeline(ClusterConnectionProvider provider2, ClusterCommandObjects commandObjects) {
        super(commandObjects);
        this.provider = provider2;
    }

    private static ClusterCommandObjects createClusterCommandObjects(RedisProtocol protocol) {
        ClusterCommandObjects cco = new ClusterCommandObjects();
        if (protocol == RedisProtocol.RESP3) {
            cco.setProtocol(protocol);
        }
        return cco;
    }

    public void prepareGraphCommands() {
        super.prepareGraphCommands(this.provider);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            IOUtils.closeQuietly(this.closeable);
        }
    }

    @Override
    protected HostAndPort getNodeKey(CommandArguments args2) {
        return this.provider.getNode(((ClusterCommandArguments)args2).getCommandHashSlot());
    }

    @Override
    protected Connection getConnection(HostAndPort nodeKey) {
        return this.provider.getConnection(nodeKey);
    }

    public Response<Long> spublish(String channel2, String message) {
        return this.appendCommand(this.commandObjects.spublish(channel2, message));
    }

    public Response<Long> spublish(byte[] channel2, byte[] message) {
        return this.appendCommand(this.commandObjects.spublish(channel2, message));
    }
}

