/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import redis.clients.jedis.CommandKeyArgumentPreProcessor;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.annots.Internal;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.RawableFactory;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.RediSearchUtil;

public class CommandArguments
implements Iterable<Rawable> {
    private CommandKeyArgumentPreProcessor keyPreProc = null;
    private final ArrayList<Rawable> args;
    private List<Object> keys;
    private boolean blocking;

    private CommandArguments() {
        throw new InstantiationError();
    }

    public CommandArguments(ProtocolCommand command2) {
        this.args = new ArrayList();
        this.args.add(command2);
        this.keys = Collections.emptyList();
    }

    public ProtocolCommand getCommand() {
        return (ProtocolCommand)this.args.get(0);
    }

    @Experimental
    void setKeyArgumentPreProcessor(CommandKeyArgumentPreProcessor keyPreProcessor) {
        this.keyPreProc = keyPreProcessor;
    }

    public CommandArguments add(Rawable arg) {
        this.args.add(arg);
        return this;
    }

    public CommandArguments add(byte[] arg) {
        return this.add(RawableFactory.from(arg));
    }

    public CommandArguments add(boolean arg) {
        return this.add(RawableFactory.from(arg));
    }

    public CommandArguments add(int arg) {
        return this.add(RawableFactory.from(arg));
    }

    public CommandArguments add(long arg) {
        return this.add(RawableFactory.from(arg));
    }

    public CommandArguments add(double arg) {
        return this.add(RawableFactory.from(arg));
    }

    public CommandArguments add(String arg) {
        return this.add(RawableFactory.from(arg));
    }

    public CommandArguments add(Object arg) {
        if (arg == null) {
            throw new IllegalArgumentException("null is not a valid argument.");
        }
        if (arg instanceof Rawable) {
            this.args.add((Rawable)arg);
        } else if (arg instanceof byte[]) {
            this.args.add(RawableFactory.from((byte[])arg));
        } else if (arg instanceof Boolean) {
            this.args.add(RawableFactory.from((Boolean)arg));
        } else if (arg instanceof Integer) {
            this.args.add(RawableFactory.from((Integer)arg));
        } else if (arg instanceof Long) {
            this.args.add(RawableFactory.from((Long)arg));
        } else if (arg instanceof Double) {
            this.args.add(RawableFactory.from((Double)arg));
        } else if (arg instanceof float[]) {
            this.args.add(RawableFactory.from(RediSearchUtil.toByteArray((float[])arg)));
        } else if (arg instanceof String) {
            this.args.add(RawableFactory.from((String)arg));
        } else if (arg instanceof GeoCoordinate) {
            GeoCoordinate geo = (GeoCoordinate)arg;
            this.args.add(RawableFactory.from(geo.getLongitude() + "," + geo.getLatitude()));
        } else {
            this.args.add(RawableFactory.from(String.valueOf(arg)));
        }
        return this;
    }

    public CommandArguments addObjects(Object ... args2) {
        for (Object arg : args2) {
            this.add(arg);
        }
        return this;
    }

    public CommandArguments addObjects(Collection args2) {
        args2.forEach(arg -> this.add(arg));
        return this;
    }

    public CommandArguments key(Object key2) {
        if (this.keyPreProc != null) {
            key2 = this.keyPreProc.actualKey(key2);
        }
        if (key2 instanceof Rawable) {
            Rawable raw = (Rawable)key2;
            this.processKey(raw.getRaw());
            this.args.add(raw);
        } else if (key2 instanceof byte[]) {
            byte[] raw = (byte[])key2;
            this.processKey(raw);
            this.args.add(RawableFactory.from(raw));
        } else if (key2 instanceof String) {
            String raw = (String)key2;
            this.processKey(raw);
            this.args.add(RawableFactory.from(raw));
        } else {
            throw new IllegalArgumentException("\"" + key2.toString() + "\" is not a valid argument.");
        }
        this.addKeyInKeys(key2);
        return this;
    }

    private void addKeyInKeys(Object key2) {
        if (this.keys.isEmpty()) {
            this.keys = Collections.singletonList(key2);
        } else if (this.keys.size() == 1) {
            List<Object> oldKeys = this.keys;
            this.keys = new ArrayList<Object>();
            this.keys.addAll(oldKeys);
            this.keys.add(key2);
        } else {
            this.keys.add(key2);
        }
    }

    public final CommandArguments keys(Object ... keys2) {
        Arrays.stream(keys2).forEach(this::key);
        return this;
    }

    public final CommandArguments keys(Collection keys2) {
        keys2.forEach(this::key);
        return this;
    }

    public final CommandArguments addParams(IParams params) {
        params.addParams(this);
        return this;
    }

    protected CommandArguments processKey(byte[] key2) {
        return this;
    }

    protected final CommandArguments processKeys(byte[] ... keys2) {
        for (byte[] key2 : keys2) {
            this.processKey(key2);
        }
        return this;
    }

    protected CommandArguments processKey(String key2) {
        return this;
    }

    protected final CommandArguments processKeys(String ... keys2) {
        for (String key2 : keys2) {
            this.processKey(key2);
        }
        return this;
    }

    public int size() {
        return this.args.size();
    }

    @Override
    public Iterator<Rawable> iterator() {
        return this.args.iterator();
    }

    @Internal
    public List<Object> getKeys() {
        return this.keys;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public CommandArguments blocking() {
        this.blocking = true;
        return this;
    }
}

