/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandKeyArgumentPreProcessor;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.JedisBroadcastAndRoundRobinConfig;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.args.BitCountOption;
import redis.clients.jedis.args.BitOP;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.args.FlushMode;
import redis.clients.jedis.args.FunctionRestorePolicy;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.args.ListPosition;
import redis.clients.jedis.args.SortedSetOption;
import redis.clients.jedis.bloom.BFInsertParams;
import redis.clients.jedis.bloom.BFReserveParams;
import redis.clients.jedis.bloom.CFInsertParams;
import redis.clients.jedis.bloom.CFReserveParams;
import redis.clients.jedis.bloom.RedisBloomProtocol;
import redis.clients.jedis.bloom.TDigestMergeParams;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.gears.RedisGearsProtocol;
import redis.clients.jedis.gears.TFunctionListParams;
import redis.clients.jedis.gears.TFunctionLoadParams;
import redis.clients.jedis.gears.resps.GearsLibraryInfo;
import redis.clients.jedis.graph.GraphProtocol;
import redis.clients.jedis.json.DefaultGsonObjectMapper;
import redis.clients.jedis.json.JsonBuilderFactory;
import redis.clients.jedis.json.JsonObjectMapper;
import redis.clients.jedis.json.JsonProtocol;
import redis.clients.jedis.json.JsonSetParams;
import redis.clients.jedis.json.Path;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.params.BitPosParams;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoRadiusStoreParam;
import redis.clients.jedis.params.GeoSearchParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.params.LCSParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.SortingParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.params.ZParams;
import redis.clients.jedis.params.ZRangeParams;
import redis.clients.jedis.resps.FunctionStats;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.resps.LCSMatchResult;
import redis.clients.jedis.resps.LibraryInfo;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.resps.StreamConsumerInfo;
import redis.clients.jedis.resps.StreamConsumersInfo;
import redis.clients.jedis.resps.StreamEntry;
import redis.clients.jedis.resps.StreamFullInfo;
import redis.clients.jedis.resps.StreamGroupInfo;
import redis.clients.jedis.resps.StreamInfo;
import redis.clients.jedis.resps.StreamPendingEntry;
import redis.clients.jedis.resps.StreamPendingSummary;
import redis.clients.jedis.resps.Tuple;
import redis.clients.jedis.search.FTCreateParams;
import redis.clients.jedis.search.FTProfileParams;
import redis.clients.jedis.search.FTSearchParams;
import redis.clients.jedis.search.FTSpellCheckParams;
import redis.clients.jedis.search.IndexOptions;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.SearchBuilderFactory;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.aggr.AggregationBuilder;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.timeseries.AggregationType;
import redis.clients.jedis.timeseries.TSAddParams;
import redis.clients.jedis.timeseries.TSAlterParams;
import redis.clients.jedis.timeseries.TSCreateParams;
import redis.clients.jedis.timeseries.TSDecrByParams;
import redis.clients.jedis.timeseries.TSElement;
import redis.clients.jedis.timeseries.TSGetParams;
import redis.clients.jedis.timeseries.TSIncrByParams;
import redis.clients.jedis.timeseries.TSInfo;
import redis.clients.jedis.timeseries.TSMGetElement;
import redis.clients.jedis.timeseries.TSMGetParams;
import redis.clients.jedis.timeseries.TSMRangeElements;
import redis.clients.jedis.timeseries.TSMRangeParams;
import redis.clients.jedis.timeseries.TSRangeParams;
import redis.clients.jedis.timeseries.TimeSeriesBuilderFactory;
import redis.clients.jedis.timeseries.TimeSeriesProtocol;
import redis.clients.jedis.util.KeyValue;

public class CommandObjects {
    private RedisProtocol protocol;
    protected volatile CommandKeyArgumentPreProcessor keyPreProcessor = null;
    private JedisBroadcastAndRoundRobinConfig broadcastAndRoundRobinConfig = null;
    private Lock mapperLock = new ReentrantLock(true);
    private volatile JsonObjectMapper jsonObjectMapper;
    private final AtomicInteger searchDialect = new AtomicInteger(0);
    private final CommandObject<String> PING_COMMAND_OBJECT = new CommandObject<String>(this.commandArguments(Protocol.Command.PING), BuilderFactory.STRING);
    private final CommandObject<String> FLUSHALL_COMMAND_OBJECT = new CommandObject<String>(this.commandArguments(Protocol.Command.FLUSHALL), BuilderFactory.STRING);
    private final CommandObject<String> FLUSHDB_COMMAND_OBJECT = new CommandObject<String>(this.commandArguments(Protocol.Command.FLUSHDB), BuilderFactory.STRING);
    private final CommandObject<String> SCRIPT_FLUSH_COMMAND_OBJECT = new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH), BuilderFactory.STRING);
    private final CommandObject<String> SCRIPT_KILL_COMMAND_OBJECT = new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.KILL), BuilderFactory.STRING);
    private final CommandObject<String> SLOWLOG_RESET_COMMAND_OBJECT = new CommandObject<String>(this.commandArguments(Protocol.Command.SLOWLOG).add(Protocol.Keyword.RESET), BuilderFactory.STRING);
    private final Builder<Object> JSON_GENERIC_OBJECT = new JsonObjectBuilder<Object>(Object.class);
    private static final Builder<Map.Entry<Long, byte[]>> BLOOM_SCANDUMP_RESPONSE = new Builder<Map.Entry<Long, byte[]>>(){

        @Override
        public Map.Entry<Long, byte[]> build(Object data2) {
            List list = (List)data2;
            return new KeyValue<Long, byte[]>(BuilderFactory.LONG.build(list.get(0)), BuilderFactory.BINARY.build(list.get(1)));
        }
    };

    public final void setProtocol(RedisProtocol proto) {
        this.protocol = proto;
    }

    protected RedisProtocol getProtocol() {
        return this.protocol;
    }

    @Experimental
    void setKeyArgumentPreProcessor(CommandKeyArgumentPreProcessor keyPreProcessor) {
        this.keyPreProcessor = keyPreProcessor;
    }

    void setBroadcastAndRoundRobinConfig(JedisBroadcastAndRoundRobinConfig config2) {
        this.broadcastAndRoundRobinConfig = config2;
    }

    protected CommandArguments commandArguments(ProtocolCommand command2) {
        CommandArguments comArgs = new CommandArguments(command2);
        if (this.keyPreProcessor != null) {
            comArgs.setKeyArgumentPreProcessor(this.keyPreProcessor);
        }
        return comArgs;
    }

    public final CommandObject<String> ping() {
        return this.PING_COMMAND_OBJECT;
    }

    public final CommandObject<String> flushAll() {
        return this.FLUSHALL_COMMAND_OBJECT;
    }

    public final CommandObject<String> flushDB() {
        return this.FLUSHDB_COMMAND_OBJECT;
    }

    public final CommandObject<String> configSet(String parameter, String value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.CONFIG).add(Protocol.Keyword.SET).add(parameter).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<Boolean> exists(String key2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.EXISTS).key(key2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> exists(String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXISTS).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> exists(byte[] key2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.EXISTS).key(key2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> exists(byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXISTS).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> persist(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PERSIST).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> persist(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PERSIST).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<String> type(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.TYPE).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<String> type(byte[] key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.TYPE).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> dump(String key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.DUMP).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> dump(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.DUMP).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<String> restore(String key2, long ttl, byte[] serializedValue) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RESTORE).key(key2).add(ttl).add(serializedValue), BuilderFactory.STRING);
    }

    public final CommandObject<String> restore(String key2, long ttl, byte[] serializedValue, RestoreParams params) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RESTORE).key(key2).add(ttl).add(serializedValue).addParams(params), BuilderFactory.STRING);
    }

    public final CommandObject<String> restore(byte[] key2, long ttl, byte[] serializedValue) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RESTORE).key(key2).add(ttl).add(serializedValue), BuilderFactory.STRING);
    }

    public final CommandObject<String> restore(byte[] key2, long ttl, byte[] serializedValue, RestoreParams params) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RESTORE).key(key2).add(ttl).add(serializedValue).addParams(params), BuilderFactory.STRING);
    }

    public final CommandObject<Long> expire(String key2, long seconds) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRE).key(key2).add(seconds), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expire(byte[] key2, long seconds) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRE).key(key2).add(seconds), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expire(String key2, long seconds, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRE).key(key2).add(seconds).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expire(byte[] key2, long seconds, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRE).key(key2).add(seconds).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpire(String key2, long milliseconds) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRE).key(key2).add(milliseconds), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpire(byte[] key2, long milliseconds) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRE).key(key2).add(milliseconds), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpire(String key2, long milliseconds, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRE).key(key2).add(milliseconds).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpire(byte[] key2, long milliseconds, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRE).key(key2).add(milliseconds).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireTime(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRETIME).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireTime(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRETIME).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireTime(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRETIME).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireTime(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRETIME).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireAt(String key2, long unixTime) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIREAT).key(key2).add(unixTime), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireAt(byte[] key2, long unixTime) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIREAT).key(key2).add(unixTime), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireAt(String key2, long unixTime, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIREAT).key(key2).add(unixTime).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireAt(byte[] key2, long unixTime, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIREAT).key(key2).add(unixTime).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireAt(String key2, long millisecondsTimestamp) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIREAT).key(key2).add(millisecondsTimestamp), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireAt(byte[] key2, long millisecondsTimestamp) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIREAT).key(key2).add(millisecondsTimestamp), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireAt(String key2, long millisecondsTimestamp, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIREAT).key(key2).add(millisecondsTimestamp).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireAt(byte[] key2, long millisecondsTimestamp, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIREAT).key(key2).add(millisecondsTimestamp).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> ttl(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TTL).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> ttl(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TTL).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pttl(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PTTL).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pttl(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PTTL).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> touch(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TOUCH).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> touch(String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TOUCH).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> touch(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TOUCH).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> touch(byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TOUCH).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> sort(String key2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.SORT).key(key2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> sort(String key2, SortingParams sortingParams) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.SORT).key(key2).addParams(sortingParams), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<byte[]>> sort(byte[] key2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.SORT).key(key2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> sort(byte[] key2, SortingParams sortingParams) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.SORT).key(key2).addParams(sortingParams), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> sort(String key2, String dstkey) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SORT).key(key2).add(Protocol.Keyword.STORE).key(dstkey), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sort(String key2, SortingParams sortingParams, String dstkey) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SORT).key(key2).addParams(sortingParams).add(Protocol.Keyword.STORE).key(dstkey), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sort(byte[] key2, byte[] dstkey) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SORT).key(key2).add(Protocol.Keyword.STORE).key(dstkey), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sort(byte[] key2, SortingParams sortingParams, byte[] dstkey) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SORT).key(key2).addParams(sortingParams).add(Protocol.Keyword.STORE).key(dstkey), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> sortReadonly(byte[] key2, SortingParams sortingParams) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.SORT_RO).key(key2).addParams(sortingParams), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<String>> sortReadonly(String key2, SortingParams sortingParams) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.SORT_RO).key(key2).addParams(sortingParams), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Long> del(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DEL).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> del(String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DEL).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> del(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DEL).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> del(byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DEL).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> unlink(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.UNLINK).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> unlink(String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.UNLINK).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> unlink(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.UNLINK).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> unlink(byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.UNLINK).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> copy(String srcKey, String dstKey, boolean replace) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.COPY).key(srcKey).key(dstKey);
        if (replace) {
            args2.add(Protocol.Keyword.REPLACE);
        }
        return new CommandObject<Boolean>(args2, BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> copy(byte[] srcKey, byte[] dstKey, boolean replace) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.COPY).key(srcKey).key(dstKey);
        if (replace) {
            args2.add(Protocol.Keyword.REPLACE);
        }
        return new CommandObject<Boolean>(args2, BuilderFactory.BOOLEAN);
    }

    public final CommandObject<String> rename(String oldkey, String newkey) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RENAME).key(oldkey).key(newkey), BuilderFactory.STRING);
    }

    public final CommandObject<Long> renamenx(String oldkey, String newkey) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RENAMENX).key(oldkey).key(newkey), BuilderFactory.LONG);
    }

    public final CommandObject<String> rename(byte[] oldkey, byte[] newkey) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RENAME).key(oldkey).key(newkey), BuilderFactory.STRING);
    }

    public final CommandObject<Long> renamenx(byte[] oldkey, byte[] newkey) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RENAMENX).key(oldkey).key(newkey), BuilderFactory.LONG);
    }

    public CommandObject<Long> dbSize() {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DBSIZE), BuilderFactory.LONG);
    }

    public CommandObject<Set<String>> keys(String pattern2) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.KEYS).key(pattern2);
        return new CommandObject<Set<String>>(args2, BuilderFactory.STRING_SET);
    }

    public CommandObject<Set<byte[]>> keys(byte[] pattern2) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.KEYS).key(pattern2);
        return new CommandObject<Set<byte[]>>(args2, BuilderFactory.BINARY_SET);
    }

    public CommandObject<ScanResult<String>> scan(String cursor) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(cursor), BuilderFactory.SCAN_RESPONSE);
    }

    public CommandObject<ScanResult<String>> scan(String cursor, ScanParams params) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(cursor).addParams(params), BuilderFactory.SCAN_RESPONSE);
    }

    public CommandObject<ScanResult<String>> scan(String cursor, ScanParams params, String type2) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(cursor).addParams(params).add(Protocol.Keyword.TYPE).add(type2), BuilderFactory.SCAN_RESPONSE);
    }

    public CommandObject<ScanResult<byte[]>> scan(byte[] cursor) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(cursor), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    public CommandObject<ScanResult<byte[]>> scan(byte[] cursor, ScanParams params) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(cursor).addParams(params), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    public CommandObject<ScanResult<byte[]>> scan(byte[] cursor, ScanParams params, byte[] type2) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(cursor).addParams(params).add(Protocol.Keyword.TYPE).add(type2), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    public final CommandObject<String> randomKey() {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RANDOMKEY), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> randomBinaryKey() {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.RANDOMKEY), BuilderFactory.BINARY);
    }

    public final CommandObject<String> set(String key2, String value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(key2).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<String> set(String key2, String value2, SetParams params) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(key2).add(value2).addParams(params), BuilderFactory.STRING);
    }

    public final CommandObject<String> set(byte[] key2, byte[] value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(key2).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<String> set(byte[] key2, byte[] value2, SetParams params) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(key2).add(value2).addParams(params), BuilderFactory.STRING);
    }

    public final CommandObject<String> get(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GET).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<String> setGet(String key2, String value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(key2).add(value2).add(Protocol.Keyword.GET), BuilderFactory.STRING);
    }

    public final CommandObject<String> setGet(String key2, String value2, SetParams params) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(key2).add(value2).addParams(params).add(Protocol.Keyword.GET), BuilderFactory.STRING);
    }

    public final CommandObject<String> getDel(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GETDEL).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<String> getEx(String key2, GetExParams params) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GETEX).key(key2).addParams(params), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> get(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GET).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> setGet(byte[] key2, byte[] value2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SET).key(key2).add(value2).add(Protocol.Keyword.GET), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> setGet(byte[] key2, byte[] value2, SetParams params) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SET).key(key2).add(value2).addParams(params).add(Protocol.Keyword.GET), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> getDel(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GETDEL).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> getEx(byte[] key2, GetExParams params) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GETEX).key(key2).addParams(params), BuilderFactory.BINARY);
    }

    @Deprecated
    public final CommandObject<String> getSet(String key2, String value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GETSET).key(key2).add(value2), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<byte[]> getSet(byte[] key2, byte[] value2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GETSET).key(key2).add(value2), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> setnx(String key2, String value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SETNX).key(key2).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<String> setex(String key2, long seconds, String value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SETEX).key(key2).add(seconds).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<String> psetex(String key2, long milliseconds, String value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.PSETEX).key(key2).add(milliseconds).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> setnx(byte[] key2, byte[] value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SETNX).key(key2).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<String> setex(byte[] key2, long seconds, byte[] value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SETEX).key(key2).add(seconds).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<String> psetex(byte[] key2, long milliseconds, byte[] value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.PSETEX).key(key2).add(milliseconds).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<Boolean> setbit(String key2, long offset, boolean value2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.SETBIT).key(key2).add(offset).add(value2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> setbit(byte[] key2, long offset, boolean value2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.SETBIT).key(key2).add(offset).add(value2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> getbit(String key2, long offset) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.GETBIT).key(key2).add(offset), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> getbit(byte[] key2, long offset) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.GETBIT).key(key2).add(offset), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> setrange(String key2, long offset, String value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SETRANGE).key(key2).add(offset).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> setrange(byte[] key2, long offset, byte[] value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SETRANGE).key(key2).add(offset).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<String> getrange(String key2, long startOffset, long endOffset) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GETRANGE).key(key2).add(startOffset).add(endOffset), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> getrange(byte[] key2, long startOffset, long endOffset) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GETRANGE).key(key2).add(startOffset).add(endOffset), BuilderFactory.BINARY);
    }

    public final CommandObject<List<String>> mget(String ... keys2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.MGET).keys(keys2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<byte[]>> mget(byte[] ... keys2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.MGET).keys((Object[])keys2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<String> mset(String ... keysvalues) {
        return new CommandObject<String>(this.addFlatKeyValueArgs(this.commandArguments(Protocol.Command.MSET), keysvalues), BuilderFactory.STRING);
    }

    public final CommandObject<Long> msetnx(String ... keysvalues) {
        return new CommandObject<Long>(this.addFlatKeyValueArgs(this.commandArguments(Protocol.Command.MSETNX), keysvalues), BuilderFactory.LONG);
    }

    public final CommandObject<String> mset(byte[] ... keysvalues) {
        return new CommandObject<String>(this.addFlatKeyValueArgs(this.commandArguments(Protocol.Command.MSET), keysvalues), BuilderFactory.STRING);
    }

    public final CommandObject<Long> msetnx(byte[] ... keysvalues) {
        return new CommandObject<Long>(this.addFlatKeyValueArgs(this.commandArguments(Protocol.Command.MSETNX), keysvalues), BuilderFactory.LONG);
    }

    public final CommandObject<Long> incr(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.INCR).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> incrBy(String key2, long increment) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.INCRBY).key(key2).add(increment), BuilderFactory.LONG);
    }

    public final CommandObject<Double> incrByFloat(String key2, double increment) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.INCRBYFLOAT).key(key2).add(increment), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> incr(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.INCR).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> incrBy(byte[] key2, long increment) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.INCRBY).key(key2).add(increment), BuilderFactory.LONG);
    }

    public final CommandObject<Double> incrByFloat(byte[] key2, double increment) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.INCRBYFLOAT).key(key2).add(increment), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> decr(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DECR).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> decrBy(String key2, long decrement) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DECRBY).key(key2).add(decrement), BuilderFactory.LONG);
    }

    public final CommandObject<Long> decr(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DECR).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> decrBy(byte[] key2, long decrement) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DECRBY).key(key2).add(decrement), BuilderFactory.LONG);
    }

    public final CommandObject<Long> append(String key2, String value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.APPEND).key(key2).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> append(byte[] key2, byte[] value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.APPEND).key(key2).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<String> substr(String key2, int start2, int end2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SUBSTR).key(key2).add(start2).add(end2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> substr(byte[] key2, int start2, int end2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SUBSTR).key(key2).add(start2).add(end2), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> strlen(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.STRLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> strlen(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.STRLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(String key2, long start2, long end2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(key2).add(start2).add(end2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(String key2, long start2, long end2, BitCountOption option) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(key2).add(start2).add(end2).add(option), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(byte[] key2, long start2, long end2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(key2).add(start2).add(end2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(byte[] key2, long start2, long end2, BitCountOption option) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(key2).add(start2).add(end2).add(option), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitpos(String key2, boolean value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITPOS).key(key2).add(value2 ? 1 : 0), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitpos(String key2, boolean value2, BitPosParams params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITPOS).key(key2).add(value2 ? 1 : 0).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitpos(byte[] key2, boolean value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITPOS).key(key2).add(value2 ? 1 : 0), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitpos(byte[] key2, boolean value2, BitPosParams params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITPOS).key(key2).add(value2 ? 1 : 0).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> bitfield(String key2, String ... arguments) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.BITFIELD).key(key2).addObjects(arguments), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> bitfieldReadonly(String key2, String ... arguments) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.BITFIELD_RO).key(key2).addObjects(arguments), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> bitfield(byte[] key2, byte[] ... arguments) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.BITFIELD).key(key2).addObjects((Object[])arguments), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> bitfieldReadonly(byte[] key2, byte[] ... arguments) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.BITFIELD_RO).key(key2).addObjects((Object[])arguments), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> bitop(BitOP op, String destKey, String ... srcKeys) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITOP).add(op).key(destKey).keys(srcKeys), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITOP).add(op).key(destKey).keys((Object[])srcKeys), BuilderFactory.LONG);
    }

    public final CommandObject<LCSMatchResult> lcs(String keyA, String keyB, LCSParams params) {
        return new CommandObject<LCSMatchResult>(this.commandArguments(Protocol.Command.LCS).key(keyA).key(keyB).addParams(params), BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER);
    }

    public final CommandObject<LCSMatchResult> lcs(byte[] keyA, byte[] keyB, LCSParams params) {
        return new CommandObject<LCSMatchResult>(this.commandArguments(Protocol.Command.LCS).key(keyA).key(keyB).addParams(params), BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER);
    }

    public final CommandObject<Long> rpush(String key2, String ... strings) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RPUSH).key(key2).addObjects(strings), BuilderFactory.LONG);
    }

    public final CommandObject<Long> rpush(byte[] key2, byte[] ... strings) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RPUSH).key(key2).addObjects((Object[])strings), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpush(String key2, String ... strings) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPUSH).key(key2).addObjects(strings), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpush(byte[] key2, byte[] ... strings) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPUSH).key(key2).addObjects((Object[])strings), BuilderFactory.LONG);
    }

    public final CommandObject<Long> llen(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> llen(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> lrange(String key2, long start2, long stop) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.LRANGE).key(key2).add(start2).add(stop), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<byte[]>> lrange(byte[] key2, long start2, long stop) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.LRANGE).key(key2).add(start2).add(stop), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<String> ltrim(String key2, long start2, long stop) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LTRIM).key(key2).add(start2).add(stop), BuilderFactory.STRING);
    }

    public final CommandObject<String> ltrim(byte[] key2, long start2, long stop) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LTRIM).key(key2).add(start2).add(stop), BuilderFactory.STRING);
    }

    public final CommandObject<String> lindex(String key2, long index) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LINDEX).key(key2).add(index), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> lindex(byte[] key2, long index) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.LINDEX).key(key2).add(index), BuilderFactory.BINARY);
    }

    public final CommandObject<String> lset(String key2, long index, String value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LSET).key(key2).add(index).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<String> lset(byte[] key2, long index, byte[] value2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LSET).key(key2).add(index).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> lrem(String key2, long count2, String value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LREM).key(key2).add(count2).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lrem(byte[] key2, long count2, byte[] value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LREM).key(key2).add(count2).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<String> lpop(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LPOP).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> lpop(String key2, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.LPOP).key(key2).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<byte[]> lpop(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.LPOP).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<List<byte[]>> lpop(byte[] key2, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.LPOP).key(key2).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<String> rpop(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RPOP).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> rpop(String key2, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.RPOP).key(key2).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<byte[]> rpop(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.RPOP).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<List<byte[]>> rpop(byte[] key2, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.RPOP).key(key2).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> lpos(String key2, String element) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPOS).key(key2).add(element), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpos(String key2, String element, LPosParams params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPOS).key(key2).add(element).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> lpos(String key2, String element, LPosParams params, long count2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.LPOS).key(key2).add(element).addParams(params).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> lpos(byte[] key2, byte[] element) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPOS).key(key2).add(element), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpos(byte[] key2, byte[] element, LPosParams params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPOS).key(key2).add(element).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> lpos(byte[] key2, byte[] element, LPosParams params, long count2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.LPOS).key(key2).add(element).addParams(params).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> linsert(String key2, ListPosition where, String pivot, String value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LINSERT).key(key2).add(where).add(pivot).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> linsert(byte[] key2, ListPosition where, byte[] pivot, byte[] value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LINSERT).key(key2).add(where).add(pivot).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpushx(String key2, String ... strings) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPUSHX).key(key2).addObjects(strings), BuilderFactory.LONG);
    }

    public final CommandObject<Long> rpushx(String key2, String ... strings) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RPUSHX).key(key2).addObjects(strings), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpushx(byte[] key2, byte[] ... args2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPUSHX).key(key2).addObjects((Object[])args2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> rpushx(byte[] key2, byte[] ... args2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RPUSHX).key(key2).addObjects((Object[])args2), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> blpop(int timeout2, String key2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.BLPOP).blocking().key(key2).add(timeout2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> blpop(int timeout2, String ... keys2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.BLPOP).blocking().keys(keys2).add(timeout2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<KeyValue<String, String>> blpop(double timeout2, String key2) {
        return new CommandObject<KeyValue<String, String>>(this.commandArguments(Protocol.Command.BLPOP).blocking().key(key2).add(timeout2), BuilderFactory.KEYED_ELEMENT);
    }

    public final CommandObject<KeyValue<String, String>> blpop(double timeout2, String ... keys2) {
        return new CommandObject<KeyValue<String, String>>(this.commandArguments(Protocol.Command.BLPOP).blocking().keys(keys2).add(timeout2), BuilderFactory.KEYED_ELEMENT);
    }

    public final CommandObject<List<byte[]>> blpop(int timeout2, byte[] ... keys2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.BLPOP).blocking().keys((Object[])keys2).add(timeout2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<KeyValue<byte[], byte[]>> blpop(double timeout2, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], byte[]>>(this.commandArguments(Protocol.Command.BLPOP).blocking().keys((Object[])keys2).add(timeout2), BuilderFactory.BINARY_KEYED_ELEMENT);
    }

    public final CommandObject<List<String>> brpop(int timeout2, String key2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.BRPOP).blocking().key(key2).add(timeout2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> brpop(int timeout2, String ... keys2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.BRPOP).blocking().keys(keys2).add(timeout2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<KeyValue<String, String>> brpop(double timeout2, String key2) {
        return new CommandObject<KeyValue<String, String>>(this.commandArguments(Protocol.Command.BRPOP).blocking().key(key2).add(timeout2), BuilderFactory.KEYED_ELEMENT);
    }

    public final CommandObject<KeyValue<String, String>> brpop(double timeout2, String ... keys2) {
        return new CommandObject<KeyValue<String, String>>(this.commandArguments(Protocol.Command.BRPOP).blocking().keys(keys2).add(timeout2), BuilderFactory.KEYED_ELEMENT);
    }

    public final CommandObject<List<byte[]>> brpop(int timeout2, byte[] ... keys2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.BRPOP).blocking().keys((Object[])keys2).add(timeout2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<KeyValue<byte[], byte[]>> brpop(double timeout2, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], byte[]>>(this.commandArguments(Protocol.Command.BRPOP).blocking().keys((Object[])keys2).add(timeout2), BuilderFactory.BINARY_KEYED_ELEMENT);
    }

    public final CommandObject<String> rpoplpush(String srckey, String dstkey) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RPOPLPUSH).key(srckey).key(dstkey), BuilderFactory.STRING);
    }

    public final CommandObject<String> brpoplpush(String source2, String destination, int timeout2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.BRPOPLPUSH).blocking().key(source2).key(destination).add(timeout2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> rpoplpush(byte[] srckey, byte[] dstkey) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.RPOPLPUSH).key(srckey).key(dstkey), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> brpoplpush(byte[] source2, byte[] destination, int timeout2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.BRPOPLPUSH).blocking().key(source2).key(destination).add(timeout2), BuilderFactory.BINARY);
    }

    public final CommandObject<String> lmove(String srcKey, String dstKey, ListDirection from2, ListDirection to) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LMOVE).key(srcKey).key(dstKey).add(from2).add(to), BuilderFactory.STRING);
    }

    public final CommandObject<String> blmove(String srcKey, String dstKey, ListDirection from2, ListDirection to, double timeout2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.BLMOVE).blocking().key(srcKey).key(dstKey).add(from2).add(to).add(timeout2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> lmove(byte[] srcKey, byte[] dstKey, ListDirection from2, ListDirection to) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.LMOVE).key(srcKey).key(dstKey).add(from2).add(to), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> blmove(byte[] srcKey, byte[] dstKey, ListDirection from2, ListDirection to, double timeout2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.BLMOVE).blocking().key(srcKey).key(dstKey).add(from2).add(to).add(timeout2), BuilderFactory.BINARY);
    }

    public final CommandObject<KeyValue<String, List<String>>> lmpop(ListDirection direction, String ... keys2) {
        return new CommandObject<KeyValue<String, List<String>>>(this.commandArguments(Protocol.Command.LMPOP).add(keys2.length).keys(keys2).add(direction), BuilderFactory.KEYED_STRING_LIST);
    }

    public final CommandObject<KeyValue<String, List<String>>> lmpop(ListDirection direction, int count2, String ... keys2) {
        return new CommandObject<KeyValue<String, List<String>>>(this.commandArguments(Protocol.Command.LMPOP).add(keys2.length).keys(keys2).add(direction).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.KEYED_STRING_LIST);
    }

    public final CommandObject<KeyValue<String, List<String>>> blmpop(double timeout2, ListDirection direction, String ... keys2) {
        return new CommandObject<KeyValue<String, List<String>>>(this.commandArguments(Protocol.Command.BLMPOP).blocking().add(timeout2).add(keys2.length).keys(keys2).add(direction), BuilderFactory.KEYED_STRING_LIST);
    }

    public final CommandObject<KeyValue<String, List<String>>> blmpop(double timeout2, ListDirection direction, int count2, String ... keys2) {
        return new CommandObject<KeyValue<String, List<String>>>(this.commandArguments(Protocol.Command.BLMPOP).blocking().add(timeout2).add(keys2.length).keys(keys2).add(direction).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.KEYED_STRING_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<byte[]>>> lmpop(ListDirection direction, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], List<byte[]>>>(this.commandArguments(Protocol.Command.LMPOP).add(keys2.length).keys((Object[])keys2).add(direction), BuilderFactory.KEYED_BINARY_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<byte[]>>> lmpop(ListDirection direction, int count2, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], List<byte[]>>>(this.commandArguments(Protocol.Command.LMPOP).add(keys2.length).keys((Object[])keys2).add(direction).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.KEYED_BINARY_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<byte[]>>> blmpop(double timeout2, ListDirection direction, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], List<byte[]>>>(this.commandArguments(Protocol.Command.BLMPOP).blocking().add(timeout2).add(keys2.length).keys((Object[])keys2).add(direction), BuilderFactory.KEYED_BINARY_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<byte[]>>> blmpop(double timeout2, ListDirection direction, int count2, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], List<byte[]>>>(this.commandArguments(Protocol.Command.BLMPOP).blocking().add(timeout2).add(keys2.length).keys((Object[])keys2).add(direction).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.KEYED_BINARY_LIST);
    }

    public final CommandObject<Long> hset(String key2, String field, String value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSET).key(key2).add(field).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hset(String key2, Map<String, String> hash) {
        return new CommandObject<Long>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HSET).key(key2), hash), BuilderFactory.LONG);
    }

    public final CommandObject<String> hget(String key2, String field) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.HGET).key(key2).add(field), BuilderFactory.STRING);
    }

    public final CommandObject<Long> hsetnx(String key2, String field, String value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSETNX).key(key2).add(field).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<String> hmset(String key2, Map<String, String> hash) {
        return new CommandObject<String>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HMSET).key(key2), hash), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> hmget(String key2, String ... fields2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.HMGET).key(key2).addObjects(fields2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Long> hset(byte[] key2, byte[] field, byte[] value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSET).key(key2).add(field).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hset(byte[] key2, Map<byte[], byte[]> hash) {
        return new CommandObject<Long>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HSET).key(key2), hash), BuilderFactory.LONG);
    }

    public final CommandObject<byte[]> hget(byte[] key2, byte[] field) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.HGET).key(key2).add(field), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> hsetnx(byte[] key2, byte[] field, byte[] value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSETNX).key(key2).add(field).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<String> hmset(byte[] key2, Map<byte[], byte[]> hash) {
        return new CommandObject<String>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HMSET).key(key2), hash), BuilderFactory.STRING);
    }

    public final CommandObject<List<byte[]>> hmget(byte[] key2, byte[] ... fields2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.HMGET).key(key2).addObjects((Object[])fields2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> hincrBy(String key2, String field, long value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HINCRBY).key(key2).add(field).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Double> hincrByFloat(String key2, String field, double value2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.HINCRBYFLOAT).key(key2).add(field).add(value2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Boolean> hexists(String key2, String field) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.HEXISTS).key(key2).add(field), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> hdel(String key2, String ... field) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HDEL).key(key2).addObjects(field), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hlen(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hincrBy(byte[] key2, byte[] field, long value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HINCRBY).key(key2).add(field).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Double> hincrByFloat(byte[] key2, byte[] field, double value2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.HINCRBYFLOAT).key(key2).add(field).add(value2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Boolean> hexists(byte[] key2, byte[] field) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.HEXISTS).key(key2).add(field), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> hdel(byte[] key2, byte[] ... field) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HDEL).key(key2).addObjects((Object[])field), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hlen(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> hkeys(String key2) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.HKEYS).key(key2), BuilderFactory.STRING_SET);
    }

    public final CommandObject<List<String>> hvals(String key2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.HVALS).key(key2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Set<byte[]>> hkeys(byte[] key2) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.HKEYS).key(key2), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<List<byte[]>> hvals(byte[] key2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.HVALS).key(key2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Map<String, String>> hgetAll(String key2) {
        return new CommandObject<Map<String, String>>(this.commandArguments(Protocol.Command.HGETALL).key(key2), BuilderFactory.STRING_MAP);
    }

    public final CommandObject<String> hrandfield(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.HRANDFIELD).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> hrandfield(String key2, long count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.HRANDFIELD).key(key2).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Map.Entry<String, String>>> hrandfieldWithValues(String key2, long count2) {
        return new CommandObject<List<Map.Entry<String, String>>>(this.commandArguments(Protocol.Command.HRANDFIELD).key(key2).add(count2).add(Protocol.Keyword.WITHVALUES), this.protocol != RedisProtocol.RESP3 ? BuilderFactory.STRING_PAIR_LIST : BuilderFactory.STRING_PAIR_LIST_FROM_PAIRS);
    }

    public final CommandObject<Map<byte[], byte[]>> hgetAll(byte[] key2) {
        return new CommandObject<Map<byte[], byte[]>>(this.commandArguments(Protocol.Command.HGETALL).key(key2), BuilderFactory.BINARY_MAP);
    }

    public final CommandObject<byte[]> hrandfield(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.HRANDFIELD).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<List<byte[]>> hrandfield(byte[] key2, long count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.HRANDFIELD).key(key2).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Map.Entry<byte[], byte[]>>> hrandfieldWithValues(byte[] key2, long count2) {
        return new CommandObject<List<Map.Entry<byte[], byte[]>>>(this.commandArguments(Protocol.Command.HRANDFIELD).key(key2).add(count2).add(Protocol.Keyword.WITHVALUES), this.protocol != RedisProtocol.RESP3 ? BuilderFactory.BINARY_PAIR_LIST : BuilderFactory.BINARY_PAIR_LIST_FROM_PAIRS);
    }

    public final CommandObject<ScanResult<Map.Entry<String, String>>> hscan(String key2, String cursor, ScanParams params) {
        return new CommandObject<ScanResult<Map.Entry<String, String>>>(this.commandArguments(Protocol.Command.HSCAN).key(key2).add(cursor).addParams(params), BuilderFactory.HSCAN_RESPONSE);
    }

    public final CommandObject<ScanResult<String>> hscanNoValues(String key2, String cursor, ScanParams params) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.HSCAN).key(key2).add(cursor).addParams(params).add(Protocol.Keyword.NOVALUES), BuilderFactory.SCAN_RESPONSE);
    }

    public final CommandObject<ScanResult<Map.Entry<byte[], byte[]>>> hscan(byte[] key2, byte[] cursor, ScanParams params) {
        return new CommandObject<ScanResult<Map.Entry<byte[], byte[]>>>(this.commandArguments(Protocol.Command.HSCAN).key(key2).add(cursor).addParams(params), BuilderFactory.HSCAN_BINARY_RESPONSE);
    }

    public final CommandObject<ScanResult<byte[]>> hscanNoValues(byte[] key2, byte[] cursor, ScanParams params) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.HSCAN).key(key2).add(cursor).addParams(params).add(Protocol.Keyword.NOVALUES), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    public final CommandObject<Long> hstrlen(String key2, String field) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSTRLEN).key(key2).add(field), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hstrlen(byte[] key2, byte[] field) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSTRLEN).key(key2).add(field), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> hexpire(String key2, long seconds, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIRE).key(key2).add(seconds).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpire(String key2, long seconds, ExpiryOption condition, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIRE).key(key2).add(seconds).add(condition).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpire(String key2, long milliseconds, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIRE).key(key2).add(milliseconds).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpire(String key2, long milliseconds, ExpiryOption condition, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIRE).key(key2).add(milliseconds).add(condition).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpireAt(String key2, long unixTimeSeconds, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIREAT).key(key2).add(unixTimeSeconds).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpireAt(String key2, long unixTimeSeconds, ExpiryOption condition, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIREAT).key(key2).add(unixTimeSeconds).add(condition).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpireAt(String key2, long unixTimeMillis, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIREAT).key(key2).add(unixTimeMillis).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpireAt(String key2, long unixTimeMillis, ExpiryOption condition, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIREAT).key(key2).add(unixTimeMillis).add(condition).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpire(byte[] key2, long seconds, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIRE).key(key2).add(seconds).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpire(byte[] key2, long seconds, ExpiryOption condition, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIRE).key(key2).add(seconds).add(condition).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpire(byte[] key2, long milliseconds, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIRE).key(key2).add(milliseconds).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpire(byte[] key2, long milliseconds, ExpiryOption condition, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIRE).key(key2).add(milliseconds).add(condition).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpireAt(byte[] key2, long unixTimeSeconds, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIREAT).key(key2).add(unixTimeSeconds).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpireAt(byte[] key2, long unixTimeSeconds, ExpiryOption condition, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIREAT).key(key2).add(unixTimeSeconds).add(condition).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpireAt(byte[] key2, long unixTimeMillis, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIREAT).key(key2).add(unixTimeMillis).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpireAt(byte[] key2, long unixTimeMillis, ExpiryOption condition, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIREAT).key(key2).add(unixTimeMillis).add(condition).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpireTime(String key2, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIRETIME).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpireTime(String key2, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIRETIME).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> httl(String key2, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HTTL).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpttl(String key2, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPTTL).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hexpireTime(byte[] key2, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HEXPIRETIME).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpexpireTime(byte[] key2, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPEXPIRETIME).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> httl(byte[] key2, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HTTL).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpttl(byte[] key2, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPTTL).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpersist(String key2, String ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPERSIST).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects(fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> hpersist(byte[] key2, byte[] ... fields2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.HPERSIST).key(key2).add(Protocol.Keyword.FIELDS).add(fields2.length).addObjects((Object[])fields2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> sadd(String key2, String ... members) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SADD).key(key2).addObjects(members), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sadd(byte[] key2, byte[] ... members) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SADD).key(key2).addObjects((Object[])members), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> smembers(String key2) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SMEMBERS).key(key2), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Set<byte[]>> smembers(byte[] key2) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SMEMBERS).key(key2), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> srem(String key2, String ... members) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SREM).key(key2).addObjects(members), BuilderFactory.LONG);
    }

    public final CommandObject<Long> srem(byte[] key2, byte[] ... members) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SREM).key(key2).addObjects((Object[])members), BuilderFactory.LONG);
    }

    public final CommandObject<String> spop(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SPOP).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> spop(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SPOP).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<Set<String>> spop(String key2, long count2) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SPOP).key(key2).add(count2), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Set<byte[]>> spop(byte[] key2, long count2) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SPOP).key(key2).add(count2), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> scard(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SCARD).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> scard(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SCARD).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> sismember(String key2, String member) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.SISMEMBER).key(key2).add(member), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> sismember(byte[] key2, byte[] member) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.SISMEMBER).key(key2).add(member), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> smismember(String key2, String ... members) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SMISMEMBER).key(key2).addObjects(members), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> smismember(byte[] key2, byte[] ... members) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SMISMEMBER).key(key2).addObjects((Object[])members), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<String> srandmember(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SRANDMEMBER).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> srandmember(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SRANDMEMBER).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<List<String>> srandmember(String key2, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.SRANDMEMBER).key(key2).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<byte[]>> srandmember(byte[] key2, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.SRANDMEMBER).key(key2).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<ScanResult<String>> sscan(String key2, String cursor, ScanParams params) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SSCAN).key(key2).add(cursor).addParams(params), BuilderFactory.SSCAN_RESPONSE);
    }

    public final CommandObject<ScanResult<byte[]>> sscan(byte[] key2, byte[] cursor, ScanParams params) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SSCAN).key(key2).add(cursor).addParams(params), BuilderFactory.SSCAN_BINARY_RESPONSE);
    }

    public final CommandObject<Set<String>> sdiff(String ... keys2) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SDIFF).keys(keys2), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Long> sdiffstore(String dstkey, String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SDIFFSTORE).key(dstkey).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> sdiff(byte[] ... keys2) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SDIFF).keys((Object[])keys2), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> sdiffstore(byte[] dstkey, byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SDIFFSTORE).key(dstkey).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> sinter(String ... keys2) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SINTER).keys(keys2), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Long> sinterstore(String dstkey, String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERSTORE).key(dstkey).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sintercard(String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERCARD).add(keys2.length).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sintercard(int limit, String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERCARD).add(keys2.length).keys(keys2).add(Protocol.Keyword.LIMIT).add(limit), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> sinter(byte[] ... keys2) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SINTER).keys((Object[])keys2), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> sinterstore(byte[] dstkey, byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERSTORE).key(dstkey).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sintercard(byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERCARD).add(keys2.length).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sintercard(int limit, byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERCARD).add(keys2.length).keys((Object[])keys2).add(Protocol.Keyword.LIMIT).add(limit), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> sunion(String ... keys2) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SUNION).keys(keys2), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Long> sunionstore(String dstkey, String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SUNIONSTORE).key(dstkey).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> sunion(byte[] ... keys2) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SUNION).keys((Object[])keys2), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> sunionstore(byte[] dstkey, byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SUNIONSTORE).key(dstkey).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> smove(String srckey, String dstkey, String member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SMOVE).key(srckey).key(dstkey).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SMOVE).key(srckey).key(dstkey).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(String key2, double score, String member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZADD).key(key2).add(score).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(String key2, double score, String member, ZAddParams params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZADD).key(key2).addParams(params).add(score).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(String key2, Map<String, Double> scoreMembers) {
        return new CommandObject<Long>(this.addSortedSetFlatMapArgs(this.commandArguments(Protocol.Command.ZADD).key(key2), scoreMembers), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(String key2, Map<String, Double> scoreMembers, ZAddParams params) {
        return new CommandObject<Long>(this.addSortedSetFlatMapArgs(this.commandArguments(Protocol.Command.ZADD).key(key2).addParams(params), scoreMembers), BuilderFactory.LONG);
    }

    public final CommandObject<Double> zaddIncr(String key2, double score, String member, ZAddParams params) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZADD).key(key2).add(Protocol.Keyword.INCR).addParams(params).add(score).add(member), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> zadd(byte[] key2, double score, byte[] member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZADD).key(key2).add(score).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(byte[] key2, double score, byte[] member, ZAddParams params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZADD).key(key2).addParams(params).add(score).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(byte[] key2, Map<byte[], Double> scoreMembers) {
        return new CommandObject<Long>(this.addSortedSetFlatMapArgs(this.commandArguments(Protocol.Command.ZADD).key(key2), scoreMembers), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(byte[] key2, Map<byte[], Double> scoreMembers, ZAddParams params) {
        return new CommandObject<Long>(this.addSortedSetFlatMapArgs(this.commandArguments(Protocol.Command.ZADD).key(key2).addParams(params), scoreMembers), BuilderFactory.LONG);
    }

    public final CommandObject<Double> zaddIncr(byte[] key2, double score, byte[] member, ZAddParams params) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZADD).key(key2).add(Protocol.Keyword.INCR).addParams(params).add(score).add(member), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> zincrby(String key2, double increment, String member) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZINCRBY).key(key2).add(increment).add(member), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> zincrby(String key2, double increment, String member, ZIncrByParams params) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZADD).key(key2).addParams(params).add(increment).add(member), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> zincrby(byte[] key2, double increment, byte[] member) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZINCRBY).key(key2).add(increment).add(member), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> zincrby(byte[] key2, double increment, byte[] member, ZIncrByParams params) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZADD).key(key2).addParams(params).add(increment).add(member), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> zrem(String key2, String ... members) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREM).key(key2).addObjects(members), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrem(byte[] key2, byte[] ... members) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREM).key(key2).addObjects((Object[])members), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrank(String key2, String member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZRANK).key(key2).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrevrank(String key2, String member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREVRANK).key(key2).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<KeyValue<Long, Double>> zrankWithScore(String key2, String member) {
        return new CommandObject<KeyValue<Long, Double>>(this.commandArguments(Protocol.Command.ZRANK).key(key2).add(member).add(Protocol.Keyword.WITHSCORE), BuilderFactory.ZRANK_WITHSCORE_PAIR);
    }

    public final CommandObject<KeyValue<Long, Double>> zrevrankWithScore(String key2, String member) {
        return new CommandObject<KeyValue<Long, Double>>(this.commandArguments(Protocol.Command.ZREVRANK).key(key2).add(member).add(Protocol.Keyword.WITHSCORE), BuilderFactory.ZRANK_WITHSCORE_PAIR);
    }

    public final CommandObject<Long> zrank(byte[] key2, byte[] member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZRANK).key(key2).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrevrank(byte[] key2, byte[] member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREVRANK).key(key2).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<KeyValue<Long, Double>> zrankWithScore(byte[] key2, byte[] member) {
        return new CommandObject<KeyValue<Long, Double>>(this.commandArguments(Protocol.Command.ZRANK).key(key2).add(member).add(Protocol.Keyword.WITHSCORE), BuilderFactory.ZRANK_WITHSCORE_PAIR);
    }

    public final CommandObject<KeyValue<Long, Double>> zrevrankWithScore(byte[] key2, byte[] member) {
        return new CommandObject<KeyValue<Long, Double>>(this.commandArguments(Protocol.Command.ZREVRANK).key(key2).add(member).add(Protocol.Keyword.WITHSCORE), BuilderFactory.ZRANK_WITHSCORE_PAIR);
    }

    public final CommandObject<String> zrandmember(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> zrandmember(String key2, long count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(key2).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zrandmemberWithScores(String key2, long count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(key2).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<byte[]> zrandmember(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<List<byte[]>> zrandmember(byte[] key2, long count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(key2).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zrandmemberWithScores(byte[] key2, long count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(key2).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<Long> zcard(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCARD).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Double> zscore(String key2, String member) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZSCORE).key(key2).add(member), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<Double>> zmscore(String key2, String ... members) {
        return new CommandObject<List<Double>>(this.commandArguments(Protocol.Command.ZMSCORE).key(key2).addObjects(members), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<Long> zcard(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCARD).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Double> zscore(byte[] key2, byte[] member) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZSCORE).key(key2).add(member), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<Double>> zmscore(byte[] key2, byte[] ... members) {
        return new CommandObject<List<Double>>(this.commandArguments(Protocol.Command.ZMSCORE).key(key2).addObjects((Object[])members), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<Tuple> zpopmax(String key2) {
        return new CommandObject<Tuple>(this.commandArguments(Protocol.Command.ZPOPMAX).key(key2), BuilderFactory.TUPLE);
    }

    public final CommandObject<List<Tuple>> zpopmax(String key2, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZPOPMAX).key(key2).add(count2), this.getTupleListBuilder());
    }

    public final CommandObject<Tuple> zpopmin(String key2) {
        return new CommandObject<Tuple>(this.commandArguments(Protocol.Command.ZPOPMIN).key(key2), BuilderFactory.TUPLE);
    }

    public final CommandObject<List<Tuple>> zpopmin(String key2, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZPOPMIN).key(key2).add(count2), this.getTupleListBuilder());
    }

    public final CommandObject<Tuple> zpopmax(byte[] key2) {
        return new CommandObject<Tuple>(this.commandArguments(Protocol.Command.ZPOPMAX).key(key2), BuilderFactory.TUPLE);
    }

    public final CommandObject<List<Tuple>> zpopmax(byte[] key2, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZPOPMAX).key(key2).add(count2), this.getTupleListBuilder());
    }

    public final CommandObject<Tuple> zpopmin(byte[] key2) {
        return new CommandObject<Tuple>(this.commandArguments(Protocol.Command.ZPOPMIN).key(key2), BuilderFactory.TUPLE);
    }

    public final CommandObject<List<Tuple>> zpopmin(byte[] key2, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZPOPMIN).key(key2).add(count2), this.getTupleListBuilder());
    }

    public final CommandObject<KeyValue<String, Tuple>> bzpopmax(double timeout2, String ... keys2) {
        return new CommandObject<KeyValue<String, Tuple>>(this.commandArguments(Protocol.Command.BZPOPMAX).blocking().keys(keys2).add(timeout2), BuilderFactory.KEYED_TUPLE);
    }

    public final CommandObject<KeyValue<String, Tuple>> bzpopmin(double timeout2, String ... keys2) {
        return new CommandObject<KeyValue<String, Tuple>>(this.commandArguments(Protocol.Command.BZPOPMIN).blocking().keys(keys2).add(timeout2), BuilderFactory.KEYED_TUPLE);
    }

    public final CommandObject<KeyValue<byte[], Tuple>> bzpopmax(double timeout2, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], Tuple>>(this.commandArguments(Protocol.Command.BZPOPMAX).blocking().keys((Object[])keys2).add(timeout2), BuilderFactory.BINARY_KEYED_TUPLE);
    }

    public final CommandObject<KeyValue<byte[], Tuple>> bzpopmin(double timeout2, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], Tuple>>(this.commandArguments(Protocol.Command.BZPOPMIN).blocking().keys((Object[])keys2).add(timeout2), BuilderFactory.BINARY_KEYED_TUPLE);
    }

    public final CommandObject<Long> zcount(String key2, double min2, double max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCOUNT).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zcount(String key2, String min2, String max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCOUNT).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zcount(byte[] key2, double min2, double max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCOUNT).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zcount(byte[] key2, byte[] min2, byte[] max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCOUNT).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> zrange(String key2, long start2, long stop) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGE).key(key2).add(start2).add(stop), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrange(String key2, long start2, long stop) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGE).key(key2).add(start2).add(stop), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeWithScores(String key2, long start2, long stop) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGE).key(key2).add(start2).add(stop).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeWithScores(String key2, long start2, long stop) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGE).key(key2).add(start2).add(stop).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<String>> zrange(String key2, ZRangeParams zRangeParams) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGE).key(key2).addParams(zRangeParams), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeWithScores(String key2, ZRangeParams zRangeParams) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGE).key(key2).addParams(zRangeParams).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<Long> zrangestore(String dest, String src, ZRangeParams zRangeParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZRANGESTORE).key(dest).add(src).addParams(zRangeParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> zrangeByScore(String key2, double min2, double max2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrangeByScore(String key2, String min2, String max2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByScore(String key2, double max2, double min2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByScore(String key2, String max2, String min2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrangeByScore(String key2, double min2, double max2, int offset, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrangeByScore(String key2, String min2, String max2, int offset, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByScore(String key2, double max2, double min2, int offset, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByScore(String key2, String max2, String min2, int offset, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(String key2, double min2, double max2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(String key2, String min2, String max2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(String key2, double max2, double min2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(String key2, String max2, String min2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(String key2, double min2, double max2, int offset, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(String key2, String min2, String max2, int offset, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(String key2, double max2, double min2, int offset, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(String key2, String max2, String min2, int offset, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<byte[]>> zrange(byte[] key2, long start2, long stop) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGE).key(key2).add(start2).add(stop), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrange(byte[] key2, long start2, long stop) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGE).key(key2).add(start2).add(stop), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeWithScores(byte[] key2, long start2, long stop) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGE).key(key2).add(start2).add(stop).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeWithScores(byte[] key2, long start2, long stop) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGE).key(key2).add(start2).add(stop).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<byte[]>> zrange(byte[] key2, ZRangeParams zRangeParams) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGE).key(key2).addParams(zRangeParams), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeWithScores(byte[] key2, ZRangeParams zRangeParams) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGE).key(key2).addParams(zRangeParams).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<Long> zrangestore(byte[] dest, byte[] src, ZRangeParams zRangeParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZRANGESTORE).key(dest).add(src).addParams(zRangeParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> zrangeByScore(byte[] key2, double min2, double max2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrangeByScore(byte[] key2, byte[] min2, byte[] max2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByScore(byte[] key2, double max2, double min2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByScore(byte[] key2, byte[] max2, byte[] min2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrangeByScore(byte[] key2, double min2, double max2, int offset, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrangeByScore(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByScore(byte[] key2, double max2, double min2, int offset, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByScore(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(byte[] key2, double min2, double max2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(byte[] key2, byte[] min2, byte[] max2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(byte[] key2, double max2, double min2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(byte[] key2, byte[] max2, byte[] min2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(byte[] key2, double min2, double max2, int offset, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(byte[] key2, double max2, double min2, int offset, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<Long> zremrangeByRank(String key2, long start2, long stop) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYRANK).key(key2).add(start2).add(stop), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByScore(String key2, double min2, double max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYSCORE).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByScore(String key2, String min2, String max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYSCORE).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByRank(byte[] key2, long start2, long stop) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYRANK).key(key2).add(start2).add(stop), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByScore(byte[] key2, double min2, double max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYSCORE).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByScore(byte[] key2, byte[] min2, byte[] max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYSCORE).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zlexcount(String key2, String min2, String max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZLEXCOUNT).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> zrangeByLex(String key2, String min2, String max2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYLEX).key(key2).add(min2).add(max2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrangeByLex(String key2, String min2, String max2, int offset, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYLEX).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByLex(String key2, String max2, String min2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYLEX).key(key2).add(max2).add(min2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByLex(String key2, String max2, String min2, int offset, int count2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYLEX).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Long> zremrangeByLex(String key2, String min2, String max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYLEX).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zlexcount(byte[] key2, byte[] min2, byte[] max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZLEXCOUNT).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> zrangeByLex(byte[] key2, byte[] min2, byte[] max2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYLEX).key(key2).add(min2).add(max2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrangeByLex(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYLEX).key(key2).add(min2).add(max2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByLex(byte[] key2, byte[] max2, byte[] min2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYLEX).key(key2).add(max2).add(min2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByLex(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYLEX).key(key2).add(max2).add(min2).add(Protocol.Keyword.LIMIT).add(offset).add(count2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> zremrangeByLex(byte[] key2, byte[] min2, byte[] max2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYLEX).key(key2).add(min2).add(max2), BuilderFactory.LONG);
    }

    public final CommandObject<ScanResult<Tuple>> zscan(String key2, String cursor, ScanParams params) {
        return new CommandObject<ScanResult<Tuple>>(this.commandArguments(Protocol.Command.ZSCAN).key(key2).add(cursor).addParams(params), BuilderFactory.ZSCAN_RESPONSE);
    }

    public final CommandObject<ScanResult<Tuple>> zscan(byte[] key2, byte[] cursor, ScanParams params) {
        return new CommandObject<ScanResult<Tuple>>(this.commandArguments(Protocol.Command.ZSCAN).key(key2).add(cursor).addParams(params), BuilderFactory.ZSCAN_RESPONSE);
    }

    public final CommandObject<List<String>> zdiff(String ... keys2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZDIFF).add(keys2.length).keys(keys2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zdiffWithScores(String ... keys2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZDIFF).add(keys2.length).keys(keys2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    @Deprecated
    public final CommandObject<Long> zdiffStore(String dstkey, String ... keys2) {
        return this.zdiffstore(dstkey, keys2);
    }

    public final CommandObject<Long> zdiffstore(String dstkey, String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZDIFFSTORE).key(dstkey).add(keys2.length).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> zdiff(byte[] ... keys2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZDIFF).add(keys2.length).keys((Object[])keys2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zdiffWithScores(byte[] ... keys2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZDIFF).add(keys2.length).keys((Object[])keys2).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    @Deprecated
    public final CommandObject<Long> zdiffStore(byte[] dstkey, byte[] ... keys2) {
        return this.zdiffstore(dstkey, keys2);
    }

    public final CommandObject<Long> zdiffstore(byte[] dstkey, byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZDIFFSTORE).key(dstkey).add(keys2.length).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> zinter(ZParams params, String ... keys2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZINTER).add(keys2.length).keys(keys2).addParams(params), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zinterWithScores(ZParams params, String ... keys2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZINTER).add(keys2.length).keys(keys2).addParams(params).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<Long> zinterstore(String dstkey, String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERSTORE).key(dstkey).add(keys2.length).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zinterstore(String dstkey, ZParams params, String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERSTORE).key(dstkey).add(keys2.length).keys(keys2).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zintercard(String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERCARD).add(keys2.length).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zintercard(long limit, String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERCARD).add(keys2.length).keys(keys2).add(Protocol.Keyword.LIMIT).add(limit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zinterstore(byte[] dstkey, byte[] ... sets) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERSTORE).key(dstkey).add(sets.length).keys((Object[])sets), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERSTORE).key(dstkey).add(sets.length).keys((Object[])sets).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zintercard(byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERCARD).add(keys2.length).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zintercard(long limit, byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERCARD).add(keys2.length).keys((Object[])keys2).add(Protocol.Keyword.LIMIT).add(limit), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> zinter(ZParams params, byte[] ... keys2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZINTER).add(keys2.length).keys((Object[])keys2).addParams(params), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zinterWithScores(ZParams params, byte[] ... keys2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZINTER).add(keys2.length).keys((Object[])keys2).addParams(params).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<Long> zunionstore(String dstkey, String ... sets) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZUNIONSTORE).key(dstkey).add(sets.length).keys(sets), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zunionstore(String dstkey, ZParams params, String ... sets) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZUNIONSTORE).key(dstkey).add(sets.length).keys(sets).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> zunion(ZParams params, String ... keys2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZUNION).add(keys2.length).keys(keys2).addParams(params), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zunionWithScores(ZParams params, String ... keys2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZUNION).add(keys2.length).keys(keys2).addParams(params).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<Long> zunionstore(byte[] dstkey, byte[] ... sets) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZUNIONSTORE).key(dstkey).add(sets.length).keys((Object[])sets), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZUNIONSTORE).key(dstkey).add(sets.length).keys((Object[])sets).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> zunion(ZParams params, byte[] ... keys2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZUNION).add(keys2.length).keys((Object[])keys2).addParams(params), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zunionWithScores(ZParams params, byte[] ... keys2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZUNION).add(keys2.length).keys((Object[])keys2).addParams(params).add(Protocol.Keyword.WITHSCORES), this.getTupleListBuilder());
    }

    public final CommandObject<KeyValue<String, List<Tuple>>> zmpop(SortedSetOption option, String ... keys2) {
        return new CommandObject<KeyValue<String, List<Tuple>>>(this.commandArguments(Protocol.Command.ZMPOP).add(keys2.length).keys(keys2).add(option), BuilderFactory.KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<String, List<Tuple>>> zmpop(SortedSetOption option, int count2, String ... keys2) {
        return new CommandObject<KeyValue<String, List<Tuple>>>(this.commandArguments(Protocol.Command.ZMPOP).add(keys2.length).keys(keys2).add(option).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<String, List<Tuple>>> bzmpop(double timeout2, SortedSetOption option, String ... keys2) {
        return new CommandObject<KeyValue<String, List<Tuple>>>(this.commandArguments(Protocol.Command.BZMPOP).blocking().add(timeout2).add(keys2.length).keys(keys2).add(option), BuilderFactory.KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<String, List<Tuple>>> bzmpop(double timeout2, SortedSetOption option, int count2, String ... keys2) {
        return new CommandObject<KeyValue<String, List<Tuple>>>(this.commandArguments(Protocol.Command.BZMPOP).blocking().add(timeout2).add(keys2.length).keys(keys2).add(option).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<Tuple>>> zmpop(SortedSetOption option, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], List<Tuple>>>(this.commandArguments(Protocol.Command.ZMPOP).add(keys2.length).keys((Object[])keys2).add(option), BuilderFactory.BINARY_KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<Tuple>>> zmpop(SortedSetOption option, int count2, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], List<Tuple>>>(this.commandArguments(Protocol.Command.ZMPOP).add(keys2.length).keys((Object[])keys2).add(option).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.BINARY_KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<Tuple>>> bzmpop(double timeout2, SortedSetOption option, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], List<Tuple>>>(this.commandArguments(Protocol.Command.BZMPOP).blocking().add(timeout2).add(keys2.length).keys((Object[])keys2).add(option), BuilderFactory.BINARY_KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<Tuple>>> bzmpop(double timeout2, SortedSetOption option, int count2, byte[] ... keys2) {
        return new CommandObject<KeyValue<byte[], List<Tuple>>>(this.commandArguments(Protocol.Command.BZMPOP).blocking().add(timeout2).add(keys2.length).keys((Object[])keys2).add(option).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.BINARY_KEYED_TUPLE_LIST);
    }

    private Builder<List<Tuple>> getTupleListBuilder() {
        return this.protocol == RedisProtocol.RESP3 ? BuilderFactory.TUPLE_LIST_RESP3 : BuilderFactory.TUPLE_LIST;
    }

    public final CommandObject<Long> geoadd(String key2, double longitude, double latitude, String member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOADD).key(key2).add(longitude).add(latitude).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geoadd(String key2, Map<String, GeoCoordinate> memberCoordinateMap) {
        return new CommandObject<Long>(this.addGeoCoordinateFlatMapArgs(this.commandArguments(Protocol.Command.GEOADD).key(key2), memberCoordinateMap), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geoadd(String key2, GeoAddParams params, Map<String, GeoCoordinate> memberCoordinateMap) {
        return new CommandObject<Long>(this.addGeoCoordinateFlatMapArgs(this.commandArguments(Protocol.Command.GEOADD).key(key2).addParams(params), memberCoordinateMap), BuilderFactory.LONG);
    }

    public final CommandObject<Double> geodist(String key2, String member1, String member2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.GEODIST).key(key2).add(member1).add(member2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> geodist(String key2, String member1, String member2, GeoUnit unit) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.GEODIST).key(key2).add(member1).add(member2).add(unit), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<String>> geohash(String key2, String ... members) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.GEOHASH).key(key2).addObjects(members), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<GeoCoordinate>> geopos(String key2, String ... members) {
        return new CommandObject<List<GeoCoordinate>>(this.commandArguments(Protocol.Command.GEOPOS).key(key2).addObjects(members), BuilderFactory.GEO_COORDINATE_LIST);
    }

    public final CommandObject<Long> geoadd(byte[] key2, double longitude, double latitude, byte[] member) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOADD).key(key2).add(longitude).add(latitude).add(member), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geoadd(byte[] key2, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return new CommandObject<Long>(this.addGeoCoordinateFlatMapArgs(this.commandArguments(Protocol.Command.GEOADD).key(key2), memberCoordinateMap), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geoadd(byte[] key2, GeoAddParams params, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return new CommandObject<Long>(this.addGeoCoordinateFlatMapArgs(this.commandArguments(Protocol.Command.GEOADD).key(key2).addParams(params), memberCoordinateMap), BuilderFactory.LONG);
    }

    public final CommandObject<Double> geodist(byte[] key2, byte[] member1, byte[] member2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.GEODIST).key(key2).add(member1).add(member2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> geodist(byte[] key2, byte[] member1, byte[] member2, GeoUnit unit) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.GEODIST).key(key2).add(member1).add(member2).add(unit), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<byte[]>> geohash(byte[] key2, byte[] ... members) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.GEOHASH).key(key2).addObjects((Object[])members), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<GeoCoordinate>> geopos(byte[] key2, byte[] ... members) {
        return new CommandObject<List<GeoCoordinate>>(this.commandArguments(Protocol.Command.GEOPOS).key(key2).addObjects((Object[])members), BuilderFactory.GEO_COORDINATE_LIST);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadius(String key2, double longitude, double latitude, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS).key(key2).add(longitude).add(latitude).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadius(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS).key(key2).add(longitude).add(latitude).add(radius).add(unit).addParams(param), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusReadonly(String key2, double longitude, double latitude, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS_RO).key(key2).add(longitude).add(latitude).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusReadonly(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS_RO).key(key2).add(longitude).add(latitude).add(radius).add(unit).addParams(param), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> georadiusStore(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEORADIUS).key(key2).add(longitude).add(latitude).add(radius).add(unit).addParams(param).addParams(storeParam), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMember(String key2, String member, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(key2).add(member).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMember(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(key2).add(member).add(radius).add(unit).addParams(param), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMemberReadonly(String key2, String member, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER_RO).key(key2).add(member).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMemberReadonly(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER_RO).key(key2).add(member).add(radius).add(unit).addParams(param), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> georadiusByMemberStore(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(key2).add(member).add(radius).add(unit).addParams(param).addParams(storeParam), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadius(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS).key(key2).add(longitude).add(latitude).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadius(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS).key(key2).add(longitude).add(latitude).add(radius).add(unit).addParams(param), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusReadonly(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS_RO).key(key2).add(longitude).add(latitude).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusReadonly(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS_RO).key(key2).add(longitude).add(latitude).add(radius).add(unit).addParams(param), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> georadiusStore(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEORADIUS).key(key2).add(longitude).add(latitude).add(radius).add(unit).addParams(param).addParams(storeParam), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMember(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(key2).add(member).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMember(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(key2).add(member).add(radius).add(unit).addParams(param), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER_RO).key(key2).add(member).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER_RO).key(key2).add(member).add(radius).add(unit).addParams(param), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> georadiusByMemberStore(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(key2).add(member).add(radius).add(unit).addParams(param).addParams(storeParam), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String key2, String member, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).add(Protocol.Keyword.FROMMEMBER).add(member).add(Protocol.Keyword.BYRADIUS).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String key2, GeoCoordinate coord, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).add(Protocol.Keyword.FROMLONLAT).add(coord.getLongitude()).add(coord.getLatitude()).add(Protocol.Keyword.BYRADIUS).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String key2, String member, double width, double height, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).add(Protocol.Keyword.FROMMEMBER).add(member).add(Protocol.Keyword.BYBOX).add(width).add(height).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String key2, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).add(Protocol.Keyword.FROMLONLAT).add(coord.getLongitude()).add(coord.getLatitude()).add(Protocol.Keyword.BYBOX).add(width).add(height).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String key2, GeoSearchParam params) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).addParams(params), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> geosearchStore(String dest, String src, String member, double radius, GeoUnit unit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).add(Protocol.Keyword.FROMMEMBER).add(member).add(Protocol.Keyword.BYRADIUS).add(radius).add(unit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(String dest, String src, GeoCoordinate coord, double radius, GeoUnit unit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).add(Protocol.Keyword.FROMLONLAT).add(coord.getLongitude()).add(coord.getLatitude()).add(Protocol.Keyword.BYRADIUS).add(radius).add(unit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(String dest, String src, String member, double width, double height, GeoUnit unit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).add(Protocol.Keyword.FROMMEMBER).add(member).add(Protocol.Keyword.BYBOX).add(width).add(height).add(unit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(String dest, String src, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).add(Protocol.Keyword.FROMLONLAT).add(coord.getLongitude()).add(coord.getLatitude()).add(Protocol.Keyword.BYBOX).add(width).add(height).add(unit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(String dest, String src, GeoSearchParam params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStoreStoreDist(String dest, String src, GeoSearchParam params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).addParams(params).add(Protocol.Keyword.STOREDIST), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).add(Protocol.Keyword.FROMMEMBER).add(member).add(Protocol.Keyword.BYRADIUS).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] key2, GeoCoordinate coord, double radius, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).add(Protocol.Keyword.FROMLONLAT).add(coord.getLongitude()).add(coord.getLatitude()).add(Protocol.Keyword.BYRADIUS).add(radius).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] key2, byte[] member, double width, double height, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).add(Protocol.Keyword.FROMMEMBER).add(member).add(Protocol.Keyword.BYBOX).add(width).add(height).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] key2, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).add(Protocol.Keyword.FROMLONLAT).add(coord.getLongitude()).add(coord.getLatitude()).add(Protocol.Keyword.BYBOX).add(width).add(height).add(unit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] key2, GeoSearchParam params) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(key2).addParams(params), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> geosearchStore(byte[] dest, byte[] src, byte[] member, double radius, GeoUnit unit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).add(Protocol.Keyword.FROMMEMBER).add(member).add(Protocol.Keyword.BYRADIUS).add(radius).add(unit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(byte[] dest, byte[] src, GeoCoordinate coord, double radius, GeoUnit unit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).add(Protocol.Keyword.FROMLONLAT).add(coord.getLongitude()).add(coord.getLatitude()).add(Protocol.Keyword.BYRADIUS).add(radius).add(unit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(byte[] dest, byte[] src, byte[] member, double width, double height, GeoUnit unit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).add(Protocol.Keyword.FROMMEMBER).add(member).add(Protocol.Keyword.BYBOX).add(width).add(height).add(unit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(byte[] dest, byte[] src, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).add(Protocol.Keyword.FROMLONLAT).add(coord.getLongitude()).add(coord.getLatitude()).add(Protocol.Keyword.BYBOX).add(width).add(height).add(unit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(byte[] dest, byte[] src, GeoSearchParam params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStoreStoreDist(byte[] dest, byte[] src, GeoSearchParam params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(dest).add(src).addParams(params).add(Protocol.Keyword.STOREDIST), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pfadd(String key2, String ... elements) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFADD).key(key2).addObjects(elements), BuilderFactory.LONG);
    }

    public final CommandObject<String> pfmerge(String destkey, String ... sourcekeys) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.PFMERGE).key(destkey).keys(sourcekeys), BuilderFactory.STRING);
    }

    public final CommandObject<Long> pfadd(byte[] key2, byte[] ... elements) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFADD).key(key2).addObjects((Object[])elements), BuilderFactory.LONG);
    }

    public final CommandObject<String> pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.PFMERGE).key(destkey).keys((Object[])sourcekeys), BuilderFactory.STRING);
    }

    public final CommandObject<Long> pfcount(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFCOUNT).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pfcount(String ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFCOUNT).keys(keys2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pfcount(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFCOUNT).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pfcount(byte[] ... keys2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFCOUNT).keys((Object[])keys2), BuilderFactory.LONG);
    }

    public final CommandObject<StreamEntryID> xadd(String key2, StreamEntryID id, Map<String, String> hash) {
        return new CommandObject<StreamEntryID>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.XADD).key(key2).add(id == null ? StreamEntryID.NEW_ENTRY : id), hash), BuilderFactory.STREAM_ENTRY_ID);
    }

    public final CommandObject<StreamEntryID> xadd(String key2, XAddParams params, Map<String, String> hash) {
        return new CommandObject<StreamEntryID>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.XADD).key(key2).addParams(params), hash), BuilderFactory.STREAM_ENTRY_ID);
    }

    public final CommandObject<Long> xlen(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<byte[]> xadd(byte[] key2, XAddParams params, Map<byte[], byte[]> hash) {
        return new CommandObject<byte[]>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.XADD).key(key2).addParams(params), hash), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> xlen(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<List<StreamEntry>> xrange(String key2, StreamEntryID start2, StreamEntryID end2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XRANGE).key(key2).add(start2 == null ? "-" : start2).add(end2 == null ? "+" : end2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrange(String key2, StreamEntryID start2, StreamEntryID end2, int count2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XRANGE).key(key2).add(start2 == null ? "-" : start2).add(end2 == null ? "+" : end2).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrevrange(String key2, StreamEntryID end2, StreamEntryID start2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XREVRANGE).key(key2).add(end2 == null ? "+" : end2).add(start2 == null ? "-" : start2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrevrange(String key2, StreamEntryID end2, StreamEntryID start2, int count2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XREVRANGE).key(key2).add(end2 == null ? "+" : end2).add(start2 == null ? "-" : start2).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrange(String key2, String start2, String end2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XRANGE).key(key2).add(start2).add(end2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrange(String key2, String start2, String end2, int count2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XRANGE).key(key2).add(start2).add(end2).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrevrange(String key2, String end2, String start2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XREVRANGE).key(key2).add(end2).add(start2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrevrange(String key2, String end2, String start2, int count2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XREVRANGE).key(key2).add(end2).add(start2).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<Object>> xrange(byte[] key2, byte[] start2, byte[] end2) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XRANGE).key(key2).add(start2 == null ? "-" : (Object)start2).add(end2 == null ? "+" : (Object)end2), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> xrange(byte[] key2, byte[] start2, byte[] end2, int count2) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XRANGE).key(key2).add(start2 == null ? "-" : (Object)start2).add(end2 == null ? "+" : (Object)end2).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> xrevrange(byte[] key2, byte[] end2, byte[] start2) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XREVRANGE).key(key2).add(end2 == null ? "+" : (Object)end2).add(start2 == null ? "-" : (Object)start2), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> xrevrange(byte[] key2, byte[] end2, byte[] start2, int count2) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XREVRANGE).key(key2).add(end2 == null ? "+" : (Object)end2).add(start2 == null ? "-" : (Object)start2).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<Long> xack(String key2, String group, StreamEntryID ... ids) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XACK).key(key2).add(group).addObjects(ids), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xack(byte[] key2, byte[] group, byte[] ... ids) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XACK).key(key2).add(group).addObjects((Object[])ids), BuilderFactory.LONG);
    }

    public final CommandObject<String> xgroupCreate(String key2, String groupName, StreamEntryID id, boolean makeStream) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.CREATE).key(key2).add(groupName).add(id == null ? "0-0" : id);
        if (makeStream) {
            args2.add(Protocol.Keyword.MKSTREAM);
        }
        return new CommandObject<String>(args2, BuilderFactory.STRING);
    }

    public final CommandObject<String> xgroupSetID(String key2, String groupName, StreamEntryID id) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.SETID).key(key2).add(groupName).add(id), BuilderFactory.STRING);
    }

    public final CommandObject<Long> xgroupDestroy(String key2, String groupName) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.DESTROY).key(key2).add(groupName), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> xgroupCreateConsumer(String key2, String groupName, String consumerName) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.CREATECONSUMER).key(key2).add(groupName).add(consumerName), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> xgroupDelConsumer(String key2, String groupName, String consumerName) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.DELCONSUMER).key(key2).add(groupName).add(consumerName), BuilderFactory.LONG);
    }

    public final CommandObject<String> xgroupCreate(byte[] key2, byte[] groupName, byte[] id, boolean makeStream) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.CREATE).key(key2).add(groupName).add(id);
        if (makeStream) {
            args2.add(Protocol.Keyword.MKSTREAM);
        }
        return new CommandObject<String>(args2, BuilderFactory.STRING);
    }

    public final CommandObject<String> xgroupSetID(byte[] key2, byte[] groupName, byte[] id) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.SETID).key(key2).add(groupName).add(id), BuilderFactory.STRING);
    }

    public final CommandObject<Long> xgroupDestroy(byte[] key2, byte[] groupName) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.DESTROY).key(key2).add(groupName), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> xgroupCreateConsumer(byte[] key2, byte[] groupName, byte[] consumerName) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.CREATECONSUMER).key(key2).add(groupName).add(consumerName), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> xgroupDelConsumer(byte[] key2, byte[] groupName, byte[] consumerName) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.DELCONSUMER).key(key2).add(groupName).add(consumerName), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xdel(String key2, StreamEntryID ... ids) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XDEL).key(key2).addObjects(ids), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xtrim(String key2, long maxLen, boolean approximate) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XTRIM).key(key2).add(Protocol.Keyword.MAXLEN);
        if (approximate) {
            args2.add(Protocol.BYTES_TILDE);
        }
        args2.add(maxLen);
        return new CommandObject<Long>(args2, BuilderFactory.LONG);
    }

    public final CommandObject<Long> xtrim(String key2, XTrimParams params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XTRIM).key(key2).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xdel(byte[] key2, byte[] ... ids) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XDEL).key(key2).addObjects((Object[])ids), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xtrim(byte[] key2, long maxLen, boolean approximateLength) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XTRIM).key(key2).add(Protocol.Keyword.MAXLEN);
        if (approximateLength) {
            args2.add(Protocol.BYTES_TILDE);
        }
        args2.add(maxLen);
        return new CommandObject<Long>(args2, BuilderFactory.LONG);
    }

    public final CommandObject<Long> xtrim(byte[] key2, XTrimParams params) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XTRIM).key(key2).addParams(params), BuilderFactory.LONG);
    }

    public final CommandObject<StreamPendingSummary> xpending(String key2, String groupName) {
        return new CommandObject<StreamPendingSummary>(this.commandArguments(Protocol.Command.XPENDING).key(key2).add(groupName), BuilderFactory.STREAM_PENDING_SUMMARY);
    }

    public final CommandObject<List<StreamPendingEntry>> xpending(String key2, String groupName, XPendingParams params) {
        return new CommandObject<List<StreamPendingEntry>>(this.commandArguments(Protocol.Command.XPENDING).key(key2).add(groupName).addParams(params), BuilderFactory.STREAM_PENDING_ENTRY_LIST);
    }

    public final CommandObject<Object> xpending(byte[] key2, byte[] groupName) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.XPENDING).key(key2).add(groupName), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<List<Object>> xpending(byte[] key2, byte[] groupName, XPendingParams params) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XPENDING).key(key2).add(groupName).addParams(params), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<StreamEntry>> xclaim(String key2, String group, String consumerName, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XCLAIM).key(key2).add(group).add(consumerName).add(minIdleTime).addObjects(ids).addParams(params), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntryID>> xclaimJustId(String key2, String group, String consumerName, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        return new CommandObject<List<StreamEntryID>>(this.commandArguments(Protocol.Command.XCLAIM).key(key2).add(group).add(consumerName).add(minIdleTime).addObjects(ids).addParams(params).add(Protocol.Keyword.JUSTID), BuilderFactory.STREAM_ENTRY_ID_LIST);
    }

    public final CommandObject<Map.Entry<StreamEntryID, List<StreamEntry>>> xautoclaim(String key2, String group, String consumerName, long minIdleTime, StreamEntryID start2, XAutoClaimParams params) {
        return new CommandObject<Map.Entry<StreamEntryID, List<StreamEntry>>>(this.commandArguments(Protocol.Command.XAUTOCLAIM).key(key2).add(group).add(consumerName).add(minIdleTime).add(start2).addParams(params), BuilderFactory.STREAM_AUTO_CLAIM_RESPONSE);
    }

    public final CommandObject<Map.Entry<StreamEntryID, List<StreamEntryID>>> xautoclaimJustId(String key2, String group, String consumerName, long minIdleTime, StreamEntryID start2, XAutoClaimParams params) {
        return new CommandObject<Map.Entry<StreamEntryID, List<StreamEntryID>>>(this.commandArguments(Protocol.Command.XAUTOCLAIM).key(key2).add(group).add(consumerName).add(minIdleTime).add(start2).addParams(params).add(Protocol.Keyword.JUSTID), BuilderFactory.STREAM_AUTO_CLAIM_JUSTID_RESPONSE);
    }

    public final CommandObject<List<byte[]>> xclaim(byte[] key2, byte[] group, byte[] consumerName, long minIdleTime, XClaimParams params, byte[] ... ids) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.XCLAIM).key(key2).add(group).add(consumerName).add(minIdleTime).addObjects((Object[])ids).addParams(params), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> xclaimJustId(byte[] key2, byte[] group, byte[] consumerName, long minIdleTime, XClaimParams params, byte[] ... ids) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.XCLAIM).key(key2).add(group).add(consumerName).add(minIdleTime).addObjects((Object[])ids).addParams(params).add(Protocol.Keyword.JUSTID), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Object>> xautoclaim(byte[] key2, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start2, XAutoClaimParams params) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XAUTOCLAIM).key(key2).add(groupName).add(consumerName).add(minIdleTime).add(start2).addParams(params), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> xautoclaimJustId(byte[] key2, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start2, XAutoClaimParams params) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XAUTOCLAIM).key(key2).add(groupName).add(consumerName).add(minIdleTime).add(start2).addParams(params).add(Protocol.Keyword.JUSTID), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<StreamInfo> xinfoStream(String key2) {
        return new CommandObject<StreamInfo>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(key2), BuilderFactory.STREAM_INFO);
    }

    public final CommandObject<Object> xinfoStream(byte[] key2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(key2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<StreamFullInfo> xinfoStreamFull(String key2) {
        return new CommandObject<StreamFullInfo>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(key2).add(Protocol.Keyword.FULL), BuilderFactory.STREAM_FULL_INFO);
    }

    public final CommandObject<StreamFullInfo> xinfoStreamFull(String key2, int count2) {
        return new CommandObject<StreamFullInfo>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(key2).add(Protocol.Keyword.FULL).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.STREAM_FULL_INFO);
    }

    public final CommandObject<Object> xinfoStreamFull(byte[] key2, int count2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(key2).add(Protocol.Keyword.FULL).add(Protocol.Keyword.COUNT).add(count2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> xinfoStreamFull(byte[] key2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(key2).add(Protocol.Keyword.FULL), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<List<StreamGroupInfo>> xinfoGroups(String key2) {
        return new CommandObject<List<StreamGroupInfo>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.GROUPS).key(key2), BuilderFactory.STREAM_GROUP_INFO_LIST);
    }

    public final CommandObject<List<Object>> xinfoGroups(byte[] key2) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.GROUPS).key(key2), BuilderFactory.RAW_OBJECT_LIST);
    }

    @Deprecated
    public final CommandObject<List<StreamConsumersInfo>> xinfoConsumers(String key2, String group) {
        return new CommandObject<List<StreamConsumersInfo>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.CONSUMERS).key(key2).add(group), BuilderFactory.STREAM_CONSUMERS_INFO_LIST);
    }

    public final CommandObject<List<StreamConsumerInfo>> xinfoConsumers2(String key2, String group) {
        return new CommandObject<List<StreamConsumerInfo>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.CONSUMERS).key(key2).add(group), BuilderFactory.STREAM_CONSUMER_INFO_LIST);
    }

    public final CommandObject<List<Object>> xinfoConsumers(byte[] key2, byte[] group) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.CONSUMERS).key(key2).add(group), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Map.Entry<String, List<StreamEntry>>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> streams) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XREAD).addParams(xReadParams).add(Protocol.Keyword.STREAMS);
        Set<Map.Entry<String, StreamEntryID>> entrySet = streams.entrySet();
        entrySet.forEach(entry -> args2.key(entry.getKey()));
        entrySet.forEach(entry -> args2.add(entry.getValue()));
        return new CommandObject<List<Map.Entry<String, List<StreamEntry>>>>(args2, BuilderFactory.STREAM_READ_RESPONSE);
    }

    public final CommandObject<Map<String, List<StreamEntry>>> xreadAsMap(XReadParams xReadParams, Map<String, StreamEntryID> streams) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XREAD).addParams(xReadParams).add(Protocol.Keyword.STREAMS);
        Set<Map.Entry<String, StreamEntryID>> entrySet = streams.entrySet();
        entrySet.forEach(entry -> args2.key(entry.getKey()));
        entrySet.forEach(entry -> args2.add(entry.getValue()));
        return new CommandObject<Map<String, List<StreamEntry>>>(args2, BuilderFactory.STREAM_READ_MAP_RESPONSE);
    }

    public final CommandObject<List<Map.Entry<String, List<StreamEntry>>>> xreadGroup(String groupName, String consumer2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> streams) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XREADGROUP).add(Protocol.Keyword.GROUP).add(groupName).add(consumer2).addParams(xReadGroupParams).add(Protocol.Keyword.STREAMS);
        Set<Map.Entry<String, StreamEntryID>> entrySet = streams.entrySet();
        entrySet.forEach(entry -> args2.key(entry.getKey()));
        entrySet.forEach(entry -> args2.add(entry.getValue()));
        return new CommandObject<List<Map.Entry<String, List<StreamEntry>>>>(args2, BuilderFactory.STREAM_READ_RESPONSE);
    }

    public final CommandObject<Map<String, List<StreamEntry>>> xreadGroupAsMap(String groupName, String consumer2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> streams) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XREADGROUP).add(Protocol.Keyword.GROUP).add(groupName).add(consumer2).addParams(xReadGroupParams).add(Protocol.Keyword.STREAMS);
        Set<Map.Entry<String, StreamEntryID>> entrySet = streams.entrySet();
        entrySet.forEach(entry -> args2.key(entry.getKey()));
        entrySet.forEach(entry -> args2.add(entry.getValue()));
        return new CommandObject<Map<String, List<StreamEntry>>>(args2, BuilderFactory.STREAM_READ_MAP_RESPONSE);
    }

    public final CommandObject<List<Object>> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... streams) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XREAD).addParams(xReadParams).add(Protocol.Keyword.STREAMS);
        for (Map.Entry<byte[], byte[]> entry : streams) {
            args2.key(entry.getKey());
        }
        for (Map.Entry<byte[], byte[]> entry : streams) {
            args2.add(entry.getValue());
        }
        return new CommandObject<List<Object>>(args2, BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> xreadGroup(byte[] groupName, byte[] consumer2, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... streams) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.XREADGROUP).add(Protocol.Keyword.GROUP).add(groupName).add(consumer2).addParams(xReadGroupParams).add(Protocol.Keyword.STREAMS);
        for (Map.Entry<byte[], byte[]> entry : streams) {
            args2.key(entry.getKey());
        }
        for (Map.Entry<byte[], byte[]> entry : streams) {
            args2.add(entry.getValue());
        }
        return new CommandObject<List<Object>>(args2, BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<Object> eval(String script) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(script).add(0), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> eval(String script, String sampleKey) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(script).add(0).processKey(sampleKey), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> eval(String script, int keyCount, String ... params) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(script).add(keyCount).addObjects(params).processKeys(Arrays.copyOf(params, keyCount)), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> eval(String script, List<String> keys2, List<String> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(script).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalReadonly(String script, List<String> keys2, List<String> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL_RO).add(script).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> eval(byte[] script) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(script).add(0), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> eval(byte[] script, byte[] sampleKey) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(script).add(0).processKey(sampleKey), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> eval(byte[] script, int keyCount, byte[] ... params) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(script).add(keyCount).addObjects((Object[])params).processKeys((byte[][])Arrays.copyOf(params, keyCount)), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> eval(byte[] script, List<byte[]> keys2, List<byte[]> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(script).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalReadonly(byte[] script, List<byte[]> keys2, List<byte[]> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL_RO).add(script).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalsha(String sha1) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(sha1).add(0), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalsha(String sha1, String sampleKey) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(sha1).add(0).processKey(sampleKey), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalsha(String sha1, int keyCount, String ... params) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(sha1).add(keyCount).addObjects(params).processKeys(Arrays.copyOf(params, keyCount)), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalsha(String sha1, List<String> keys2, List<String> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(sha1).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalshaReadonly(String sha1, List<String> keys2, List<String> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA_RO).add(sha1).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalsha(byte[] sha1) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(sha1).add(0), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalsha(byte[] sha1, byte[] sampleKey) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(sha1).add(0).processKey(sampleKey), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(sha1).add(keyCount).addObjects((Object[])params).processKeys((byte[][])Arrays.copyOf(params, keyCount)), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalsha(byte[] sha1, List<byte[]> keys2, List<byte[]> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(sha1).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalshaReadonly(byte[] sha1, List<byte[]> keys2, List<byte[]> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA_RO).add(sha1).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<List<Boolean>> scriptExists(List<String> sha1s) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.EXISTS).addObjects(sha1s), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> scriptExists(String sampleKey, String ... sha1s) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.EXISTS).addObjects(sha1s).processKey(sampleKey), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<String> scriptLoad(String script) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.LOAD).add(script), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptLoad(String script, String sampleKey) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.LOAD).add(script).processKey(sampleKey), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptFlush() {
        return this.SCRIPT_FLUSH_COMMAND_OBJECT;
    }

    public final CommandObject<String> scriptFlush(String sampleKey) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).processKey(sampleKey), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptFlush(String sampleKey, FlushMode flushMode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).add(flushMode).processKey(sampleKey), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptKill() {
        return this.SCRIPT_KILL_COMMAND_OBJECT;
    }

    public final CommandObject<String> scriptKill(String sampleKey) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.KILL).processKey(sampleKey), BuilderFactory.STRING);
    }

    public final CommandObject<List<Boolean>> scriptExists(byte[] sampleKey, byte[] ... sha1s) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.EXISTS).addObjects((Object[])sha1s).processKey(sampleKey), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<byte[]> scriptLoad(byte[] script, byte[] sampleKey) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.LOAD).add(script).processKey(sampleKey), BuilderFactory.BINARY);
    }

    public final CommandObject<String> scriptFlush(byte[] sampleKey) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).processKey(sampleKey), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptFlush(byte[] sampleKey, FlushMode flushMode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).add(flushMode).processKey(sampleKey), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptKill(byte[] sampleKey) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.KILL).processKey(sampleKey), BuilderFactory.STRING);
    }

    public final CommandObject<String> slowlogReset() {
        return this.SLOWLOG_RESET_COMMAND_OBJECT;
    }

    public final CommandObject<Object> fcall(String name, List<String> keys2, List<String> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FCALL).add(name).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<Object> fcallReadonly(String name, List<String> keys2, List<String> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FCALL_RO).add(name).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<String> functionDelete(String libraryName) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.DELETE).add(libraryName), BuilderFactory.STRING);
    }

    public final CommandObject<List<LibraryInfo>> functionList() {
        return new CommandObject<List<LibraryInfo>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST), LibraryInfo.LIBRARY_INFO_LIST);
    }

    public final CommandObject<List<LibraryInfo>> functionList(String libraryNamePattern) {
        return new CommandObject<List<LibraryInfo>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.LIBRARYNAME).add(libraryNamePattern), LibraryInfo.LIBRARY_INFO_LIST);
    }

    public final CommandObject<List<LibraryInfo>> functionListWithCode() {
        return new CommandObject<List<LibraryInfo>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.WITHCODE), LibraryInfo.LIBRARY_INFO_LIST);
    }

    public final CommandObject<List<LibraryInfo>> functionListWithCode(String libraryNamePattern) {
        return new CommandObject<List<LibraryInfo>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.LIBRARYNAME).add(libraryNamePattern).add(Protocol.Keyword.WITHCODE), LibraryInfo.LIBRARY_INFO_LIST);
    }

    public final CommandObject<String> functionLoad(String functionCode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LOAD).add(functionCode), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionLoadReplace(String functionCode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LOAD).add(Protocol.Keyword.REPLACE).add(functionCode), BuilderFactory.STRING);
    }

    public final CommandObject<FunctionStats> functionStats() {
        return new CommandObject<FunctionStats>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.STATS), FunctionStats.FUNCTION_STATS_BUILDER);
    }

    public final CommandObject<Object> functionStatsBinary() {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.STATS), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<String> functionFlush() {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.FLUSH), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionFlush(FlushMode mode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.FLUSH).add(mode), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionKill() {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.KILL), BuilderFactory.STRING);
    }

    public final CommandObject<Object> fcall(byte[] name, List<byte[]> keys2, List<byte[]> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FCALL).add(name).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> fcallReadonly(byte[] name, List<byte[]> keys2, List<byte[]> args2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FCALL_RO).add(name).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<String> functionDelete(byte[] libraryName) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.DELETE).add(libraryName), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> functionDump() {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.DUMP), BuilderFactory.BINARY);
    }

    public final CommandObject<List<Object>> functionListBinary() {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> functionList(byte[] libraryNamePattern) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.LIBRARYNAME).add(libraryNamePattern), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> functionListWithCodeBinary() {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.WITHCODE), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> functionListWithCode(byte[] libraryNamePattern) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.LIBRARYNAME).add(libraryNamePattern).add(Protocol.Keyword.WITHCODE), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<String> functionLoad(byte[] functionCode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LOAD).add(functionCode), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionLoadReplace(byte[] functionCode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LOAD).add(Protocol.Keyword.REPLACE).add(functionCode), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionRestore(byte[] serializedValue) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Command.RESTORE).add(serializedValue), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionRestore(byte[] serializedValue, FunctionRestorePolicy policy) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Command.RESTORE).add(serializedValue).add(policy.getRaw()), BuilderFactory.STRING);
    }

    public final CommandObject<Boolean> copy(String srcKey, String dstKey, int dstDB, boolean replace) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.COPY).key(srcKey).key(dstKey).add(Protocol.Keyword.DB).add(dstDB);
        if (replace) {
            args2.add(Protocol.Keyword.REPLACE);
        }
        return new CommandObject<Boolean>(args2, BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> copy(byte[] srcKey, byte[] dstKey, int dstDB, boolean replace) {
        CommandArguments args2 = this.commandArguments(Protocol.Command.COPY).key(srcKey).key(dstKey).add(Protocol.Keyword.DB).add(dstDB);
        if (replace) {
            args2.add(Protocol.Keyword.REPLACE);
        }
        return new CommandObject<Boolean>(args2, BuilderFactory.BOOLEAN);
    }

    public final CommandObject<String> migrate(String host2, int port2, String key2, int timeout2) {
        return this.migrate(host2, port2, key2, 0, timeout2);
    }

    public final CommandObject<String> migrate(String host2, int port2, String key2, int destinationDB, int timeout2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.MIGRATE).add(host2).add(port2).key(key2).add(destinationDB).add(timeout2), BuilderFactory.STRING);
    }

    public final CommandObject<String> migrate(String host2, int port2, int timeout2, MigrateParams params, String ... keys2) {
        return this.migrate(host2, port2, 0, timeout2, params, keys2);
    }

    public final CommandObject<String> migrate(String host2, int port2, int destinationDB, int timeout2, MigrateParams params, String ... keys2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.MIGRATE).add(host2).add(port2).add(new byte[0]).add(destinationDB).add(timeout2).addParams(params).add(Protocol.Keyword.KEYS).keys(keys2), BuilderFactory.STRING);
    }

    public final CommandObject<String> migrate(String host2, int port2, byte[] key2, int timeout2) {
        return this.migrate(host2, port2, key2, 0, timeout2);
    }

    public final CommandObject<String> migrate(String host2, int port2, byte[] key2, int destinationDB, int timeout2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.MIGRATE).add(host2).add(port2).key(key2).add(destinationDB).add(timeout2), BuilderFactory.STRING);
    }

    public final CommandObject<String> migrate(String host2, int port2, int timeout2, MigrateParams params, byte[] ... keys2) {
        return this.migrate(host2, port2, 0, timeout2, params, keys2);
    }

    public final CommandObject<String> migrate(String host2, int port2, int destinationDB, int timeout2, MigrateParams params, byte[] ... keys2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.MIGRATE).add(host2).add(port2).add(new byte[0]).add(destinationDB).add(timeout2).addParams(params).add(Protocol.Keyword.KEYS).keys((Object[])keys2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> memoryUsage(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.MEMORY).add(Protocol.Keyword.USAGE).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> memoryUsage(String key2, int samples) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.MEMORY).add(Protocol.Keyword.USAGE).key(key2).add(Protocol.Keyword.SAMPLES).add(samples), BuilderFactory.LONG);
    }

    public final CommandObject<Long> memoryUsage(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.MEMORY).add(Protocol.Keyword.USAGE).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> memoryUsage(byte[] key2, int samples) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.MEMORY).add(Protocol.Keyword.USAGE).key(key2).add(Protocol.Keyword.SAMPLES).add(samples), BuilderFactory.LONG);
    }

    public final CommandObject<Long> objectRefcount(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.REFCOUNT).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<String> objectEncoding(String key2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.ENCODING).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> objectIdletime(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.IDLETIME).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> objectFreq(String key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.FREQ).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> objectRefcount(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.REFCOUNT).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<byte[]> objectEncoding(byte[] key2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.ENCODING).key(key2), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> objectIdletime(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.IDLETIME).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> objectFreq(byte[] key2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.FREQ).key(key2), BuilderFactory.LONG);
    }

    public CommandObject<Long> waitReplicas(int replicas, long timeout2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.WAIT).add(replicas).add(timeout2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> waitReplicas(String sampleKey, int replicas, long timeout2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.WAIT).add(replicas).add(timeout2).processKey(sampleKey), BuilderFactory.LONG);
    }

    public final CommandObject<Long> waitReplicas(byte[] sampleKey, int replicas, long timeout2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.WAIT).add(replicas).add(timeout2).processKey(sampleKey), BuilderFactory.LONG);
    }

    public CommandObject<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout2) {
        return new CommandObject<KeyValue<Long, Long>>(this.commandArguments(Protocol.Command.WAITAOF).add(numLocal).add(numReplicas).add(timeout2), BuilderFactory.LONG_LONG_PAIR);
    }

    public CommandObject<KeyValue<Long, Long>> waitAOF(byte[] sampleKey, long numLocal, long numReplicas, long timeout2) {
        return new CommandObject<KeyValue<Long, Long>>(this.commandArguments(Protocol.Command.WAITAOF).add(numLocal).add(numReplicas).add(timeout2).processKey(sampleKey), BuilderFactory.LONG_LONG_PAIR);
    }

    public CommandObject<KeyValue<Long, Long>> waitAOF(String sampleKey, long numLocal, long numReplicas, long timeout2) {
        return new CommandObject<KeyValue<Long, Long>>(this.commandArguments(Protocol.Command.WAITAOF).add(numLocal).add(numReplicas).add(timeout2).processKey(sampleKey), BuilderFactory.LONG_LONG_PAIR);
    }

    public final CommandObject<Long> publish(String channel2, String message) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PUBLISH).add(channel2).add(message), BuilderFactory.LONG);
    }

    public final CommandObject<Long> publish(byte[] channel2, byte[] message) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PUBLISH).add(channel2).add(message), BuilderFactory.LONG);
    }

    public final CommandObject<Long> spublish(String channel2, String message) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SPUBLISH).key(channel2).add(message), BuilderFactory.LONG);
    }

    public final CommandObject<Long> spublish(byte[] channel2, byte[] message) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SPUBLISH).key(channel2).add(message), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hsetObject(String key2, String field, Object value2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSET).key(key2).add(field).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hsetObject(String key2, Map<String, Object> hash) {
        return new CommandObject<Long>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HSET).key(key2), hash), BuilderFactory.LONG);
    }

    private boolean isRoundRobinSearchCommand() {
        if (this.broadcastAndRoundRobinConfig == null) {
            return true;
        }
        return this.broadcastAndRoundRobinConfig.getRediSearchModeInCluster() != JedisBroadcastAndRoundRobinConfig.RediSearchMode.LIGHT;
    }

    private CommandArguments checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand sc, String idx) {
        CommandArguments ca = this.commandArguments(sc);
        if (this.isRoundRobinSearchCommand()) {
            ca.add(idx);
        } else {
            ca.key(idx);
        }
        return ca;
    }

    private CommandArguments checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand sc, String idx1, String idx2) {
        CommandArguments ca = this.commandArguments(sc);
        if (this.isRoundRobinSearchCommand()) {
            ca.add(idx1).add(idx2);
        } else {
            ca.key(idx1).key(idx2);
        }
        return ca;
    }

    private CommandArguments checkAndRoundRobinSearchCommand(CommandArguments commandArguments, byte[] indexName) {
        return this.isRoundRobinSearchCommand() ? commandArguments.add(indexName) : commandArguments.key(indexName);
    }

    private <T> CommandObject<T> directSearchCommand(CommandObject<T> object, String indexName) {
        object.getArguments().processKey(indexName);
        return object;
    }

    public final CommandObject<String> ftCreate(String indexName, IndexOptions indexOptions, Schema schema) {
        CommandArguments args2 = this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.CREATE, indexName).addParams(indexOptions).add(SearchProtocol.SearchKeyword.SCHEMA);
        schema.fields.forEach(field -> args2.addParams((IParams)field));
        return new CommandObject<String>(args2, BuilderFactory.STRING);
    }

    public final CommandObject<String> ftCreate(String indexName, FTCreateParams createParams, Iterable<SchemaField> schemaFields) {
        CommandArguments args2 = this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.CREATE, indexName).addParams(createParams).add(SearchProtocol.SearchKeyword.SCHEMA);
        schemaFields.forEach(field -> args2.addParams((IParams)field));
        return new CommandObject<String>(args2, BuilderFactory.STRING);
    }

    public final CommandObject<String> ftAlter(String indexName, Schema schema) {
        CommandArguments args2 = this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.ALTER, indexName).add(SearchProtocol.SearchKeyword.SCHEMA).add(SearchProtocol.SearchKeyword.ADD);
        schema.fields.forEach(field -> args2.addParams((IParams)field));
        return new CommandObject<String>(args2, BuilderFactory.STRING);
    }

    public final CommandObject<String> ftAlter(String indexName, Iterable<SchemaField> schemaFields) {
        CommandArguments args2 = this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.ALTER, indexName).add(SearchProtocol.SearchKeyword.SCHEMA).add(SearchProtocol.SearchKeyword.ADD);
        schemaFields.forEach(field -> args2.addParams((IParams)field));
        return new CommandObject<String>(args2, BuilderFactory.STRING);
    }

    public final CommandObject<String> ftAliasAdd(String aliasName, String indexName) {
        return new CommandObject<String>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.ALIASADD, aliasName, indexName), BuilderFactory.STRING);
    }

    public final CommandObject<String> ftAliasUpdate(String aliasName, String indexName) {
        return new CommandObject<String>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.ALIASUPDATE, aliasName, indexName), BuilderFactory.STRING);
    }

    public final CommandObject<String> ftAliasDel(String aliasName) {
        return new CommandObject<String>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.ALIASDEL, aliasName), BuilderFactory.STRING);
    }

    public final CommandObject<String> ftDropIndex(String indexName) {
        return new CommandObject<String>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.DROPINDEX, indexName), BuilderFactory.STRING);
    }

    public final CommandObject<String> ftDropIndexDD(String indexName) {
        return new CommandObject<String>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.DROPINDEX, indexName).add(SearchProtocol.SearchKeyword.DD), BuilderFactory.STRING);
    }

    public final CommandObject<SearchResult> ftSearch(String indexName, String query2) {
        return new CommandObject<SearchResult>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.SEARCH, indexName).add(query2), this.getSearchResultBuilder(null, () -> new SearchResult.SearchResultBuilder(true, false, true)));
    }

    public final CommandObject<SearchResult> ftSearch(String indexName, String query2, FTSearchParams params) {
        return new CommandObject<SearchResult>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.SEARCH, indexName).add(query2).addParams(params.dialectOptional(this.searchDialect.get())), this.getSearchResultBuilder(params.getReturnFieldDecodeMap(), () -> new SearchResult.SearchResultBuilder(!params.getNoContent(), params.getWithScores(), true, params.getReturnFieldDecodeMap())));
    }

    public final CommandObject<SearchResult> ftSearch(String indexName, Query query2) {
        return new CommandObject<SearchResult>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.SEARCH, indexName).addParams(query2.dialectOptional(this.searchDialect.get())), this.getSearchResultBuilder(null, () -> new SearchResult.SearchResultBuilder(!query2.getNoContent(), query2.getWithScores(), true)));
    }

    @Deprecated
    public final CommandObject<SearchResult> ftSearch(byte[] indexName, Query query2) {
        if (this.protocol == RedisProtocol.RESP3) {
            throw new UnsupportedOperationException("binary ft.search is not implemented with resp3.");
        }
        return new CommandObject<SearchResult>(this.checkAndRoundRobinSearchCommand(this.commandArguments(SearchProtocol.SearchCommand.SEARCH), indexName).addParams(query2.dialectOptional(this.searchDialect.get())), this.getSearchResultBuilder(null, () -> new SearchResult.SearchResultBuilder(!query2.getNoContent(), query2.getWithScores(), false)));
    }

    public final CommandObject<String> ftExplain(String indexName, Query query2) {
        return new CommandObject<String>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.EXPLAIN, indexName).addParams(query2.dialectOptional(this.searchDialect.get())), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> ftExplainCLI(String indexName, Query query2) {
        return new CommandObject<List<String>>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.EXPLAINCLI, indexName).addParams(query2.dialectOptional(this.searchDialect.get())), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<AggregationResult> ftAggregate(String indexName, AggregationBuilder aggr) {
        return new CommandObject<AggregationResult>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.AGGREGATE, indexName).addParams(aggr.dialectOptional(this.searchDialect.get())), !aggr.isWithCursor() ? AggregationResult.SEARCH_AGGREGATION_RESULT : AggregationResult.SEARCH_AGGREGATION_RESULT_WITH_CURSOR);
    }

    public final CommandObject<AggregationResult> ftCursorRead(String indexName, long cursorId, int count2) {
        return new CommandObject<AggregationResult>(this.commandArguments(SearchProtocol.SearchCommand.CURSOR).add(SearchProtocol.SearchKeyword.READ).key(indexName).add(cursorId).add(SearchProtocol.SearchKeyword.COUNT).add(count2), AggregationResult.SEARCH_AGGREGATION_RESULT_WITH_CURSOR);
    }

    public final CommandObject<String> ftCursorDel(String indexName, long cursorId) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.CURSOR).add(SearchProtocol.SearchKeyword.DEL).key(indexName).add(cursorId), BuilderFactory.STRING);
    }

    public final CommandObject<Map.Entry<AggregationResult, Map<String, Object>>> ftProfileAggregate(String indexName, FTProfileParams profileParams, AggregationBuilder aggr) {
        return new CommandObject<AggregationResult>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.PROFILE, indexName).add(SearchProtocol.SearchKeyword.AGGREGATE).addParams(profileParams).add(SearchProtocol.SearchKeyword.QUERY).addParams(aggr.dialectOptional(this.searchDialect.get())), new SearchProfileResponseBuilder<AggregationResult>(!aggr.isWithCursor() ? AggregationResult.SEARCH_AGGREGATION_RESULT : AggregationResult.SEARCH_AGGREGATION_RESULT_WITH_CURSOR));
    }

    public final CommandObject<Map.Entry<SearchResult, Map<String, Object>>> ftProfileSearch(String indexName, FTProfileParams profileParams, Query query2) {
        return new CommandObject<SearchResult>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.PROFILE, indexName).add(SearchProtocol.SearchKeyword.SEARCH).addParams(profileParams).add(SearchProtocol.SearchKeyword.QUERY).addParams(query2.dialectOptional(this.searchDialect.get())), new SearchProfileResponseBuilder<SearchResult>(this.getSearchResultBuilder(null, () -> new SearchResult.SearchResultBuilder(!query2.getNoContent(), query2.getWithScores(), true))));
    }

    public final CommandObject<Map.Entry<SearchResult, Map<String, Object>>> ftProfileSearch(String indexName, FTProfileParams profileParams, String query2, FTSearchParams searchParams) {
        return new CommandObject<SearchResult>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.PROFILE, indexName).add(SearchProtocol.SearchKeyword.SEARCH).addParams(profileParams).add(SearchProtocol.SearchKeyword.QUERY).add(query2).addParams(searchParams.dialectOptional(this.searchDialect.get())), new SearchProfileResponseBuilder<SearchResult>(this.getSearchResultBuilder(searchParams.getReturnFieldDecodeMap(), () -> new SearchResult.SearchResultBuilder(!searchParams.getNoContent(), searchParams.getWithScores(), true, searchParams.getReturnFieldDecodeMap()))));
    }

    private Builder<SearchResult> getSearchResultBuilder(Map<String, Boolean> isReturnFieldDecode, Supplier<Builder<SearchResult>> resp2) {
        if (this.protocol == RedisProtocol.RESP3) {
            return isReturnFieldDecode == null ? SearchResult.SEARCH_RESULT_BUILDER : new SearchResult.PerFieldDecoderSearchResultBuilder(isReturnFieldDecode);
        }
        return resp2.get();
    }

    public final CommandObject<String> ftSynUpdate(String indexName, String synonymGroupId, String ... terms) {
        return new CommandObject<String>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.SYNUPDATE, indexName).add(synonymGroupId).addObjects(terms), BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, List<String>>> ftSynDump(String indexName) {
        return new CommandObject<Map<String, List<String>>>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.SYNDUMP, indexName), SearchBuilderFactory.SEARCH_SYNONYM_GROUPS);
    }

    public final CommandObject<Long> ftDictAdd(String dictionary, String ... terms) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.DICTADD).add(dictionary).addObjects(terms), BuilderFactory.LONG);
    }

    public final CommandObject<Long> ftDictDel(String dictionary, String ... terms) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.DICTDEL).add(dictionary).addObjects(terms), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> ftDictDump(String dictionary) {
        return new CommandObject<Set<String>>(this.commandArguments(SearchProtocol.SearchCommand.DICTDUMP).add(dictionary), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Long> ftDictAddBySampleKey(String indexName, String dictionary, String ... terms) {
        return this.directSearchCommand(this.ftDictAdd(dictionary, terms), indexName);
    }

    public final CommandObject<Long> ftDictDelBySampleKey(String indexName, String dictionary, String ... terms) {
        return this.directSearchCommand(this.ftDictDel(dictionary, terms), indexName);
    }

    public final CommandObject<Set<String>> ftDictDumpBySampleKey(String indexName, String dictionary) {
        return this.directSearchCommand(this.ftDictDump(dictionary), indexName);
    }

    public final CommandObject<Map<String, Map<String, Double>>> ftSpellCheck(String index, String query2) {
        return new CommandObject<Map<String, Map<String, Double>>>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.SPELLCHECK, index).add(query2), SearchBuilderFactory.SEARCH_SPELLCHECK_RESPONSE);
    }

    public final CommandObject<Map<String, Map<String, Double>>> ftSpellCheck(String index, String query2, FTSpellCheckParams spellCheckParams) {
        return new CommandObject<Map<String, Map<String, Double>>>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.SPELLCHECK, index).add(query2).addParams(spellCheckParams.dialectOptional(this.searchDialect.get())), SearchBuilderFactory.SEARCH_SPELLCHECK_RESPONSE);
    }

    public final CommandObject<Map<String, Object>> ftInfo(String indexName) {
        return new CommandObject<Map<String, Object>>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.INFO, indexName), this.protocol == RedisProtocol.RESP3 ? BuilderFactory.AGGRESSIVE_ENCODED_OBJECT_MAP : BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<Set<String>> ftTagVals(String indexName, String fieldName) {
        return new CommandObject<Set<String>>(this.checkAndRoundRobinSearchCommand(SearchProtocol.SearchCommand.TAGVALS, indexName).add(fieldName), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Map<String, Object>> ftConfigGet(String option) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(SearchProtocol.SearchCommand.CONFIG).add(SearchProtocol.SearchKeyword.GET).add(option), this.protocol == RedisProtocol.RESP3 ? BuilderFactory.AGGRESSIVE_ENCODED_OBJECT_MAP : BuilderFactory.ENCODED_OBJECT_MAP_FROM_PAIRS);
    }

    public final CommandObject<Map<String, Object>> ftConfigGet(String indexName, String option) {
        return this.directSearchCommand(this.ftConfigGet(option), indexName);
    }

    public final CommandObject<String> ftConfigSet(String option, String value2) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.CONFIG).add(SearchProtocol.SearchKeyword.SET).add(option).add(value2), BuilderFactory.STRING);
    }

    public final CommandObject<String> ftConfigSet(String indexName, String option, String value2) {
        return this.directSearchCommand(this.ftConfigSet(option, value2), indexName);
    }

    public final CommandObject<Long> ftSugAdd(String key2, String string, double score) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.SUGADD).key(key2).add(string).add(score), BuilderFactory.LONG);
    }

    public final CommandObject<Long> ftSugAddIncr(String key2, String string, double score) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.SUGADD).key(key2).add(string).add(score).add(SearchProtocol.SearchKeyword.INCR), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> ftSugGet(String key2, String prefix2) {
        return new CommandObject<List<String>>(this.commandArguments(SearchProtocol.SearchCommand.SUGGET).key(key2).add(prefix2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> ftSugGet(String key2, String prefix2, boolean fuzzy, int max2) {
        CommandArguments args2 = this.commandArguments(SearchProtocol.SearchCommand.SUGGET).key(key2).add(prefix2);
        if (fuzzy) {
            args2.add(SearchProtocol.SearchKeyword.FUZZY);
        }
        args2.add(SearchProtocol.SearchKeyword.MAX).add(max2);
        return new CommandObject<List<String>>(args2, BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> ftSugGetWithScores(String key2, String prefix2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(SearchProtocol.SearchCommand.SUGGET).key(key2).add(prefix2).add(SearchProtocol.SearchKeyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> ftSugGetWithScores(String key2, String prefix2, boolean fuzzy, int max2) {
        CommandArguments args2 = this.commandArguments(SearchProtocol.SearchCommand.SUGGET).key(key2).add(prefix2);
        if (fuzzy) {
            args2.add(SearchProtocol.SearchKeyword.FUZZY);
        }
        args2.add(SearchProtocol.SearchKeyword.MAX).add(max2);
        args2.add(SearchProtocol.SearchKeyword.WITHSCORES);
        return new CommandObject<List<Tuple>>(args2, BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Boolean> ftSugDel(String key2, String string) {
        return new CommandObject<Boolean>(this.commandArguments(SearchProtocol.SearchCommand.SUGDEL).key(key2).add(string), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> ftSugLen(String key2) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.SUGLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> ftList() {
        return new CommandObject<Set<String>>(this.commandArguments(SearchProtocol.SearchCommand._LIST), BuilderFactory.STRING_SET);
    }

    public final CommandObject<String> jsonSet(String key2, Path2 path2, Object object) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(key2).add(path2).add(object), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSetWithEscape(String key2, Path2 path2, Object object) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(object)), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<String> jsonSet(String key2, Path path2, Object pojo) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(pojo)), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<String> jsonSetWithPlainString(String key2, Path path2, String string) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(key2).add(path2).add(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSet(String key2, Path2 path2, Object object, JsonSetParams params) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(key2).add(path2).add(object).addParams(params), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSetWithEscape(String key2, Path2 path2, Object object, JsonSetParams params) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(object)).addParams(params), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<String> jsonSet(String key2, Path path2, Object pojo, JsonSetParams params) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(pojo)).addParams(params), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonMerge(String key2, Path2 path2, Object object) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.MERGE).key(key2).add(path2).add(object), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<String> jsonMerge(String key2, Path path2, Object pojo) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.MERGE).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(pojo)), BuilderFactory.STRING);
    }

    public final CommandObject<Object> jsonGet(String key2) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(key2), this.JSON_GENERIC_OBJECT);
    }

    @Deprecated
    public final <T> CommandObject<T> jsonGet(String key2, Class<T> clazz) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(key2), new JsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<Object> jsonGet(String key2, Path2 ... paths) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(key2).addObjects(paths), JsonBuilderFactory.JSON_OBJECT);
    }

    @Deprecated
    public final CommandObject<Object> jsonGet(String key2, Path ... paths) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(key2).addObjects(paths), this.JSON_GENERIC_OBJECT);
    }

    @Deprecated
    public final CommandObject<String> jsonGetAsPlainString(String key2, Path path2) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(key2).add(path2), BuilderFactory.STRING);
    }

    @Deprecated
    public final <T> CommandObject<T> jsonGet(String key2, Class<T> clazz, Path ... paths) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(key2).addObjects(paths), new JsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<List<JSONArray>> jsonMGet(Path2 path2, String ... keys2) {
        return new CommandObject<List<JSONArray>>(this.commandArguments(JsonProtocol.JsonCommand.MGET).keys(keys2).add(path2), JsonBuilderFactory.JSON_ARRAY_LIST);
    }

    @Deprecated
    public final <T> CommandObject<List<T>> jsonMGet(Path path2, Class<T> clazz, String ... keys2) {
        return new CommandObject<List<T>>(this.commandArguments(JsonProtocol.JsonCommand.MGET).keys(keys2).add(path2), new JsonObjectListBuilder<T>(clazz));
    }

    public final CommandObject<Long> jsonDel(String key2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEL).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonDel(String key2, Path2 path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEL).key(key2).add(path2), BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<Long> jsonDel(String key2, Path path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEL).key(key2).add(path2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonClear(String key2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.CLEAR).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonClear(String key2, Path2 path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.CLEAR).key(key2).add(path2), BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<Long> jsonClear(String key2, Path path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.CLEAR).key(key2).add(path2), BuilderFactory.LONG);
    }

    public final CommandObject<List<Boolean>> jsonToggle(String key2, Path2 path2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(JsonProtocol.JsonCommand.TOGGLE).key(key2).add(path2), BuilderFactory.BOOLEAN_LIST);
    }

    @Deprecated
    public final CommandObject<String> jsonToggle(String key2, Path path2) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.TOGGLE).key(key2).add(path2), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<Class<?>> jsonType(String key2) {
        return new CommandObject(this.commandArguments(JsonProtocol.JsonCommand.TYPE).key(key2), JsonBuilderFactory.JSON_TYPE);
    }

    public final CommandObject<List<Class<?>>> jsonType(String key2, Path2 path2) {
        return new CommandObject(this.commandArguments(JsonProtocol.JsonCommand.TYPE).key(key2).add(path2), this.protocol != RedisProtocol.RESP3 ? JsonBuilderFactory.JSON_TYPE_LIST : JsonBuilderFactory.JSON_TYPE_RESPONSE_RESP3_COMPATIBLE);
    }

    @Deprecated
    public final CommandObject<Class<?>> jsonType(String key2, Path path2) {
        return new CommandObject(this.commandArguments(JsonProtocol.JsonCommand.TYPE).key(key2).add(path2), JsonBuilderFactory.JSON_TYPE);
    }

    @Deprecated
    public final CommandObject<Long> jsonStrAppend(String key2, Object string) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.STRAPPEND).key(key2).add(this.getJsonObjectMapper().toJson(string)), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonStrAppend(String key2, Path2 path2, Object string) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.STRAPPEND).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(string)), BuilderFactory.LONG_LIST);
    }

    @Deprecated
    public final CommandObject<Long> jsonStrAppend(String key2, Path path2, Object string) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.STRAPPEND).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(string)), BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<Long> jsonStrLen(String key2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.STRLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonStrLen(String key2, Path2 path2) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.STRLEN).key(key2).add(path2), BuilderFactory.LONG_LIST);
    }

    @Deprecated
    public final CommandObject<Long> jsonStrLen(String key2, Path path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.STRLEN).key(key2).add(path2), BuilderFactory.LONG);
    }

    public final CommandObject<Object> jsonNumIncrBy(String key2, Path2 path2, double value2) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.NUMINCRBY).key(key2).add(path2).add(value2), JsonBuilderFactory.JSON_ARRAY_OR_DOUBLE_LIST);
    }

    @Deprecated
    public final CommandObject<Double> jsonNumIncrBy(String key2, Path path2, double value2) {
        return new CommandObject<Double>(this.commandArguments(JsonProtocol.JsonCommand.NUMINCRBY).key(key2).add(path2).add(value2), BuilderFactory.DOUBLE);
    }

    @Deprecated
    public final CommandObject<Long> jsonArrAppend(String key2, String path2, JSONObject ... objects) {
        CommandArguments args2 = this.commandArguments(JsonProtocol.JsonCommand.ARRAPPEND).key(key2).add(path2);
        for (JSONObject object : objects) {
            args2.add(object);
        }
        return new CommandObject<Long>(args2, BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrAppend(String key2, Path2 path2, Object ... objects) {
        CommandArguments args2 = this.commandArguments(JsonProtocol.JsonCommand.ARRAPPEND).key(key2).add(path2).addObjects(objects);
        return new CommandObject<List<Long>>(args2, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> jsonArrAppendWithEscape(String key2, Path2 path2, Object ... objects) {
        CommandArguments args2 = this.commandArguments(JsonProtocol.JsonCommand.ARRAPPEND).key(key2).add(path2);
        for (Object object : objects) {
            args2.add(this.getJsonObjectMapper().toJson(object));
        }
        return new CommandObject<List<Long>>(args2, BuilderFactory.LONG_LIST);
    }

    @Deprecated
    public final CommandObject<Long> jsonArrAppend(String key2, Path path2, Object ... pojos) {
        CommandArguments args2 = this.commandArguments(JsonProtocol.JsonCommand.ARRAPPEND).key(key2).add(path2);
        for (Object pojo : pojos) {
            args2.add(this.getJsonObjectMapper().toJson(pojo));
        }
        return new CommandObject<Long>(args2, BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrIndex(String key2, Path2 path2, Object scalar) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.ARRINDEX).key(key2).add(path2).add(scalar), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> jsonArrIndexWithEscape(String key2, Path2 path2, Object scalar) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.ARRINDEX).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(scalar)), BuilderFactory.LONG_LIST);
    }

    @Deprecated
    public final CommandObject<Long> jsonArrIndex(String key2, Path path2, Object scalar) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.ARRINDEX).key(key2).add(path2).add(this.getJsonObjectMapper().toJson(scalar)), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrInsert(String key2, Path2 path2, int index, Object ... objects) {
        CommandArguments args2 = this.commandArguments(JsonProtocol.JsonCommand.ARRINSERT).key(key2).add(path2).add(index).addObjects(objects);
        return new CommandObject<List<Long>>(args2, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> jsonArrInsertWithEscape(String key2, Path2 path2, int index, Object ... objects) {
        CommandArguments args2 = this.commandArguments(JsonProtocol.JsonCommand.ARRINSERT).key(key2).add(path2).add(index);
        for (Object object : objects) {
            args2.add(this.getJsonObjectMapper().toJson(object));
        }
        return new CommandObject<List<Long>>(args2, BuilderFactory.LONG_LIST);
    }

    @Deprecated
    public final CommandObject<Long> jsonArrInsert(String key2, Path path2, int index, Object ... pojos) {
        CommandArguments args2 = this.commandArguments(JsonProtocol.JsonCommand.ARRINSERT).key(key2).add(path2).add(index);
        for (Object pojo : pojos) {
            args2.add(this.getJsonObjectMapper().toJson(pojo));
        }
        return new CommandObject<Long>(args2, BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<Object> jsonArrPop(String key2) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(key2), new JsonObjectBuilder<Object>(Object.class));
    }

    @Deprecated
    public final <T> CommandObject<T> jsonArrPop(String key2, Class<T> clazz) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(key2), new JsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<List<Object>> jsonArrPop(String key2, Path2 path2) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(key2).add(path2), new JsonObjectListBuilder<Object>(Object.class));
    }

    @Deprecated
    public final CommandObject<Object> jsonArrPop(String key2, Path path2) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(key2).add(path2), new JsonObjectBuilder<Object>(Object.class));
    }

    @Deprecated
    public final <T> CommandObject<T> jsonArrPop(String key2, Class<T> clazz, Path path2) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(key2).add(path2), new JsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<List<Object>> jsonArrPop(String key2, Path2 path2, int index) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(key2).add(path2).add(index), new JsonObjectListBuilder<Object>(Object.class));
    }

    @Deprecated
    public final CommandObject<Object> jsonArrPop(String key2, Path path2, int index) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(key2).add(path2).add(index), new JsonObjectBuilder<Object>(Object.class));
    }

    @Deprecated
    public final <T> CommandObject<T> jsonArrPop(String key2, Class<T> clazz, Path path2, int index) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(key2).add(path2).add(index), new JsonObjectBuilder<T>(clazz));
    }

    @Deprecated
    public final CommandObject<Long> jsonArrLen(String key2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.ARRLEN).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrLen(String key2, Path2 path2) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.ARRLEN).key(key2).add(path2), BuilderFactory.LONG_LIST);
    }

    @Deprecated
    public final CommandObject<Long> jsonArrLen(String key2, Path path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.ARRLEN).key(key2).add(path2), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrTrim(String key2, Path2 path2, int start2, int stop) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.ARRTRIM).key(key2).add(path2).add(start2).add(stop), BuilderFactory.LONG_LIST);
    }

    @Deprecated
    public final CommandObject<Long> jsonArrTrim(String key2, Path path2, int start2, int stop) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.ARRTRIM).key(key2).add(path2).add(start2).add(stop), BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<Long> jsonObjLen(String key2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.OBJLEN).key(key2), BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<Long> jsonObjLen(String key2, Path path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.OBJLEN).key(key2).add(path2), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonObjLen(String key2, Path2 path2) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.OBJLEN).key(key2).add(path2), BuilderFactory.LONG_LIST);
    }

    @Deprecated
    public final CommandObject<List<String>> jsonObjKeys(String key2) {
        return new CommandObject<List<String>>(this.commandArguments(JsonProtocol.JsonCommand.OBJKEYS).key(key2), BuilderFactory.STRING_LIST);
    }

    @Deprecated
    public final CommandObject<List<String>> jsonObjKeys(String key2, Path path2) {
        return new CommandObject<List<String>>(this.commandArguments(JsonProtocol.JsonCommand.OBJKEYS).key(key2).add(path2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<List<String>>> jsonObjKeys(String key2, Path2 path2) {
        return new CommandObject<List<List<String>>>(this.commandArguments(JsonProtocol.JsonCommand.OBJKEYS).key(key2).add(path2), BuilderFactory.STRING_LIST_LIST);
    }

    @Deprecated
    public final CommandObject<Long> jsonDebugMemory(String key2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEBUG).add("MEMORY").key(key2), BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<Long> jsonDebugMemory(String key2, Path path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEBUG).add("MEMORY").key(key2).add(path2), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonDebugMemory(String key2, Path2 path2) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.DEBUG).add("MEMORY").key(key2).add(path2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<String> tsCreate(String key2) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.CREATE).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<String> tsCreate(String key2, TSCreateParams createParams) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.CREATE).key(key2).addParams(createParams), BuilderFactory.STRING);
    }

    public final CommandObject<Long> tsDel(String key2, long fromTimestamp, long toTimestamp) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DEL).key(key2).add(fromTimestamp).add(toTimestamp), BuilderFactory.LONG);
    }

    public final CommandObject<String> tsAlter(String key2, TSAlterParams alterParams) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ALTER).key(key2).addParams(alterParams), BuilderFactory.STRING);
    }

    public final CommandObject<Long> tsAdd(String key2, double value2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ADD).key(key2).add(Protocol.BYTES_ASTERISK).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsAdd(String key2, long timestamp, double value2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ADD).key(key2).add(timestamp).add(value2), BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<Long> tsAdd(String key2, long timestamp, double value2, TSCreateParams createParams) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ADD).key(key2).add(timestamp).add(value2).addParams(createParams), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsAdd(String key2, long timestamp, double value2, TSAddParams addParams) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ADD).key(key2).add(timestamp).add(value2).addParams(addParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> tsMAdd(Map.Entry<String, TSElement> ... entries2) {
        CommandArguments args2 = this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MADD);
        for (Map.Entry<String, TSElement> entry : entries2) {
            args2.key(entry.getKey()).add(entry.getValue().getTimestamp()).add(entry.getValue().getValue());
        }
        return new CommandObject<List<Long>>(args2, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> tsIncrBy(String key2, double value2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INCRBY).key(key2).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsIncrBy(String key2, double value2, long timestamp) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INCRBY).key(key2).add(value2).add(TimeSeriesProtocol.TimeSeriesKeyword.TIMESTAMP).add(timestamp), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsIncrBy(String key2, double addend, TSIncrByParams incrByParams) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INCRBY).key(key2).add(addend).addParams(incrByParams), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsDecrBy(String key2, double value2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DECRBY).key(key2).add(value2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsDecrBy(String key2, double value2, long timestamp) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DECRBY).key(key2).add(value2).add(TimeSeriesProtocol.TimeSeriesKeyword.TIMESTAMP).add(timestamp), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsDecrBy(String key2, double subtrahend, TSDecrByParams decrByParams) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DECRBY).key(key2).add(subtrahend).addParams(decrByParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<TSElement>> tsRange(String key2, long fromTimestamp, long toTimestamp) {
        return new CommandObject<List<TSElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.RANGE).key(key2).add(fromTimestamp).add(toTimestamp), TimeSeriesBuilderFactory.TIMESERIES_ELEMENT_LIST);
    }

    public final CommandObject<List<TSElement>> tsRange(String key2, TSRangeParams rangeParams) {
        return new CommandObject<List<TSElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.RANGE).key(key2).addParams(rangeParams), TimeSeriesBuilderFactory.TIMESERIES_ELEMENT_LIST);
    }

    public final CommandObject<List<TSElement>> tsRevRange(String key2, long fromTimestamp, long toTimestamp) {
        return new CommandObject<List<TSElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.REVRANGE).key(key2).add(fromTimestamp).add(toTimestamp), TimeSeriesBuilderFactory.TIMESERIES_ELEMENT_LIST);
    }

    public final CommandObject<List<TSElement>> tsRevRange(String key2, TSRangeParams rangeParams) {
        return new CommandObject<List<TSElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.REVRANGE).key(key2).addParams(rangeParams), TimeSeriesBuilderFactory.TIMESERIES_ELEMENT_LIST);
    }

    public final CommandObject<Map<String, TSMRangeElements>> tsMRange(long fromTimestamp, long toTimestamp, String ... filters) {
        return new CommandObject<Map<String, TSMRangeElements>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MRANGE).add(fromTimestamp).add(toTimestamp).add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER).addObjects(filters), this.getTimeseriesMultiRangeResponseBuilder());
    }

    public final CommandObject<Map<String, TSMRangeElements>> tsMRange(TSMRangeParams multiRangeParams) {
        return new CommandObject<Map<String, TSMRangeElements>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MRANGE).addParams(multiRangeParams), this.getTimeseriesMultiRangeResponseBuilder());
    }

    public final CommandObject<Map<String, TSMRangeElements>> tsMRevRange(long fromTimestamp, long toTimestamp, String ... filters) {
        return new CommandObject<Map<String, TSMRangeElements>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MREVRANGE).add(fromTimestamp).add(toTimestamp).add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER).addObjects(filters), this.getTimeseriesMultiRangeResponseBuilder());
    }

    public final CommandObject<Map<String, TSMRangeElements>> tsMRevRange(TSMRangeParams multiRangeParams) {
        return new CommandObject<Map<String, TSMRangeElements>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MREVRANGE).addParams(multiRangeParams), this.getTimeseriesMultiRangeResponseBuilder());
    }

    public final CommandObject<TSElement> tsGet(String key2) {
        return new CommandObject<TSElement>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.GET).key(key2), TimeSeriesBuilderFactory.TIMESERIES_ELEMENT);
    }

    public final CommandObject<TSElement> tsGet(String key2, TSGetParams getParams) {
        return new CommandObject<TSElement>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.GET).key(key2).addParams(getParams), TimeSeriesBuilderFactory.TIMESERIES_ELEMENT);
    }

    public final CommandObject<Map<String, TSMGetElement>> tsMGet(TSMGetParams multiGetParams, String ... filters) {
        return new CommandObject<Map<String, TSMGetElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MGET).addParams(multiGetParams).add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER).addObjects(filters), this.protocol == RedisProtocol.RESP3 ? TimeSeriesBuilderFactory.TIMESERIES_MGET_RESPONSE_RESP3 : TimeSeriesBuilderFactory.TIMESERIES_MGET_RESPONSE);
    }

    public final CommandObject<String> tsCreateRule(String sourceKey, String destKey, AggregationType aggregationType, long timeBucket) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.CREATERULE).key(sourceKey).key(destKey).add(TimeSeriesProtocol.TimeSeriesKeyword.AGGREGATION).add(aggregationType).add(timeBucket), BuilderFactory.STRING);
    }

    public final CommandObject<String> tsCreateRule(String sourceKey, String destKey, AggregationType aggregationType, long bucketDuration, long alignTimestamp) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.CREATERULE).key(sourceKey).key(destKey).add(TimeSeriesProtocol.TimeSeriesKeyword.AGGREGATION).add(aggregationType).add(bucketDuration).add(alignTimestamp), BuilderFactory.STRING);
    }

    public final CommandObject<String> tsDeleteRule(String sourceKey, String destKey) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DELETERULE).key(sourceKey).key(destKey), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> tsQueryIndex(String ... filters) {
        return new CommandObject<List<String>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.QUERYINDEX).addObjects(filters), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<TSInfo> tsInfo(String key2) {
        return new CommandObject<TSInfo>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INFO).key(key2), this.getTimeseriesInfoBuilder());
    }

    public final CommandObject<TSInfo> tsInfoDebug(String key2) {
        return new CommandObject<TSInfo>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INFO).key(key2).add(TimeSeriesProtocol.TimeSeriesKeyword.DEBUG), this.getTimeseriesInfoBuilder());
    }

    private Builder<Map<String, TSMRangeElements>> getTimeseriesMultiRangeResponseBuilder() {
        return this.protocol == RedisProtocol.RESP3 ? TimeSeriesBuilderFactory.TIMESERIES_MRANGE_RESPONSE_RESP3 : TimeSeriesBuilderFactory.TIMESERIES_MRANGE_RESPONSE;
    }

    private Builder<TSInfo> getTimeseriesInfoBuilder() {
        return this.protocol == RedisProtocol.RESP3 ? TSInfo.TIMESERIES_INFO_RESP3 : TSInfo.TIMESERIES_INFO;
    }

    public final CommandObject<String> bfReserve(String key2, double errorRate, long capacity) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.RESERVE).key(key2).add(errorRate).add(capacity), BuilderFactory.STRING);
    }

    public final CommandObject<String> bfReserve(String key2, double errorRate, long capacity, BFReserveParams reserveParams) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.RESERVE).key(key2).add(errorRate).add(capacity).addParams(reserveParams), BuilderFactory.STRING);
    }

    public final CommandObject<Boolean> bfAdd(String key2, String item) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.ADD).key(key2).add(item), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> bfMAdd(String key2, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.MADD).key(key2).addObjects(items2), BuilderFactory.BOOLEAN_WITH_ERROR_LIST);
    }

    public final CommandObject<List<Boolean>> bfInsert(String key2, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.INSERT).key(key2).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(items2), BuilderFactory.BOOLEAN_WITH_ERROR_LIST);
    }

    public final CommandObject<List<Boolean>> bfInsert(String key2, BFInsertParams insertParams, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.INSERT).key(key2).addParams(insertParams).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(items2), BuilderFactory.BOOLEAN_WITH_ERROR_LIST);
    }

    public final CommandObject<Boolean> bfExists(String key2, String item) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.EXISTS).key(key2).add(item), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> bfMExists(String key2, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.MEXISTS).key(key2).addObjects(items2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<Map.Entry<Long, byte[]>> bfScanDump(String key2, long iterator2) {
        return new CommandObject<Map.Entry<Long, byte[]>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.SCANDUMP).key(key2).add(iterator2), BLOOM_SCANDUMP_RESPONSE);
    }

    public final CommandObject<String> bfLoadChunk(String key2, long iterator2, byte[] data2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.LOADCHUNK).key(key2).add(iterator2).add(data2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> bfCard(String key2) {
        return new CommandObject<Long>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.CARD).key(key2), BuilderFactory.LONG);
    }

    public final CommandObject<Map<String, Object>> bfInfo(String key2) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.INFO).key(key2), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> cfReserve(String key2, long capacity) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.RESERVE).key(key2).add(capacity), BuilderFactory.STRING);
    }

    public final CommandObject<String> cfReserve(String key2, long capacity, CFReserveParams reserveParams) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.RESERVE).key(key2).add(capacity).addParams(reserveParams), BuilderFactory.STRING);
    }

    public final CommandObject<Boolean> cfAdd(String key2, String item) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.ADD).key(key2).add(item), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> cfAddNx(String key2, String item) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.ADDNX).key(key2).add(item), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> cfInsert(String key2, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INSERT).key(key2).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(items2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> cfInsert(String key2, CFInsertParams insertParams, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INSERT).key(key2).addParams(insertParams).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(items2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> cfInsertNx(String key2, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INSERTNX).key(key2).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(items2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> cfInsertNx(String key2, CFInsertParams insertParams, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INSERTNX).key(key2).addParams(insertParams).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(items2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<Boolean> cfExists(String key2, String item) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.EXISTS).key(key2).add(item), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> cfMExists(String key2, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.MEXISTS).key(key2).addObjects(items2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<Boolean> cfDel(String key2, String item) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.DEL).key(key2).add(item), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> cfCount(String key2, String item) {
        return new CommandObject<Long>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.COUNT).key(key2).add(item), BuilderFactory.LONG);
    }

    public final CommandObject<Map.Entry<Long, byte[]>> cfScanDump(String key2, long iterator2) {
        return new CommandObject<Map.Entry<Long, byte[]>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.SCANDUMP).key(key2).add(iterator2), BLOOM_SCANDUMP_RESPONSE);
    }

    public final CommandObject<String> cfLoadChunk(String key2, long iterator2, byte[] data2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.LOADCHUNK).key(key2).add(iterator2).add(data2), BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, Object>> cfInfo(String key2) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INFO).key(key2), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> cmsInitByDim(String key2, long width, long depth) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.INITBYDIM).key(key2).add(width).add(depth), BuilderFactory.STRING);
    }

    public final CommandObject<String> cmsInitByProb(String key2, double error2, double probability) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.INITBYPROB).key(key2).add(error2).add(probability), BuilderFactory.STRING);
    }

    public final CommandObject<List<Long>> cmsIncrBy(String key2, Map<String, Long> itemIncrements) {
        CommandArguments args2 = this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.INCRBY).key(key2);
        itemIncrements.entrySet().forEach(entry -> args2.add((String)entry.getKey()).add(entry.getValue()));
        return new CommandObject<List<Long>>(args2, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> cmsQuery(String key2, String ... items2) {
        return new CommandObject<List<Long>>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.QUERY).key(key2).addObjects(items2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<String> cmsMerge(String destKey, String ... keys2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.MERGE).key(destKey).add(keys2.length).keys(keys2), BuilderFactory.STRING);
    }

    public final CommandObject<String> cmsMerge(String destKey, Map<String, Long> keysAndWeights) {
        CommandArguments args2 = this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.MERGE).key(destKey);
        args2.add(keysAndWeights.size());
        keysAndWeights.entrySet().forEach(entry -> args2.key(entry.getKey()));
        args2.add(RedisBloomProtocol.RedisBloomKeyword.WEIGHTS);
        keysAndWeights.entrySet().forEach(entry -> args2.add(entry.getValue()));
        return new CommandObject<String>(args2, BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, Object>> cmsInfo(String key2) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.INFO).key(key2), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> topkReserve(String key2, long topk) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TopKCommand.RESERVE).key(key2).add(topk), BuilderFactory.STRING);
    }

    public final CommandObject<String> topkReserve(String key2, long topk, long width, long depth, double decay) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TopKCommand.RESERVE).key(key2).add(topk).add(width).add(depth).add(decay), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> topkAdd(String key2, String ... items2) {
        return new CommandObject<List<String>>(this.commandArguments(RedisBloomProtocol.TopKCommand.ADD).key(key2).addObjects(items2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> topkIncrBy(String key2, Map<String, Long> itemIncrements) {
        CommandArguments args2 = this.commandArguments(RedisBloomProtocol.TopKCommand.INCRBY).key(key2);
        itemIncrements.entrySet().forEach(entry -> args2.add((String)entry.getKey()).add(entry.getValue()));
        return new CommandObject<List<String>>(args2, BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Boolean>> topkQuery(String key2, String ... items2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.TopKCommand.QUERY).key(key2).addObjects(items2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<String>> topkList(String key2) {
        return new CommandObject<List<String>>(this.commandArguments(RedisBloomProtocol.TopKCommand.LIST).key(key2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Map<String, Long>> topkListWithCount(String key2) {
        return new CommandObject<Map<String, Long>>(this.commandArguments(RedisBloomProtocol.TopKCommand.LIST).key(key2).add(RedisBloomProtocol.RedisBloomKeyword.WITHCOUNT), BuilderFactory.STRING_LONG_MAP);
    }

    public final CommandObject<Map<String, Object>> topkInfo(String key2) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.TopKCommand.INFO).key(key2), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> tdigestCreate(String key2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.CREATE).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<String> tdigestCreate(String key2, int compression) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.CREATE).key(key2).add(RedisBloomProtocol.RedisBloomKeyword.COMPRESSION).add(compression), BuilderFactory.STRING);
    }

    public final CommandObject<String> tdigestReset(String key2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.RESET).key(key2), BuilderFactory.STRING);
    }

    public final CommandObject<String> tdigestMerge(String destinationKey, String ... sourceKeys) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.MERGE).key(destinationKey).add(sourceKeys.length).keys(sourceKeys), BuilderFactory.STRING);
    }

    public final CommandObject<String> tdigestMerge(TDigestMergeParams mergeParams, String destinationKey, String ... sourceKeys) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.MERGE).key(destinationKey).add(sourceKeys.length).keys(sourceKeys).addParams(mergeParams), BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, Object>> tdigestInfo(String key2) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.TDigestCommand.INFO).key(key2), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> tdigestAdd(String key2, double ... values2) {
        return new CommandObject<String>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.ADD).key(key2), values2), BuilderFactory.STRING);
    }

    public final CommandObject<List<Double>> tdigestCDF(String key2, double ... values2) {
        return new CommandObject<List<Double>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.CDF).key(key2), values2), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<List<Double>> tdigestQuantile(String key2, double ... quantiles) {
        return new CommandObject<List<Double>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.QUANTILE).key(key2), quantiles), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<Double> tdigestMin(String key2) {
        return new CommandObject<Double>(this.commandArguments(RedisBloomProtocol.TDigestCommand.MIN).key(key2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> tdigestMax(String key2) {
        return new CommandObject<Double>(this.commandArguments(RedisBloomProtocol.TDigestCommand.MAX).key(key2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> tdigestTrimmedMean(String key2, double lowCutQuantile, double highCutQuantile) {
        return new CommandObject<Double>(this.commandArguments(RedisBloomProtocol.TDigestCommand.TRIMMED_MEAN).key(key2).add(lowCutQuantile).add(highCutQuantile), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<Long>> tdigestRank(String key2, double ... values2) {
        return new CommandObject<List<Long>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.RANK).key(key2), values2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> tdigestRevRank(String key2, double ... values2) {
        return new CommandObject<List<Long>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.REVRANK).key(key2), values2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Double>> tdigestByRank(String key2, long ... ranks) {
        return new CommandObject<List<Double>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.BYRANK).key(key2), ranks), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<List<Double>> tdigestByRevRank(String key2, long ... ranks) {
        return new CommandObject<List<Double>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.BYREVRANK).key(key2), ranks), BuilderFactory.DOUBLE_LIST);
    }

    @Deprecated
    public final CommandObject<List<String>> graphList() {
        return new CommandObject<List<String>>(this.commandArguments(GraphProtocol.GraphCommand.LIST), BuilderFactory.STRING_LIST);
    }

    @Deprecated
    public final CommandObject<List<String>> graphProfile(String graphName, String query2) {
        return new CommandObject<List<String>>(this.commandArguments(GraphProtocol.GraphCommand.PROFILE).key(graphName).add(query2), BuilderFactory.STRING_LIST);
    }

    @Deprecated
    public final CommandObject<List<String>> graphExplain(String graphName, String query2) {
        return new CommandObject<List<String>>(this.commandArguments(GraphProtocol.GraphCommand.EXPLAIN).key(graphName).add(query2), BuilderFactory.STRING_LIST);
    }

    @Deprecated
    public final CommandObject<List<List<Object>>> graphSlowlog(String graphName) {
        return new CommandObject<List<List<Object>>>(this.commandArguments(GraphProtocol.GraphCommand.SLOWLOG).key(graphName), BuilderFactory.ENCODED_OBJECT_LIST_LIST);
    }

    @Deprecated
    public final CommandObject<String> graphConfigSet(String configName, Object value2) {
        return new CommandObject<String>(this.commandArguments(GraphProtocol.GraphCommand.CONFIG).add(GraphProtocol.GraphKeyword.SET).add(configName).add(value2), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<Map<String, Object>> graphConfigGet(String configName) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(GraphProtocol.GraphCommand.CONFIG).add(GraphProtocol.GraphKeyword.GET).add(configName), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    @Deprecated
    public final CommandObject<String> tFunctionLoad(String libraryCode, TFunctionLoadParams params) {
        return new CommandObject<String>(this.commandArguments(RedisGearsProtocol.GearsCommand.TFUNCTION).add(RedisGearsProtocol.GearsKeyword.LOAD).addParams(params).add(libraryCode), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<String> tFunctionDelete(String libraryName) {
        return new CommandObject<String>(this.commandArguments(RedisGearsProtocol.GearsCommand.TFUNCTION).add(RedisGearsProtocol.GearsKeyword.DELETE).add(libraryName), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<List<GearsLibraryInfo>> tFunctionList(TFunctionListParams params) {
        return new CommandObject<List<GearsLibraryInfo>>(this.commandArguments(RedisGearsProtocol.GearsCommand.TFUNCTION).add(RedisGearsProtocol.GearsKeyword.LIST).addParams(params), GearsLibraryInfo.GEARS_LIBRARY_INFO_LIST);
    }

    @Deprecated
    public final CommandObject<Object> tFunctionCall(String library, String function, List<String> keys2, List<String> args2) {
        return new CommandObject<Object>(this.commandArguments(RedisGearsProtocol.GearsCommand.TFCALL).add(library + "." + function).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    @Deprecated
    public final CommandObject<Object> tFunctionCallAsync(String library, String function, List<String> keys2, List<String> args2) {
        return new CommandObject<Object>(this.commandArguments(RedisGearsProtocol.GearsCommand.TFCALLASYNC).add(library + "." + function).add(keys2.size()).keys(keys2).addObjects(args2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT);
    }

    public final CommandObject<String> watch(String ... keys2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.WATCH).keys(keys2), BuilderFactory.STRING);
    }

    public final CommandObject<String> watch(byte[] ... keys2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.WATCH).keys((Object[])keys2), BuilderFactory.STRING);
    }

    private JsonObjectMapper getJsonObjectMapper() {
        JsonObjectMapper localRef = this.jsonObjectMapper;
        if (Objects.isNull(localRef)) {
            this.mapperLock.lock();
            try {
                localRef = this.jsonObjectMapper;
                if (Objects.isNull(localRef)) {
                    this.jsonObjectMapper = localRef = new DefaultGsonObjectMapper();
                }
            }
            finally {
                this.mapperLock.unlock();
            }
        }
        return localRef;
    }

    public void setJsonObjectMapper(JsonObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public void setDefaultSearchDialect(int dialect) {
        if (dialect == 0) {
            throw new IllegalArgumentException("DIALECT=0 cannot be set.");
        }
        this.searchDialect.set(dialect);
    }

    private CommandArguments addFlatArgs(CommandArguments args2, long ... values2) {
        for (long value2 : values2) {
            args2.add(value2);
        }
        return args2;
    }

    private CommandArguments addFlatArgs(CommandArguments args2, double ... values2) {
        for (double value2 : values2) {
            args2.add(value2);
        }
        return args2;
    }

    private CommandArguments addFlatKeyValueArgs(CommandArguments args2, String ... keyvalues) {
        for (int i2 = 0; i2 < keyvalues.length; i2 += 2) {
            args2.key(keyvalues[i2]).add(keyvalues[i2 + 1]);
        }
        return args2;
    }

    private CommandArguments addFlatKeyValueArgs(CommandArguments args2, byte[] ... keyvalues) {
        for (int i2 = 0; i2 < keyvalues.length; i2 += 2) {
            args2.key(keyvalues[i2]).add(keyvalues[i2 + 1]);
        }
        return args2;
    }

    private CommandArguments addFlatMapArgs(CommandArguments args2, Map<?, ?> map2) {
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            args2.add(entry.getKey());
            args2.add(entry.getValue());
        }
        return args2;
    }

    private CommandArguments addSortedSetFlatMapArgs(CommandArguments args2, Map<?, Double> map2) {
        for (Map.Entry<?, Double> entry : map2.entrySet()) {
            args2.add(entry.getValue());
            args2.add(entry.getKey());
        }
        return args2;
    }

    private CommandArguments addGeoCoordinateFlatMapArgs(CommandArguments args2, Map<?, GeoCoordinate> map2) {
        for (Map.Entry<?, GeoCoordinate> entry : map2.entrySet()) {
            GeoCoordinate ord = entry.getValue();
            args2.add(ord.getLongitude());
            args2.add(ord.getLatitude());
            args2.add(entry.getKey());
        }
        return args2;
    }

    private class JsonObjectListBuilder<T>
    extends Builder<List<T>> {
        private final Class<T> clazz;

        public JsonObjectListBuilder(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public List<T> build(Object data2) {
            if (data2 == null) {
                return null;
            }
            List<String> list = BuilderFactory.STRING_LIST.build(data2);
            return list.stream().map(s2 -> CommandObjects.this.getJsonObjectMapper().fromJson((String)s2, this.clazz)).collect(Collectors.toList());
        }
    }

    private class JsonObjectBuilder<T>
    extends Builder<T> {
        private final Class<T> clazz;

        public JsonObjectBuilder(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T build(Object data2) {
            return CommandObjects.this.getJsonObjectMapper().fromJson(BuilderFactory.STRING.build(data2), this.clazz);
        }
    }

    private class SearchProfileResponseBuilder<T>
    extends Builder<Map.Entry<T, Map<String, Object>>> {
        private static final String PROFILE_STR = "profile";
        private final Builder<T> replyBuilder;

        public SearchProfileResponseBuilder(Builder<T> replyBuilder) {
            this.replyBuilder = replyBuilder;
        }

        @Override
        public Map.Entry<T, Map<String, Object>> build(Object data2) {
            List list = (List)data2;
            if (list == null || list.isEmpty()) {
                return null;
            }
            if (list.get(0) instanceof KeyValue) {
                for (KeyValue keyValue : (List)data2) {
                    if (!PROFILE_STR.equals(BuilderFactory.STRING.build(keyValue.getKey()))) continue;
                    return KeyValue.of(this.replyBuilder.build(data2), BuilderFactory.AGGRESSIVE_ENCODED_OBJECT_MAP.build(keyValue.getValue()));
                }
            }
            return KeyValue.of(this.replyBuilder.build(list.get(0)), SearchBuilderFactory.SEARCH_PROFILE_PROFILE.build(list.get(1)));
        }
    }
}

