/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.ClientSetInfoConfig;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.DefaultRedisCredentials;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisMetaInfo;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisCredentials;
import redis.clients.jedis.RedisCredentialsProvider;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.args.ClientAttributeOption;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisValidationException;
import redis.clients.jedis.util.IOUtils;
import redis.clients.jedis.util.RedisInputStream;
import redis.clients.jedis.util.RedisOutputStream;
import redis.clients.jedis.util.SafeEncoder;

public class Connection
implements Closeable {
    private ConnectionPool memberOf;
    protected RedisProtocol protocol;
    private final JedisSocketFactory socketFactory;
    private Socket socket;
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int soTimeout = 0;
    private int infiniteSoTimeout = 0;
    private boolean broken = false;
    private boolean strValActive;
    private String strVal;
    protected String server;
    protected String version;

    public Connection() {
        this("127.0.0.1", 6379);
    }

    public Connection(String host2, int port2) {
        this(new HostAndPort(host2, port2));
    }

    public Connection(HostAndPort hostAndPort) {
        this(new DefaultJedisSocketFactory(hostAndPort));
    }

    public Connection(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new DefaultJedisSocketFactory(hostAndPort, clientConfig), clientConfig);
    }

    public Connection(JedisSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public Connection(JedisSocketFactory socketFactory, JedisClientConfig clientConfig) {
        this.socketFactory = socketFactory;
        this.soTimeout = clientConfig.getSocketTimeoutMillis();
        this.infiniteSoTimeout = clientConfig.getBlockingSocketTimeoutMillis();
        this.initializeFromClientConfig(clientConfig);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.socketFactory + "}";
    }

    @Experimental
    public String toIdentityString() {
        if (this.strValActive == this.broken && this.strVal != null) {
            return this.strVal;
        }
        String className = this.getClass().getSimpleName();
        int id = this.hashCode();
        if (this.socket == null) {
            return String.format("%s{id: 0x%X}", className, id);
        }
        SocketAddress remoteAddr = this.socket.getRemoteSocketAddress();
        SocketAddress localAddr = this.socket.getLocalSocketAddress();
        this.strVal = remoteAddr != null ? String.format("%s{id: 0x%X, L:%s %c R:%s}", className, id, localAddr, Character.valueOf(this.broken ? (char)'!' : '-'), remoteAddr) : (localAddr != null ? String.format("%s{id: 0x%X, L:%s}", className, id, localAddr) : String.format("%s{id: 0x%X}", className, id));
        this.strValActive = this.broken;
        return this.strVal;
    }

    public final RedisProtocol getRedisProtocol() {
        return this.protocol;
    }

    public final void setHandlingPool(ConnectionPool pool) {
        this.memberOf = pool;
    }

    final HostAndPort getHostAndPort() {
        return ((DefaultJedisSocketFactory)this.socketFactory).getHostAndPort();
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(soTimeout);
            }
            catch (SocketException ex) {
                this.setBroken();
                throw new JedisConnectionException(ex);
            }
        }
    }

    public void setTimeoutInfinite() {
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            this.socket.setSoTimeout(this.infiniteSoTimeout);
        }
        catch (SocketException ex) {
            this.setBroken();
            throw new JedisConnectionException(ex);
        }
    }

    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.soTimeout);
        }
        catch (SocketException ex) {
            this.setBroken();
            throw new JedisConnectionException(ex);
        }
    }

    public Object executeCommand(ProtocolCommand cmd) {
        return this.executeCommand(new CommandArguments(cmd));
    }

    public Object executeCommand(CommandArguments args2) {
        this.sendCommand(args2);
        return this.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeCommand(CommandObject<T> commandObject) {
        CommandArguments args2 = commandObject.getArguments();
        this.sendCommand(args2);
        if (!args2.isBlocking()) {
            return commandObject.getBuilder().build(this.getOne());
        }
        try {
            this.setTimeoutInfinite();
            T t2 = commandObject.getBuilder().build(this.getOne());
            return t2;
        }
        finally {
            this.rollbackTimeout();
        }
    }

    public void sendCommand(ProtocolCommand cmd) {
        this.sendCommand(new CommandArguments(cmd));
    }

    public void sendCommand(ProtocolCommand cmd, Rawable keyword) {
        this.sendCommand(new CommandArguments(cmd).add(keyword));
    }

    public void sendCommand(ProtocolCommand cmd, String ... args2) {
        this.sendCommand(new CommandArguments(cmd).addObjects(args2));
    }

    public void sendCommand(ProtocolCommand cmd, byte[] ... args2) {
        this.sendCommand(new CommandArguments(cmd).addObjects((Object[])args2));
    }

    public void sendCommand(CommandArguments args2) {
        try {
            this.connect();
            Protocol.sendCommand(this.outputStream, args2);
        }
        catch (JedisConnectionException ex) {
            try {
                String errorMessage = Protocol.readErrorLineIfPossible(this.inputStream);
                if (errorMessage != null && errorMessage.length() > 0) {
                    ex = new JedisConnectionException(errorMessage, ex.getCause());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBroken();
            throw ex;
        }
    }

    public void connect() throws JedisConnectionException {
        if (!this.isConnected()) {
            try {
                this.socket = this.socketFactory.createSocket();
                this.soTimeout = this.socket.getSoTimeout();
                this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
                this.inputStream = new RedisInputStream(this.socket.getInputStream());
                this.broken = false;
            }
            catch (JedisConnectionException jce) {
                this.setBroken();
                throw jce;
            }
            catch (IOException ioe) {
                this.setBroken();
                throw new JedisConnectionException("Failed to create input/output stream", ioe);
            }
            finally {
                if (this.broken) {
                    IOUtils.closeQuietly(this.socket);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.memberOf != null) {
            ConnectionPool pool = this.memberOf;
            this.memberOf = null;
            if (this.isBroken()) {
                pool.returnBrokenResource(this);
            } else {
                pool.returnResource(this);
            }
        } else {
            this.disconnect();
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.outputStream.flush();
                this.socket.close();
            }
            catch (IOException ex) {
                throw new JedisConnectionException(ex);
            }
            finally {
                IOUtils.closeQuietly(this.socket);
                this.setBroken();
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken() {
        this.broken = true;
    }

    public String getStatusCodeReply() {
        this.flush();
        byte[] resp = (byte[])this.readProtocolWithCheckingBroken();
        if (null == resp) {
            return null;
        }
        return SafeEncoder.encode(resp);
    }

    public String getBulkReply() {
        byte[] result2 = this.getBinaryBulkReply();
        if (null != result2) {
            return SafeEncoder.encode(result2);
        }
        return null;
    }

    public byte[] getBinaryBulkReply() {
        this.flush();
        return (byte[])this.readProtocolWithCheckingBroken();
    }

    public Long getIntegerReply() {
        this.flush();
        return (Long)this.readProtocolWithCheckingBroken();
    }

    public List<String> getMultiBulkReply() {
        return BuilderFactory.STRING_LIST.build(this.getBinaryMultiBulkReply());
    }

    public List<byte[]> getBinaryMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    @Deprecated
    public List<Object> getUnflushedObjectMultiBulkReply() {
        return (List)this.readProtocolWithCheckingBroken();
    }

    public Object getUnflushedObject() {
        return this.readProtocolWithCheckingBroken();
    }

    public List<Object> getObjectMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    public List<Long> getIntegerMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    public Object getOne() {
        this.flush();
        return this.readProtocolWithCheckingBroken();
    }

    protected void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException ex) {
            this.setBroken();
            throw new JedisConnectionException(ex);
        }
    }

    @Experimental
    protected Object protocolRead(RedisInputStream is) {
        return Protocol.read(is);
    }

    @Experimental
    protected void protocolReadPushes(RedisInputStream is) {
    }

    protected Object readProtocolWithCheckingBroken() {
        if (this.broken) {
            throw new JedisConnectionException("Attempting to read from a broken connection.");
        }
        try {
            return this.protocolRead(this.inputStream);
        }
        catch (JedisConnectionException exc) {
            this.broken = true;
            throw exc;
        }
    }

    protected void readPushesWithCheckingBroken() {
        if (this.broken) {
            throw new JedisConnectionException("Attempting to read from a broken connection.");
        }
        try {
            if (this.inputStream.available() > 0) {
                this.protocolReadPushes(this.inputStream);
            }
        }
        catch (IOException e2) {
            this.broken = true;
            throw new JedisConnectionException("Failed to check buffer on connection.", e2);
        }
        catch (JedisConnectionException exc) {
            this.setBroken();
            throw exc;
        }
    }

    public List<Object> getMany(int count2) {
        this.flush();
        ArrayList<Object> responses2 = new ArrayList<Object>(count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            try {
                responses2.add(this.readProtocolWithCheckingBroken());
                continue;
            }
            catch (JedisDataException e2) {
                responses2.add(e2);
            }
        }
        return responses2;
    }

    private static boolean validateClientInfo(String info) {
        for (int i2 = 0; i2 < info.length(); ++i2) {
            char c2 = info.charAt(i2);
            if (c2 >= '!' && c2 <= '~') continue;
            throw new JedisValidationException("client info cannot contain spaces, newlines or special characters.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeFromClientConfig(JedisClientConfig config2) {
        try {
            ClientSetInfoConfig setInfoConfig;
            this.connect();
            this.protocol = config2.getRedisProtocol();
            Supplier<RedisCredentials> credentialsProvider = config2.getCredentialsProvider();
            if (credentialsProvider instanceof RedisCredentialsProvider) {
                RedisCredentialsProvider redisCredentialsProvider = (RedisCredentialsProvider)credentialsProvider;
                try {
                    redisCredentialsProvider.prepare();
                    this.helloAndAuth(this.protocol, (RedisCredentials)redisCredentialsProvider.get());
                }
                finally {
                    redisCredentialsProvider.cleanUp();
                }
            } else {
                this.helloAndAuth(this.protocol, credentialsProvider != null ? credentialsProvider.get() : new DefaultRedisCredentials(config2.getUser(), config2.getPassword()));
            }
            ArrayList<CommandArguments> fireAndForgetMsg = new ArrayList<CommandArguments>();
            String clientName = config2.getClientName();
            if (clientName != null && Connection.validateClientInfo(clientName)) {
                fireAndForgetMsg.add(new CommandArguments(Protocol.Command.CLIENT).add(Protocol.Keyword.SETNAME).add(clientName));
            }
            if ((setInfoConfig = config2.getClientSetInfoConfig()) == null) {
                setInfoConfig = ClientSetInfoConfig.DEFAULT;
            }
            if (!setInfoConfig.isDisabled()) {
                String libVersion;
                Object libName = JedisMetaInfo.getArtifactId();
                if (libName != null && Connection.validateClientInfo((String)libName)) {
                    String libNameSuffix = setInfoConfig.getLibNameSuffix();
                    if (libNameSuffix != null) {
                        libName = (String)libName + '(' + libNameSuffix + ')';
                    }
                    fireAndForgetMsg.add(new CommandArguments(Protocol.Command.CLIENT).add(Protocol.Keyword.SETINFO).add(ClientAttributeOption.LIB_NAME.getRaw()).add((String)libName));
                }
                if ((libVersion = JedisMetaInfo.getVersion()) != null && Connection.validateClientInfo(libVersion)) {
                    fireAndForgetMsg.add(new CommandArguments(Protocol.Command.CLIENT).add(Protocol.Keyword.SETINFO).add(ClientAttributeOption.LIB_VER.getRaw()).add(libVersion));
                }
            }
            if (config2.isReadOnlyForRedisClusterReplicas()) {
                fireAndForgetMsg.add(new CommandArguments(Protocol.Command.READONLY));
            }
            for (CommandArguments arg : fireAndForgetMsg) {
                this.sendCommand(arg);
            }
            this.getMany(fireAndForgetMsg.size());
            int dbIndex = config2.getDatabase();
            if (dbIndex > 0) {
                this.select(dbIndex);
            }
        }
        catch (JedisException je) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw je;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helloAndAuth(RedisProtocol protocol, RedisCredentials credentials) {
        Map<String, Object> helloResult = null;
        if (protocol != null && credentials != null && credentials.getUser() != null) {
            byte[] rawPass = this.encodeToBytes(credentials.getPassword());
            try {
                helloResult = this.hello(SafeEncoder.encode(protocol.version()), Protocol.Keyword.AUTH.getRaw(), SafeEncoder.encode(credentials.getUser()), rawPass);
            }
            finally {
                Arrays.fill(rawPass, (byte)0);
            }
        } else {
            this.auth(credentials);
            Map<String, Object> map2 = helloResult = protocol == null ? null : this.hello(new byte[][]{SafeEncoder.encode(protocol.version())});
        }
        if (helloResult != null) {
            this.server = (String)helloResult.get("server");
            this.version = (String)helloResult.get("version");
        }
    }

    private void auth(RedisCredentials credentials) {
        if (credentials == null || credentials.getPassword() == null) {
            return;
        }
        byte[] rawPass = this.encodeToBytes(credentials.getPassword());
        try {
            if (credentials.getUser() == null) {
                this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, new byte[][]{rawPass});
            } else {
                this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, SafeEncoder.encode(credentials.getUser()), rawPass);
            }
        }
        finally {
            Arrays.fill(rawPass, (byte)0);
        }
        this.getStatusCodeReply();
    }

    protected Map<String, Object> hello(byte[] ... args2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HELLO, args2);
        return BuilderFactory.ENCODED_OBJECT_MAP.build(this.getOne());
    }

    protected byte[] encodeToBytes(char[] chars) {
        ByteBuffer passBuf = Protocol.CHARSET.encode(CharBuffer.wrap(chars));
        byte[] rawPass = Arrays.copyOfRange(passBuf.array(), passBuf.position(), passBuf.limit());
        Arrays.fill(passBuf.array(), (byte)0);
        return rawPass;
    }

    public String select(int index) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index)});
        return this.getStatusCodeReply();
    }

    public boolean ping() {
        this.sendCommand(Protocol.Command.PING);
        String status2 = this.getStatusCodeReply();
        if (!"PONG".equals(status2)) {
            throw new JedisException(status2);
        }
        return true;
    }
}

