/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.ClusterCommandArguments;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.Module;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.args.BitCountOption;
import redis.clients.jedis.args.BitOP;
import redis.clients.jedis.args.ClientAttributeOption;
import redis.clients.jedis.args.ClientPauseMode;
import redis.clients.jedis.args.ClientType;
import redis.clients.jedis.args.ClusterFailoverOption;
import redis.clients.jedis.args.ClusterResetType;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.args.FlushMode;
import redis.clients.jedis.args.FunctionRestorePolicy;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.args.LatencyEvent;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.args.ListPosition;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.SortedSetOption;
import redis.clients.jedis.args.UnblockType;
import redis.clients.jedis.commands.ClusterCommands;
import redis.clients.jedis.commands.ControlBinaryCommands;
import redis.clients.jedis.commands.ControlCommands;
import redis.clients.jedis.commands.DatabaseCommands;
import redis.clients.jedis.commands.GenericControlCommands;
import redis.clients.jedis.commands.JedisBinaryCommands;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.ModuleCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.SentinelCommands;
import redis.clients.jedis.commands.ServerCommands;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.params.BitPosParams;
import redis.clients.jedis.params.ClientKillParams;
import redis.clients.jedis.params.CommandListFilterByParams;
import redis.clients.jedis.params.FailoverParams;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoRadiusStoreParam;
import redis.clients.jedis.params.GeoSearchParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LCSParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.LolwutParams;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.ModuleLoadExParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ShutdownParams;
import redis.clients.jedis.params.SortingParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.params.ZParams;
import redis.clients.jedis.params.ZRangeParams;
import redis.clients.jedis.resps.AccessControlLogEntry;
import redis.clients.jedis.resps.AccessControlUser;
import redis.clients.jedis.resps.ClusterShardInfo;
import redis.clients.jedis.resps.CommandDocument;
import redis.clients.jedis.resps.CommandInfo;
import redis.clients.jedis.resps.FunctionStats;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.resps.LCSMatchResult;
import redis.clients.jedis.resps.LatencyHistoryInfo;
import redis.clients.jedis.resps.LatencyLatestInfo;
import redis.clients.jedis.resps.LibraryInfo;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.resps.Slowlog;
import redis.clients.jedis.resps.StreamConsumerInfo;
import redis.clients.jedis.resps.StreamConsumersInfo;
import redis.clients.jedis.resps.StreamEntry;
import redis.clients.jedis.resps.StreamFullInfo;
import redis.clients.jedis.resps.StreamGroupInfo;
import redis.clients.jedis.resps.StreamInfo;
import redis.clients.jedis.resps.StreamPendingEntry;
import redis.clients.jedis.resps.StreamPendingSummary;
import redis.clients.jedis.resps.TrackingInfo;
import redis.clients.jedis.resps.Tuple;
import redis.clients.jedis.util.JedisURIHelper;
import redis.clients.jedis.util.KeyValue;
import redis.clients.jedis.util.Pool;
import redis.clients.jedis.util.SafeEncoder;

public class Jedis
implements ServerCommands,
DatabaseCommands,
JedisCommands,
JedisBinaryCommands,
ControlCommands,
ControlBinaryCommands,
ClusterCommands,
ModuleCommands,
GenericControlCommands,
SentinelCommands,
Closeable {
    protected final Connection connection;
    private final CommandObjects commandObjects = new CommandObjects();
    private int db = 0;
    private Transaction transaction = null;
    private boolean isInMulti = false;
    private boolean isInWatch = false;
    private Pipeline pipeline = null;
    protected static final byte[][] DUMMY_ARRAY = new byte[0][];
    private Pool<Jedis> dataSource = null;

    public Jedis() {
        this.connection = new Connection();
    }

    public Jedis(String url2) {
        this(URI.create(url2));
    }

    public Jedis(HostAndPort hp) {
        this.connection = new Connection(hp);
    }

    public Jedis(String host2, int port2) {
        this.connection = new Connection(host2, port2);
    }

    public Jedis(String host2, int port2, JedisClientConfig config2) {
        this(new HostAndPort(host2, port2), config2);
    }

    public Jedis(HostAndPort hostPort, JedisClientConfig config2) {
        this.connection = new Connection(hostPort, config2);
        RedisProtocol proto = config2.getRedisProtocol();
        if (proto != null) {
            this.commandObjects.setProtocol(proto);
        }
    }

    public Jedis(String host2, int port2, boolean ssl) {
        this(host2, port2, DefaultJedisClientConfig.builder().ssl(ssl).build());
    }

    public Jedis(String host2, int port2, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host2, port2, DefaultJedisClientConfig.builder().ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(String host2, int port2, int timeout2) {
        this(host2, port2, timeout2, timeout2);
    }

    public Jedis(String host2, int port2, int timeout2, boolean ssl) {
        this(host2, port2, timeout2, timeout2, ssl);
    }

    public Jedis(String host2, int port2, int timeout2, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host2, port2, timeout2, timeout2, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(String host2, int port2, int connectionTimeout, int soTimeout) {
        this(host2, port2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).build());
    }

    public Jedis(String host2, int port2, int connectionTimeout, int soTimeout, int infiniteSoTimeout) {
        this(host2, port2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).build());
    }

    public Jedis(String host2, int port2, int connectionTimeout, int soTimeout, boolean ssl) {
        this(host2, port2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).ssl(ssl).build());
    }

    public Jedis(String host2, int port2, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host2, port2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(String host2, int port2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host2, port2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(URI uri2) {
        if (!JedisURIHelper.isValid(uri2)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI \"%s\".", uri2.toString()));
        }
        this.connection = new Connection(new HostAndPort(uri2.getHost(), uri2.getPort()), (JedisClientConfig)DefaultJedisClientConfig.builder().user(JedisURIHelper.getUser(uri2)).password(JedisURIHelper.getPassword(uri2)).database(JedisURIHelper.getDBIndex(uri2)).protocol(JedisURIHelper.getRedisProtocol(uri2)).ssl(JedisURIHelper.isRedisSSLScheme(uri2)).build());
    }

    public Jedis(URI uri2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri2, (JedisClientConfig)DefaultJedisClientConfig.builder().sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(URI uri2, int timeout2) {
        this(uri2, timeout2, timeout2);
    }

    public Jedis(URI uri2, int timeout2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri2, timeout2, timeout2, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri2, int connectionTimeout, int soTimeout) {
        this(uri2, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).build());
    }

    public Jedis(URI uri2, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri2, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(URI uri2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri2, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(URI uri2, JedisClientConfig config2) {
        if (!JedisURIHelper.isValid(uri2)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI \"%s\".", uri2.toString()));
        }
        this.connection = new Connection(new HostAndPort(uri2.getHost(), uri2.getPort()), (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(config2.getConnectionTimeoutMillis()).socketTimeoutMillis(config2.getSocketTimeoutMillis()).blockingSocketTimeoutMillis(config2.getBlockingSocketTimeoutMillis()).user(JedisURIHelper.getUser(uri2)).password(JedisURIHelper.getPassword(uri2)).database(JedisURIHelper.getDBIndex(uri2)).clientName(config2.getClientName()).protocol(JedisURIHelper.getRedisProtocol(uri2)).ssl(JedisURIHelper.isRedisSSLScheme(uri2)).sslSocketFactory(config2.getSslSocketFactory()).sslParameters(config2.getSslParameters()).hostnameVerifier(config2.getHostnameVerifier()).build());
        RedisProtocol proto = config2.getRedisProtocol();
        if (proto != null) {
            this.commandObjects.setProtocol(proto);
        }
    }

    public Jedis(JedisSocketFactory jedisSocketFactory) {
        this.connection = new Connection(jedisSocketFactory);
    }

    public Jedis(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this.connection = new Connection(jedisSocketFactory, clientConfig);
        RedisProtocol proto = clientConfig.getRedisProtocol();
        if (proto != null) {
            this.commandObjects.setProtocol(proto);
        }
    }

    public Jedis(Connection connection) {
        this.connection = connection;
    }

    public String toString() {
        return "Jedis{" + this.connection + '}';
    }

    public Connection getClient() {
        return this.getConnection();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void connect() {
        this.connection.connect();
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public boolean isBroken() {
        return this.connection.isBroken();
    }

    public void resetState() {
        if (this.isConnected()) {
            if (this.transaction != null) {
                this.transaction.close();
            }
            if (this.pipeline != null) {
                this.pipeline.close();
            }
            if (this.isInWatch) {
                this.connection.sendCommand(Protocol.Command.UNWATCH);
                this.connection.getStatusCodeReply();
                this.isInWatch = false;
            }
        }
        this.transaction = null;
        this.pipeline = null;
    }

    protected void setDataSource(Pool<Jedis> jedisPool) {
        this.dataSource = jedisPool;
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            Pool<Jedis> pool = this.dataSource;
            this.dataSource = null;
            if (this.isBroken()) {
                pool.returnBrokenResource(this);
            } else {
                pool.returnResource(this);
            }
        } else {
            this.connection.close();
        }
    }

    public Transaction multi() {
        this.transaction = new Transaction(this);
        return this.transaction;
    }

    public Pipeline pipelined() {
        this.pipeline = new Pipeline(this);
        return this.pipeline;
    }

    protected void checkIsInMultiOrPipeline() {
        if (this.transaction != null) {
            throw new IllegalStateException("Cannot use Jedis when in Multi. Please use Transaction or reset jedis state.");
        }
        if (this.pipeline != null && this.pipeline.hasPipelinedResponse()) {
            throw new IllegalStateException("Cannot use Jedis when in Pipeline. Please use Pipeline or reset jedis state.");
        }
    }

    public int getDB() {
        return this.db;
    }

    @Override
    public String ping() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.PING);
        return this.connection.getStatusCodeReply();
    }

    public byte[] ping(byte[] message) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PING, new byte[][]{message});
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public String select(int index) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(index)});
        String statusCodeReply = this.connection.getStatusCodeReply();
        this.db = index;
        return statusCodeReply;
    }

    @Override
    public String swapDB(int index1, int index2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SWAPDB, Protocol.toByteArray(index1), Protocol.toByteArray(index2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String flushDB() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.flushDB());
    }

    @Override
    public String flushDB(FlushMode flushMode) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.FLUSHDB, new byte[][]{flushMode.getRaw()});
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String flushAll() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.flushAll());
    }

    @Override
    public String flushAll(FlushMode flushMode) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.FLUSHALL, new byte[][]{flushMode.getRaw()});
        return this.connection.getStatusCodeReply();
    }

    @Override
    public boolean copy(byte[] srcKey, byte[] dstKey, int db, boolean replace) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.copy(srcKey, dstKey, db, replace));
    }

    @Override
    public boolean copy(byte[] srcKey, byte[] dstKey, boolean replace) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.copy(srcKey, dstKey, replace));
    }

    @Override
    public String set(byte[] key2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.set(key2, value2));
    }

    @Override
    public String set(byte[] key2, byte[] value2, SetParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.set(key2, value2, params));
    }

    @Override
    public byte[] get(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.get(key2));
    }

    @Override
    public byte[] setGet(byte[] key2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setGet(key2, value2));
    }

    @Override
    public byte[] setGet(byte[] key2, byte[] value2, SetParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setGet(key2, value2, params));
    }

    @Override
    public byte[] getDel(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getDel(key2));
    }

    @Override
    public byte[] getEx(byte[] key2, GetExParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getEx(key2, params));
    }

    @Override
    public long exists(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.exists(keys2));
    }

    @Override
    public boolean exists(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.exists(key2));
    }

    @Override
    public long del(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.del(keys2));
    }

    @Override
    public long del(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.del(key2));
    }

    @Override
    public long unlink(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.unlink(keys2));
    }

    @Override
    public long unlink(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.unlink(key2));
    }

    @Override
    public String type(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.type(key2));
    }

    @Override
    public Set<byte[]> keys(byte[] pattern2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.keys(pattern2));
    }

    @Override
    public byte[] randomBinaryKey() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.randomBinaryKey());
    }

    @Override
    public String rename(byte[] oldkey, byte[] newkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rename(oldkey, newkey));
    }

    @Override
    public long renamenx(byte[] oldkey, byte[] newkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.renamenx(oldkey, newkey));
    }

    @Override
    public long dbSize() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.DBSIZE);
        return this.connection.getIntegerReply();
    }

    @Override
    public long expire(byte[] key2, long seconds) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expire(key2, seconds));
    }

    @Override
    public long expire(byte[] key2, long seconds, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expire(key2, seconds, expiryOption));
    }

    @Override
    public long pexpire(byte[] key2, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpire(key2, milliseconds));
    }

    @Override
    public long pexpire(byte[] key2, long milliseconds, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpire(key2, milliseconds, expiryOption));
    }

    @Override
    public long expireTime(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireTime(key2));
    }

    @Override
    public long pexpireTime(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireTime(key2));
    }

    @Override
    public long expireAt(byte[] key2, long unixTime) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireAt(key2, unixTime));
    }

    @Override
    public long expireAt(byte[] key2, long unixTime, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireAt(key2, unixTime, expiryOption));
    }

    @Override
    public long pexpireAt(byte[] key2, long millisecondsTimestamp) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireAt(key2, millisecondsTimestamp));
    }

    @Override
    public long pexpireAt(byte[] key2, long millisecondsTimestamp, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireAt(key2, millisecondsTimestamp, expiryOption));
    }

    @Override
    public long ttl(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.ttl(key2));
    }

    @Override
    public long touch(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.touch(keys2));
    }

    @Override
    public long touch(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.touch(key2));
    }

    @Override
    public long move(byte[] key2, int dbIndex) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MOVE, key2, Protocol.toByteArray(dbIndex));
        return this.connection.getIntegerReply();
    }

    @Override
    @Deprecated
    public byte[] getSet(byte[] key2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getSet(key2, value2));
    }

    @Override
    public List<byte[]> mget(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.mget(keys2));
    }

    @Override
    public long setnx(byte[] key2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setnx(key2, value2));
    }

    @Override
    public String setex(byte[] key2, long seconds, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setex(key2, seconds, value2));
    }

    @Override
    public String mset(byte[] ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.mset(keysvalues));
    }

    @Override
    public long msetnx(byte[] ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.msetnx(keysvalues));
    }

    @Override
    public long decrBy(byte[] key2, long decrement) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.decrBy(key2, decrement));
    }

    @Override
    public long decr(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.decr(key2));
    }

    @Override
    public long incrBy(byte[] key2, long increment) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incrBy(key2, increment));
    }

    @Override
    public double incrByFloat(byte[] key2, double increment) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incrByFloat(key2, increment));
    }

    @Override
    public long incr(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incr(key2));
    }

    @Override
    public long append(byte[] key2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.append(key2, value2));
    }

    @Override
    public byte[] substr(byte[] key2, int start2, int end2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.substr(key2, start2, end2));
    }

    @Override
    public long hset(byte[] key2, byte[] field, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hset(key2, field, value2));
    }

    @Override
    public long hset(byte[] key2, Map<byte[], byte[]> hash) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hset(key2, hash));
    }

    @Override
    public byte[] hget(byte[] key2, byte[] field) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hget(key2, field));
    }

    @Override
    public long hsetnx(byte[] key2, byte[] field, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hsetnx(key2, field, value2));
    }

    @Override
    public String hmset(byte[] key2, Map<byte[], byte[]> hash) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hmset(key2, hash));
    }

    @Override
    public List<byte[]> hmget(byte[] key2, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hmget(key2, fields2));
    }

    @Override
    public long hincrBy(byte[] key2, byte[] field, long value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hincrBy(key2, field, value2));
    }

    @Override
    public double hincrByFloat(byte[] key2, byte[] field, double value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hincrByFloat(key2, field, value2));
    }

    @Override
    public boolean hexists(byte[] key2, byte[] field) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexists(key2, field));
    }

    @Override
    public long hdel(byte[] key2, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hdel(key2, fields2));
    }

    @Override
    public long hlen(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hlen(key2));
    }

    @Override
    public Set<byte[]> hkeys(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hkeys(key2));
    }

    @Override
    public List<byte[]> hvals(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hvals(key2));
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hgetAll(key2));
    }

    @Override
    public byte[] hrandfield(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfield(key2));
    }

    @Override
    public List<byte[]> hrandfield(byte[] key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfield(key2, count2));
    }

    @Override
    public List<Map.Entry<byte[], byte[]>> hrandfieldWithValues(byte[] key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfieldWithValues(key2, count2));
    }

    @Override
    public long rpush(byte[] key2, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpush(key2, strings));
    }

    @Override
    public long lpush(byte[] key2, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpush(key2, strings));
    }

    @Override
    public long llen(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.llen(key2));
    }

    @Override
    public List<byte[]> lrange(byte[] key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lrange(key2, start2, stop));
    }

    @Override
    public String ltrim(byte[] key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.ltrim(key2, start2, stop));
    }

    @Override
    public byte[] lindex(byte[] key2, long index) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lindex(key2, index));
    }

    @Override
    public String lset(byte[] key2, long index, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lset(key2, index, value2));
    }

    @Override
    public long lrem(byte[] key2, long count2, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lrem(key2, count2, value2));
    }

    @Override
    public byte[] lpop(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpop(key2));
    }

    @Override
    public List<byte[]> lpop(byte[] key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpop(key2, count2));
    }

    @Override
    public Long lpos(byte[] key2, byte[] element) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(key2, element));
    }

    @Override
    public Long lpos(byte[] key2, byte[] element, LPosParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(key2, element, params));
    }

    @Override
    public List<Long> lpos(byte[] key2, byte[] element, LPosParams params, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(key2, element, params, count2));
    }

    @Override
    public byte[] rpop(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpop(key2));
    }

    @Override
    public List<byte[]> rpop(byte[] key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpop(key2, count2));
    }

    @Override
    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpoplpush(srckey, dstkey));
    }

    @Override
    public long sadd(byte[] key2, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sadd(key2, members));
    }

    @Override
    public Set<byte[]> smembers(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smembers(key2));
    }

    @Override
    public long srem(byte[] key2, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srem(key2, members));
    }

    @Override
    public byte[] spop(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.spop(key2));
    }

    @Override
    public Set<byte[]> spop(byte[] key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.spop(key2, count2));
    }

    @Override
    public long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smove(srckey, dstkey, member));
    }

    @Override
    public long scard(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scard(key2));
    }

    @Override
    public boolean sismember(byte[] key2, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sismember(key2, member));
    }

    @Override
    public List<Boolean> smismember(byte[] key2, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smismember(key2, members));
    }

    @Override
    public Set<byte[]> sinter(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sinter(keys2));
    }

    @Override
    public long sinterstore(byte[] dstkey, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sinterstore(dstkey, keys2));
    }

    @Override
    public long sintercard(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sintercard(keys2));
    }

    @Override
    public long sintercard(int limit, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sintercard(limit, keys2));
    }

    @Override
    public Set<byte[]> sunion(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sunion(keys2));
    }

    @Override
    public long sunionstore(byte[] dstkey, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sunionstore(dstkey, keys2));
    }

    @Override
    public Set<byte[]> sdiff(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sdiff(keys2));
    }

    @Override
    public long sdiffstore(byte[] dstkey, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sdiffstore(dstkey, keys2));
    }

    @Override
    public byte[] srandmember(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srandmember(key2));
    }

    @Override
    public List<byte[]> srandmember(byte[] key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srandmember(key2, count2));
    }

    @Override
    public long zadd(byte[] key2, double score, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(key2, score, member));
    }

    @Override
    public long zadd(byte[] key2, double score, byte[] member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(key2, score, member, params));
    }

    @Override
    public long zadd(byte[] key2, Map<byte[], Double> scoreMembers) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(key2, scoreMembers));
    }

    @Override
    public long zadd(byte[] key2, Map<byte[], Double> scoreMembers, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(key2, scoreMembers, params));
    }

    @Override
    public Double zaddIncr(byte[] key2, double score, byte[] member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zaddIncr(key2, score, member, params));
    }

    @Override
    public List<byte[]> zrange(byte[] key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrange(key2, start2, stop));
    }

    @Override
    public long zrem(byte[] key2, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrem(key2, members));
    }

    @Override
    public double zincrby(byte[] key2, double increment, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zincrby(key2, increment, member));
    }

    @Override
    public Double zincrby(byte[] key2, double increment, byte[] member, ZIncrByParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zincrby(key2, increment, member, params));
    }

    @Override
    public Long zrank(byte[] key2, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrank(key2, member));
    }

    @Override
    public Long zrevrank(byte[] key2, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrank(key2, member));
    }

    @Override
    public KeyValue<Long, Double> zrankWithScore(byte[] key2, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrankWithScore(key2, member));
    }

    @Override
    public KeyValue<Long, Double> zrevrankWithScore(byte[] key2, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrankWithScore(key2, member));
    }

    @Override
    public List<byte[]> zrevrange(byte[] key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrange(key2, start2, stop));
    }

    @Override
    public List<Tuple> zrangeWithScores(byte[] key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeWithScores(key2, start2, stop));
    }

    @Override
    public List<Tuple> zrevrangeWithScores(byte[] key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeWithScores(key2, start2, stop));
    }

    @Override
    public List<byte[]> zrange(byte[] key2, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrange(key2, zRangeParams));
    }

    @Override
    public List<Tuple> zrangeWithScores(byte[] key2, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeWithScores(key2, zRangeParams));
    }

    @Override
    public long zrangestore(byte[] dest, byte[] src, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangestore(dest, src, zRangeParams));
    }

    @Override
    public byte[] zrandmember(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmember(key2));
    }

    @Override
    public List<byte[]> zrandmember(byte[] key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmember(key2, count2));
    }

    @Override
    public List<Tuple> zrandmemberWithScores(byte[] key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmemberWithScores(key2, count2));
    }

    @Override
    public long zcard(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcard(key2));
    }

    @Override
    public Double zscore(byte[] key2, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zscore(key2, member));
    }

    @Override
    public List<Double> zmscore(byte[] key2, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmscore(key2, members));
    }

    @Override
    public Tuple zpopmax(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmax(key2));
    }

    @Override
    public List<Tuple> zpopmax(byte[] key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmax(key2, count2));
    }

    @Override
    public Tuple zpopmin(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmin(key2));
    }

    @Override
    public List<Tuple> zpopmin(byte[] key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmin(key2, count2));
    }

    public String watch(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.WATCH, keys2);
        String status2 = this.connection.getStatusCodeReply();
        this.isInWatch = true;
        return status2;
    }

    public String unwatch() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.UNWATCH);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<byte[]> sort(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(key2));
    }

    @Override
    public List<byte[]> sort(byte[] key2, SortingParams sortingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(key2, sortingParams));
    }

    @Override
    public long sort(byte[] key2, SortingParams sortingParams, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(key2, sortingParams, dstkey));
    }

    @Override
    public long sort(byte[] key2, byte[] dstkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(key2, dstkey));
    }

    @Override
    public List<byte[]> sortReadonly(byte[] key2, SortingParams sortingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sortReadonly(key2, sortingParams));
    }

    @Override
    public byte[] lmove(byte[] srcKey, byte[] dstKey, ListDirection from2, ListDirection to) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmove(srcKey, dstKey, from2, to));
    }

    @Override
    public byte[] blmove(byte[] srcKey, byte[] dstKey, ListDirection from2, ListDirection to, double timeout2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmove(srcKey, dstKey, from2, to, timeout2));
    }

    @Override
    public List<byte[]> blpop(int timeout2, byte[] ... keys2) {
        return this.connection.executeCommand(this.commandObjects.blpop(timeout2, keys2));
    }

    @Override
    public KeyValue<byte[], byte[]> blpop(double timeout2, byte[] ... keys2) {
        return this.connection.executeCommand(this.commandObjects.blpop(timeout2, keys2));
    }

    @Override
    public List<byte[]> brpop(int timeout2, byte[] ... keys2) {
        return this.connection.executeCommand(this.commandObjects.brpop(timeout2, keys2));
    }

    @Override
    public KeyValue<byte[], byte[]> brpop(double timeout2, byte[] ... keys2) {
        return this.connection.executeCommand(this.commandObjects.brpop(timeout2, keys2));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection direction, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmpop(direction, keys2));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection direction, int count2, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmpop(direction, count2, keys2));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> blmpop(double timeout2, ListDirection direction, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmpop(timeout2, direction, keys2));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> blmpop(double timeout2, ListDirection direction, int count2, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmpop(timeout2, direction, count2, keys2));
    }

    @Override
    public KeyValue<byte[], Tuple> bzpopmax(double timeout2, byte[] ... keys2) {
        return this.connection.executeCommand(this.commandObjects.bzpopmax(timeout2, keys2));
    }

    @Override
    public KeyValue<byte[], Tuple> bzpopmin(double timeout2, byte[] ... keys2) {
        return this.connection.executeCommand(this.commandObjects.bzpopmin(timeout2, keys2));
    }

    @Override
    public String auth(String password) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.AUTH, password);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String auth(String user, String password) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.AUTH, user, password);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long zcount(byte[] key2, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcount(key2, min2, max2));
    }

    @Override
    public long zcount(byte[] key2, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcount(key2, min2, max2));
    }

    @Override
    public List<byte[]> zdiff(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiff(keys2));
    }

    @Override
    public List<Tuple> zdiffWithScores(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffWithScores(keys2));
    }

    @Override
    @Deprecated
    public long zdiffStore(byte[] dstkey, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffStore(dstkey, keys2));
    }

    @Override
    public long zdiffstore(byte[] dstkey, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffstore(dstkey, keys2));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] key2, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] key2, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] key2, double min2, double max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2, offset, count2));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2, offset, count2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] key2, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] key2, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] key2, double min2, double max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2, offset, count2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2, offset, count2));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] key2, double max2, double min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] key2, byte[] max2, byte[] min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] key2, double max2, double min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2, offset, count2));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] key2, double max2, double min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] key2, double max2, double min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] key2, byte[] max2, byte[] min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2, offset, count2));
    }

    @Override
    public long zremrangeByRank(byte[] key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByRank(key2, start2, stop));
    }

    @Override
    public long zremrangeByScore(byte[] key2, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByScore(key2, min2, max2));
    }

    @Override
    public long zremrangeByScore(byte[] key2, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByScore(key2, min2, max2));
    }

    @Override
    public List<byte[]> zunion(ZParams params, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunion(params, keys2));
    }

    @Override
    public List<Tuple> zunionWithScores(ZParams params, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionWithScores(params, keys2));
    }

    @Override
    public long zunionstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionstore(dstkey, sets));
    }

    @Override
    public long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionstore(dstkey, params, sets));
    }

    @Override
    public List<byte[]> zinter(ZParams params, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinter(params, keys2));
    }

    @Override
    public List<Tuple> zinterWithScores(ZParams params, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterWithScores(params, keys2));
    }

    @Override
    public long zinterstore(byte[] dstkey, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterstore(dstkey, sets));
    }

    @Override
    public long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterstore(dstkey, params, sets));
    }

    @Override
    public long zintercard(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zintercard(keys2));
    }

    @Override
    public long zintercard(long limit, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zintercard(limit, keys2));
    }

    @Override
    public long zlexcount(byte[] key2, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zlexcount(key2, min2, max2));
    }

    @Override
    public List<byte[]> zrangeByLex(byte[] key2, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByLex(key2, min2, max2));
    }

    @Override
    public List<byte[]> zrangeByLex(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByLex(key2, min2, max2, offset, count2));
    }

    @Override
    public List<byte[]> zrevrangeByLex(byte[] key2, byte[] max2, byte[] min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByLex(key2, max2, min2));
    }

    @Override
    public List<byte[]> zrevrangeByLex(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByLex(key2, max2, min2, offset, count2));
    }

    @Override
    public long zremrangeByLex(byte[] key2, byte[] min2, byte[] max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByLex(key2, min2, max2));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> zmpop(SortedSetOption option, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmpop(option, keys2));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> zmpop(SortedSetOption option, int count2, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmpop(option, count2, keys2));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> bzmpop(double timeout2, SortedSetOption option, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzmpop(timeout2, option, keys2));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> bzmpop(double timeout2, SortedSetOption option, int count2, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzmpop(timeout2, option, count2, keys2));
    }

    @Override
    public String save() {
        this.connection.sendCommand(Protocol.Command.SAVE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String bgsave() {
        this.connection.sendCommand(Protocol.Command.BGSAVE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String bgsaveSchedule() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.BGSAVE, Protocol.Keyword.SCHEDULE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String bgrewriteaof() {
        this.connection.sendCommand(Protocol.Command.BGREWRITEAOF);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long lastsave() {
        this.connection.sendCommand(Protocol.Command.LASTSAVE);
        return this.connection.getIntegerReply();
    }

    @Override
    public void shutdown() throws JedisException {
        this.connection.sendCommand(Protocol.Command.SHUTDOWN);
        try {
            throw new JedisException(this.connection.getStatusCodeReply());
        }
        catch (JedisConnectionException jce) {
            this.connection.setBroken();
            return;
        }
    }

    @Override
    public void shutdown(ShutdownParams shutdownParams) throws JedisException {
        this.connection.sendCommand(new CommandArguments(Protocol.Command.SHUTDOWN).addParams(shutdownParams));
        try {
            throw new JedisException(this.connection.getStatusCodeReply());
        }
        catch (JedisConnectionException jce) {
            this.connection.setBroken();
            return;
        }
    }

    @Override
    public String shutdownAbort() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SHUTDOWN, Protocol.Keyword.ABORT);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String info() {
        this.connection.sendCommand(Protocol.Command.INFO);
        return this.connection.getBulkReply();
    }

    @Override
    public String info(String section) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.INFO, section);
        return this.connection.getBulkReply();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.connection.sendCommand(Protocol.Command.MONITOR);
        this.connection.getStatusCodeReply();
        jedisMonitor.proceed(this.connection);
    }

    @Override
    @Deprecated
    public String slaveof(String host2, int port2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, SafeEncoder.encode(host2), Protocol.toByteArray(port2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    @Deprecated
    public String slaveofNoOne() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, Protocol.Keyword.NO.getRaw(), Protocol.Keyword.ONE.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String replicaof(String host2, int port2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, SafeEncoder.encode(host2), Protocol.toByteArray(port2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String replicaofNoOne() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, Protocol.Keyword.NO.getRaw(), Protocol.Keyword.ONE.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<Object> roleBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.ROLE);
        return BuilderFactory.RAW_OBJECT_LIST.build(this.connection.getOne());
    }

    @Override
    public Map<byte[], byte[]> configGet(byte[] pattern2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.GET.getRaw(), pattern2);
        return BuilderFactory.BINARY_MAP.build(this.connection.getOne());
    }

    @Override
    public Map<byte[], byte[]> configGet(byte[] ... patterns2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Jedis.joinParameters(Protocol.Keyword.GET.getRaw(), patterns2));
        return BuilderFactory.BINARY_MAP.build(this.connection.getOne());
    }

    @Override
    public String configResetStat() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.RESETSTAT);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configRewrite() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.REWRITE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configSet(byte[] parameter, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.SET.getRaw(), parameter, value2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configSet(byte[] ... parameterValues) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Jedis.joinParameters(Protocol.Keyword.SET.getRaw(), parameterValues));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configSetBinary(Map<byte[], byte[]> parameterValues) {
        this.checkIsInMultiOrPipeline();
        CommandArguments args2 = new CommandArguments(Protocol.Command.CONFIG).add(Protocol.Keyword.SET);
        parameterValues.forEach((k2, v) -> args2.add((byte[])k2).add((byte[])v));
        this.connection.sendCommand(args2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long strlen(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.strlen(key2));
    }

    @Override
    public LCSMatchResult lcs(byte[] keyA, byte[] keyB, LCSParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lcs(keyA, keyB, params));
    }

    @Override
    public long lpushx(byte[] key2, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpushx(key2, strings));
    }

    @Override
    public long persist(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.persist(key2));
    }

    @Override
    public long rpushx(byte[] key2, byte[] ... strings) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpushx(key2, strings));
    }

    @Override
    public byte[] echo(byte[] string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ECHO, new byte[][]{string});
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public long linsert(byte[] key2, ListPosition where, byte[] pivot, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.linsert(key2, where, pivot, value2));
    }

    @Override
    public byte[] brpoplpush(byte[] source2, byte[] destination, int timeout2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpoplpush(source2, destination, timeout2));
    }

    @Override
    public boolean setbit(byte[] key2, long offset, boolean value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setbit(key2, offset, value2));
    }

    @Override
    public boolean getbit(byte[] key2, long offset) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getbit(key2, offset));
    }

    @Override
    public long bitpos(byte[] key2, boolean value2) {
        return this.bitpos(key2, value2, new BitPosParams());
    }

    @Override
    public long bitpos(byte[] key2, boolean value2, BitPosParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitpos(key2, value2, params));
    }

    @Override
    public long setrange(byte[] key2, long offset, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setrange(key2, offset, value2));
    }

    @Override
    public byte[] getrange(byte[] key2, long startOffset, long endOffset) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getrange(key2, startOffset, endOffset));
    }

    public long publish(byte[] channel2, byte[] message) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.publish(channel2, message));
    }

    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        jedisPubSub.proceed(this.connection, (T[])channels);
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns2) {
        jedisPubSub.proceedWithPatterns(this.connection, (T[])patterns2);
    }

    @Override
    public Object eval(byte[] script, List<byte[]> keys2, List<byte[]> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(script, keys2, args2));
    }

    @Override
    public Object evalReadonly(byte[] script, List<byte[]> keys2, List<byte[]> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalReadonly(script, keys2, args2));
    }

    protected static byte[][] getParamsWithBinary(List<byte[]> keys2, List<byte[]> args2) {
        int i2;
        int keyCount = keys2.size();
        int argCount = args2.size();
        byte[][] params = new byte[keyCount + argCount][];
        for (i2 = 0; i2 < keyCount; ++i2) {
            params[i2] = keys2.get(i2);
        }
        for (i2 = 0; i2 < argCount; ++i2) {
            params[keyCount + i2] = args2.get(i2);
        }
        return params;
    }

    @Override
    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(script, keyCount, params));
    }

    @Override
    public Object eval(byte[] script) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(script));
    }

    @Override
    public Object evalsha(byte[] sha1) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(sha1));
    }

    @Override
    public Object evalsha(byte[] sha1, List<byte[]> keys2, List<byte[]> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(sha1, keys2, args2));
    }

    @Override
    public Object evalshaReadonly(byte[] sha1, List<byte[]> keys2, List<byte[]> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalshaReadonly(sha1, keys2, args2));
    }

    @Override
    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(sha1, keyCount, params));
    }

    @Override
    public String scriptFlush() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.FLUSH);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String scriptFlush(FlushMode flushMode) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.FLUSH.getRaw(), flushMode.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public Boolean scriptExists(byte[] sha1) {
        byte[][] a2 = new byte[][]{sha1};
        return this.scriptExists(a2).get(0);
    }

    @Override
    public List<Boolean> scriptExists(byte[] ... sha1) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Jedis.joinParameters(Protocol.Keyword.EXISTS.getRaw(), sha1));
        return BuilderFactory.BOOLEAN_LIST.build(this.connection.getOne());
    }

    @Override
    public byte[] scriptLoad(byte[] script) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.LOAD.getRaw(), script);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public String scriptKill() {
        return this.connection.executeCommand(this.commandObjects.scriptKill());
    }

    @Override
    public String slowlogReset() {
        return this.connection.executeCommand(this.commandObjects.slowlogReset());
    }

    @Override
    public long slowlogLen() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.LEN);
        return this.connection.getIntegerReply();
    }

    @Override
    public List<Object> slowlogGetBinary() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET);
        return this.connection.getObjectMultiBulkReply();
    }

    @Override
    public List<Object> slowlogGetBinary(long entries2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET.getRaw(), Protocol.toByteArray(entries2));
        return this.connection.getObjectMultiBulkReply();
    }

    @Override
    public Long objectRefcount(byte[] key2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT.getRaw(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public byte[] objectEncoding(byte[] key2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.ENCODING.getRaw(), key2);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public Long objectIdletime(byte[] key2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME.getRaw(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public List<byte[]> objectHelpBinary() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.HELP);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public Long objectFreq(byte[] key2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.FREQ.getRaw(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public long bitcount(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(key2));
    }

    @Override
    public long bitcount(byte[] key2, long start2, long end2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(key2, start2, end2));
    }

    @Override
    public long bitcount(byte[] key2, long start2, long end2, BitCountOption option) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(key2, start2, end2, option));
    }

    @Override
    public long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitop(op, destKey, srcKeys));
    }

    @Override
    public byte[] dump(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.dump(key2));
    }

    @Override
    public String restore(byte[] key2, long ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.restore(key2, ttl, serializedValue));
    }

    @Override
    public String restore(byte[] key2, long ttl, byte[] serializedValue, RestoreParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.restore(key2, ttl, serializedValue, params));
    }

    @Override
    public long pttl(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pttl(key2));
    }

    @Override
    public String psetex(byte[] key2, long milliseconds, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.psetex(key2, milliseconds, value2));
    }

    @Override
    public byte[] memoryDoctorBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.DOCTOR);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public Long memoryUsage(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.USAGE.getRaw(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public Long memoryUsage(byte[] key2, int samples) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.USAGE.getRaw(), key2, Protocol.Keyword.SAMPLES.getRaw(), Protocol.toByteArray(samples));
        return this.connection.getIntegerReply();
    }

    @Override
    public String failover() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.FAILOVER);
        this.connection.setTimeoutInfinite();
        try {
            String string = this.connection.getStatusCodeReply();
            return string;
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String failover(FailoverParams failoverParams) {
        this.checkIsInMultiOrPipeline();
        CommandArguments args2 = new ClusterCommandArguments(Protocol.Command.FAILOVER).addParams(failoverParams);
        this.connection.sendCommand(args2);
        this.connection.setTimeoutInfinite();
        try {
            String string = this.connection.getStatusCodeReply();
            return string;
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    @Override
    public String failoverAbort() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.FAILOVER, Protocol.Keyword.ABORT);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public byte[] aclWhoAmIBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.WHOAMI);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] aclGenPassBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GENPASS);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] aclGenPassBinary(int bits) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GENPASS.getRaw(), Protocol.toByteArray(bits));
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> aclListBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LIST);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclUsersBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.USERS);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public AccessControlUser aclGetUser(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GETUSER.getRaw(), name);
        return BuilderFactory.ACCESS_CONTROL_USER.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public String aclSetUser(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.SETUSER.getRaw(), name);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String aclSetUser(byte[] name, byte[] ... rules) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Jedis.joinParameters(Protocol.Keyword.SETUSER.getRaw(), name, rules));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long aclDelUser(byte[] ... names2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Jedis.joinParameters(Protocol.Keyword.DELUSER.getRaw(), names2));
        return this.connection.getIntegerReply();
    }

    @Override
    public List<byte[]> aclCatBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.CAT);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclCat(byte[] category) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.CAT.getRaw(), category);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclLogBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclLogBinary(int limit) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG.getRaw(), Protocol.toByteArray(limit));
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public String aclLogReset() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG.getRaw(), Protocol.Keyword.RESET.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientKill(byte[] ipPort) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.KILL.getRaw(), ipPort);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientKill(String ip, int port2) {
        return this.clientKill(ip + ':' + port2);
    }

    @Override
    public long clientKill(ClientKillParams params) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(new CommandArguments(Protocol.Command.CLIENT).add(Protocol.Keyword.KILL).addParams(params));
        return this.connection.getIntegerReply();
    }

    @Override
    public byte[] clientGetnameBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.GETNAME);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.LIST);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary(ClientType type2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.LIST.getRaw(), type2.getRaw());
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary(long ... clientIds) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, this.clientListParams(clientIds));
        return this.connection.getBinaryBulkReply();
    }

    private byte[][] clientListParams(long ... clientIds) {
        byte[][] params = new byte[2 + clientIds.length][];
        int index = 0;
        params[index++] = Protocol.Keyword.LIST.getRaw();
        params[index++] = Protocol.Keyword.ID.getRaw();
        for (long clientId : clientIds) {
            params[index++] = Protocol.toByteArray(clientId);
        }
        return params;
    }

    @Override
    public byte[] clientInfoBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.INFO);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public String clientSetInfo(ClientAttributeOption attr, byte[] value2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETINFO.getRaw(), attr.getRaw(), value2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientSetname(byte[] name) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.getRaw(), name);
        return this.connection.getBulkReply();
    }

    @Override
    public long clientId() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.ID);
        return this.connection.getIntegerReply();
    }

    @Override
    public long clientUnblock(long clientId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.UNBLOCK.getRaw(), Protocol.toByteArray(clientId));
        return this.connection.getIntegerReply();
    }

    @Override
    public long clientUnblock(long clientId, UnblockType unblockType) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.UNBLOCK.getRaw(), Protocol.toByteArray(clientId), unblockType.getRaw());
        return this.connection.getIntegerReply();
    }

    @Override
    public String clientPause(long timeout2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.PAUSE.getRaw(), Protocol.toByteArray(timeout2));
        return this.connection.getBulkReply();
    }

    @Override
    public String clientPause(long timeout2, ClientPauseMode mode) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.PAUSE.getRaw(), Protocol.toByteArray(timeout2), mode.getRaw());
        return this.connection.getBulkReply();
    }

    @Override
    public String clientUnpause() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.UNPAUSE);
        return this.connection.getBulkReply();
    }

    @Override
    public String clientNoEvictOn() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, "NO-EVICT", "ON");
        return this.connection.getBulkReply();
    }

    @Override
    public String clientNoEvictOff() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, "NO-EVICT", "OFF");
        return this.connection.getBulkReply();
    }

    @Override
    public String clientNoTouchOn() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, "NO-TOUCH", "ON");
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientNoTouchOff() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, "NO-TOUCH", "OFF");
        return this.connection.getStatusCodeReply();
    }

    @Override
    public TrackingInfo clientTrackingInfo() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, "TRACKINGINFO");
        return TrackingInfo.TRACKING_INFO_BUILDER.build(this.connection.getOne());
    }

    public List<String> time() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.TIME);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public String migrate(String host2, int port2, byte[] key2, int destinationDb, int timeout2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(host2, port2, key2, destinationDb, timeout2));
    }

    @Override
    public String migrate(String host2, int port2, int destinationDB, int timeout2, MigrateParams params, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(host2, port2, destinationDB, timeout2, params, keys2));
    }

    @Override
    public String migrate(String host2, int port2, byte[] key2, int timeout2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(host2, port2, key2, timeout2));
    }

    @Override
    public String migrate(String host2, int port2, int timeout2, MigrateParams params, byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(host2, port2, timeout2, params, keys2));
    }

    @Override
    public long waitReplicas(int replicas, long timeout2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.WAIT, Protocol.toByteArray(replicas), Protocol.toByteArray(timeout2));
        return this.connection.getIntegerReply();
    }

    @Override
    public KeyValue<Long, Long> waitAOF(long numLocal, long numReplicas, long timeout2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.WAITAOF, Protocol.toByteArray(numLocal), Protocol.toByteArray(numReplicas), Protocol.toByteArray(timeout2));
        return BuilderFactory.LONG_LONG_PAIR.build(this.connection.getOne());
    }

    @Override
    public long pfadd(byte[] key2, byte[] ... elements) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfadd(key2, elements));
    }

    @Override
    public long pfcount(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfcount(key2));
    }

    @Override
    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfmerge(destkey, sourcekeys));
    }

    @Override
    public long pfcount(byte[] ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfcount(keys2));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scan(cursor));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scan(cursor, params));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params, byte[] type2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scan(cursor, params, type2));
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key2, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hscan(key2, cursor, params));
    }

    @Override
    public ScanResult<byte[]> hscanNoValues(byte[] key2, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hscanNoValues(key2, cursor, params));
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key2, byte[] cursor) {
        return this.sscan(key2, cursor, new ScanParams());
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key2, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sscan(key2, cursor, params));
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key2, byte[] cursor) {
        return this.zscan(key2, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key2, byte[] cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zscan(key2, cursor, params));
    }

    @Override
    public long geoadd(byte[] key2, double longitude, double latitude, byte[] member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(key2, longitude, latitude, member));
    }

    @Override
    public long geoadd(byte[] key2, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(key2, memberCoordinateMap));
    }

    @Override
    public long geoadd(byte[] key2, GeoAddParams params, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(key2, params, memberCoordinateMap));
    }

    @Override
    public Double geodist(byte[] key2, byte[] member1, byte[] member2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geodist(key2, member1, member2));
    }

    @Override
    public Double geodist(byte[] key2, byte[] member1, byte[] member2, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geodist(key2, member1, member2, unit));
    }

    @Override
    public List<byte[]> geohash(byte[] key2, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geohash(key2, members));
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key2, byte[] ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geopos(key2, members));
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadius(key2, longitude, latitude, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusReadonly(key2, longitude, latitude, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadius(key2, longitude, latitude, radius, unit, param));
    }

    @Override
    public long georadiusStore(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusStore(key2, longitude, latitude, radius, unit, param, storeParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusReadonly(key2, longitude, latitude, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMember(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberReadonly(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMember(key2, member, radius, unit, param));
    }

    @Override
    public long georadiusByMemberStore(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberStore(key2, member, radius, unit, param, storeParam));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, GeoCoordinate coord, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, coord, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, byte[] member, double width, double height, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, member, width, height, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, coord, width, height, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, GeoSearchParam params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, params));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, byte[] member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, member, radius, unit));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, GeoCoordinate coord, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, coord, radius, unit));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, byte[] member, double width, double height, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, member, width, height, unit));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, coord, width, height, unit));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, GeoSearchParam params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, params));
    }

    @Override
    public long geosearchStoreStoreDist(byte[] dest, byte[] src, GeoSearchParam params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStoreStoreDist(dest, src, params));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberReadonly(key2, member, radius, unit, param));
    }

    @Override
    public List<Long> bitfield(byte[] key2, byte[] ... arguments) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitfield(key2, arguments));
    }

    @Override
    public List<Long> bitfieldReadonly(byte[] key2, byte[] ... arguments) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitfieldReadonly(key2, arguments));
    }

    @Override
    public long hstrlen(byte[] key2, byte[] field) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hstrlen(key2, field));
    }

    @Override
    public List<Long> hexpire(byte[] key2, long seconds, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpire(key2, seconds, fields2));
    }

    @Override
    public List<Long> hexpire(byte[] key2, long seconds, ExpiryOption condition, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpire(key2, seconds, condition, fields2));
    }

    @Override
    public List<Long> hpexpire(byte[] key2, long milliseconds, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpire(key2, milliseconds, fields2));
    }

    @Override
    public List<Long> hpexpire(byte[] key2, long milliseconds, ExpiryOption condition, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpire(key2, milliseconds, condition, fields2));
    }

    @Override
    public List<Long> hexpireAt(byte[] key2, long unixTimeSeconds, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpireAt(key2, unixTimeSeconds, fields2));
    }

    @Override
    public List<Long> hexpireAt(byte[] key2, long unixTimeSeconds, ExpiryOption condition, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpireAt(key2, unixTimeSeconds, condition, fields2));
    }

    @Override
    public List<Long> hpexpireAt(byte[] key2, long unixTimeMillis, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpireAt(key2, unixTimeMillis, fields2));
    }

    @Override
    public List<Long> hpexpireAt(byte[] key2, long unixTimeMillis, ExpiryOption condition, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpireAt(key2, unixTimeMillis, condition, fields2));
    }

    @Override
    public List<Long> hexpireTime(byte[] key2, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpireTime(key2, fields2));
    }

    @Override
    public List<Long> hpexpireTime(byte[] key2, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpireTime(key2, fields2));
    }

    @Override
    public List<Long> httl(byte[] key2, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.httl(key2, fields2));
    }

    @Override
    public List<Long> hpttl(byte[] key2, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpttl(key2, fields2));
    }

    @Override
    public List<Long> hpersist(byte[] key2, byte[] ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpersist(key2, fields2));
    }

    @Override
    public List<Object> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... streams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xread(xReadParams, streams));
    }

    @Override
    public List<Object> xreadGroup(byte[] groupName, byte[] consumer2, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... streams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xreadGroup(groupName, consumer2, xReadGroupParams, streams));
    }

    @Override
    public byte[] xadd(byte[] key2, XAddParams params, Map<byte[], byte[]> hash) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xadd(key2, params, hash));
    }

    @Override
    public long xlen(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xlen(key2));
    }

    @Override
    public List<Object> xrange(byte[] key2, byte[] start2, byte[] end2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(key2, start2, end2));
    }

    @Override
    public List<Object> xrange(byte[] key2, byte[] start2, byte[] end2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(key2, start2, end2, count2));
    }

    @Override
    public List<Object> xrevrange(byte[] key2, byte[] end2, byte[] start2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(key2, end2, start2));
    }

    @Override
    public List<Object> xrevrange(byte[] key2, byte[] end2, byte[] start2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(key2, end2, start2, count2));
    }

    @Override
    public long xack(byte[] key2, byte[] group, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xack(key2, group, ids));
    }

    @Override
    public String xgroupCreate(byte[] key2, byte[] consumer2, byte[] id, boolean makeStream) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupCreate(key2, consumer2, id, makeStream));
    }

    @Override
    public String xgroupSetID(byte[] key2, byte[] consumer2, byte[] id) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupSetID(key2, consumer2, id));
    }

    @Override
    public long xgroupDestroy(byte[] key2, byte[] consumer2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupDestroy(key2, consumer2));
    }

    @Override
    public boolean xgroupCreateConsumer(byte[] key2, byte[] groupName, byte[] consumerName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupCreateConsumer(key2, groupName, consumerName));
    }

    @Override
    public long xgroupDelConsumer(byte[] key2, byte[] groupName, byte[] consumerName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupDelConsumer(key2, groupName, consumerName));
    }

    @Override
    public long xdel(byte[] key2, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xdel(key2, ids));
    }

    @Override
    public long xtrim(byte[] key2, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xtrim(key2, maxLen, approximateLength));
    }

    @Override
    public long xtrim(byte[] key2, XTrimParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xtrim(key2, params));
    }

    @Override
    public Object xpending(byte[] key2, byte[] groupName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(key2, groupName));
    }

    @Override
    public List<Object> xpending(byte[] key2, byte[] groupName, XPendingParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(key2, groupName, params));
    }

    @Override
    public List<byte[]> xclaim(byte[] key2, byte[] group, byte[] consumerName, long minIdleTime, XClaimParams params, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xclaim(key2, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public List<byte[]> xclaimJustId(byte[] key2, byte[] group, byte[] consumerName, long minIdleTime, XClaimParams params, byte[] ... ids) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xclaimJustId(key2, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public List<Object> xautoclaim(byte[] key2, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start2, XAutoClaimParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xautoclaim(key2, groupName, consumerName, minIdleTime, start2, params));
    }

    @Override
    public List<Object> xautoclaimJustId(byte[] key2, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start2, XAutoClaimParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xautoclaimJustId(key2, groupName, consumerName, minIdleTime, start2, params));
    }

    @Override
    public Object xinfoStream(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStream(key2));
    }

    @Override
    public Object xinfoStreamFull(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStreamFull(key2));
    }

    @Override
    public Object xinfoStreamFull(byte[] key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStreamFull(key2, count2));
    }

    @Override
    public List<Object> xinfoGroups(byte[] key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoGroups(key2));
    }

    @Override
    public List<Object> xinfoConsumers(byte[] key2, byte[] group) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoConsumers(key2, group));
    }

    public Object sendCommand(ProtocolCommand cmd, byte[] ... args2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(cmd, args2);
        return this.connection.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendBlockingCommand(ProtocolCommand cmd, byte[] ... args2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(cmd, args2);
        this.connection.setTimeoutInfinite();
        try {
            Object object = this.connection.getOne();
            return object;
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    public Object sendCommand(ProtocolCommand cmd) {
        return this.sendCommand(cmd, DUMMY_ARRAY);
    }

    @Override
    public boolean copy(String srcKey, String dstKey, int db, boolean replace) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.copy(srcKey, dstKey, db, replace));
    }

    @Override
    public boolean copy(String srcKey, String dstKey, boolean replace) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.copy(srcKey, dstKey, replace));
    }

    @Override
    public String ping(String message) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PING, message);
        return this.connection.getBulkReply();
    }

    @Override
    public String set(String key2, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.set(key2, value2));
    }

    @Override
    public String set(String key2, String value2, SetParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.set(key2, value2, params));
    }

    @Override
    public String get(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.get(key2));
    }

    @Override
    public String setGet(String key2, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setGet(key2, value2));
    }

    @Override
    public String setGet(String key2, String value2, SetParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setGet(key2, value2, params));
    }

    @Override
    public String getDel(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getDel(key2));
    }

    @Override
    public String getEx(String key2, GetExParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getEx(key2, params));
    }

    @Override
    public long exists(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.exists(keys2));
    }

    @Override
    public boolean exists(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.exists(key2));
    }

    @Override
    public long del(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.del(keys2));
    }

    @Override
    public long del(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.del(key2));
    }

    @Override
    public long unlink(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.unlink(keys2));
    }

    @Override
    public long unlink(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.unlink(key2));
    }

    @Override
    public String type(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.type(key2));
    }

    @Override
    public Set<String> keys(String pattern2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.keys(pattern2));
    }

    @Override
    public String randomKey() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.randomKey());
    }

    @Override
    public String rename(String oldkey, String newkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rename(oldkey, newkey));
    }

    @Override
    public long renamenx(String oldkey, String newkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.renamenx(oldkey, newkey));
    }

    @Override
    public long expire(String key2, long seconds) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expire(key2, seconds));
    }

    @Override
    public long expire(String key2, long seconds, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expire(key2, seconds, expiryOption));
    }

    @Override
    public long pexpire(String key2, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpire(key2, milliseconds));
    }

    @Override
    public long pexpire(String key2, long milliseconds, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpire(key2, milliseconds, expiryOption));
    }

    @Override
    public long expireTime(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireTime(key2));
    }

    @Override
    public long pexpireTime(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireTime(key2));
    }

    @Override
    public long expireAt(String key2, long unixTime) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireAt(key2, unixTime));
    }

    @Override
    public long expireAt(String key2, long unixTime, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireAt(key2, unixTime, expiryOption));
    }

    @Override
    public long pexpireAt(String key2, long millisecondsTimestamp) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireAt(key2, millisecondsTimestamp));
    }

    @Override
    public long pexpireAt(String key2, long millisecondsTimestamp, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireAt(key2, millisecondsTimestamp, expiryOption));
    }

    @Override
    public long ttl(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.ttl(key2));
    }

    @Override
    public long touch(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.touch(keys2));
    }

    @Override
    public long touch(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.touch(key2));
    }

    @Override
    public long move(String key2, int dbIndex) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MOVE, SafeEncoder.encode(key2), Protocol.toByteArray(dbIndex));
        return this.connection.getIntegerReply();
    }

    @Override
    @Deprecated
    public String getSet(String key2, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getSet(key2, value2));
    }

    @Override
    public List<String> mget(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.mget(keys2));
    }

    @Override
    public long setnx(String key2, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setnx(key2, value2));
    }

    @Override
    public String setex(String key2, long seconds, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setex(key2, seconds, value2));
    }

    @Override
    public String mset(String ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.mset(keysvalues));
    }

    @Override
    public long msetnx(String ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.msetnx(keysvalues));
    }

    @Override
    public long decrBy(String key2, long decrement) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.decrBy(key2, decrement));
    }

    @Override
    public long decr(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.decr(key2));
    }

    @Override
    public long incrBy(String key2, long increment) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incrBy(key2, increment));
    }

    @Override
    public double incrByFloat(String key2, double increment) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incrByFloat(key2, increment));
    }

    @Override
    public long incr(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incr(key2));
    }

    @Override
    public long append(String key2, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.append(key2, value2));
    }

    @Override
    public String substr(String key2, int start2, int end2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.substr(key2, start2, end2));
    }

    @Override
    public long hset(String key2, String field, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hset(key2, field, value2));
    }

    @Override
    public long hset(String key2, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hset(key2, hash));
    }

    @Override
    public String hget(String key2, String field) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hget(key2, field));
    }

    @Override
    public long hsetnx(String key2, String field, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hsetnx(key2, field, value2));
    }

    @Override
    public String hmset(String key2, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hmset(key2, hash));
    }

    @Override
    public List<String> hmget(String key2, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hmget(key2, fields2));
    }

    @Override
    public long hincrBy(String key2, String field, long value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hincrBy(key2, field, value2));
    }

    @Override
    public double hincrByFloat(String key2, String field, double value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hincrByFloat(key2, field, value2));
    }

    @Override
    public boolean hexists(String key2, String field) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexists(key2, field));
    }

    @Override
    public long hdel(String key2, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hdel(key2, fields2));
    }

    @Override
    public long hlen(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hlen(key2));
    }

    @Override
    public Set<String> hkeys(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hkeys(key2));
    }

    @Override
    public List<String> hvals(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hvals(key2));
    }

    @Override
    public Map<String, String> hgetAll(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hgetAll(key2));
    }

    @Override
    public String hrandfield(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfield(key2));
    }

    @Override
    public List<String> hrandfield(String key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfield(key2, count2));
    }

    @Override
    public List<Map.Entry<String, String>> hrandfieldWithValues(String key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfieldWithValues(key2, count2));
    }

    @Override
    public long rpush(String key2, String ... strings) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpush(key2, strings));
    }

    @Override
    public long lpush(String key2, String ... strings) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpush(key2, strings));
    }

    @Override
    public long llen(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.llen(key2));
    }

    @Override
    public List<String> lrange(String key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lrange(key2, start2, stop));
    }

    @Override
    public String ltrim(String key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.ltrim(key2, start2, stop));
    }

    @Override
    public String lindex(String key2, long index) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lindex(key2, index));
    }

    @Override
    public String lset(String key2, long index, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lset(key2, index, value2));
    }

    @Override
    public long lrem(String key2, long count2, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lrem(key2, count2, value2));
    }

    @Override
    public String lpop(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpop(key2));
    }

    @Override
    public List<String> lpop(String key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpop(key2, count2));
    }

    @Override
    public Long lpos(String key2, String element) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(key2, element));
    }

    @Override
    public Long lpos(String key2, String element, LPosParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(key2, element, params));
    }

    @Override
    public List<Long> lpos(String key2, String element, LPosParams params, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(key2, element, params, count2));
    }

    @Override
    public String rpop(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpop(key2));
    }

    @Override
    public List<String> rpop(String key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpop(key2, count2));
    }

    @Override
    public String rpoplpush(String srckey, String dstkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpoplpush(srckey, dstkey));
    }

    @Override
    public long sadd(String key2, String ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sadd(key2, members));
    }

    @Override
    public Set<String> smembers(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smembers(key2));
    }

    @Override
    public long srem(String key2, String ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srem(key2, members));
    }

    @Override
    public String spop(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.spop(key2));
    }

    @Override
    public Set<String> spop(String key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.spop(key2, count2));
    }

    @Override
    public long smove(String srckey, String dstkey, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smove(srckey, dstkey, member));
    }

    @Override
    public long scard(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scard(key2));
    }

    @Override
    public boolean sismember(String key2, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sismember(key2, member));
    }

    @Override
    public List<Boolean> smismember(String key2, String ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smismember(key2, members));
    }

    @Override
    public Set<String> sinter(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sinter(keys2));
    }

    @Override
    public long sinterstore(String dstkey, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sinterstore(dstkey, keys2));
    }

    @Override
    public long sintercard(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sintercard(keys2));
    }

    @Override
    public long sintercard(int limit, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sintercard(limit, keys2));
    }

    @Override
    public Set<String> sunion(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sunion(keys2));
    }

    @Override
    public long sunionstore(String dstkey, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sunionstore(dstkey, keys2));
    }

    @Override
    public Set<String> sdiff(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sdiff(keys2));
    }

    @Override
    public long sdiffstore(String dstkey, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sdiffstore(dstkey, keys2));
    }

    @Override
    public String srandmember(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srandmember(key2));
    }

    @Override
    public List<String> srandmember(String key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srandmember(key2, count2));
    }

    @Override
    public long zadd(String key2, double score, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(key2, score, member));
    }

    @Override
    public long zadd(String key2, double score, String member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(key2, score, member, params));
    }

    @Override
    public long zadd(String key2, Map<String, Double> scoreMembers) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(key2, scoreMembers));
    }

    @Override
    public long zadd(String key2, Map<String, Double> scoreMembers, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(key2, scoreMembers, params));
    }

    @Override
    public Double zaddIncr(String key2, double score, String member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zaddIncr(key2, score, member, params));
    }

    @Override
    public List<String> zdiff(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiff(keys2));
    }

    @Override
    public List<Tuple> zdiffWithScores(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffWithScores(keys2));
    }

    @Override
    @Deprecated
    public long zdiffStore(String dstkey, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffStore(dstkey, keys2));
    }

    @Override
    public long zdiffstore(String dstkey, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffstore(dstkey, keys2));
    }

    @Override
    public List<String> zrange(String key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrange(key2, start2, stop));
    }

    @Override
    public long zrem(String key2, String ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrem(key2, members));
    }

    @Override
    public double zincrby(String key2, double increment, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zincrby(key2, increment, member));
    }

    @Override
    public Double zincrby(String key2, double increment, String member, ZIncrByParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zincrby(key2, increment, member, params));
    }

    @Override
    public Long zrank(String key2, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrank(key2, member));
    }

    @Override
    public Long zrevrank(String key2, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrank(key2, member));
    }

    @Override
    public KeyValue<Long, Double> zrankWithScore(String key2, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrankWithScore(key2, member));
    }

    @Override
    public KeyValue<Long, Double> zrevrankWithScore(String key2, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrankWithScore(key2, member));
    }

    @Override
    public List<String> zrevrange(String key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrange(key2, start2, stop));
    }

    @Override
    public List<Tuple> zrangeWithScores(String key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeWithScores(key2, start2, stop));
    }

    @Override
    public List<Tuple> zrevrangeWithScores(String key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeWithScores(key2, start2, stop));
    }

    @Override
    public List<String> zrange(String key2, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrange(key2, zRangeParams));
    }

    @Override
    public List<Tuple> zrangeWithScores(String key2, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeWithScores(key2, zRangeParams));
    }

    @Override
    public long zrangestore(String dest, String src, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangestore(dest, src, zRangeParams));
    }

    @Override
    public String zrandmember(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmember(key2));
    }

    @Override
    public List<String> zrandmember(String key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmember(key2, count2));
    }

    @Override
    public List<Tuple> zrandmemberWithScores(String key2, long count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmemberWithScores(key2, count2));
    }

    @Override
    public long zcard(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcard(key2));
    }

    @Override
    public Double zscore(String key2, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zscore(key2, member));
    }

    @Override
    public List<Double> zmscore(String key2, String ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmscore(key2, members));
    }

    @Override
    public Tuple zpopmax(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmax(key2));
    }

    @Override
    public List<Tuple> zpopmax(String key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmax(key2, count2));
    }

    @Override
    public Tuple zpopmin(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmin(key2));
    }

    @Override
    public List<Tuple> zpopmin(String key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmin(key2, count2));
    }

    public String watch(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.WATCH, keys2);
        String status2 = this.connection.getStatusCodeReply();
        this.isInWatch = true;
        return status2;
    }

    @Override
    public List<String> sort(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(key2));
    }

    @Override
    public List<String> sort(String key2, SortingParams sortingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(key2, sortingParams));
    }

    @Override
    public long sort(String key2, SortingParams sortingParams, String dstkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(key2, sortingParams, dstkey));
    }

    @Override
    public List<String> sortReadonly(String key2, SortingParams sortingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sortReadonly(key2, sortingParams));
    }

    @Override
    public long sort(String key2, String dstkey) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(key2, dstkey));
    }

    @Override
    public String lmove(String srcKey, String dstKey, ListDirection from2, ListDirection to) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmove(srcKey, dstKey, from2, to));
    }

    @Override
    public String blmove(String srcKey, String dstKey, ListDirection from2, ListDirection to, double timeout2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmove(srcKey, dstKey, from2, to, timeout2));
    }

    @Override
    public List<String> blpop(int timeout2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blpop(timeout2, keys2));
    }

    @Override
    public KeyValue<String, String> blpop(double timeout2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blpop(timeout2, keys2));
    }

    @Override
    public List<String> brpop(int timeout2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpop(timeout2, keys2));
    }

    @Override
    public KeyValue<String, String> brpop(double timeout2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpop(timeout2, keys2));
    }

    @Override
    public KeyValue<String, List<String>> lmpop(ListDirection direction, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmpop(direction, keys2));
    }

    @Override
    public KeyValue<String, List<String>> lmpop(ListDirection direction, int count2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmpop(direction, count2, keys2));
    }

    @Override
    public KeyValue<String, List<String>> blmpop(double timeout2, ListDirection direction, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmpop(timeout2, direction, keys2));
    }

    @Override
    public KeyValue<String, List<String>> blmpop(double timeout2, ListDirection direction, int count2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmpop(timeout2, direction, count2, keys2));
    }

    @Override
    public KeyValue<String, Tuple> bzpopmax(double timeout2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzpopmax(timeout2, keys2));
    }

    @Override
    public KeyValue<String, Tuple> bzpopmin(double timeout2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzpopmin(timeout2, keys2));
    }

    @Override
    public List<String> blpop(int timeout2, String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blpop(timeout2, key2));
    }

    @Override
    public KeyValue<String, String> blpop(double timeout2, String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blpop(timeout2, key2));
    }

    @Override
    public List<String> brpop(int timeout2, String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpop(timeout2, key2));
    }

    @Override
    public KeyValue<String, String> brpop(double timeout2, String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpop(timeout2, key2));
    }

    @Override
    public long zcount(String key2, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcount(key2, min2, max2));
    }

    @Override
    public long zcount(String key2, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcount(key2, min2, max2));
    }

    @Override
    public List<String> zrangeByScore(String key2, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2));
    }

    @Override
    public List<String> zrangeByScore(String key2, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2));
    }

    @Override
    public List<String> zrangeByScore(String key2, double min2, double max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2, offset, count2));
    }

    @Override
    public List<String> zrangeByScore(String key2, String min2, String max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2, offset, count2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String key2, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String key2, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String key2, double min2, double max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2, offset, count2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String key2, String min2, String max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2, offset, count2));
    }

    @Override
    public List<String> zrevrangeByScore(String key2, double max2, double min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2));
    }

    @Override
    public List<String> zrevrangeByScore(String key2, String max2, String min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2));
    }

    @Override
    public List<String> zrevrangeByScore(String key2, double max2, double min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String key2, double max2, double min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String key2, double max2, double min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String key2, String max2, String min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2, offset, count2));
    }

    @Override
    public List<String> zrevrangeByScore(String key2, String max2, String min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String key2, String max2, String min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2));
    }

    @Override
    public long zremrangeByRank(String key2, long start2, long stop) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByRank(key2, start2, stop));
    }

    @Override
    public long zremrangeByScore(String key2, double min2, double max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByScore(key2, min2, max2));
    }

    @Override
    public long zremrangeByScore(String key2, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByScore(key2, min2, max2));
    }

    @Override
    public List<String> zunion(ZParams params, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunion(params, keys2));
    }

    @Override
    public List<Tuple> zunionWithScores(ZParams params, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionWithScores(params, keys2));
    }

    @Override
    public long zunionstore(String dstkey, String ... sets) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionstore(dstkey, sets));
    }

    @Override
    public long zunionstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionstore(dstkey, params, sets));
    }

    @Override
    public List<String> zinter(ZParams params, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinter(params, keys2));
    }

    @Override
    public List<Tuple> zinterWithScores(ZParams params, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterWithScores(params, keys2));
    }

    @Override
    public long zintercard(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zintercard(keys2));
    }

    @Override
    public long zintercard(long limit, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zintercard(limit, keys2));
    }

    @Override
    public long zinterstore(String dstkey, String ... sets) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterstore(dstkey, sets));
    }

    @Override
    public long zinterstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterstore(dstkey, params, sets));
    }

    @Override
    public long zlexcount(String key2, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zlexcount(key2, min2, max2));
    }

    @Override
    public List<String> zrangeByLex(String key2, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByLex(key2, min2, max2));
    }

    @Override
    public List<String> zrangeByLex(String key2, String min2, String max2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByLex(key2, min2, max2, offset, count2));
    }

    @Override
    public List<String> zrevrangeByLex(String key2, String max2, String min2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByLex(key2, max2, min2));
    }

    @Override
    public List<String> zrevrangeByLex(String key2, String max2, String min2, int offset, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByLex(key2, max2, min2, offset, count2));
    }

    @Override
    public long zremrangeByLex(String key2, String min2, String max2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByLex(key2, min2, max2));
    }

    @Override
    public KeyValue<String, List<Tuple>> zmpop(SortedSetOption option, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmpop(option, keys2));
    }

    @Override
    public KeyValue<String, List<Tuple>> zmpop(SortedSetOption option, int count2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmpop(option, count2, keys2));
    }

    @Override
    public KeyValue<String, List<Tuple>> bzmpop(double timeout2, SortedSetOption option, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzmpop(timeout2, option, keys2));
    }

    @Override
    public KeyValue<String, List<Tuple>> bzmpop(double timeout2, SortedSetOption option, int count2, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzmpop(timeout2, option, count2, keys2));
    }

    @Override
    public long strlen(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.strlen(key2));
    }

    @Override
    public LCSMatchResult lcs(String keyA, String keyB, LCSParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lcs(keyA, keyB, params));
    }

    @Override
    public long lpushx(String key2, String ... strings) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpushx(key2, strings));
    }

    @Override
    public long persist(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.persist(key2));
    }

    @Override
    public long rpushx(String key2, String ... strings) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpushx(key2, strings));
    }

    @Override
    public String echo(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ECHO, string);
        return this.connection.getBulkReply();
    }

    @Override
    public long linsert(String key2, ListPosition where, String pivot, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.linsert(key2, where, pivot, value2));
    }

    @Override
    public String brpoplpush(String source2, String destination, int timeout2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpoplpush(source2, destination, timeout2));
    }

    @Override
    public boolean setbit(String key2, long offset, boolean value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setbit(key2, offset, value2));
    }

    @Override
    public boolean getbit(String key2, long offset) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getbit(key2, offset));
    }

    @Override
    public long setrange(String key2, long offset, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setrange(key2, offset, value2));
    }

    @Override
    public String getrange(String key2, long startOffset, long endOffset) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getrange(key2, startOffset, endOffset));
    }

    @Override
    public long bitpos(String key2, boolean value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitpos(key2, value2));
    }

    @Override
    public long bitpos(String key2, boolean value2, BitPosParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitpos(key2, value2, params));
    }

    @Override
    public List<Object> role() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.ROLE);
        return BuilderFactory.ENCODED_OBJECT_LIST.build(this.connection.getOne());
    }

    @Override
    public Map<String, String> configGet(String pattern2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.GET.name(), pattern2);
        return BuilderFactory.STRING_MAP.build(this.connection.getOne());
    }

    @Override
    public Map<String, String> configGet(String ... patterns2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Jedis.joinParameters(Protocol.Keyword.GET.name(), patterns2));
        return BuilderFactory.STRING_MAP.build(this.connection.getOne());
    }

    @Override
    public String configSet(String parameter, String value2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.SET.name(), parameter, value2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configSet(String ... parameterValues) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Jedis.joinParameters(Protocol.Keyword.SET.name(), parameterValues));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configSet(Map<String, String> parameterValues) {
        this.checkIsInMultiOrPipeline();
        CommandArguments args2 = new CommandArguments(Protocol.Command.CONFIG).add(Protocol.Keyword.SET);
        parameterValues.forEach((k2, v) -> args2.add((String)k2).add((String)v));
        this.connection.sendCommand(args2);
        return this.connection.getStatusCodeReply();
    }

    public long publish(String channel2, String message) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBLISH, channel2, message);
        return this.connection.getIntegerReply();
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        jedisPubSub.proceed(this.connection, channels);
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns2) {
        jedisPubSub.proceedWithPatterns(this.connection, patterns2);
    }

    public List<String> pubsubChannels() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Protocol.Keyword.CHANNELS);
        return this.connection.getMultiBulkReply();
    }

    public List<String> pubsubChannels(String pattern2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Protocol.Keyword.CHANNELS.name(), pattern2);
        return this.connection.getMultiBulkReply();
    }

    public Long pubsubNumPat() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Protocol.Keyword.NUMPAT);
        return this.connection.getIntegerReply();
    }

    public Map<String, Long> pubsubNumSub(String ... channels) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Jedis.joinParameters(Protocol.Keyword.NUMSUB.name(), channels));
        return BuilderFactory.PUBSUB_NUMSUB_MAP.build(this.connection.getOne());
    }

    public List<String> pubsubShardChannels() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Protocol.Keyword.SHARDCHANNELS);
        return this.connection.getMultiBulkReply();
    }

    public List<String> pubsubShardChannels(String pattern2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Protocol.Keyword.SHARDCHANNELS.name(), pattern2);
        return this.connection.getMultiBulkReply();
    }

    public Map<String, Long> pubsubShardNumSub(String ... channels) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Jedis.joinParameters(Protocol.Keyword.SHARDNUMSUB.name(), channels));
        return BuilderFactory.PUBSUB_NUMSUB_MAP.build(this.connection.getOne());
    }

    @Override
    public Object eval(String script, int keyCount, String ... params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(script, keyCount, params));
    }

    @Override
    public Object eval(String script, List<String> keys2, List<String> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(script, keys2, args2));
    }

    @Override
    public Object evalReadonly(String script, List<String> keys2, List<String> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalReadonly(script, keys2, args2));
    }

    @Override
    public Object eval(String script) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(script));
    }

    @Override
    public Object evalsha(String sha1) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(sha1));
    }

    @Override
    public Object evalsha(String sha1, List<String> keys2, List<String> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(sha1, keys2, args2));
    }

    @Override
    public Object evalshaReadonly(String sha1, List<String> keys2, List<String> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalshaReadonly(sha1, keys2, args2));
    }

    @Override
    public Object evalsha(String sha1, int keyCount, String ... params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(sha1, keyCount, params));
    }

    @Override
    public Boolean scriptExists(String sha1) {
        String[] a2 = new String[]{sha1};
        return this.scriptExists(a2).get(0);
    }

    @Override
    public List<Boolean> scriptExists(String ... sha1) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Jedis.joinParameters(Protocol.Keyword.EXISTS.name(), sha1));
        return BuilderFactory.BOOLEAN_LIST.build(this.connection.getOne());
    }

    @Override
    public String scriptLoad(String script) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.LOAD.name(), script);
        return this.connection.getBulkReply();
    }

    @Override
    public List<Slowlog> slowlogGet() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET);
        return Slowlog.from(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<Slowlog> slowlogGet(long entries2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET.getRaw(), Protocol.toByteArray(entries2));
        return Slowlog.from(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public Long objectRefcount(String key2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT.name(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public String objectEncoding(String key2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.ENCODING.name(), key2);
        return this.connection.getBulkReply();
    }

    @Override
    public Long objectIdletime(String key2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME.name(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public List<String> objectHelp() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.HELP);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public Long objectFreq(String key2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.FREQ.name(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public long bitcount(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(key2));
    }

    @Override
    public long bitcount(String key2, long start2, long end2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(key2, start2, end2));
    }

    @Override
    public long bitcount(String key2, long start2, long end2, BitCountOption option) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(key2, start2, end2, option));
    }

    @Override
    public long bitop(BitOP op, String destKey, String ... srcKeys) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitop(op, destKey, srcKeys));
    }

    public long commandCount() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Protocol.Keyword.COUNT);
        return this.connection.getIntegerReply();
    }

    public Map<String, CommandDocument> commandDocs(String ... commands) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Jedis.joinParameters(Protocol.Keyword.DOCS.name(), commands));
        return BuilderFactory.COMMAND_DOCS_RESPONSE.build(this.connection.getOne());
    }

    public List<String> commandGetKeys(String ... command2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Jedis.joinParameters(Protocol.Keyword.GETKEYS.name(), command2));
        return BuilderFactory.STRING_LIST.build(this.connection.getOne());
    }

    public List<KeyValue<String, List<String>>> commandGetKeysAndFlags(String ... command2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Jedis.joinParameters(Protocol.Keyword.GETKEYSANDFLAGS.name(), command2));
        return BuilderFactory.KEYED_STRING_LIST_LIST.build(this.connection.getOne());
    }

    public Map<String, CommandInfo> commandInfo(String ... commands) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Jedis.joinParameters(Protocol.Keyword.INFO.name(), commands));
        return BuilderFactory.COMMAND_INFO_RESPONSE.build(this.connection.getOne());
    }

    public List<String> commandList() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Protocol.Keyword.LIST);
        return BuilderFactory.STRING_LIST.build(this.connection.getOne());
    }

    public List<String> commandListFilterBy(CommandListFilterByParams filterByParams) {
        this.checkIsInMultiOrPipeline();
        CommandArguments args2 = new CommandArguments(Protocol.Command.COMMAND).add(Protocol.Keyword.LIST).addParams(filterByParams);
        this.connection.sendCommand(args2);
        return BuilderFactory.STRING_LIST.build(this.connection.getOne());
    }

    @Override
    public String sentinelMyId() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MYID);
        return this.connection.getBulkReply();
    }

    @Override
    public List<Map<String, String>> sentinelMasters() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MASTERS);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> sentinelMaster(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MASTER.name(), masterName);
        return BuilderFactory.STRING_MAP.build(this.connection.getOne());
    }

    @Override
    public List<Map<String, String>> sentinelSentinels(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.SENTINELS.name(), masterName);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public List<String> sentinelGetMasterAddrByName(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.GET_MASTER_ADDR_BY_NAME.getRaw(), SafeEncoder.encode(masterName));
        return this.connection.getMultiBulkReply();
    }

    @Override
    public Long sentinelReset(String pattern2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.RESET.name(), pattern2);
        return this.connection.getIntegerReply();
    }

    @Override
    @Deprecated
    public List<Map<String, String>> sentinelSlaves(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.SLAVES.name(), masterName);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public List<Map<String, String>> sentinelReplicas(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.REPLICAS.name(), masterName);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public String sentinelFailover(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.FAILOVER.name(), masterName);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelMonitor(String masterName, String ip, int port2, int quorum) {
        CommandArguments args2 = new CommandArguments(Protocol.Command.SENTINEL).add(Protocol.SentinelKeyword.MONITOR).add(masterName).add(ip).add(port2).add(quorum);
        this.connection.sendCommand(args2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelRemove(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.REMOVE.name(), masterName);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        CommandArguments args2 = new CommandArguments(Protocol.Command.SENTINEL).add(Protocol.SentinelKeyword.SET).add(masterName);
        parameterMap.entrySet().forEach(entry -> args2.add((String)entry.getKey()).add((String)entry.getValue()));
        this.connection.sendCommand(args2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public byte[] dump(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.dump(key2));
    }

    @Override
    public String restore(String key2, long ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.restore(key2, ttl, serializedValue));
    }

    @Override
    public String restore(String key2, long ttl, byte[] serializedValue, RestoreParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.restore(key2, ttl, serializedValue, params));
    }

    @Override
    public long pttl(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pttl(key2));
    }

    @Override
    public String psetex(String key2, long milliseconds, String value2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.psetex(key2, milliseconds, value2));
    }

    @Override
    public String aclSetUser(String name) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.SETUSER.name(), name);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String aclSetUser(String name, String ... rules) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Jedis.joinParameters(Protocol.Keyword.SETUSER.name(), name, rules));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long aclDelUser(String ... names2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Jedis.joinParameters(Protocol.Keyword.DELUSER.name(), names2));
        return this.connection.getIntegerReply();
    }

    @Override
    public AccessControlUser aclGetUser(String name) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GETUSER.name(), name);
        return BuilderFactory.ACCESS_CONTROL_USER.build(this.connection.getOne());
    }

    @Override
    public List<String> aclUsers() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.USERS);
        return BuilderFactory.STRING_LIST.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<String> aclList() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LIST);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public String aclWhoAmI() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.WHOAMI);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<String> aclCat() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.CAT);
        return BuilderFactory.STRING_LIST.build(this.connection.getOne());
    }

    @Override
    public List<String> aclCat(String category) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.CAT.name(), category);
        return BuilderFactory.STRING_LIST.build(this.connection.getOne());
    }

    @Override
    public List<AccessControlLogEntry> aclLog() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG);
        return BuilderFactory.ACCESS_CONTROL_LOG_ENTRY_LIST.build(this.connection.getOne());
    }

    @Override
    public List<AccessControlLogEntry> aclLog(int limit) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG.getRaw(), Protocol.toByteArray(limit));
        return BuilderFactory.ACCESS_CONTROL_LOG_ENTRY_LIST.build(this.connection.getOne());
    }

    @Override
    public String aclLoad() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOAD);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String aclSave() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.SAVE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String aclGenPass() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GENPASS);
        return this.connection.getBulkReply();
    }

    @Override
    public String aclGenPass(int bits) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GENPASS.getRaw(), Protocol.toByteArray(bits));
        return this.connection.getBulkReply();
    }

    @Override
    public String aclDryRun(String username, String command2, String ... args2) {
        this.checkIsInMultiOrPipeline();
        String[] allArgs = new String[3 + args2.length];
        allArgs[0] = Protocol.Keyword.DRYRUN.name();
        allArgs[1] = username;
        allArgs[2] = command2;
        System.arraycopy(args2, 0, allArgs, 3, args2.length);
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, allArgs);
        return this.connection.getBulkReply();
    }

    @Override
    public String aclDryRun(String username, CommandArguments commandArgs) {
        this.checkIsInMultiOrPipeline();
        CommandArguments allArgs = new CommandArguments(Protocol.Command.ACL).add(Protocol.Keyword.DRYRUN).add(username);
        Iterator<Rawable> it = commandArgs.iterator();
        while (it.hasNext()) {
            allArgs.add(it.next());
        }
        this.connection.sendCommand(allArgs);
        return this.connection.getBulkReply();
    }

    @Override
    public byte[] aclDryRunBinary(byte[] username, byte[] command2, byte[] ... args2) {
        this.checkIsInMultiOrPipeline();
        byte[][] allArgs = new byte[3 + args2.length][];
        allArgs[0] = Protocol.Keyword.DRYRUN.getRaw();
        allArgs[1] = username;
        allArgs[2] = command2;
        System.arraycopy(args2, 0, allArgs, 3, args2.length);
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, allArgs);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] aclDryRunBinary(byte[] username, CommandArguments commandArgs) {
        this.checkIsInMultiOrPipeline();
        CommandArguments allArgs = new CommandArguments(Protocol.Command.ACL).add(Protocol.Keyword.DRYRUN).add(username);
        Iterator<Rawable> it = commandArgs.iterator();
        while (it.hasNext()) {
            allArgs.add(it.next());
        }
        this.connection.sendCommand(allArgs);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public String clientKill(String ipPort) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.KILL.name(), ipPort);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientGetname() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.GETNAME);
        return this.connection.getBulkReply();
    }

    @Override
    public String clientList() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.LIST);
        return this.connection.getBulkReply();
    }

    @Override
    public String clientList(ClientType type2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.LIST.getRaw(), Protocol.Keyword.TYPE.getRaw(), type2.getRaw());
        return this.connection.getBulkReply();
    }

    @Override
    public String clientList(long ... clientIds) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, this.clientListParams(clientIds));
        return this.connection.getBulkReply();
    }

    @Override
    public String clientInfo() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.INFO);
        return this.connection.getBulkReply();
    }

    @Override
    public String clientSetInfo(ClientAttributeOption attr, String value2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETINFO.getRaw(), attr.getRaw(), SafeEncoder.encode(value2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientSetname(String name) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.name(), name);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String migrate(String host2, int port2, String key2, int destinationDb, int timeout2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(host2, port2, key2, destinationDb, timeout2));
    }

    @Override
    public String migrate(String host2, int port2, int destinationDB, int timeout2, MigrateParams params, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(host2, port2, destinationDB, timeout2, params, keys2));
    }

    @Override
    public String migrate(String host2, int port2, String key2, int timeout2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(host2, port2, key2, timeout2));
    }

    @Override
    public String migrate(String host2, int port2, int timeout2, MigrateParams params, String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(host2, port2, timeout2, params, keys2));
    }

    @Override
    public ScanResult<String> scan(String cursor) {
        return this.connection.executeCommand(this.commandObjects.scan(cursor));
    }

    @Override
    public ScanResult<String> scan(String cursor, ScanParams params) {
        return this.connection.executeCommand(this.commandObjects.scan(cursor, params));
    }

    @Override
    public ScanResult<String> scan(String cursor, ScanParams params, String type2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scan(cursor, params, type2));
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key2, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hscan(key2, cursor, params));
    }

    @Override
    public ScanResult<String> hscanNoValues(String key2, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hscanNoValues(key2, cursor, params));
    }

    @Override
    public ScanResult<String> sscan(String key2, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sscan(key2, cursor, params));
    }

    @Override
    public ScanResult<Tuple> zscan(String key2, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zscan(key2, cursor, params));
    }

    @Override
    public String readonly() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.READONLY);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String readwrite() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.READWRITE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterNodes() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.NODES);
        return this.connection.getBulkReply();
    }

    @Override
    public String clusterMeet(String ip, int port2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.MEET.name(), ip, Integer.toString(port2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterReset() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.RESET);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterReset(ClusterResetType resetType) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.RESET.getRaw(), resetType.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterAddSlots(int ... slots) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Jedis.joinParameters(Protocol.ClusterKeyword.ADDSLOTS.getRaw(), Jedis.joinParameters(slots)));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterDelSlots(int ... slots) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Jedis.joinParameters(Protocol.ClusterKeyword.DELSLOTS.getRaw(), Jedis.joinParameters(slots)));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterInfo() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.INFO);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<String> clusterGetKeysInSlot(int slot, int count2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.GETKEYSINSLOT.getRaw(), Protocol.toByteArray(slot), Protocol.toByteArray(count2));
        return this.connection.getMultiBulkReply();
    }

    @Override
    public List<byte[]> clusterGetKeysInSlotBinary(int slot, int count2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.GETKEYSINSLOT.getRaw(), Protocol.toByteArray(slot), Protocol.toByteArray(count2));
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public String clusterSetSlotNode(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SETSLOT.getRaw(), Protocol.toByteArray(slot), Protocol.ClusterKeyword.NODE.getRaw(), SafeEncoder.encode(nodeId));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotMigrating(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SETSLOT.getRaw(), Protocol.toByteArray(slot), Protocol.ClusterKeyword.MIGRATING.getRaw(), SafeEncoder.encode(nodeId));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotImporting(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SETSLOT.getRaw(), Protocol.toByteArray(slot), Protocol.ClusterKeyword.IMPORTING.getRaw(), SafeEncoder.encode(nodeId));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotStable(int slot) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SETSLOT.getRaw(), Protocol.toByteArray(slot), Protocol.ClusterKeyword.STABLE.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterForget(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.FORGET.name(), nodeId);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterFlushSlots() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.FLUSHSLOTS);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long clusterKeySlot(String key2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.KEYSLOT.name(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public long clusterCountFailureReports(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, "COUNT-FAILURE-REPORTS", nodeId);
        return this.connection.getIntegerReply();
    }

    @Override
    public long clusterCountKeysInSlot(int slot) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.COUNTKEYSINSLOT.getRaw(), Protocol.toByteArray(slot));
        return this.connection.getIntegerReply();
    }

    @Override
    public String clusterSaveConfig() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SAVECONFIG);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterSetConfigEpoch(long configEpoch) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, "SET-CONFIG-EPOCH", Long.toString(configEpoch));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterBumpEpoch() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.BUMPEPOCH);
        return this.connection.getBulkReply();
    }

    @Override
    public String clusterReplicate(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.REPLICATE.name(), nodeId);
        return this.connection.getStatusCodeReply();
    }

    @Override
    @Deprecated
    public List<String> clusterSlaves(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SLAVES.name(), nodeId);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public List<String> clusterReplicas(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.REPLICAS.name(), nodeId);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public String clusterFailover() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.FAILOVER);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterFailover(ClusterFailoverOption failoverOption) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.FAILOVER.getRaw(), failoverOption.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    @Deprecated
    public List<Object> clusterSlots() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SLOTS);
        return this.connection.getObjectMultiBulkReply();
    }

    @Override
    public List<ClusterShardInfo> clusterShards() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SHARDS);
        return BuilderFactory.CLUSTER_SHARD_INFO_LIST.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public String clusterMyId() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.MYID);
        return this.connection.getBulkReply();
    }

    @Override
    public String clusterMyShardId() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.MYSHARDID);
        return this.connection.getBulkReply();
    }

    @Override
    public List<Map<String, Object>> clusterLinks() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.LINKS);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.ENCODED_OBJECT_MAP::build).collect(Collectors.toList());
    }

    @Override
    public String clusterAddSlotsRange(int ... ranges) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Jedis.joinParameters(Protocol.ClusterKeyword.ADDSLOTSRANGE.getRaw(), Jedis.joinParameters(ranges)));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterDelSlotsRange(int ... ranges) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Jedis.joinParameters(Protocol.ClusterKeyword.DELSLOTSRANGE.getRaw(), Jedis.joinParameters(ranges)));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String asking() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.ASKING);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long pfadd(String key2, String ... elements) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfadd(key2, elements));
    }

    @Override
    public long pfcount(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfcount(key2));
    }

    @Override
    public long pfcount(String ... keys2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfcount(keys2));
    }

    @Override
    public String pfmerge(String destkey, String ... sourcekeys) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfmerge(destkey, sourcekeys));
    }

    @Override
    public Object fcall(String name, List<String> keys2, List<String> args2) {
        return this.connection.executeCommand(this.commandObjects.fcall(name, keys2, args2));
    }

    @Override
    public Object fcallReadonly(String name, List<String> keys2, List<String> args2) {
        return this.connection.executeCommand(this.commandObjects.fcallReadonly(name, keys2, args2));
    }

    @Override
    public String functionDelete(String libraryName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionDelete(libraryName));
    }

    @Override
    public String functionLoad(String functionCode) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionLoad(functionCode));
    }

    @Override
    public String functionLoadReplace(String functionCode) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionLoadReplace(functionCode));
    }

    @Override
    public FunctionStats functionStats() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionStats());
    }

    @Override
    public String functionFlush() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionFlush());
    }

    @Override
    public String functionFlush(FlushMode mode) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionFlush(mode));
    }

    @Override
    public String functionKill() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionKill());
    }

    @Override
    public List<LibraryInfo> functionList() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionList());
    }

    @Override
    public List<LibraryInfo> functionList(String libraryNamePattern) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionList(libraryNamePattern));
    }

    @Override
    public List<LibraryInfo> functionListWithCode() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListWithCode());
    }

    @Override
    public List<LibraryInfo> functionListWithCode(String libraryNamePattern) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListWithCode(libraryNamePattern));
    }

    @Override
    public long geoadd(String key2, double longitude, double latitude, String member) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(key2, longitude, latitude, member));
    }

    @Override
    public long geoadd(String key2, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(key2, memberCoordinateMap));
    }

    @Override
    public long geoadd(String key2, GeoAddParams params, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(key2, params, memberCoordinateMap));
    }

    @Override
    public Double geodist(String key2, String member1, String member2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geodist(key2, member1, member2));
    }

    @Override
    public Double geodist(String key2, String member1, String member2, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geodist(key2, member1, member2, unit));
    }

    @Override
    public List<String> geohash(String key2, String ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geohash(key2, members));
    }

    @Override
    public List<GeoCoordinate> geopos(String key2, String ... members) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geopos(key2, members));
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key2, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadius(key2, longitude, latitude, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key2, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusReadonly(key2, longitude, latitude, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadius(key2, longitude, latitude, radius, unit, param));
    }

    @Override
    public long georadiusStore(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusStore(key2, longitude, latitude, radius, unit, param, storeParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusReadonly(key2, longitude, latitude, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key2, String member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMember(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key2, String member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberReadonly(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMember(key2, member, radius, unit, param));
    }

    @Override
    public long georadiusByMemberStore(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberStore(key2, member, radius, unit, param, storeParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberReadonly(key2, member, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, String member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, GeoCoordinate coord, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, coord, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, String member, double width, double height, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, member, width, height, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, coord, width, height, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, GeoSearchParam params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(key2, params));
    }

    @Override
    public long geosearchStore(String dest, String src, String member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, member, radius, unit));
    }

    @Override
    public long geosearchStore(String dest, String src, GeoCoordinate coord, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, coord, radius, unit));
    }

    @Override
    public long geosearchStore(String dest, String src, String member, double width, double height, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, member, width, height, unit));
    }

    @Override
    public long geosearchStore(String dest, String src, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, coord, width, height, unit));
    }

    @Override
    public long geosearchStore(String dest, String src, GeoSearchParam params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(dest, src, params));
    }

    @Override
    public long geosearchStoreStoreDist(String dest, String src, GeoSearchParam params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStoreStoreDist(dest, src, params));
    }

    @Override
    public String moduleLoad(String path2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.LOAD.name(), path2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String moduleLoad(String path2, String ... args2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Jedis.joinParameters(Protocol.Keyword.LOAD.name(), path2, args2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String moduleLoadEx(String path2, ModuleLoadExParams params) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(new CommandArguments(Protocol.Command.MODULE).add(Protocol.Keyword.LOADEX).add(path2).addParams(params));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String moduleUnload(String name) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.UNLOAD.name(), name);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<Module> moduleList() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.LIST);
        return BuilderFactory.MODULE_LIST.build(this.connection.getOne());
    }

    @Override
    public List<Long> bitfield(String key2, String ... arguments) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitfield(key2, arguments));
    }

    @Override
    public List<Long> bitfieldReadonly(String key2, String ... arguments) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitfieldReadonly(key2, arguments));
    }

    @Override
    public long hstrlen(String key2, String field) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hstrlen(key2, field));
    }

    @Override
    public List<Long> hexpire(String key2, long seconds, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpire(key2, seconds, fields2));
    }

    @Override
    public List<Long> hexpire(String key2, long seconds, ExpiryOption condition, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpire(key2, seconds, condition, fields2));
    }

    @Override
    public List<Long> hpexpire(String key2, long milliseconds, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpire(key2, milliseconds, fields2));
    }

    @Override
    public List<Long> hpexpire(String key2, long milliseconds, ExpiryOption condition, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpire(key2, milliseconds, condition, fields2));
    }

    @Override
    public List<Long> hexpireAt(String key2, long unixTimeSeconds, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpireAt(key2, unixTimeSeconds, fields2));
    }

    @Override
    public List<Long> hexpireAt(String key2, long unixTimeSeconds, ExpiryOption condition, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpireAt(key2, unixTimeSeconds, condition, fields2));
    }

    @Override
    public List<Long> hpexpireAt(String key2, long unixTimeMillis, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpireAt(key2, unixTimeMillis, fields2));
    }

    @Override
    public List<Long> hpexpireAt(String key2, long unixTimeMillis, ExpiryOption condition, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpireAt(key2, unixTimeMillis, condition, fields2));
    }

    @Override
    public List<Long> hexpireTime(String key2, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexpireTime(key2, fields2));
    }

    @Override
    public List<Long> hpexpireTime(String key2, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpexpireTime(key2, fields2));
    }

    @Override
    public List<Long> httl(String key2, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.httl(key2, fields2));
    }

    @Override
    public List<Long> hpttl(String key2, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpttl(key2, fields2));
    }

    @Override
    public List<Long> hpersist(String key2, String ... fields2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hpersist(key2, fields2));
    }

    @Override
    public String memoryDoctor() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.DOCTOR);
        return this.connection.getBulkReply();
    }

    @Override
    public Long memoryUsage(String key2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.USAGE.name(), key2);
        return this.connection.getIntegerReply();
    }

    @Override
    public Long memoryUsage(String key2, int samples) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.USAGE.getRaw(), SafeEncoder.encode(key2), Protocol.Keyword.SAMPLES.getRaw(), Protocol.toByteArray(samples));
        return this.connection.getIntegerReply();
    }

    @Override
    public String memoryPurge() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.PURGE);
        return this.connection.getBulkReply();
    }

    @Override
    public Map<String, Object> memoryStats() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.STATS);
        return BuilderFactory.ENCODED_OBJECT_MAP.build(this.connection.getOne());
    }

    @Override
    public String lolwut() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.LOLWUT);
        return this.connection.getBulkReply();
    }

    @Override
    public String lolwut(LolwutParams lolwutParams) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(new CommandArguments(Protocol.Command.LOLWUT).addParams(lolwutParams));
        return this.connection.getBulkReply();
    }

    @Override
    public String reset() {
        this.connection.sendCommand(Protocol.Command.RESET);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String latencyDoctor() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.LATENCY, Protocol.Keyword.DOCTOR);
        return this.connection.getBulkReply();
    }

    @Override
    public Map<String, LatencyLatestInfo> latencyLatest() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.LATENCY, Protocol.Keyword.LATEST);
        return BuilderFactory.LATENCY_LATEST_RESPONSE.build(this.connection.getOne());
    }

    @Override
    public List<LatencyHistoryInfo> latencyHistory(LatencyEvent event) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(new CommandArguments(Protocol.Command.LATENCY).add(Protocol.Keyword.HISTORY).add(event));
        return BuilderFactory.LATENCY_HISTORY_RESPONSE.build(this.connection.getOne());
    }

    @Override
    public long latencyReset(LatencyEvent ... events) {
        this.checkIsInMultiOrPipeline();
        CommandArguments arguments = new CommandArguments(Protocol.Command.LATENCY).add(Protocol.Keyword.RESET);
        Arrays.stream(events).forEach(arguments::add);
        this.connection.sendCommand(arguments);
        return this.connection.getIntegerReply();
    }

    @Override
    public StreamEntryID xadd(String key2, StreamEntryID id, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xadd(key2, id, hash));
    }

    @Override
    public StreamEntryID xadd(String key2, XAddParams params, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xadd(key2, params, hash));
    }

    @Override
    public long xlen(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xlen(key2));
    }

    @Override
    public List<StreamEntry> xrange(String key2, StreamEntryID start2, StreamEntryID end2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(key2, start2, end2));
    }

    @Override
    public List<StreamEntry> xrange(String key2, StreamEntryID start2, StreamEntryID end2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(key2, start2, end2, count2));
    }

    @Override
    public List<StreamEntry> xrevrange(String key2, StreamEntryID end2, StreamEntryID start2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(key2, end2, start2));
    }

    @Override
    public List<StreamEntry> xrevrange(String key2, StreamEntryID end2, StreamEntryID start2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(key2, end2, start2, count2));
    }

    @Override
    public List<StreamEntry> xrange(String key2, String start2, String end2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(key2, start2, end2));
    }

    @Override
    public List<StreamEntry> xrange(String key2, String start2, String end2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(key2, start2, end2, count2));
    }

    @Override
    public List<StreamEntry> xrevrange(String key2, String end2, String start2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(key2, end2, start2));
    }

    @Override
    public List<StreamEntry> xrevrange(String key2, String end2, String start2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(key2, end2, start2, count2));
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> streams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xread(xReadParams, streams));
    }

    @Override
    public Map<String, List<StreamEntry>> xreadAsMap(XReadParams xReadParams, Map<String, StreamEntryID> streams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xreadAsMap(xReadParams, streams));
    }

    @Override
    public long xack(String key2, String group, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xack(key2, group, ids));
    }

    @Override
    public String xgroupCreate(String key2, String groupName, StreamEntryID id, boolean makeStream) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupCreate(key2, groupName, id, makeStream));
    }

    @Override
    public String xgroupSetID(String key2, String groupName, StreamEntryID id) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupSetID(key2, groupName, id));
    }

    @Override
    public long xgroupDestroy(String key2, String groupName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupDestroy(key2, groupName));
    }

    @Override
    public boolean xgroupCreateConsumer(String key2, String groupName, String consumerName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupCreateConsumer(key2, groupName, consumerName));
    }

    @Override
    public long xgroupDelConsumer(String key2, String groupName, String consumerName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupDelConsumer(key2, groupName, consumerName));
    }

    @Override
    public long xdel(String key2, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xdel(key2, ids));
    }

    @Override
    public long xtrim(String key2, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xtrim(key2, maxLen, approximateLength));
    }

    @Override
    public long xtrim(String key2, XTrimParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xtrim(key2, params));
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xreadGroup(String groupName, String consumer2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> streams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xreadGroup(groupName, consumer2, xReadGroupParams, streams));
    }

    @Override
    public Map<String, List<StreamEntry>> xreadGroupAsMap(String groupName, String consumer2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> streams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xreadGroupAsMap(groupName, consumer2, xReadGroupParams, streams));
    }

    @Override
    public StreamPendingSummary xpending(String key2, String groupName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(key2, groupName));
    }

    @Override
    public List<StreamPendingEntry> xpending(String key2, String groupName, XPendingParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(key2, groupName, params));
    }

    @Override
    public List<StreamEntry> xclaim(String key2, String group, String consumerName, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xclaim(key2, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public List<StreamEntryID> xclaimJustId(String key2, String group, String consumerName, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xclaimJustId(key2, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String key2, String group, String consumerName, long minIdleTime, StreamEntryID start2, XAutoClaimParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xautoclaim(key2, group, consumerName, minIdleTime, start2, params));
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String key2, String group, String consumerName, long minIdleTime, StreamEntryID start2, XAutoClaimParams params) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xautoclaimJustId(key2, group, consumerName, minIdleTime, start2, params));
    }

    @Override
    public StreamInfo xinfoStream(String key2) {
        return this.connection.executeCommand(this.commandObjects.xinfoStream(key2));
    }

    @Override
    public StreamFullInfo xinfoStreamFull(String key2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStreamFull(key2));
    }

    @Override
    public StreamFullInfo xinfoStreamFull(String key2, int count2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStreamFull(key2, count2));
    }

    @Override
    public List<StreamGroupInfo> xinfoGroups(String key2) {
        return this.connection.executeCommand(this.commandObjects.xinfoGroups(key2));
    }

    @Override
    public List<StreamConsumersInfo> xinfoConsumers(String key2, String group) {
        return this.connection.executeCommand(this.commandObjects.xinfoConsumers(key2, group));
    }

    @Override
    public List<StreamConsumerInfo> xinfoConsumers2(String key2, String group) {
        return this.connection.executeCommand(this.commandObjects.xinfoConsumers2(key2, group));
    }

    @Override
    public Object fcall(byte[] name, List<byte[]> keys2, List<byte[]> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.fcall(name, keys2, args2));
    }

    @Override
    public Object fcallReadonly(byte[] name, List<byte[]> keys2, List<byte[]> args2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.fcallReadonly(name, keys2, args2));
    }

    @Override
    public String functionDelete(byte[] libraryName) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionDelete(libraryName));
    }

    @Override
    public byte[] functionDump() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionDump());
    }

    @Override
    public List<Object> functionListBinary() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListBinary());
    }

    @Override
    public List<Object> functionList(byte[] libraryNamePattern) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionList(libraryNamePattern));
    }

    @Override
    public List<Object> functionListWithCodeBinary() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListWithCodeBinary());
    }

    @Override
    public List<Object> functionListWithCode(byte[] libraryNamePattern) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListWithCode(libraryNamePattern));
    }

    @Override
    public String functionLoad(byte[] functionCode) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionLoad(functionCode));
    }

    @Override
    public String functionLoadReplace(byte[] functionCode) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionLoadReplace(functionCode));
    }

    @Override
    public String functionRestore(byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionRestore(serializedValue));
    }

    @Override
    public String functionRestore(byte[] serializedValue, FunctionRestorePolicy policy) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionRestore(serializedValue, policy));
    }

    @Override
    public Object functionStatsBinary() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionStatsBinary());
    }

    public Object sendCommand(ProtocolCommand cmd, String ... args2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(cmd, args2);
        return this.connection.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendBlockingCommand(ProtocolCommand cmd, String ... args2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(cmd, args2);
        this.connection.setTimeoutInfinite();
        try {
            Object object = this.connection.getOne();
            return object;
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    private static byte[][] joinParameters(int ... params) {
        byte[][] result2 = new byte[params.length][];
        for (int i2 = 0; i2 < params.length; ++i2) {
            result2[i2] = Protocol.toByteArray(params[i2]);
        }
        return result2;
    }

    private static byte[][] joinParameters(byte[] first2, byte[][] rest2) {
        byte[][] result2 = new byte[rest2.length + 1][];
        result2[0] = first2;
        System.arraycopy(rest2, 0, result2, 1, rest2.length);
        return result2;
    }

    private static byte[][] joinParameters(byte[] first2, byte[] second2, byte[][] rest2) {
        byte[][] result2 = new byte[rest2.length + 2][];
        result2[0] = first2;
        result2[1] = second2;
        System.arraycopy(rest2, 0, result2, 2, rest2.length);
        return result2;
    }

    private static String[] joinParameters(String first2, String[] rest2) {
        String[] result2 = new String[rest2.length + 1];
        result2[0] = first2;
        System.arraycopy(rest2, 0, result2, 1, rest2.length);
        return result2;
    }

    private static String[] joinParameters(String first2, String second2, String[] rest2) {
        String[] result2 = new String[rest2.length + 2];
        result2[0] = first2;
        result2[1] = second2;
        System.arraycopy(rest2, 0, result2, 2, rest2.length);
        return result2;
    }
}

